// hello.cxx : a simple console application that illustrates how to
// 1. create a connection to S-PLUS.
// 2. create permanent objects in S database.
// 3. evaluate an S expression.
//
// Steps to build and test this program from a DOS prompt.
// 1. Change current directory to directory containing this file
//     cd <directory containing this file>
// 2. Build the program
//     msdev hello.dsp /make
// 3. Run the program
//     hello.exe S_HOME=%SHOME%
// 4. Run the S-PLUS console
//     %SHOME%\cmd\sqpe.exe
// 5. Look for S object: hello.  For example,
//     > objects()

#if defined(__hppa) || defined(__alpha)
namespace std{};
#endif

using namespace std;

#include "sconnect.h"

int main(int argc, char* argv[])
{
	//Creat a connection object 
	CSPengineConnect engineConnect;
	engineConnect.Create(argc, argv, NULL, S_CONNECT_DEFAULTAUTO, 0 );

	//Parse and evaluate a string of S expression to create 
	//a character object with name "hello" in the working database.
	//Same as hello<-'hello world!' at the S-PLUS command line.
	engineConnect.SyncParseEval("hello<-'Hello world!' ");

	//Find the S character object with name "hello"
	//and assign as a C++ object of the corresponding SPL character class.
	CSPcharacter myHello = CSPobject(engineConnect.get("hello"));

	//Print the object to standard output
	myHello.print();

	return 0;
}
