/*
	Connect/C++ : Copyright (c) 2001, 2006 Insightful Corp.
	All rights reserved.
	Version 6.0: 2001

	spint.h: interface for the CSPinteger class.
*/

#if !defined(__SCONNECT_SPINT_H_INCLUDED__)
#define __SCONNECT_SPINT_H_INCLUDED__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "spvector.h"

class SCONNECT_LIB_EXTERN CSPinteger : public TSPvector<long, S_MODE_INT>  
{
//////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////
public:
	//Default constructor
	CSPinteger();
	//Copy constructor: copy appropriate data members
	CSPinteger(const CSPinteger& sObject);
	//Construct from object of a base class
	CSPinteger(const CSPobject& sObject);
	//Construct from a valid S-expression
	explicit CSPinteger(const char* pszExpression);
	//Construct frmo an S object pointer  
	explicit CSPinteger(s_object* ps_object, BOOL bTryToFreeOnDetach=FALSE);
	//Assign from the same class
	CSPinteger& operator=(const CSPinteger& sObject);
	//Assign from the base class
	CSPinteger& operator=(const CSPobject& sObject);
	//Assign from an S object
	CSPinteger& operator=(s_object* ps_object);
	//The destructor
	virtual ~CSPinteger();

	//Construct an 'integer' of specified length 
	explicit CSPinteger(long lLength);
	explicit CSPinteger(int  nLength);
	//Construct an 'integer' vector 
	explicit CSPinteger(long* plValues, long lLength=1);
	CSPinteger(long* plValues, int  nLength);
	explicit CSPinteger(int*  pnValues, long lLength=1);
	CSPinteger(int*  pnValues, int  nLength);

	CSPinteger& operator=(const long  rhs);
	CSPinteger& operator=(const int rhs)
	{    return operator=(static_cast<const long>(rhs)); }
	CSPinteger& operator=(const double rhs)
	{    return operator=(static_cast<const long>(rhs)); }

//////////////////////////////////////////////////////
// Attributes
//////////////////////////////////////////////////////
public:
	//Proxy to assist indexing operator for lvalue/rvalue, type conversions and ref count.
	class SCONNECT_LIB_EXTERN CProxy : public TSPvector<long, S_MODE_INT>::CSPvectorProxy
	{
	public:
		CProxy(CSPinteger& sVector, long lZeroBasedIndex);
		CProxy(const CProxy& proxyRhs);
		CProxy& operator =(const CProxy& proxyRhs);
		CProxy& operator =(const long& rhs);
		CProxy& operator+=(const long& rhs);
		CProxy& operator-=(const long& rhs);
		CProxy& operator*=(const long& rhs);
		CProxy& operator/=(const long& rhs);
		friend class CSPinteger;
	};
	CSPinteger& operator=(const CProxy& proxyRhs);
	//Subscripting, C style zero-based and Fortran one-based-indexing: must over-load all required [] and ().
	const long operator[](int nZeroBasedIndex) const //rvalue only
	{ return MyTypeValue(&(*this), nZeroBasedIndex);}
	CProxy operator[](int nZeroBasedIndex)//both lvalue and rvalue     
	{ return CProxy(*this, nZeroBasedIndex);}
	//Subscripting, Fortran style and one-based-indexing
	const long operator()(int nOneBasedIndex) const 
	{ return MyTypeValue(&(*this), nOneBasedIndex-1L);}
	CProxy operator()(int nOneBasedIndex)            
	{ return CProxy(*this, nOneBasedIndex-1);}
	//long arguments are needed to avoid ambiguity between int and operator s_object*()
	const long operator[](long lZeroBasedIndex) const 
	{	return MyTypeValue(&(*this), lZeroBasedIndex);}
	CProxy operator[](long lZeroBasedIndex)            
	{	return CProxy(*this, lZeroBasedIndex);}
	const long operator()(long lOneBasedIndex) const 
	{ return MyTypeValue(&(*this), lOneBasedIndex-1L);}
	CProxy operator()(long lOneBasedIndex)            
	{ return CProxy(*this, lOneBasedIndex-1);}

	//Direct access to elements of character vector (ZERO-BASED INDEX). Use it carefully!
	void SetAtDirect(long lIndex, long lElement, BOOL bValidate=TRUE);
	void SetAtDirect(long* plValues, long lStartIndex, long lEndIndex, BOOL bValidate=TRUE);
	void SetAtDirect(int* pnValues,  long lStartIndex, long lEndIndex, BOOL bValidate=TRUE);

//////////////////////////////////////////////////////
// Operations
//////////////////////////////////////////////////////
public:
	CSPinteger abs(BOOL bValidate=TRUE) const;
	long Max(BOOL bValidate=TRUE) const; //It would be nice to use max, but it is a popular macro
	long Min(BOOL bValidate=TRUE) const; //It would be nice to use min, but it is a popular macro

#ifdef WIN32
	#include "spint_com.h"
#endif

};

#endif // !defined(__SCONNECT_SPINT_H_INCLUDED__)
