/*
	Connect/C++ : Copyright (c) 2001, 2006 Insightful Corp.
	All rights reserved.
	Version 6.0: 2001

	spnum.h: interface for the CSPnumeric class.
*/

#if !defined(__SCONNECT__SPNUM_H_INCLUDED__)
#define __SCONNECT__SPNUM_H_INCLUDED__
#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#include "spvector.h"
#include "spproxy.h"

class SCONNECT_LIB_EXTERN CSPnumeric : public TSPvector<double, S_MODE_DOUBLE>
{
//////////////////////////////////////////////////////
// Construction/Destruction/Assignment Operators
//////////////////////////////////////////////////////
public:
	//Default constructor
	CSPnumeric();
	//Copy constructor: copy appropriate data members
	CSPnumeric(const CSPnumeric& sObject);
	//Construct from object of a base class
	CSPnumeric(const CSPobject& sObject);
	//Construct from a valid S-expression
	explicit CSPnumeric(const char* pszExpression);
	//Construct frmo an S object pointer  
	explicit CSPnumeric(s_object* ps_object, BOOL bTryToFreeOnDetach=FALSE);
	//Assign from the same class
	CSPnumeric& operator=(const CSPnumeric& sObject);
	//Assign from the base class
	CSPnumeric& operator=(const CSPobject& sObject);
	//Assign from an S object
	CSPnumeric& operator=(s_object* ps_object);
	//The destructor
	virtual ~CSPnumeric();

	//Construct with a desired length 
	explicit CSPnumeric(long lLength); 
	explicit CSPnumeric(int nLength); 
	//Construct from an array of double
	explicit CSPnumeric(double* pdValues, long lLength=1);
	CSPnumeric(double* pdValues, int nLength);
	//Construct from a scalar double
	explicit CSPnumeric(double d);
	CSPnumeric& operator=(const double rhs);
	CSPnumeric& operator=(const long rhs)
	{    return operator=(static_cast<const double>(rhs)); }
	CSPnumeric& operator=(const int rhs)
	{    return operator=(static_cast<const double>(rhs)); }
//////////////////////////////////////////////////////
// Attributes
//////////////////////////////////////////////////////
public:
	//Proxy to assist indexing operator for lvalue/rvalue, type conversions and ref count.
	class SCONNECT_LIB_EXTERN CProxy : public TSPvector<double, S_MODE_DOUBLE>::CSPvectorProxy
	{
	public:
		CProxy(CSPnumeric& sVector, long lZeroBasedIndex);
		CProxy(const CProxy& proxyRhs);
		CProxy& operator =(const CProxy& proxyRhs);
		CProxy& operator =(const double& rhs);
		CProxy& operator+=(const double& rhs);
		CProxy& operator-=(const double& rhs);
		CProxy& operator*=(const double& rhs);
		CProxy& operator/=(const double& rhs);
		friend class CSPnumeric;
	};
	CSPnumeric& operator=(const CProxy& proxyRhs);
	//Subscripting, C style zero-based and Fortran one-based-indexing: must over-load all required [] and ().
	const double operator[](int nZeroBasedIndex) const //rvalue only
	{ return MyTypeValue(&(*this), nZeroBasedIndex);}
	CProxy operator[](int nZeroBasedIndex)//both lvalue and rvalue     
	{ return CProxy(*this, nZeroBasedIndex);}
	//Subscripting, Fortran style and one-based-indexing
	const double operator()(int nOneBasedIndex) const 
	{ return MyTypeValue(&(*this), nOneBasedIndex-1L);}
	CProxy operator()(int nOneBasedIndex)            
	{ return CProxy(*this, nOneBasedIndex-1);}
	//long arguments are needed to avoid ambiguity between int and operator s_object*()
	const double operator[](long lZeroBasedIndex) const 
	{	return MyTypeValue(&(*this), lZeroBasedIndex);}
	CProxy operator[](long lZeroBasedIndex)            
	{	return CProxy(*this, lZeroBasedIndex);}
	const double operator()(long lOneBasedIndex) const 
	{ return MyTypeValue(&(*this), lOneBasedIndex-1L);}
	CProxy operator()(long lOneBasedIndex)            
	{ return CProxy(*this, lOneBasedIndex-1);}

	//Direct access to elements of character vector (ZERO-BASED INDEX). Use it carefully!
	void SetAtDirect(long lIndex, double dElement, BOOL bValidate=TRUE);
	void SetAtDirect(double* pdValues, long lStartIndex, long lEndIndex, BOOL bValidate=TRUE);

//////////////////////////////////////////////////////
// Operations
//////////////////////////////////////////////////////
public:
	//Compound operators: op= rhs
	CSPnumeric& operator+=(const double rhs);
	CSPnumeric& operator-=(const double rhs);
	CSPnumeric& operator*=(const double rhs);
	CSPnumeric& operator/=(const double rhs);
	CSPnumeric& operator+=(const long rhs)
	{    return operator+=(static_cast<const double>(rhs)); }
	CSPnumeric& operator-=(const long rhs)
	{    return operator-=(static_cast<const double>(rhs)); }
	CSPnumeric& operator*=(const long rhs)
	{    return operator*=(static_cast<const double>(rhs)); }
	CSPnumeric& operator/=(const long rhs)
	{    return operator/=(static_cast<const double>(rhs)); }
	CSPnumeric& operator+=(const int rhs)
	{    return operator+=(static_cast<const double>(rhs)); }
	CSPnumeric& operator-=(const int rhs)
	{    return operator-=(static_cast<const double>(rhs)); }
	CSPnumeric& operator*=(const int rhs)
	{    return operator*=(static_cast<const double>(rhs)); }
	CSPnumeric& operator/=(const int rhs)
	{    return operator/=(static_cast<const double>(rhs)); }
	CSPnumeric& operator+=(const CSPnumeric& sRhs);
	CSPnumeric& operator-=(const CSPnumeric& sRhs);
	CSPnumeric& operator*=(const CSPnumeric& sRhs);
	CSPnumeric& operator/=(const CSPnumeric& sRhs);
	//vector-scalar operations
	CSPnumeric operator+(double dLhs) 
	{ 
		CSPnumeric sAns(Clone()); 
		sAns += dLhs; 
		return sAns; 
	}
	CSPnumeric operator-(double dLhs) 
	{
		CSPnumeric sAns(Clone());
		sAns -= dLhs;
		return sAns;
	}
	CSPnumeric operator*(double dLhs) 
	{
		CSPnumeric sAns(Clone());
		sAns *= dLhs;
		return sAns;
	}
	CSPnumeric operator/(double dLhs) 
	{
		CSPnumeric sAns(Clone());
		sAns /= dLhs;
		return sAns;
	}

	//abs, max, min
	CSPnumeric abs(BOOL bValidate=TRUE) const;
	double Max(BOOL bValidate=TRUE) const; //It would be nice to use max, but it is a popular macro
	double Min(BOOL bValidate=TRUE) const; //It would be nice to use min, but it is a popular macro

#ifdef WIN32
	#include "spnum_com.h"
#endif

}; //class CSPnumeric

SCONNECT_DLLAPI(CSPnumeric) abs(const CSPnumeric& sObject, BOOL bValidate=TRUE)  ;
SCONNECT_DLLAPI(double) Max(const CSPnumeric& sObject, BOOL bValidate=TRUE)  ;
SCONNECT_DLLAPI(double) Min(const CSPnumeric& sObject, BOOL bValidate=TRUE)  ;

#endif // !defined(__SCONNECT__SPNUM_H_INCLUDED__)
