\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{aauletter}[2013/01/02]
\LoadClass[11pt]{article}
\RequirePackage{trebuchet}
\RequirePackage[absolute]{textpos}
\RequirePackage{graphicx}
\RequirePackage{lastpage}
\RequirePackage{vmargin}
\RequirePackage{fancyhdr}
\usepackage[ngerman]{babel}
\RequirePackage{datetime}
\newcommand{\aauletter@date}{\today}
\renewcommand{\dateseparator}{.}
\newcommand{\aauletter@name}{Definieren Sie Ihren Namen mit \\\texttt{$\setminus$name\{Titel$\setminus$$\setminus$Name\}}}
\newcommand{\aauletter@institut}{Institut f\"ur Mathematik}
\newcommand{\aauletter@phone}{\texttt{$\setminus$phone\{\ldots\}}}
\newcommand{\aauletter@fax}{\texttt{$\setminus$fax\{\ldots\}}}
\newcommand{\aauletter@email}{\texttt{$\setminus$email\{\ldots\}}}


\renewcommand{\date}[1]{\renewcommand{\aauletter@date}{#1}}
\newcommand{\name}[1]{\renewcommand{\aauletter@name}{#1}}
\newcommand{\institut}[1]{\renewcommand{\aauletter@institut}{#1}}
\newcommand{\phone}[1]{\renewcommand{\aauletter@phone}{#1}}
\newcommand{\fax}[1]{\renewcommand{\aauletter@fax}{#1}}
\newcommand{\email}[1]{\renewcommand{\aauletter@email}{#1}}

\setlength{\TPHorizModule}{1mm}
\setlength{\TPVertModule}{1mm}

\setpapersize{A4}
\setmarginsrb{2.5cm}{1.3cm}{2cm}{1.3cm}{1.9cm}{3mm}{4mm}{1.7cm}

\fancyheadoffset[r]{6mm}
\fancypagestyle{main}{%
\lhead{}
\chead{}
\rhead{\includegraphics[width=52mm]{aau-logo}}
\lfoot{\begin{textblock}{29}(15,281)\includegraphics[width=29mm]{AAU_www_Logo_rechts}\end{textblock}}
\cfoot{}
\rfoot{{\fontsize{10}{11}\selectfont\thepage/\pageref{LastPage}}}
}
\fancypagestyle{first}{%
\lhead{}
\chead{}
\rhead{\includegraphics[width=52mm]{aau-logo}}
\lfoot{\begin{textblock}{29}(15,281)\includegraphics[width=29mm]{AAU_www_Logo_rechts}\end{textblock}}
\cfoot{}
\rfoot{}
}
\pagestyle{main}

\renewcommand{\headrulewidth}{0pt}
\renewcommand{\footrulewidth}{0pt}

\textblockorigin{2.54cm}{2.54cm}
\setlength{\parindent}{0pt}
\setlength{\parskip}{6pt}
\renewcommand{\baselinestretch}{1.1}
\newcommand{\nostretch}{\setlength{\parskip}{0pt}\renewcommand{\baselinestretch}{1}}


\newcommand{\subject}[1]{\fontsize{12}{14}\selectfont\textbf{Betreff: #1}\par\vskip3mm}
\newcommand{\opening}[1]{#1\par\vskip3mm}
\newcommand{\closing}[1]{\par\vskip0.6cm#1\par}

\newenvironment{letter}[1]{\clearpage\thispagestyle{first}
\begin{textblock}{52}(144,35)
  \nostretch%
  {\fontsize{8.5}{9.5} \selectfont
  \textsc{Fakult\"at f\"ur Technische Wissenschaften}\\}
  {\fontsize{8.5}{9.5}\selectfont \textsc{\aauletter@institut}\par}

  \vskip5mm

  {\fontsize{9}{10} \selectfont
  \aauletter@name\par}

\vskip3mm

  {\fontsize{8}{9}\selectfont Universit\"atsstra\ss{}e 65--67\\
  9020 Klagenfurt\\
  Austria\\
  \hbox to 4mm{T\hfill}+43 (0) 463 2700-\aauletter@phone\\
  \hbox to 4mm{F\hfill}+43 (0) 463 2700-\aauletter@fax\\
  \hbox to 4mm{M\hfill}\aauletter@email\par}
\end{textblock}
\begin{textblock}{52}(25,69)
  \nostretch%
{  \fontsize{10}{11.5}\selectfont
#1
\par}
\end{textblock}

\begin{textblock}{52}(144,135)
  \nostretch%
  {\fontsize{8}{9}\selectfont
  Klagenfurt, \aauletter@date\par}
\end{textblock}

\vbox to 11.3cm{}
}{}
\AtBeginDocument{\ddmmyyyydate}




%%% Local Variables: 
%%% mode: latex
%%% TeX-master: t
%%% End: 
