/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LogicalConnection;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OraclePreparedStatementWrapper;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.ScrollableResultSet;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class UpdatableResultSet
extends BaseResultSet {
    static final int concurrencyType = 1008;
    static final int BEGIN_COLUMN_INDEX = 1;
    static final int MAX_CHAR_BUFFER_SIZE = 1024;
    static final int MAX_BYTE_BUFFER_SIZE = 1024;
    PhysicalConnection connection;
    OracleResultSet resultSet;
    boolean isCachedRset;
    ScrollRsetStatement scrollStmt;
    ResultSetMetaData rsetMetaData;
    private int rsetType;
    private int columnCount;
    private OraclePreparedStatement deleteStmt;
    private OraclePreparedStatement insertStmt;
    private OraclePreparedStatement updateStmt;
    private int[] indexColsChanged;
    private Object[] rowBuffer;
    private boolean[] m_nullIndicator;
    private int[][] typeInfo;
    private boolean isInserting;
    private boolean isUpdating;
    private int wasNull;
    private static final int VALUE_NULL = 1;
    private static final int VALUE_NOT_NULL = 2;
    private static final int VALUE_UNKNOWN = 3;
    private static final int VALUE_IN_RSET = 4;
    private static final int ASCII_STREAM = 1;
    private static final int BINARY_STREAM = 2;
    private static final int UNICODE_STREAM = 3;
    private static int _MIN_STREAM_SIZE = 4000;
    ArrayList tempClobsToFree = null;
    ArrayList tempBlobsToFree = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_12:16:40_PDT_2010";
    public static final boolean TRACE = false;

    UpdatableResultSet(ScrollRsetStatement scrollRsetStatement, ScrollableResultSet scrollableResultSet, int n2, int n3) throws SQLException {
        this.init(scrollRsetStatement, scrollableResultSet, n2, n3);
        scrollableResultSet.resetBeginColumnIndex();
        this.getInternalMetadata();
        this.isCachedRset = true;
    }

    UpdatableResultSet(ScrollRsetStatement scrollRsetStatement, OracleResultSetImpl oracleResultSetImpl, int n2, int n3) throws SQLException {
        this.init(scrollRsetStatement, oracleResultSetImpl, n2, n3);
        this.getInternalMetadata();
        this.isCachedRset = false;
    }

    private void init(ScrollRsetStatement scrollRsetStatement, OracleResultSet oracleResultSet, int n2, int n3) throws SQLException {
        if (scrollRsetStatement == null || oracleResultSet == null || n3 != 1008) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.connection = ((OracleStatement)scrollRsetStatement).connection;
        this.resultSet = oracleResultSet;
        this.scrollStmt = scrollRsetStatement;
        this.rsetType = n2;
        this.deleteStmt = null;
        this.insertStmt = null;
        this.updateStmt = null;
        this.indexColsChanged = null;
        this.rowBuffer = null;
        this.m_nullIndicator = null;
        this.typeInfo = null;
        this.isInserting = false;
        this.isUpdating = false;
        this.wasNull = -1;
        this.rsetMetaData = null;
        this.columnCount = 0;
    }

    void ensureOpen() throws SQLException {
        if (this.closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.resultSet == null || this.scrollStmt == null || ((OracleStatement)this.scrollStmt).closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            super.close();
            if (this.resultSet != null) {
                this.resultSet.close();
            }
            if (this.insertStmt != null) {
                this.insertStmt.close();
            }
            if (this.updateStmt != null) {
                this.updateStmt.close();
            }
            if (this.deleteStmt != null) {
                this.deleteStmt.close();
            }
            if (this.scrollStmt != null) {
                this.scrollStmt.notifyCloseRset();
            }
            this.cancelRowInserts();
            this.connection = LogicalConnection.closedConnection;
            this.resultSet = null;
            this.scrollStmt = null;
            this.rsetMetaData = null;
            this.scrollStmt = null;
            this.deleteStmt = null;
            this.insertStmt = null;
            this.updateStmt = null;
            this.indexColsChanged = null;
            this.rowBuffer = null;
            this.m_nullIndicator = null;
            this.typeInfo = null;
        }
    }

    public boolean wasNull() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            switch (this.wasNull) {
                case 1: {
                    return true;
                }
                case 2: {
                    return false;
                }
                case 4: {
                    return this.resultSet.wasNull();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 24);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    int getFirstUserColumnIndex() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement getStatement() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return (Statement)((Object)this.scrollStmt);
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        SQLWarning sQLWarning = this.resultSet.getWarnings();
        if (this.sqlWarning == null) {
            return sQLWarning;
        }
        SQLWarning sQLWarning2 = this.sqlWarning;
        while (sQLWarning2.getNextWarning() != null) {
            sQLWarning2 = sQLWarning2.getNextWarning();
        }
        sQLWarning2.setNextWarning(sQLWarning);
        return this.sqlWarning;
    }

    public void clearWarnings() throws SQLException {
        this.sqlWarning = null;
        this.resultSet.clearWarnings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.cancelRowChanges();
            return this.resultSet.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBeforeFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            return this.resultSet.isBeforeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAfterLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            return this.resultSet.isAfterLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            return this.resultSet.isFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            return this.resultSet.isLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.cancelRowChanges();
            this.resultSet.beforeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.cancelRowChanges();
            this.resultSet.afterLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean first() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.cancelRowChanges();
            return this.resultSet.first();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean last() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.cancelRowChanges();
            return this.resultSet.last();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            return this.resultSet.getRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean absolute(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.cancelRowChanges();
            return this.resultSet.absolute(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean relative(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.cancelRowChanges();
            return this.resultSet.relative(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean previous() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.cancelRowChanges();
            return this.resultSet.previous();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum getOracleObject(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            Datum datum = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                this.setIsNull(datum == null);
                datum = this.getRowBufferDatumAt(n2);
            } else {
                this.setIsNull(4);
                datum = this.resultSet.getOracleObject(n2 + 1);
            }
            return datum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            String string = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    string = datum.stringValue(this.connection);
                }
            } else {
                this.setIsNull(4);
                string = this.resultSet.getString(n2 + 1);
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            boolean bl = false;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    bl = datum.booleanValue();
                }
            } else {
                this.setIsNull(4);
                bl = this.resultSet.getBoolean(n2 + 1);
            }
            return bl;
        }
    }

    public OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int n2) throws SQLException {
        return this.resultSet.getAuthorizationIndicator(n2 + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getByte(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            byte by = 0;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    by = datum.byteValue();
                }
            } else {
                this.setIsNull(4);
                by = this.resultSet.getByte(n2 + 1);
            }
            return by;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            short s2 = 0;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                long l2 = this.getLong(n2);
                if (l2 > 65537L || l2 < -65538L) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 26, "getShort");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                s2 = (short)l2;
            } else {
                this.setIsNull(4);
                s2 = this.resultSet.getShort(n2 + 1);
            }
            return s2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            int n3 = 0;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    n3 = datum.intValue();
                }
            } else {
                this.setIsNull(4);
                n3 = this.resultSet.getInt(n2 + 1);
            }
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            long l2 = 0L;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    l2 = datum.longValue();
                }
            } else {
                this.setIsNull(4);
                l2 = this.resultSet.getLong(n2 + 1);
            }
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            float f2 = 0.0f;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    f2 = datum.floatValue();
                }
            } else {
                this.setIsNull(4);
                f2 = this.resultSet.getFloat(n2 + 1);
            }
            return f2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            double d2 = 0.0;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    d2 = datum.doubleValue();
                }
            } else {
                this.setIsNull(4);
                d2 = this.resultSet.getDouble(n2 + 1);
            }
            return d2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            BigDecimal bigDecimal = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    bigDecimal = datum.bigDecimalValue();
                }
            } else {
                this.setIsNull(4);
                bigDecimal = this.resultSet.getBigDecimal(n2 + 1);
            }
            return bigDecimal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            byte[] byArray = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    byArray = datum.getBytes();
                }
            } else {
                this.setIsNull(4);
                byArray = this.resultSet.getBytes(n2 + 1);
            }
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            Date date = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    date = datum.dateValue();
                }
            } else {
                this.setIsNull(4);
                date = this.resultSet.getDate(n2 + 1);
            }
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            Time time = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    time = datum.timeValue();
                }
            } else {
                this.setIsNull(4);
                time = this.resultSet.getTime(n2 + 1);
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            Timestamp timestamp = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    timestamp = datum.timestampValue();
                }
            } else {
                this.setIsNull(4);
                timestamp = this.resultSet.getTimestamp(n2 + 1);
            }
            return timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getAsciiStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            InputStream inputStream = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Object object = this.getRowBufferAt(n2);
                this.setIsNull(object == null);
                if (object != null) {
                    if (object instanceof InputStream) {
                        inputStream = (InputStream)object;
                    } else {
                        Datum datum = this.getRowBufferDatumAt(n2);
                        inputStream = datum.asciiStreamValue();
                    }
                }
            } else {
                this.setIsNull(4);
                inputStream = this.resultSet.getAsciiStream(n2 + 1);
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InputStream getUnicodeStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            InputStream inputStream = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Object object = this.getRowBufferAt(n2);
                this.setIsNull(object == null);
                if (object == null) return inputStream;
                if (object instanceof InputStream) {
                    return (InputStream)object;
                }
                Datum datum = this.getRowBufferDatumAt(n2);
                DBConversion dBConversion = this.connection.conversion;
                byte[] byArray = datum.shareBytes();
                if (datum instanceof RAW) {
                    return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 3);
                }
                if (datum instanceof CHAR) {
                    return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 1);
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getUnicodeStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setIsNull(4);
            return this.resultSet.getUnicodeStream(n2 + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            InputStream inputStream = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Object object = this.getRowBufferAt(n2);
                this.setIsNull(object == null);
                if (object != null) {
                    if (object instanceof InputStream) {
                        inputStream = (InputStream)object;
                    } else {
                        Datum datum = this.getRowBufferDatumAt(n2);
                        inputStream = datum.binaryStreamValue();
                    }
                }
            } else {
                this.setIsNull(4);
                inputStream = this.resultSet.getBinaryStream(n2 + 1);
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            Object object = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getOracleObject(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    object = datum.toJdbc();
                }
            } else {
                this.setIsNull(4);
                object = this.resultSet.getObject(n2 + 1);
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getCharacterStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            Reader reader = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Object object = this.getRowBufferAt(n2);
                this.setIsNull(object == null);
                if (object != null) {
                    if (object instanceof Reader) {
                        reader = (Reader)object;
                    } else {
                        Datum datum = this.getRowBufferDatumAt(n2);
                        reader = datum.characterStreamValue();
                    }
                }
            } else {
                this.setIsNull(4);
                reader = this.resultSet.getCharacterStream(n2 + 1);
            }
            return reader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            BigDecimal bigDecimal = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    bigDecimal = datum.bigDecimalValue();
                }
            } else {
                this.setIsNull(4);
                bigDecimal = this.resultSet.getBigDecimal(n2 + 1);
            }
            return bigDecimal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int n2, Map map) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            Object object = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getOracleObject(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    object = datum instanceof STRUCT ? ((STRUCT)datum).toJdbc(map) : datum.toJdbc();
                }
            } else {
                this.setIsNull(4);
                object = this.resultSet.getObject(n2 + 1, map);
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ref getRef(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            return this.getREF(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getBlob(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            return this.getBLOB(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clob getClob(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            return this.getCLOB(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Array getArray(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            return this.getARRAY(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            Date date = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getOracleObject(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    if (datum instanceof DATE) {
                        date = ((DATE)datum).dateValue(calendar);
                    } else if (datum instanceof TIMESTAMP) {
                        Timestamp timestamp = ((TIMESTAMP)datum).timestampValue(calendar);
                        long l2 = timestamp.getTime();
                        date = new Date(l2);
                    } else {
                        DATE dATE = new DATE(datum.stringValue(this.connection));
                        if (dATE != null) {
                            date = dATE.dateValue(calendar);
                        }
                    }
                }
            } else {
                this.setIsNull(4);
                date = this.resultSet.getDate(n2 + 1, calendar);
            }
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            Time time = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getOracleObject(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    if (datum instanceof DATE) {
                        time = ((DATE)datum).timeValue(calendar);
                    } else if (datum instanceof TIMESTAMP) {
                        Timestamp timestamp = ((TIMESTAMP)datum).timestampValue(calendar);
                        long l2 = timestamp.getTime();
                        time = new Time(l2);
                    } else {
                        DATE dATE = new DATE(datum.stringValue(this.connection));
                        if (dATE != null) {
                            time = dATE.timeValue(calendar);
                        }
                    }
                }
            } else {
                this.setIsNull(4);
                time = this.resultSet.getTime(n2 + 1, calendar);
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            Timestamp timestamp = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getOracleObject(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    if (datum instanceof DATE) {
                        timestamp = ((DATE)datum).timestampValue(calendar);
                    } else if (datum instanceof TIMESTAMP) {
                        timestamp = ((TIMESTAMP)datum).timestampValue(calendar);
                    } else {
                        DATE dATE = new DATE(datum.stringValue(this.connection));
                        if (dATE != null) {
                            timestamp = dATE.timestampValue(calendar);
                        }
                    }
                }
            } else {
                this.setIsNull(4);
                timestamp = this.resultSet.getTimestamp(n2 + 1, calendar);
            }
            return timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getURL(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            URL uRL = null;
            int n3 = this.getInternalMetadata().getColumnType(n2 + 1);
            int n4 = SQLUtil.getInternalType(n3);
            if (n4 == 96 || n4 == 1 || n4 == 8) {
                try {
                    String string = this.getString(n2);
                    if (string == null) {
                        uRL = null;
                    }
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 136);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            } else {
                SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return uRL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getCursor(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            ResultSet resultSet = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getOracleObject(n2);
                this.setIsNull(datum == null);
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCursor");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setIsNull(4);
            resultSet = this.resultSet.getCursor(n2 + 1);
            return resultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ROWID getROWID(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            ROWID rOWID = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof ROWID)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getROWID");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                rOWID = (ROWID)datum;
            } else {
                this.setIsNull(4);
                rOWID = this.resultSet.getROWID(n2 + 1);
            }
            return rOWID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NUMBER getNUMBER(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            NUMBER nUMBER = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof NUMBER)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getNUMBER");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                nUMBER = (NUMBER)datum;
            } else {
                this.setIsNull(4);
                nUMBER = this.resultSet.getNUMBER(n2 + 1);
            }
            return nUMBER;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DATE getDATE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum;
            this.ensureOpen();
            DATE dATE = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                datum = this.getRowBufferDatumAt(n2);
                if (datum != null) {
                    if (datum instanceof DATE) {
                        return (DATE)datum;
                    }
                    if (datum instanceof TIMESTAMP) {
                        Timestamp timestamp = ((TIMESTAMP)datum).timestampValue();
                        return new DATE(timestamp);
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getDATE");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            } else {
                this.setIsNull(4);
                return this.resultSet.getDATE(n2 + 1);
            }
            this.setIsNull(datum == null);
            return dATE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            TIMESTAMP tIMESTAMP = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof TIMESTAMP)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMP");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                tIMESTAMP = (TIMESTAMP)datum;
            } else {
                this.setIsNull(4);
                tIMESTAMP = this.resultSet.getTIMESTAMP(n2 + 1);
            }
            return tIMESTAMP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            TIMESTAMPTZ tIMESTAMPTZ = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof TIMESTAMPTZ)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPTZ");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                tIMESTAMPTZ = (TIMESTAMPTZ)datum;
            } else {
                this.setIsNull(4);
                tIMESTAMPTZ = this.resultSet.getTIMESTAMPTZ(n2 + 1);
            }
            return tIMESTAMPTZ;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            TIMESTAMPLTZ tIMESTAMPLTZ = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof TIMESTAMPLTZ)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPLTZ");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                tIMESTAMPLTZ = (TIMESTAMPLTZ)datum;
            } else {
                this.setIsNull(4);
                tIMESTAMPLTZ = this.resultSet.getTIMESTAMPLTZ(n2 + 1);
            }
            return tIMESTAMPLTZ;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INTERVALDS getINTERVALDS(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            INTERVALDS iNTERVALDS = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof INTERVALDS)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getINTERVALDS");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                iNTERVALDS = (INTERVALDS)datum;
            } else {
                this.setIsNull(4);
                iNTERVALDS = this.resultSet.getINTERVALDS(n2 + 1);
            }
            return iNTERVALDS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INTERVALYM getINTERVALYM(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            INTERVALYM iNTERVALYM = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof INTERVALYM)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getINTERVALYM");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                iNTERVALYM = (INTERVALYM)datum;
            } else {
                this.setIsNull(4);
                iNTERVALYM = this.resultSet.getINTERVALYM(n2 + 1);
            }
            return iNTERVALYM;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ARRAY getARRAY(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            ARRAY aRRAY = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof ARRAY)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getARRAY");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                aRRAY = (ARRAY)datum;
            } else {
                this.setIsNull(4);
                aRRAY = this.resultSet.getARRAY(n2 + 1);
            }
            return aRRAY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public STRUCT getSTRUCT(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            STRUCT sTRUCT = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof STRUCT)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getSTRUCT");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                sTRUCT = (STRUCT)datum;
            } else {
                this.setIsNull(4);
                sTRUCT = this.resultSet.getSTRUCT(n2 + 1);
            }
            return sTRUCT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPAQUE getOPAQUE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            OPAQUE oPAQUE = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof OPAQUE)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getOPAQUE");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                oPAQUE = (OPAQUE)datum;
            } else {
                this.setIsNull(4);
                oPAQUE = this.resultSet.getOPAQUE(n2 + 1);
            }
            return oPAQUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REF getREF(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            REF rEF = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof REF)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getREF");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                rEF = (REF)datum;
            } else {
                this.setIsNull(4);
                rEF = this.resultSet.getREF(n2 + 1);
            }
            return rEF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CHAR getCHAR(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            CHAR cHAR = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof CHAR)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCHAR");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                cHAR = (CHAR)datum;
            } else {
                this.setIsNull(4);
                cHAR = this.resultSet.getCHAR(n2 + 1);
            }
            return cHAR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RAW getRAW(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            RAW rAW = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof RAW)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getRAW");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                rAW = (RAW)datum;
            } else {
                this.setIsNull(4);
                rAW = this.resultSet.getRAW(n2 + 1);
            }
            return rAW;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BLOB getBLOB(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            BLOB bLOB = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof BLOB)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBLOB");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                bLOB = (BLOB)datum;
            } else {
                this.setIsNull(4);
                bLOB = this.resultSet.getBLOB(n2 + 1);
            }
            return bLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CLOB getCLOB(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            CLOB cLOB = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof CLOB)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCLOB");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                cLOB = (CLOB)datum;
            } else {
                this.setIsNull(4);
                cLOB = this.resultSet.getCLOB(n2 + 1);
            }
            return cLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BFILE getBFILE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            BFILE bFILE = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof BFILE)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBFILE");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                bFILE = (BFILE)datum;
            } else {
                this.setIsNull(4);
                bFILE = this.resultSet.getBFILE(n2 + 1);
            }
            return bFILE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BFILE getBfile(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            return this.getBFILE(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomDatum getCustomDatum(int n2, CustomDatumFactory customDatumFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (customDatumFactory == null) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            CustomDatum customDatum = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                customDatum = customDatumFactory.create(datum, 0);
            } else {
                this.setIsNull(4);
                customDatum = this.resultSet.getCustomDatum(n2 + 1, customDatumFactory);
            }
            return customDatum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ORAData getORAData(int n2, ORADataFactory oRADataFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (oRADataFactory == null) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            ORAData oRAData = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                oRAData = oRADataFactory.create(datum, 0);
            } else {
                this.setIsNull(4);
                oRAData = this.resultSet.getORAData(n2 + 1, oRADataFactory);
            }
            return oRAData;
        }
    }

    void updateBlob(int n2, InputStream inputStream, long l2) throws SQLException {
        BLOB bLOB = BLOB.createTemporary(this.connection, true, 10);
        this.addToTempLobsToFree(bLOB);
        int n3 = bLOB.getBufferSize();
        OutputStream outputStream = bLOB.setBinaryStream(1L);
        byte[] byArray = new byte[n3];
        try {
            int n4;
            for (long i2 = l2; i2 > 0L && (n4 = inputStream.read(byArray, 0, Math.min(n3, (int)i2))) != -1; i2 -= (long)n4) {
                outputStream.write(byArray, 0, n4);
            }
            outputStream.close();
            this.updateBlob(n2, (Blob)bLOB);
        }
        catch (IOException iOException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    void updateClob(int n2, Reader reader, long l2) throws SQLException {
        CLOB cLOB = CLOB.createTemporary(this.connection, true, 10);
        this.addToTempLobsToFree(cLOB);
        int n3 = cLOB.getBufferSize();
        Writer writer = cLOB.setCharacterStream(1L);
        char[] cArray = new char[n3];
        try {
            int n4;
            for (long i2 = l2; i2 > 0L && (n4 = reader.read(cArray, 0, Math.min(n3, (int)i2))) != -1; i2 -= (long)n4) {
                writer.write(cArray, 0, n4);
            }
            writer.close();
            this.updateClob(n2, (Clob)cLOB);
        }
        catch (IOException iOException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    void updateClob(int n2, InputStream inputStream, int n3) throws SQLException {
        CLOB cLOB = CLOB.createTemporary(this.connection, true, 10);
        this.addToTempLobsToFree(cLOB);
        int n4 = cLOB.getBufferSize();
        OutputStream outputStream = cLOB.setAsciiStream(1L);
        byte[] byArray = new byte[n4];
        try {
            int n5;
            for (long i2 = (long)n3; i2 > 0L && (n5 = inputStream.read(byArray, 0, Math.min(n4, (int)i2))) != -1; i2 -= (long)n5) {
                outputStream.write(byArray, 0, n5);
            }
            outputStream.close();
            this.updateClob(n2, (Clob)cLOB);
        }
        catch (IOException iOException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    void addToTempLobsToFree(Clob clob) {
        if (this.tempClobsToFree == null) {
            this.tempClobsToFree = new ArrayList();
        }
        this.tempClobsToFree.add(clob);
    }

    void addToTempLobsToFree(Blob blob) {
        if (this.tempBlobsToFree == null) {
            this.tempBlobsToFree = new ArrayList();
        }
        this.tempBlobsToFree.add(blob);
    }

    void cleanTempLobs() {
        this.cleanTempClobs(this.tempClobsToFree);
        this.cleanTempBlobs(this.tempBlobsToFree);
        this.tempClobsToFree = null;
        this.tempBlobsToFree = null;
    }

    void cleanTempBlobs(ArrayList arrayList) {
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                try {
                    ((BLOB)iterator.next()).freeTemporary();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    void cleanTempClobs(ArrayList arrayList) {
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                try {
                    ((CLOB)iterator.next()).freeTemporary();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        if (((OracleStatement)this.scrollStmt).closed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9, "getMetaData");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return new OracleResultSetMetaData(this.connection, (OracleStatement)this.scrollStmt, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findColumn(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            return this.resultSet.findColumn(string) - 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchDirection(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.resultSet.setFetchDirection(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFetchDirection() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            return this.resultSet.getFetchDirection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchSize(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.resultSet.setFetchSize(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFetchSize() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            return this.resultSet.getFetchSize();
        }
    }

    public int getType() throws SQLException {
        return this.rsetType;
    }

    public int getConcurrency() throws SQLException {
        return 1008;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (!this.isOnInsertRow()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 83);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.prepareInsertRowStatement();
            this.prepareInsertRowBinds();
            this.executeInsertRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isOnInsertRow()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 84);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n2 = this.getNumColumnsChanged();
            if (n2 > 0) {
                this.prepareUpdateRowStatement(n2);
                this.prepareUpdateRowBinds(n2);
                this.executeUpdateRow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isOnInsertRow()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 84);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.prepareDeleteRowStatement();
            this.prepareDeleteRowBinds();
            this.executeDeleteRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isOnInsertRow()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 84);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.resultSet.refreshRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRowUpdates() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isUpdating) {
                this.isUpdating = false;
                this.clearRowBuffer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToInsertRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isOnInsertRow()) {
                return;
            }
            this.isInserting = true;
            if (this.rowBuffer == null) {
                this.rowBuffer = new Object[this.getColumnCount()];
            }
            if (this.m_nullIndicator == null) {
                this.m_nullIndicator = new boolean[this.getColumnCount()];
            }
            this.clearRowBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToCurrentRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            this.cancelRowInserts();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateString(int n2, String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (string == null || string.length() == 0) {
                this.updateNull(n2);
            } else {
                this.updateObject(n2, (Object)string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNull(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setRowBufferAt(n2, null);
        }
    }

    public void updateBoolean(int n2, boolean bl) throws SQLException {
        this.updateObject(n2, (Object)bl);
    }

    public void updateByte(int n2, byte by) throws SQLException {
        this.updateObject(n2, (Object)by);
    }

    public void updateShort(int n2, short s2) throws SQLException {
        this.updateObject(n2, (Object)s2);
    }

    public void updateInt(int n2, int n3) throws SQLException {
        this.updateObject(n2, (Object)n3);
    }

    public void updateLong(int n2, long l2) throws SQLException {
        this.updateObject(n2, (Object)l2);
    }

    public void updateFloat(int n2, float f2) throws SQLException {
        this.updateObject(n2, (Object)Float.valueOf(f2));
    }

    public void updateDouble(int n2, double d2) throws SQLException {
        this.updateObject(n2, (Object)d2);
    }

    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.updateObject(n2, (Object)bigDecimal);
    }

    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        this.updateObject(n2, (Object)byArray);
    }

    public void updateDate(int n2, Date date) throws SQLException {
        this.updateObject(n2, (Object)date);
    }

    public void updateTime(int n2, Time time) throws SQLException {
        this.updateObject(n2, (Object)time);
    }

    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.updateObject(n2, (Object)timestamp);
    }

    public void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.ensureOpen();
        int n4 = this.getInternalMetadata().getColumnType(1 + n2);
        if (inputStream != null && n3 > 0) {
            switch (n4) {
                case 2005: {
                    this.updateClob(n2, inputStream, n3);
                    break;
                }
                case 2004: {
                    this.updateBlob(n2, inputStream, (long)n3);
                    break;
                }
                case -1: {
                    int[] nArray = new int[]{n3, 1};
                    this.setRowBufferAt(n2, inputStream, nArray);
                    break;
                }
                default: {
                    try {
                        int n5;
                        int n6 = 0;
                        byte[] byArray = new byte[1024];
                        char[] cArray = new char[1024];
                        StringBuilder stringBuilder = new StringBuilder(1024);
                        for (n5 = n3; n5 > 0 && (n6 = n5 >= 1024 ? inputStream.read(byArray) : inputStream.read(byArray, 0, n5)) != -1; n5 -= n6) {
                            DBConversion cfr_ignored_0 = this.connection.conversion;
                            DBConversion.asciiBytesToJavaChars(byArray, n6, cArray);
                            stringBuilder.append(cArray, 0, n6);
                        }
                        inputStream.close();
                        if (n5 == n3) {
                            this.updateNull(n2);
                            return;
                        }
                        this.updateString(n2, stringBuilder.toString());
                        break;
                    }
                    catch (IOException iOException) {
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                }
            }
        } else {
            this.setRowBufferAt(n2, null);
        }
    }

    public void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.ensureOpen();
        int n4 = this.getInternalMetadata().getColumnType(1 + n2);
        if (inputStream != null && n3 > 0) {
            switch (n4) {
                case 2004: {
                    this.updateBlob(n2, inputStream, (long)n3);
                    break;
                }
                case -4: {
                    int[] nArray = new int[]{n3, 2};
                    this.setRowBufferAt(n2, inputStream, nArray);
                    break;
                }
                default: {
                    try {
                        int n5;
                        int n6 = 0;
                        byte[] byArray = new byte[1024];
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                        for (n5 = n3; n5 > 0 && (n6 = n5 >= 1024 ? inputStream.read(byArray) : inputStream.read(byArray, 0, n5)) != -1; n5 -= n6) {
                            byteArrayOutputStream.write(byArray, 0, n6);
                        }
                        inputStream.close();
                        if (n5 == n3) {
                            this.updateNull(n2);
                            return;
                        }
                        this.updateBytes(n2, byteArrayOutputStream.toByteArray());
                        break;
                    }
                    catch (IOException iOException) {
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                }
            }
        } else {
            this.setRowBufferAt(n2, null);
        }
    }

    public void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        int n4 = 0;
        this.ensureOpen();
        int n5 = this.getInternalMetadata().getColumnType(1 + n2);
        if (reader != null && n3 > 0) {
            switch (n5) {
                case 2005: {
                    this.updateClob(n2, reader, (long)n3);
                    break;
                }
                case -1: {
                    int[] nArray = new int[]{n3};
                    this.setRowBufferAt(n2, reader, nArray);
                    break;
                }
                default: {
                    try {
                        int n6;
                        char[] cArray = new char[1024];
                        StringBuilder stringBuilder = new StringBuilder(1024);
                        for (n6 = n3; n6 > 0 && (n4 = n6 >= 1024 ? reader.read(cArray) : reader.read(cArray, 0, n6)) != -1; n6 -= n4) {
                            stringBuilder.append(cArray, 0, n4);
                        }
                        reader.close();
                        if (n6 == n3) {
                            this.updateNull(n2);
                            return;
                        }
                        this.updateString(n2, stringBuilder.toString());
                        break;
                    }
                    catch (IOException iOException) {
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                }
            }
        } else {
            this.setRowBufferAt(n2, null);
        }
    }

    public void updateObject(int n2, Object object, int n3) throws SQLException {
        this.updateObject(n2, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObject(int n2, Object object) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            Datum datum = null;
            if (object != null) {
                if (object instanceof Datum) {
                    datum = (Datum)object;
                } else {
                    int n3;
                    OracleResultSetMetaData oracleResultSetMetaData = (OracleResultSetMetaData)this.getInternalMetadata();
                    if (oracleResultSetMetaData.getColumnType(n3 = n2 + 1) == 96) {
                        int n4 = oracleResultSetMetaData.getColumnDisplaySize(n3);
                        String string = (String)object;
                        for (int i2 = string.length(); i2 < n4; ++i2) {
                            string = string + " ";
                        }
                    }
                    datum = SQLUtil.makeOracleDatum(this.connection, object, oracleResultSetMetaData.getColumnType(n3), null, oracleResultSetMetaData.isNCHAR(n3));
                }
            }
            this.setRowBufferAt(n2, datum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOracleObject(int n2, Datum datum) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setRowBufferAt(n2, datum);
        }
    }

    public void updateROWID(int n2, ROWID rOWID) throws SQLException {
        this.updateOracleObject(n2, (Datum)rOWID);
    }

    public void updateNUMBER(int n2, NUMBER nUMBER) throws SQLException {
        this.updateOracleObject(n2, (Datum)nUMBER);
    }

    public void updateDATE(int n2, DATE dATE) throws SQLException {
        this.updateOracleObject(n2, (Datum)dATE);
    }

    public void updateINTERVALYM(int n2, INTERVALYM iNTERVALYM) throws SQLException {
        this.updateOracleObject(n2, (Datum)iNTERVALYM);
    }

    public void updateINTERVALDS(int n2, INTERVALDS iNTERVALDS) throws SQLException {
        this.updateOracleObject(n2, (Datum)iNTERVALDS);
    }

    public void updateTIMESTAMP(int n2, TIMESTAMP tIMESTAMP) throws SQLException {
        this.updateOracleObject(n2, (Datum)tIMESTAMP);
    }

    public void updateTIMESTAMPTZ(int n2, TIMESTAMPTZ tIMESTAMPTZ) throws SQLException {
        this.updateOracleObject(n2, (Datum)tIMESTAMPTZ);
    }

    public void updateTIMESTAMPLTZ(int n2, TIMESTAMPLTZ tIMESTAMPLTZ) throws SQLException {
        this.updateOracleObject(n2, (Datum)tIMESTAMPLTZ);
    }

    public void updateARRAY(int n2, ARRAY aRRAY) throws SQLException {
        this.updateOracleObject(n2, (Datum)aRRAY);
    }

    public void updateSTRUCT(int n2, STRUCT sTRUCT) throws SQLException {
        this.updateOracleObject(n2, (Datum)sTRUCT);
    }

    public void updateOPAQUE(int n2, OPAQUE oPAQUE) throws SQLException {
        this.updateOracleObject(n2, (Datum)oPAQUE);
    }

    public void updateREF(int n2, REF rEF) throws SQLException {
        this.updateOracleObject(n2, (Datum)rEF);
    }

    public void updateCHAR(int n2, CHAR cHAR) throws SQLException {
        this.updateOracleObject(n2, (Datum)cHAR);
    }

    public void updateRAW(int n2, RAW rAW) throws SQLException {
        this.updateOracleObject(n2, (Datum)rAW);
    }

    public void updateBLOB(int n2, BLOB bLOB) throws SQLException {
        this.updateOracleObject(n2, (Datum)bLOB);
    }

    public void updateCLOB(int n2, CLOB cLOB) throws SQLException {
        this.updateOracleObject(n2, (Datum)cLOB);
    }

    public void updateBFILE(int n2, BFILE bFILE) throws SQLException {
        this.updateOracleObject(n2, (Datum)bFILE);
    }

    public void updateBfile(int n2, BFILE bFILE) throws SQLException {
        this.updateOracleObject(n2, (Datum)bFILE);
    }

    public void updateCustomDatum(int n2, CustomDatum customDatum) throws SQLException {
        throw new Error("wanna do datum = ((CustomDatum) x).toDatum(m_comm)");
    }

    public void updateORAData(int n2, ORAData oRAData) throws SQLException {
        Datum datum = oRAData.toDatum(this.connection);
        this.updateOracleObject(n2, datum);
    }

    public void updateRef(int n2, Ref ref) throws SQLException {
        this.updateREF(n2, (REF)ref);
    }

    public void updateBlob(int n2, Blob blob) throws SQLException {
        this.updateBLOB(n2, (BLOB)blob);
    }

    public void updateClob(int n2, Clob clob) throws SQLException {
        this.updateCLOB(n2, (CLOB)clob);
    }

    public void updateArray(int n2, Array array) throws SQLException {
        this.updateARRAY(n2, (ARRAY)array);
    }

    int getColumnCount() throws SQLException {
        if (this.columnCount == 0) {
            this.columnCount = this.resultSet instanceof OracleResultSetImpl ? (((OracleResultSetImpl)this.resultSet).statement.accessors != null ? ((OracleResultSetImpl)this.resultSet).statement.numberOfDefinePositions : this.getInternalMetadata().getColumnCount()) : ((ScrollableResultSet)this.resultSet).getColumnCount();
        }
        return this.columnCount;
    }

    ResultSetMetaData getInternalMetadata() throws SQLException {
        if (this.rsetMetaData == null) {
            this.rsetMetaData = this.resultSet.getMetaData();
        }
        return this.rsetMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelRowChanges() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.isInserting) {
                this.cancelRowInserts();
            }
            if (this.isUpdating) {
                this.cancelRowUpdates();
            }
        }
    }

    boolean isOnInsertRow() {
        return this.isInserting;
    }

    private void cancelRowInserts() {
        if (this.isInserting) {
            this.isInserting = false;
            this.clearRowBuffer();
        }
    }

    boolean isUpdatingRow() {
        return this.isUpdating;
    }

    private void clearRowBuffer() {
        int n2;
        if (this.rowBuffer != null) {
            for (n2 = 0; n2 < this.rowBuffer.length; ++n2) {
                this.rowBuffer[n2] = null;
            }
        }
        if (this.m_nullIndicator != null) {
            for (n2 = 0; n2 < this.m_nullIndicator.length; ++n2) {
                this.m_nullIndicator[n2] = false;
            }
        }
        if (this.typeInfo != null) {
            for (n2 = 0; n2 < this.typeInfo.length; ++n2) {
                if (this.typeInfo[n2] == null) continue;
                for (int i2 = 0; i2 < this.typeInfo[n2].length; ++i2) {
                    this.typeInfo[n2][i2] = 0;
                }
            }
        }
    }

    private void setRowBufferAt(int n2, Datum datum) throws SQLException {
        this.setRowBufferAt(n2, datum, null);
    }

    private void setRowBufferAt(int n2, Object object, int[] nArray) throws SQLException {
        if (!this.isInserting) {
            if (this.isBeforeFirst() || this.isAfterLast() || this.getRow() == 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.isUpdating = true;
        }
        if (n2 < 1 || n2 > this.getColumnCount() - 1) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "setRowBufferAt");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowBuffer == null) {
            this.rowBuffer = new Object[this.getColumnCount()];
        }
        if (this.m_nullIndicator == null) {
            this.m_nullIndicator = new boolean[this.getColumnCount()];
            for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
                this.m_nullIndicator[i2] = false;
            }
        }
        if (nArray != null) {
            if (this.typeInfo == null) {
                this.typeInfo = new int[this.getColumnCount()][];
            }
            this.typeInfo[n2] = nArray;
        }
        this.rowBuffer[n2] = object;
        this.m_nullIndicator[n2] = object == null;
    }

    private Datum getRowBufferDatumAt(int n2) throws SQLException {
        Object object;
        if (n2 < 1 || n2 > this.getColumnCount() - 1) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getRowBufferDatumAt");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Datum datum = null;
        if (this.rowBuffer != null && (object = this.rowBuffer[n2]) != null) {
            if (object instanceof Datum) {
                datum = (Datum)object;
            } else {
                OracleResultSetMetaData oracleResultSetMetaData = (OracleResultSetMetaData)this.getInternalMetadata();
                int n3 = n2 + 1;
                datum = SQLUtil.makeOracleDatum(this.connection, object, oracleResultSetMetaData.getColumnType(n3), null, oracleResultSetMetaData.isNCHAR(n3));
                this.rowBuffer[n2] = datum;
            }
        }
        return datum;
    }

    private Object getRowBufferAt(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.getColumnCount() - 1) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getRowBufferDatumAt");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowBuffer != null) {
            return this.rowBuffer[n2];
        }
        return null;
    }

    private boolean isRowBufferUpdatedAt(int n2) {
        if (this.rowBuffer == null) {
            return false;
        }
        return this.rowBuffer[n2] != null || this.m_nullIndicator[n2];
    }

    private void prepareInsertRowStatement() throws SQLException {
        if (this.insertStmt == null) {
            PreparedStatement preparedStatement = this.connection.prepareStatement(((OracleStatement)this.scrollStmt).sqlObject.getInsertSqlForUpdatableResultSet(this));
            this.insertStmt = (OraclePreparedStatement)((OraclePreparedStatementWrapper)preparedStatement).preparedStatement;
            this.insertStmt.setQueryTimeout(((Statement)((Object)this.scrollStmt)).getQueryTimeout());
            if (((OracleStatement)this.scrollStmt).sqlObject.generatedSqlNeedEscapeProcessing()) {
                this.insertStmt.setEscapeProcessing(true);
            }
        }
    }

    private void prepareInsertRowBinds() throws SQLException {
        int n2 = 1;
        n2 = this.prepareSubqueryBinds(this.insertStmt, n2);
        OracleResultSetMetaData oracleResultSetMetaData = (OracleResultSetMetaData)this.getInternalMetadata();
        for (int i2 = 1; i2 < this.getColumnCount(); ++i2) {
            Object object = this.getRowBufferAt(i2);
            if (object != null) {
                if (object instanceof Reader) {
                    if (oracleResultSetMetaData.isNCHAR(i2 + 1)) {
                        this.insertStmt.setFormOfUse(n2, (short)2);
                    }
                    this.insertStmt.setCharacterStream(n2 + i2 - 1, (Reader)object, this.typeInfo[i2][0]);
                    continue;
                }
                if (object instanceof InputStream) {
                    if (this.typeInfo[i2][1] == 2) {
                        this.insertStmt.setBinaryStream(n2 + i2 - 1, (InputStream)object, this.typeInfo[i2][0]);
                        continue;
                    }
                    if (this.typeInfo[i2][1] != 1) continue;
                    this.insertStmt.setAsciiStream(n2 + i2 - 1, (InputStream)object, this.typeInfo[i2][0]);
                    continue;
                }
                Datum datum = this.getRowBufferDatumAt(i2);
                if (oracleResultSetMetaData.isNCHAR(i2 + 1)) {
                    this.insertStmt.setFormOfUse(n2 + i2 - 1, (short)2);
                }
                this.insertStmt.setOracleObject(n2 + i2 - 1, datum);
                continue;
            }
            int n3 = this.getInternalMetadata().getColumnType(i2 + 1);
            if (n3 == 2006 || n3 == 2002 || n3 == 2008 || n3 == 2007 || n3 == 2003) {
                this.insertStmt.setNull(n2 + i2 - 1, n3, this.getInternalMetadata().getColumnTypeName(i2 + 1));
                continue;
            }
            this.insertStmt.setNull(n2 + i2 - 1, n3);
        }
    }

    private void executeInsertRow() throws SQLException {
        if (this.insertStmt.executeUpdate() != 1) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 85);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    private int getNumColumnsChanged() throws SQLException {
        int n2 = 0;
        if (this.indexColsChanged == null) {
            this.indexColsChanged = new int[this.getColumnCount()];
        }
        if (this.rowBuffer != null) {
            for (int i2 = 1; i2 < this.getColumnCount(); ++i2) {
                if (this.rowBuffer[i2] == null && (this.rowBuffer[i2] != null || !this.m_nullIndicator[i2])) continue;
                this.indexColsChanged[n2++] = i2;
            }
        }
        return n2;
    }

    private void prepareUpdateRowStatement(int n2) throws SQLException {
        if (this.updateStmt != null) {
            this.updateStmt.close();
        }
        PreparedStatement preparedStatement = this.connection.prepareStatement(((OracleStatement)this.scrollStmt).sqlObject.getUpdateSqlForUpdatableResultSet(this, n2, this.rowBuffer, this.indexColsChanged));
        this.updateStmt = (OraclePreparedStatement)((OraclePreparedStatementWrapper)preparedStatement).preparedStatement;
        this.updateStmt.setQueryTimeout(((Statement)((Object)this.scrollStmt)).getQueryTimeout());
        if (((OracleStatement)this.scrollStmt).sqlObject.generatedSqlNeedEscapeProcessing()) {
            this.updateStmt.setEscapeProcessing(true);
        }
    }

    private void prepareUpdateRowBinds(int n2) throws SQLException {
        int n3 = 1;
        n3 = this.prepareSubqueryBinds(this.updateStmt, n3);
        OracleResultSetMetaData oracleResultSetMetaData = (OracleResultSetMetaData)this.getInternalMetadata();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = this.indexColsChanged[i2];
            Object object = this.getRowBufferAt(n4);
            if (object != null) {
                if (object instanceof Reader) {
                    if (oracleResultSetMetaData.isNCHAR(n4 + 1)) {
                        this.updateStmt.setFormOfUse(n3, (short)2);
                    }
                    this.updateStmt.setCharacterStream(n3++, (Reader)object, this.typeInfo[n4][0]);
                    continue;
                }
                if (object instanceof InputStream) {
                    if (this.typeInfo[n4][1] == 2) {
                        this.updateStmt.setBinaryStream(n3++, (InputStream)object, this.typeInfo[n4][0]);
                        continue;
                    }
                    if (this.typeInfo[n4][1] != 1) continue;
                    this.updateStmt.setAsciiStream(n3++, (InputStream)object, this.typeInfo[n4][0]);
                    continue;
                }
                Datum datum = this.getRowBufferDatumAt(n4);
                if (oracleResultSetMetaData.isNCHAR(n4 + 1)) {
                    this.updateStmt.setFormOfUse(n3, (short)2);
                }
                this.updateStmt.setOracleObject(n3++, datum);
                continue;
            }
            int n5 = this.getInternalMetadata().getColumnType(n4 + 1);
            if (n5 == 2006 || n5 == 2002 || n5 == 2008 || n5 == 2007 || n5 == 2003) {
                this.updateStmt.setNull(n3++, n5, this.getInternalMetadata().getColumnTypeName(n4 + 1));
                continue;
            }
            if (oracleResultSetMetaData.isNCHAR(n4 + 1)) {
                this.updateStmt.setFormOfUse(n3, (short)2);
            }
            this.updateStmt.setNull(n3++, n5);
        }
        this.prepareCompareSelfBinds(this.updateStmt, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeUpdateRow() throws SQLException {
        try {
            if (this.updateStmt.executeUpdate() == 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 85);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.isCachedRset) {
                ((ScrollableResultSet)this.resultSet).refreshRowsInCache(this.getRow(), 1, 1000);
                this.cancelRowUpdates();
            }
        }
        finally {
            if (this.updateStmt != null) {
                this.updateStmt.close();
                this.updateStmt = null;
            }
        }
    }

    private void prepareDeleteRowStatement() throws SQLException {
        if (this.deleteStmt == null) {
            PreparedStatement preparedStatement = this.connection.prepareStatement(((OracleStatement)this.scrollStmt).sqlObject.getDeleteSqlForUpdatableResultSet(this));
            this.deleteStmt = (OraclePreparedStatement)((OraclePreparedStatementWrapper)preparedStatement).preparedStatement;
            this.deleteStmt.setQueryTimeout(((Statement)((Object)this.scrollStmt)).getQueryTimeout());
            if (((OracleStatement)this.scrollStmt).sqlObject.generatedSqlNeedEscapeProcessing()) {
                this.deleteStmt.setEscapeProcessing(true);
            }
        }
    }

    private void prepareDeleteRowBinds() throws SQLException {
        int n2 = 1;
        n2 = this.prepareSubqueryBinds(this.deleteStmt, n2);
        this.prepareCompareSelfBinds(this.deleteStmt, n2);
    }

    private void executeDeleteRow() throws SQLException {
        if (this.deleteStmt.executeUpdate() == 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 85);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.isCachedRset) {
            ((ScrollableResultSet)this.resultSet).removeRowInCache(this.getRow());
        }
    }

    private int prepareCompareSelfBinds(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
        oraclePreparedStatement.setOracleObject(n2, this.resultSet.getOracleObject(1));
        return n2 + 1;
    }

    private int prepareSubqueryBinds(OraclePreparedStatement oraclePreparedStatement, int n2) throws SQLException {
        int n3 = this.scrollStmt.copyBinds(oraclePreparedStatement, n2 - 1);
        return n3 + 1;
    }

    private void setIsNull(int n2) {
        this.wasNull = n2;
    }

    private void setIsNull(boolean bl) {
        this.wasNull = bl ? 1 : 2;
    }

    public String getCursorName() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "getCursorName");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }

    OracleStatement getOracleStatement() throws SQLException {
        return this.resultSet == null ? null : this.resultSet.getOracleStatement();
    }
}

