#!/bin/bash

LANG=C
export LANG

# sync printers.conf from master
#
# arguments: force or restart
#            force accepts hostname as $2

PATH=/bin:/sbin:/usr/bin:/usr/sbin:/usr/local/bin
LOG="/var/log/cups-cron.log"
touch $LOG
chmod 644 $LOG

#HOSTNAME=$(hostname -f)
if [ -n "$2" ]; then
  HOSTNAME="$2"
  DOMAIN=${HOSTNAME#*.}
else
  HOSTNAME=$(host $(hostname) | cut -f 1 -d ' ')
  if [ "$HOSTNAME" = "Host" ]; then
    HOSTNAME=$(hostname)
  fi
  DOMAIN=$(hostname -d)
fi

INET=$(ifconfig  -a | grep Bcast | awk '{ print $2 }'  | awk -F":" '{ print $2 }')
BCAST=$(ifconfig -a | grep Bcast | awk '{ print $3 }'  | awk -F":" '{ print $2 }')
MASK=$(ifconfig  -a | grep Bcast | awk '{ print $4 }'  | awk -F":" '{ print $2 }')
NET=$(expr "$INET" : "\([0-9][0-9]*.[0-9][0-9]*.[0-9][0-9]*\)[0-9]*")
NET=$NET.0



if [ ! -e /etc/cups/printers.conf -o "$1" = "force" -o /etc/cups/printers.conf.d -nt /etc/cups/printers.conf ]; then

# add local printers
rm -f /etc/cups/printers.conf
touch /etc/cups/printers.conf
if [ -e /etc/cups/printers.conf.local ]; then
    cp -p /etc/cups/printers.conf.local /etc/cups/printers.conf
fi
for i in $(cd /etc/cups/printers.conf.d/; find . -maxdepth 1 -mindepth 1 -type d ); do
    i=${i#*/}
    j=${i%%\.*}
    jold=${j/aau/uniklu.ac}
    SUBNET=${HOSTNAME#*\.}
    SUBNET=${SUBNET%%\.*}
    if  [ "${SUBNET}" = "${j}" -o "${SUBNET}" = "${jold}" -o "${j}" = "uni-klu" ]; then
      cat /etc/cups/printers.conf.d/$i/*.conf >> /etc/cups/printers.conf
    fi 
done

grep $HOSTNAME /etc/cups/printers.local | while read LINE
do
  PRINTER=$(expr "$LINE" : ".*|\(.*\)|.*")
  DEVICE=$(expr "$LINE" : ".*|.*|\(.*\)")
  PRINTER=$(echo $PRINTER | sed -e "s:\@:\\\@:")

  perl -pi -e "s|DeviceURI ipp://$HOSTNAME.*$PRINTER|DeviceURI $DEVICE|" /etc/cups/printers.conf
done

# replace network vars
#rm -f /etc/cups/cupsd.conf
#cp -p /etc/cups/cupsd.conf.master /etc/cups/cupsd.conf
#perl -pi -e "s|___NET___|$NET/$MASK|" /etc/cups/cupsd.conf
#perl -pi -e "s|___BCAST___|$BCAST|"   /etc/cups/cupsd.conf


if [ "$1" = "restart" ]; then
    # create cups output dir
    mkdir -p   /tmp/cups
    chmod 1777 /tmp/cups

    # restart cups
    /etc/init.d/cupsys restart > $LOG 2>&1
    sleep 4
fi

fi


if [ "$1" = "restart" ]; then

# check for not responding queues
PRINTERS=$(lpstat -a | awk '{ print $1 }')

for p in $PRINTERS ; do
    if /usr/bin/lpstat -p $p | grep -q "did not respond" >> $LOG 2>&1
    then
        echo -e "\n--- $(date) ---" >> $LOG
        echo "$p: not responding - restarting queue" >> $LOG
        # remove all jobs from queue
        /usr/bin/cancel -a $p >> $LOG 2>&1
        sleep 2
        # restart queue
        /usr/bin/enable $p >> $LOG 2>&1
        sleep 2
    fi
done

fi

