; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i386-apple-darwin -mattr=-avx,+sse4.2 | FileCheck %s

define i32 @test_x86_sse42_pcmpestri128(<16 x i8> %a0, <16 x i8> %a2) {
; CHECK-LABEL: test_x86_sse42_pcmpestri128:
; CHECK:       ## BB#0:
; CHECK-NEXT:    movl $7, %eax
; CHECK-NEXT:    movl $7, %edx
; CHECK-NEXT:    pcmpestri $7, %xmm1, %xmm0
; CHECK-NEXT:    movl %ecx, %eax
; CHECK-NEXT:    retl
  %res = call i32 @llvm.x86.sse42.pcmpestri128(<16 x i8> %a0, i32 7, <16 x i8> %a2, i32 7, i8 7) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpestri128(<16 x i8>, i32, <16 x i8>, i32, i8) nounwind readnone


define i32 @test_x86_sse42_pcmpestri128_load(<16 x i8>* %a0, <16 x i8>* %a2) {
; CHECK-LABEL: test_x86_sse42_pcmpestri128_load:
; CHECK:       ## BB#0:
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    movdqa (%eax), %xmm0
; CHECK-NEXT:    movl $7, %eax
; CHECK-NEXT:    movl $7, %edx
; CHECK-NEXT:    pcmpestri $7, (%ecx), %xmm0
; CHECK-NEXT:    movl %ecx, %eax
; CHECK-NEXT:    retl
  %1 = load <16 x i8>, <16 x i8>* %a0
  %2 = load <16 x i8>, <16 x i8>* %a2
  %res = call i32 @llvm.x86.sse42.pcmpestri128(<16 x i8> %1, i32 7, <16 x i8> %2, i32 7, i8 7) ; <i32> [#uses=1]
  ret i32 %res
}


define i32 @test_x86_sse42_pcmpestria128(<16 x i8> %a0, <16 x i8> %a2) nounwind {
; CHECK-LABEL: test_x86_sse42_pcmpestria128:
; CHECK:       ## BB#0:
; CHECK-NEXT:    pushl %ebx
; CHECK-NEXT:    movl $7, %eax
; CHECK-NEXT:    movl $7, %edx
; CHECK-NEXT:    xorl %ebx, %ebx
; CHECK-NEXT:    pcmpestri $7, %xmm1, %xmm0
; CHECK-NEXT:    seta %bl
; CHECK-NEXT:    movl %ebx, %eax
; CHECK-NEXT:    popl %ebx
; CHECK-NEXT:    retl
  %res = call i32 @llvm.x86.sse42.pcmpestria128(<16 x i8> %a0, i32 7, <16 x i8> %a2, i32 7, i8 7) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpestria128(<16 x i8>, i32, <16 x i8>, i32, i8) nounwind readnone


define i32 @test_x86_sse42_pcmpestric128(<16 x i8> %a0, <16 x i8> %a2) {
; CHECK-LABEL: test_x86_sse42_pcmpestric128:
; CHECK:       ## BB#0:
; CHECK-NEXT:    movl $7, %eax
; CHECK-NEXT:    movl $7, %edx
; CHECK-NEXT:    pcmpestri $7, %xmm1, %xmm0
; CHECK-NEXT:    sbbl %eax, %eax
; CHECK-NEXT:    andl $1, %eax
; CHECK-NEXT:    retl
  %res = call i32 @llvm.x86.sse42.pcmpestric128(<16 x i8> %a0, i32 7, <16 x i8> %a2, i32 7, i8 7) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpestric128(<16 x i8>, i32, <16 x i8>, i32, i8) nounwind readnone


define i32 @test_x86_sse42_pcmpestrio128(<16 x i8> %a0, <16 x i8> %a2) nounwind {
; CHECK-LABEL: test_x86_sse42_pcmpestrio128:
; CHECK:       ## BB#0:
; CHECK-NEXT:    pushl %ebx
; CHECK-NEXT:    movl $7, %eax
; CHECK-NEXT:    movl $7, %edx
; CHECK-NEXT:    xorl %ebx, %ebx
; CHECK-NEXT:    pcmpestri $7, %xmm1, %xmm0
; CHECK-NEXT:    seto %bl
; CHECK-NEXT:    movl %ebx, %eax
; CHECK-NEXT:    popl %ebx
; CHECK-NEXT:    retl
  %res = call i32 @llvm.x86.sse42.pcmpestrio128(<16 x i8> %a0, i32 7, <16 x i8> %a2, i32 7, i8 7) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpestrio128(<16 x i8>, i32, <16 x i8>, i32, i8) nounwind readnone


define i32 @test_x86_sse42_pcmpestris128(<16 x i8> %a0, <16 x i8> %a2) nounwind {
; CHECK-LABEL: test_x86_sse42_pcmpestris128:
; CHECK:       ## BB#0:
; CHECK-NEXT:    pushl %ebx
; CHECK-NEXT:    movl $7, %eax
; CHECK-NEXT:    movl $7, %edx
; CHECK-NEXT:    xorl %ebx, %ebx
; CHECK-NEXT:    pcmpestri $7, %xmm1, %xmm0
; CHECK-NEXT:    sets %bl
; CHECK-NEXT:    movl %ebx, %eax
; CHECK-NEXT:    popl %ebx
; CHECK-NEXT:    retl
  %res = call i32 @llvm.x86.sse42.pcmpestris128(<16 x i8> %a0, i32 7, <16 x i8> %a2, i32 7, i8 7) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpestris128(<16 x i8>, i32, <16 x i8>, i32, i8) nounwind readnone


define i32 @test_x86_sse42_pcmpestriz128(<16 x i8> %a0, <16 x i8> %a2) nounwind {
; CHECK-LABEL: test_x86_sse42_pcmpestriz128:
; CHECK:       ## BB#0:
; CHECK-NEXT:    pushl %ebx
; CHECK-NEXT:    movl $7, %eax
; CHECK-NEXT:    movl $7, %edx
; CHECK-NEXT:    xorl %ebx, %ebx
; CHECK-NEXT:    pcmpestri $7, %xmm1, %xmm0
; CHECK-NEXT:    sete %bl
; CHECK-NEXT:    movl %ebx, %eax
; CHECK-NEXT:    popl %ebx
; CHECK-NEXT:    retl
  %res = call i32 @llvm.x86.sse42.pcmpestriz128(<16 x i8> %a0, i32 7, <16 x i8> %a2, i32 7, i8 7) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpestriz128(<16 x i8>, i32, <16 x i8>, i32, i8) nounwind readnone


define <16 x i8> @test_x86_sse42_pcmpestrm128(<16 x i8> %a0, <16 x i8> %a2) {
; CHECK-LABEL: test_x86_sse42_pcmpestrm128:
; CHECK:       ## BB#0:
; CHECK-NEXT:    movl $7, %eax
; CHECK-NEXT:    movl $7, %edx
; CHECK-NEXT:    pcmpestrm $7, %xmm1, %xmm0
; CHECK-NEXT:    retl
  %res = call <16 x i8> @llvm.x86.sse42.pcmpestrm128(<16 x i8> %a0, i32 7, <16 x i8> %a2, i32 7, i8 7) ; <<16 x i8>> [#uses=1]
  ret <16 x i8> %res
}
declare <16 x i8> @llvm.x86.sse42.pcmpestrm128(<16 x i8>, i32, <16 x i8>, i32, i8) nounwind readnone


define <16 x i8> @test_x86_sse42_pcmpestrm128_load(<16 x i8> %a0, <16 x i8>* %a2) {
; CHECK-LABEL: test_x86_sse42_pcmpestrm128_load:
; CHECK:       ## BB#0:
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; CHECK-NEXT:    movl $7, %eax
; CHECK-NEXT:    movl $7, %edx
; CHECK-NEXT:    pcmpestrm $7, (%ecx), %xmm0
; CHECK-NEXT:    retl
  %1 = load <16 x i8>, <16 x i8>* %a2
  %res = call <16 x i8> @llvm.x86.sse42.pcmpestrm128(<16 x i8> %a0, i32 7, <16 x i8> %1, i32 7, i8 7) ; <<16 x i8>> [#uses=1]
  ret <16 x i8> %res
}


define i32 @test_x86_sse42_pcmpistri128(<16 x i8> %a0, <16 x i8> %a1) {
; CHECK-LABEL: test_x86_sse42_pcmpistri128:
; CHECK:       ## BB#0:
; CHECK-NEXT:    pcmpistri $7, %xmm1, %xmm0
; CHECK-NEXT:    movl %ecx, %eax
; CHECK-NEXT:    retl
  %res = call i32 @llvm.x86.sse42.pcmpistri128(<16 x i8> %a0, <16 x i8> %a1, i8 7) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpistri128(<16 x i8>, <16 x i8>, i8) nounwind readnone


define i32 @test_x86_sse42_pcmpistri128_load(<16 x i8>* %a0, <16 x i8>* %a1) {
; CHECK-LABEL: test_x86_sse42_pcmpistri128_load:
; CHECK:       ## BB#0:
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; CHECK-NEXT:    movdqa (%ecx), %xmm0
; CHECK-NEXT:    pcmpistri $7, (%eax), %xmm0
; CHECK-NEXT:    movl %ecx, %eax
; CHECK-NEXT:    retl
  %1 = load <16 x i8>, <16 x i8>* %a0
  %2 = load <16 x i8>, <16 x i8>* %a1
  %res = call i32 @llvm.x86.sse42.pcmpistri128(<16 x i8> %1, <16 x i8> %2, i8 7) ; <i32> [#uses=1]
  ret i32 %res
}


define i32 @test_x86_sse42_pcmpistria128(<16 x i8> %a0, <16 x i8> %a1) {
; CHECK-LABEL: test_x86_sse42_pcmpistria128:
; CHECK:       ## BB#0:
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    pcmpistri $7, %xmm1, %xmm0
; CHECK-NEXT:    seta %al
; CHECK-NEXT:    retl
  %res = call i32 @llvm.x86.sse42.pcmpistria128(<16 x i8> %a0, <16 x i8> %a1, i8 7) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpistria128(<16 x i8>, <16 x i8>, i8) nounwind readnone


define i32 @test_x86_sse42_pcmpistric128(<16 x i8> %a0, <16 x i8> %a1) {
; CHECK-LABEL: test_x86_sse42_pcmpistric128:
; CHECK:       ## BB#0:
; CHECK-NEXT:    pcmpistri $7, %xmm1, %xmm0
; CHECK-NEXT:    sbbl %eax, %eax
; CHECK-NEXT:    andl $1, %eax
; CHECK-NEXT:    retl
  %res = call i32 @llvm.x86.sse42.pcmpistric128(<16 x i8> %a0, <16 x i8> %a1, i8 7) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpistric128(<16 x i8>, <16 x i8>, i8) nounwind readnone


define i32 @test_x86_sse42_pcmpistrio128(<16 x i8> %a0, <16 x i8> %a1) {
; CHECK-LABEL: test_x86_sse42_pcmpistrio128:
; CHECK:       ## BB#0:
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    pcmpistri $7, %xmm1, %xmm0
; CHECK-NEXT:    seto %al
; CHECK-NEXT:    retl
  %res = call i32 @llvm.x86.sse42.pcmpistrio128(<16 x i8> %a0, <16 x i8> %a1, i8 7) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpistrio128(<16 x i8>, <16 x i8>, i8) nounwind readnone


define i32 @test_x86_sse42_pcmpistris128(<16 x i8> %a0, <16 x i8> %a1) {
; CHECK-LABEL: test_x86_sse42_pcmpistris128:
; CHECK:       ## BB#0:
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    pcmpistri $7, %xmm1, %xmm0
; CHECK-NEXT:    sets %al
; CHECK-NEXT:    retl
  %res = call i32 @llvm.x86.sse42.pcmpistris128(<16 x i8> %a0, <16 x i8> %a1, i8 7) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpistris128(<16 x i8>, <16 x i8>, i8) nounwind readnone


define i32 @test_x86_sse42_pcmpistriz128(<16 x i8> %a0, <16 x i8> %a1) {
; CHECK-LABEL: test_x86_sse42_pcmpistriz128:
; CHECK:       ## BB#0:
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    pcmpistri $7, %xmm1, %xmm0
; CHECK-NEXT:    sete %al
; CHECK-NEXT:    retl
  %res = call i32 @llvm.x86.sse42.pcmpistriz128(<16 x i8> %a0, <16 x i8> %a1, i8 7) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpistriz128(<16 x i8>, <16 x i8>, i8) nounwind readnone


define <16 x i8> @test_x86_sse42_pcmpistrm128(<16 x i8> %a0, <16 x i8> %a1) {
; CHECK-LABEL: test_x86_sse42_pcmpistrm128:
; CHECK:       ## BB#0:
; CHECK-NEXT:    pcmpistrm $7, %xmm1, %xmm0
; CHECK-NEXT:    retl
  %res = call <16 x i8> @llvm.x86.sse42.pcmpistrm128(<16 x i8> %a0, <16 x i8> %a1, i8 7) ; <<16 x i8>> [#uses=1]
  ret <16 x i8> %res
}
declare <16 x i8> @llvm.x86.sse42.pcmpistrm128(<16 x i8>, <16 x i8>, i8) nounwind readnone


define <16 x i8> @test_x86_sse42_pcmpistrm128_load(<16 x i8> %a0, <16 x i8>* %a1) {
; CHECK-LABEL: test_x86_sse42_pcmpistrm128_load:
; CHECK:       ## BB#0:
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    pcmpistrm $7, (%eax), %xmm0
; CHECK-NEXT:    retl
  %1 = load <16 x i8>, <16 x i8>* %a1
  %res = call <16 x i8> @llvm.x86.sse42.pcmpistrm128(<16 x i8> %a0, <16 x i8> %1, i8 7) ; <<16 x i8>> [#uses=1]
  ret <16 x i8> %res
}
