// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/assistant/embedded/v1alpha2/embedded_assistant.proto

/*
Package embedded is a generated protocol buffer package.

It is generated from these files:
	google/assistant/embedded/v1alpha2/embedded_assistant.proto

It has these top-level messages:
	AssistConfig
	AudioInConfig
	AudioOutConfig
	DialogStateIn
	AudioOut
	DialogStateOut
	AssistRequest
	AssistResponse
	SpeechRecognitionResult
	DeviceConfig
	DeviceAction
	DeviceLocation
*/
package embedded

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_type "google.golang.org/genproto/googleapis/type/latlng"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Audio encoding of the data sent in the audio message.
// Audio must be one-channel (mono). The only language supported is "en-US".
type AudioInConfig_Encoding int32

const (
	// Not specified. Will return result [google.rpc.Code.INVALID_ARGUMENT][].
	AudioInConfig_ENCODING_UNSPECIFIED AudioInConfig_Encoding = 0
	// Uncompressed 16-bit signed little-endian samples (Linear PCM).
	// This encoding includes no header, only the raw audio bytes.
	AudioInConfig_LINEAR16 AudioInConfig_Encoding = 1
	// [`FLAC`](https://xiph.org/flac/documentation.html) (Free Lossless Audio
	// Codec) is the recommended encoding because it is
	// lossless--therefore recognition is not compromised--and
	// requires only about half the bandwidth of `LINEAR16`. This encoding
	// includes the `FLAC` stream header followed by audio data. It supports
	// 16-bit and 24-bit samples, however, not all fields in `STREAMINFO` are
	// supported.
	AudioInConfig_FLAC AudioInConfig_Encoding = 2
)

var AudioInConfig_Encoding_name = map[int32]string{
	0: "ENCODING_UNSPECIFIED",
	1: "LINEAR16",
	2: "FLAC",
}
var AudioInConfig_Encoding_value = map[string]int32{
	"ENCODING_UNSPECIFIED": 0,
	"LINEAR16":             1,
	"FLAC":                 2,
}

func (x AudioInConfig_Encoding) String() string {
	return proto.EnumName(AudioInConfig_Encoding_name, int32(x))
}
func (AudioInConfig_Encoding) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1, 0} }

// Audio encoding of the data returned in the audio message. All encodings are
// raw audio bytes with no header, except as indicated below.
type AudioOutConfig_Encoding int32

const (
	// Not specified. Will return result [google.rpc.Code.INVALID_ARGUMENT][].
	AudioOutConfig_ENCODING_UNSPECIFIED AudioOutConfig_Encoding = 0
	// Uncompressed 16-bit signed little-endian samples (Linear PCM).
	AudioOutConfig_LINEAR16 AudioOutConfig_Encoding = 1
	// MP3 audio encoding. The sample rate is encoded in the payload.
	AudioOutConfig_MP3 AudioOutConfig_Encoding = 2
	// Opus-encoded audio wrapped in an ogg container. The result will be a
	// file which can be played natively on Android and in some browsers (such
	// as Chrome). The quality of the encoding is considerably higher than MP3
	// while using the same bitrate. The sample rate is encoded in the payload.
	AudioOutConfig_OPUS_IN_OGG AudioOutConfig_Encoding = 3
)

var AudioOutConfig_Encoding_name = map[int32]string{
	0: "ENCODING_UNSPECIFIED",
	1: "LINEAR16",
	2: "MP3",
	3: "OPUS_IN_OGG",
}
var AudioOutConfig_Encoding_value = map[string]int32{
	"ENCODING_UNSPECIFIED": 0,
	"LINEAR16":             1,
	"MP3":                  2,
	"OPUS_IN_OGG":          3,
}

func (x AudioOutConfig_Encoding) String() string {
	return proto.EnumName(AudioOutConfig_Encoding_name, int32(x))
}
func (AudioOutConfig_Encoding) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{2, 0} }

// Possible states of the microphone after a `Assist` RPC completes.
type DialogStateOut_MicrophoneMode int32

const (
	// No mode specified.
	DialogStateOut_MICROPHONE_MODE_UNSPECIFIED DialogStateOut_MicrophoneMode = 0
	// The service is not expecting a follow-on question from the user.
	// The microphone should remain off until the user re-activates it.
	DialogStateOut_CLOSE_MICROPHONE DialogStateOut_MicrophoneMode = 1
	// The service is expecting a follow-on question from the user. The
	// microphone should be re-opened when the `AudioOut` playback completes
	// (by starting a new `Assist` RPC call to send the new audio).
	DialogStateOut_DIALOG_FOLLOW_ON DialogStateOut_MicrophoneMode = 2
)

var DialogStateOut_MicrophoneMode_name = map[int32]string{
	0: "MICROPHONE_MODE_UNSPECIFIED",
	1: "CLOSE_MICROPHONE",
	2: "DIALOG_FOLLOW_ON",
}
var DialogStateOut_MicrophoneMode_value = map[string]int32{
	"MICROPHONE_MODE_UNSPECIFIED": 0,
	"CLOSE_MICROPHONE":            1,
	"DIALOG_FOLLOW_ON":            2,
}

func (x DialogStateOut_MicrophoneMode) String() string {
	return proto.EnumName(DialogStateOut_MicrophoneMode_name, int32(x))
}
func (DialogStateOut_MicrophoneMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{5, 0}
}

// Indicates the type of event.
type AssistResponse_EventType int32

const (
	// No event specified.
	AssistResponse_EVENT_TYPE_UNSPECIFIED AssistResponse_EventType = 0
	// This event indicates that the server has detected the end of the user's
	// speech utterance and expects no additional speech. Therefore, the server
	// will not process additional audio (although it may subsequently return
	// additional results). The client should stop sending additional audio
	// data, half-close the gRPC connection, and wait for any additional results
	// until the server closes the gRPC connection.
	AssistResponse_END_OF_UTTERANCE AssistResponse_EventType = 1
)

var AssistResponse_EventType_name = map[int32]string{
	0: "EVENT_TYPE_UNSPECIFIED",
	1: "END_OF_UTTERANCE",
}
var AssistResponse_EventType_value = map[string]int32{
	"EVENT_TYPE_UNSPECIFIED": 0,
	"END_OF_UTTERANCE":       1,
}

func (x AssistResponse_EventType) String() string {
	return proto.EnumName(AssistResponse_EventType_name, int32(x))
}
func (AssistResponse_EventType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{7, 0} }

// Specifies how to process the `AssistRequest` messages.
type AssistConfig struct {
	// Types that are valid to be assigned to Type:
	//	*AssistConfig_AudioInConfig
	//	*AssistConfig_TextQuery
	Type isAssistConfig_Type `protobuf_oneof:"type"`
	// *Required* Specifies how to format the audio that will be returned.
	AudioOutConfig *AudioOutConfig `protobuf:"bytes,2,opt,name=audio_out_config,json=audioOutConfig" json:"audio_out_config,omitempty"`
	// *Required* Represents the current dialog state.
	DialogStateIn *DialogStateIn `protobuf:"bytes,3,opt,name=dialog_state_in,json=dialogStateIn" json:"dialog_state_in,omitempty"`
	// Device configuration that uniquely identifies a specific device.
	DeviceConfig *DeviceConfig `protobuf:"bytes,4,opt,name=device_config,json=deviceConfig" json:"device_config,omitempty"`
}

func (m *AssistConfig) Reset()                    { *m = AssistConfig{} }
func (m *AssistConfig) String() string            { return proto.CompactTextString(m) }
func (*AssistConfig) ProtoMessage()               {}
func (*AssistConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type isAssistConfig_Type interface {
	isAssistConfig_Type()
}

type AssistConfig_AudioInConfig struct {
	AudioInConfig *AudioInConfig `protobuf:"bytes,1,opt,name=audio_in_config,json=audioInConfig,oneof"`
}
type AssistConfig_TextQuery struct {
	TextQuery string `protobuf:"bytes,6,opt,name=text_query,json=textQuery,oneof"`
}

func (*AssistConfig_AudioInConfig) isAssistConfig_Type() {}
func (*AssistConfig_TextQuery) isAssistConfig_Type()     {}

func (m *AssistConfig) GetType() isAssistConfig_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *AssistConfig) GetAudioInConfig() *AudioInConfig {
	if x, ok := m.GetType().(*AssistConfig_AudioInConfig); ok {
		return x.AudioInConfig
	}
	return nil
}

func (m *AssistConfig) GetTextQuery() string {
	if x, ok := m.GetType().(*AssistConfig_TextQuery); ok {
		return x.TextQuery
	}
	return ""
}

func (m *AssistConfig) GetAudioOutConfig() *AudioOutConfig {
	if m != nil {
		return m.AudioOutConfig
	}
	return nil
}

func (m *AssistConfig) GetDialogStateIn() *DialogStateIn {
	if m != nil {
		return m.DialogStateIn
	}
	return nil
}

func (m *AssistConfig) GetDeviceConfig() *DeviceConfig {
	if m != nil {
		return m.DeviceConfig
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*AssistConfig) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _AssistConfig_OneofMarshaler, _AssistConfig_OneofUnmarshaler, _AssistConfig_OneofSizer, []interface{}{
		(*AssistConfig_AudioInConfig)(nil),
		(*AssistConfig_TextQuery)(nil),
	}
}

func _AssistConfig_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*AssistConfig)
	// type
	switch x := m.Type.(type) {
	case *AssistConfig_AudioInConfig:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AudioInConfig); err != nil {
			return err
		}
	case *AssistConfig_TextQuery:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.TextQuery)
	case nil:
	default:
		return fmt.Errorf("AssistConfig.Type has unexpected type %T", x)
	}
	return nil
}

func _AssistConfig_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*AssistConfig)
	switch tag {
	case 1: // type.audio_in_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AudioInConfig)
		err := b.DecodeMessage(msg)
		m.Type = &AssistConfig_AudioInConfig{msg}
		return true, err
	case 6: // type.text_query
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Type = &AssistConfig_TextQuery{x}
		return true, err
	default:
		return false, nil
	}
}

func _AssistConfig_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*AssistConfig)
	// type
	switch x := m.Type.(type) {
	case *AssistConfig_AudioInConfig:
		s := proto.Size(x.AudioInConfig)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AssistConfig_TextQuery:
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.TextQuery)))
		n += len(x.TextQuery)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Specifies how to process the `audio_in` data that will be provided in
// subsequent requests. For recommended settings, see the Google Assistant SDK
// [best practices](https://developers.google.com/assistant/sdk/guides/service/python/best-practices/audio).
type AudioInConfig struct {
	// *Required* Encoding of audio data sent in all `audio_in` messages.
	Encoding AudioInConfig_Encoding `protobuf:"varint,1,opt,name=encoding,enum=google.assistant.embedded.v1alpha2.AudioInConfig_Encoding" json:"encoding,omitempty"`
	// *Required* Sample rate (in Hertz) of the audio data sent in all `audio_in`
	// messages. Valid values are from 16000-24000, but 16000 is optimal.
	// For best results, set the sampling rate of the audio source to 16000 Hz.
	// If that's not possible, use the native sample rate of the audio source
	// (instead of re-sampling).
	SampleRateHertz int32 `protobuf:"varint,2,opt,name=sample_rate_hertz,json=sampleRateHertz" json:"sample_rate_hertz,omitempty"`
}

func (m *AudioInConfig) Reset()                    { *m = AudioInConfig{} }
func (m *AudioInConfig) String() string            { return proto.CompactTextString(m) }
func (*AudioInConfig) ProtoMessage()               {}
func (*AudioInConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *AudioInConfig) GetEncoding() AudioInConfig_Encoding {
	if m != nil {
		return m.Encoding
	}
	return AudioInConfig_ENCODING_UNSPECIFIED
}

func (m *AudioInConfig) GetSampleRateHertz() int32 {
	if m != nil {
		return m.SampleRateHertz
	}
	return 0
}

// Specifies the desired format for the server to use when it returns
// `audio_out` messages.
type AudioOutConfig struct {
	// *Required* The encoding of audio data to be returned in all `audio_out`
	// messages.
	Encoding AudioOutConfig_Encoding `protobuf:"varint,1,opt,name=encoding,enum=google.assistant.embedded.v1alpha2.AudioOutConfig_Encoding" json:"encoding,omitempty"`
	// *Required* The sample rate in Hertz of the audio data returned in
	// `audio_out` messages. Valid values are: 16000-24000.
	SampleRateHertz int32 `protobuf:"varint,2,opt,name=sample_rate_hertz,json=sampleRateHertz" json:"sample_rate_hertz,omitempty"`
	// *Required* Current volume setting of the device's audio output.
	// Valid values are 1 to 100 (corresponding to 1% to 100%).
	VolumePercentage int32 `protobuf:"varint,3,opt,name=volume_percentage,json=volumePercentage" json:"volume_percentage,omitempty"`
}

func (m *AudioOutConfig) Reset()                    { *m = AudioOutConfig{} }
func (m *AudioOutConfig) String() string            { return proto.CompactTextString(m) }
func (*AudioOutConfig) ProtoMessage()               {}
func (*AudioOutConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *AudioOutConfig) GetEncoding() AudioOutConfig_Encoding {
	if m != nil {
		return m.Encoding
	}
	return AudioOutConfig_ENCODING_UNSPECIFIED
}

func (m *AudioOutConfig) GetSampleRateHertz() int32 {
	if m != nil {
		return m.SampleRateHertz
	}
	return 0
}

func (m *AudioOutConfig) GetVolumePercentage() int32 {
	if m != nil {
		return m.VolumePercentage
	}
	return 0
}

// Provides information about the current dialog state.
type DialogStateIn struct {
	// *Required* This field must always be set to the
	// [DialogStateOut.conversation_state][google.assistant.embedded.v1alpha2.DialogStateOut.conversation_state] value that was returned in the prior
	// `Assist` RPC. It should only be omitted (field not set) if there was no
	// prior `Assist` RPC because this is the first `Assist` RPC made by this
	// device after it was first setup and/or a factory-default reset.
	ConversationState []byte `protobuf:"bytes,1,opt,name=conversation_state,json=conversationState,proto3" json:"conversation_state,omitempty"`
	// *Required* Language of the request in
	// [IETF BCP 47 syntax](https://tools.ietf.org/html/bcp47). For example:
	// "en-US". If you have selected a language for this `device_id` using the
	// [Settings](https://developers.google.com/assistant/sdk/guides/assistant-settings)
	// menu in your phone's Google Assistant app, that selection will override
	// this value.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode" json:"language_code,omitempty"`
	// *Optional* Location of the device where the query originated.
	DeviceLocation *DeviceLocation `protobuf:"bytes,5,opt,name=device_location,json=deviceLocation" json:"device_location,omitempty"`
}

func (m *DialogStateIn) Reset()                    { *m = DialogStateIn{} }
func (m *DialogStateIn) String() string            { return proto.CompactTextString(m) }
func (*DialogStateIn) ProtoMessage()               {}
func (*DialogStateIn) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *DialogStateIn) GetConversationState() []byte {
	if m != nil {
		return m.ConversationState
	}
	return nil
}

func (m *DialogStateIn) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *DialogStateIn) GetDeviceLocation() *DeviceLocation {
	if m != nil {
		return m.DeviceLocation
	}
	return nil
}

// The audio containing the Assistant's response to the query. Sequential chunks
// of audio data are received in sequential `AssistResponse` messages.
type AudioOut struct {
	// *Output-only* The audio data containing the Assistant's response to the
	// query. Sequential chunks of audio data are received in sequential
	// `AssistResponse` messages.
	AudioData []byte `protobuf:"bytes,1,opt,name=audio_data,json=audioData,proto3" json:"audio_data,omitempty"`
}

func (m *AudioOut) Reset()                    { *m = AudioOut{} }
func (m *AudioOut) String() string            { return proto.CompactTextString(m) }
func (*AudioOut) ProtoMessage()               {}
func (*AudioOut) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *AudioOut) GetAudioData() []byte {
	if m != nil {
		return m.AudioData
	}
	return nil
}

// The dialog state resulting from the user's query. Multiple of these messages
// may be received.
type DialogStateOut struct {
	// *Output-only* Supplemental display text from the Assistant. This could be
	// the same as the speech spoken in `AssistResponse.audio_out` or it could
	// be some additional information which aids the user's understanding.
	SupplementalDisplayText string `protobuf:"bytes,1,opt,name=supplemental_display_text,json=supplementalDisplayText" json:"supplemental_display_text,omitempty"`
	// *Output-only* State information for the subsequent `Assist` RPC. This
	// value should be saved in the client and returned in the
	// [`DialogStateIn.conversation_state`](#dialogstatein) field with the next
	// `Assist` RPC. (The client does not need to interpret or otherwise use this
	// value.) This information should be saved across device reboots. However,
	// this value should be cleared (not saved in the client) during a
	// factory-default reset.
	ConversationState []byte `protobuf:"bytes,2,opt,name=conversation_state,json=conversationState,proto3" json:"conversation_state,omitempty"`
	// *Output-only* Specifies the mode of the microphone after this `Assist`
	// RPC is processed.
	MicrophoneMode DialogStateOut_MicrophoneMode `protobuf:"varint,3,opt,name=microphone_mode,json=microphoneMode,enum=google.assistant.embedded.v1alpha2.DialogStateOut_MicrophoneMode" json:"microphone_mode,omitempty"`
	// *Output-only* Updated volume level. The value will be 0 or omitted
	// (indicating no change) unless a voice command such as *Increase the volume*
	// or *Set volume level 4* was recognized, in which case the value will be
	// between 1 and 100 (corresponding to the new volume level of 1% to 100%).
	// Typically, a client should use this volume level when playing the
	// `audio_out` data, and retain this value as the current volume level and
	// supply it in the `AudioOutConfig` of the next `AssistRequest`. (Some
	// clients may also implement other ways to allow the current volume level to
	// be changed, for example, by providing a knob that the user can turn.)
	VolumePercentage int32 `protobuf:"varint,4,opt,name=volume_percentage,json=volumePercentage" json:"volume_percentage,omitempty"`
}

func (m *DialogStateOut) Reset()                    { *m = DialogStateOut{} }
func (m *DialogStateOut) String() string            { return proto.CompactTextString(m) }
func (*DialogStateOut) ProtoMessage()               {}
func (*DialogStateOut) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *DialogStateOut) GetSupplementalDisplayText() string {
	if m != nil {
		return m.SupplementalDisplayText
	}
	return ""
}

func (m *DialogStateOut) GetConversationState() []byte {
	if m != nil {
		return m.ConversationState
	}
	return nil
}

func (m *DialogStateOut) GetMicrophoneMode() DialogStateOut_MicrophoneMode {
	if m != nil {
		return m.MicrophoneMode
	}
	return DialogStateOut_MICROPHONE_MODE_UNSPECIFIED
}

func (m *DialogStateOut) GetVolumePercentage() int32 {
	if m != nil {
		return m.VolumePercentage
	}
	return 0
}

// The top-level message sent by the client. Clients must send at least two, and
// typically numerous `AssistRequest` messages. The first message must
// contain a `config` message and must not contain `audio_in` data. All
// subsequent messages must contain `audio_in` data and must not contain a
// `config` message.
type AssistRequest struct {
	// Exactly one of these fields must be specified in each `AssistRequest`.
	//
	// Types that are valid to be assigned to Type:
	//	*AssistRequest_Config
	//	*AssistRequest_AudioIn
	Type isAssistRequest_Type `protobuf_oneof:"type"`
}

func (m *AssistRequest) Reset()                    { *m = AssistRequest{} }
func (m *AssistRequest) String() string            { return proto.CompactTextString(m) }
func (*AssistRequest) ProtoMessage()               {}
func (*AssistRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

type isAssistRequest_Type interface {
	isAssistRequest_Type()
}

type AssistRequest_Config struct {
	Config *AssistConfig `protobuf:"bytes,1,opt,name=config,oneof"`
}
type AssistRequest_AudioIn struct {
	AudioIn []byte `protobuf:"bytes,2,opt,name=audio_in,json=audioIn,proto3,oneof"`
}

func (*AssistRequest_Config) isAssistRequest_Type()  {}
func (*AssistRequest_AudioIn) isAssistRequest_Type() {}

func (m *AssistRequest) GetType() isAssistRequest_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *AssistRequest) GetConfig() *AssistConfig {
	if x, ok := m.GetType().(*AssistRequest_Config); ok {
		return x.Config
	}
	return nil
}

func (m *AssistRequest) GetAudioIn() []byte {
	if x, ok := m.GetType().(*AssistRequest_AudioIn); ok {
		return x.AudioIn
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*AssistRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _AssistRequest_OneofMarshaler, _AssistRequest_OneofUnmarshaler, _AssistRequest_OneofSizer, []interface{}{
		(*AssistRequest_Config)(nil),
		(*AssistRequest_AudioIn)(nil),
	}
}

func _AssistRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*AssistRequest)
	// type
	switch x := m.Type.(type) {
	case *AssistRequest_Config:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Config); err != nil {
			return err
		}
	case *AssistRequest_AudioIn:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.AudioIn)
	case nil:
	default:
		return fmt.Errorf("AssistRequest.Type has unexpected type %T", x)
	}
	return nil
}

func _AssistRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*AssistRequest)
	switch tag {
	case 1: // type.config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AssistConfig)
		err := b.DecodeMessage(msg)
		m.Type = &AssistRequest_Config{msg}
		return true, err
	case 2: // type.audio_in
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Type = &AssistRequest_AudioIn{x}
		return true, err
	default:
		return false, nil
	}
}

func _AssistRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*AssistRequest)
	// type
	switch x := m.Type.(type) {
	case *AssistRequest_Config:
		s := proto.Size(x.Config)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AssistRequest_AudioIn:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.AudioIn)))
		n += len(x.AudioIn)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The top-level message received by the client. A series of one or more
// `AssistResponse` messages are streamed back to the client.
type AssistResponse struct {
	// *Output-only* Indicates the type of event.
	EventType AssistResponse_EventType `protobuf:"varint,1,opt,name=event_type,json=eventType,enum=google.assistant.embedded.v1alpha2.AssistResponse_EventType" json:"event_type,omitempty"`
	// *Output-only* The audio containing the Assistant's response to the query.
	AudioOut *AudioOut `protobuf:"bytes,3,opt,name=audio_out,json=audioOut" json:"audio_out,omitempty"`
	// *Output-only* Contains the action triggered by the query with the
	// appropriate payloads and semantic parsing.
	DeviceAction *DeviceAction `protobuf:"bytes,6,opt,name=device_action,json=deviceAction" json:"device_action,omitempty"`
	// *Output-only* This repeated list contains zero or more speech recognition
	// results that correspond to consecutive portions of the audio currently
	// being processed, starting with the portion corresponding to the earliest
	// audio (and most stable portion) to the portion corresponding to the most
	// recent audio. The strings can be concatenated to view the full
	// in-progress response. When the speech recognition completes, this list
	// will contain one item with `stability` of `1.0`.
	SpeechResults []*SpeechRecognitionResult `protobuf:"bytes,2,rep,name=speech_results,json=speechResults" json:"speech_results,omitempty"`
	// *Output-only* Contains output related to the user's query.
	DialogStateOut *DialogStateOut `protobuf:"bytes,5,opt,name=dialog_state_out,json=dialogStateOut" json:"dialog_state_out,omitempty"`
}

func (m *AssistResponse) Reset()                    { *m = AssistResponse{} }
func (m *AssistResponse) String() string            { return proto.CompactTextString(m) }
func (*AssistResponse) ProtoMessage()               {}
func (*AssistResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *AssistResponse) GetEventType() AssistResponse_EventType {
	if m != nil {
		return m.EventType
	}
	return AssistResponse_EVENT_TYPE_UNSPECIFIED
}

func (m *AssistResponse) GetAudioOut() *AudioOut {
	if m != nil {
		return m.AudioOut
	}
	return nil
}

func (m *AssistResponse) GetDeviceAction() *DeviceAction {
	if m != nil {
		return m.DeviceAction
	}
	return nil
}

func (m *AssistResponse) GetSpeechResults() []*SpeechRecognitionResult {
	if m != nil {
		return m.SpeechResults
	}
	return nil
}

func (m *AssistResponse) GetDialogStateOut() *DialogStateOut {
	if m != nil {
		return m.DialogStateOut
	}
	return nil
}

// The estimated transcription of a phrase the user has spoken. This could be
// a single segment or the full guess of the user's spoken query.
type SpeechRecognitionResult struct {
	// *Output-only* Transcript text representing the words that the user spoke.
	Transcript string `protobuf:"bytes,1,opt,name=transcript" json:"transcript,omitempty"`
	// *Output-only* An estimate of the likelihood that the Assistant will not
	// change its guess about this result. Values range from 0.0 (completely
	// unstable) to 1.0 (completely stable and final). The default of 0.0 is a
	// sentinel value indicating `stability` was not set.
	Stability float32 `protobuf:"fixed32,2,opt,name=stability" json:"stability,omitempty"`
}

func (m *SpeechRecognitionResult) Reset()                    { *m = SpeechRecognitionResult{} }
func (m *SpeechRecognitionResult) String() string            { return proto.CompactTextString(m) }
func (*SpeechRecognitionResult) ProtoMessage()               {}
func (*SpeechRecognitionResult) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *SpeechRecognitionResult) GetTranscript() string {
	if m != nil {
		return m.Transcript
	}
	return ""
}

func (m *SpeechRecognitionResult) GetStability() float32 {
	if m != nil {
		return m.Stability
	}
	return 0
}

// *Required* Fields that identify the device to the Assistant.
//
// See also:
//
// *   [Register a Device - REST API](https://developers.google.com/assistant/sdk/reference/device-registration/register-device-manual)
// *   [Device Model and Instance Schemas](https://developers.google.com/assistant/sdk/reference/device-registration/model-and-instance-schemas)
// *   [Device Proto](https://developers.google.com/assistant/sdk/reference/rpc/google.assistant.devices.v1alpha2#device)
type DeviceConfig struct {
	// *Required* Unique identifier for the device. The id length must be 128
	// characters or less. Example: DBCDW098234. This MUST match the device_id
	// returned from device registration. This device_id is used to match against
	// the user's registered devices to lookup the supported traits and
	// capabilities of this device. This information should not change across
	// device reboots. However, it should not be saved across
	// factory-default resets.
	DeviceId string `protobuf:"bytes,1,opt,name=device_id,json=deviceId" json:"device_id,omitempty"`
	// *Required* Unique identifier for the device model. The combination of
	// device_model_id and device_id must have been previously associated through
	// device registration.
	DeviceModelId string `protobuf:"bytes,3,opt,name=device_model_id,json=deviceModelId" json:"device_model_id,omitempty"`
}

func (m *DeviceConfig) Reset()                    { *m = DeviceConfig{} }
func (m *DeviceConfig) String() string            { return proto.CompactTextString(m) }
func (*DeviceConfig) ProtoMessage()               {}
func (*DeviceConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *DeviceConfig) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

func (m *DeviceConfig) GetDeviceModelId() string {
	if m != nil {
		return m.DeviceModelId
	}
	return ""
}

// The response returned to the device if the user has triggered a Device
// Action. For example, a device which supports the query *Turn on the light*
// would receive a `DeviceAction` with a JSON payload containing the semantics
// of the request.
type DeviceAction struct {
	// JSON containing the device command response generated from the triggered
	// Device Action grammar. The format is given by the
	// `action.devices.EXECUTE` intent for a given
	// [trait](https://developers.google.com/assistant/sdk/reference/traits/).
	DeviceRequestJson string `protobuf:"bytes,1,opt,name=device_request_json,json=deviceRequestJson" json:"device_request_json,omitempty"`
}

func (m *DeviceAction) Reset()                    { *m = DeviceAction{} }
func (m *DeviceAction) String() string            { return proto.CompactTextString(m) }
func (*DeviceAction) ProtoMessage()               {}
func (*DeviceAction) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *DeviceAction) GetDeviceRequestJson() string {
	if m != nil {
		return m.DeviceRequestJson
	}
	return ""
}

// There are three sources of locations. They are used with this precedence:
//
// 1. This `DeviceLocation`, which is primarily used for mobile devices with
//    GPS .
// 2. Location specified by the user during device setup; this is per-user, per
//    device. This location is used if `DeviceLocation` is not specified.
// 3. Inferred location based on IP address. This is used only if neither of the
//    above are specified.
type DeviceLocation struct {
	// Types that are valid to be assigned to Type:
	//	*DeviceLocation_Coordinates
	Type isDeviceLocation_Type `protobuf_oneof:"type"`
}

func (m *DeviceLocation) Reset()                    { *m = DeviceLocation{} }
func (m *DeviceLocation) String() string            { return proto.CompactTextString(m) }
func (*DeviceLocation) ProtoMessage()               {}
func (*DeviceLocation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

type isDeviceLocation_Type interface {
	isDeviceLocation_Type()
}

type DeviceLocation_Coordinates struct {
	Coordinates *google_type.LatLng `protobuf:"bytes,1,opt,name=coordinates,oneof"`
}

func (*DeviceLocation_Coordinates) isDeviceLocation_Type() {}

func (m *DeviceLocation) GetType() isDeviceLocation_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *DeviceLocation) GetCoordinates() *google_type.LatLng {
	if x, ok := m.GetType().(*DeviceLocation_Coordinates); ok {
		return x.Coordinates
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*DeviceLocation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _DeviceLocation_OneofMarshaler, _DeviceLocation_OneofUnmarshaler, _DeviceLocation_OneofSizer, []interface{}{
		(*DeviceLocation_Coordinates)(nil),
	}
}

func _DeviceLocation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*DeviceLocation)
	// type
	switch x := m.Type.(type) {
	case *DeviceLocation_Coordinates:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Coordinates); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("DeviceLocation.Type has unexpected type %T", x)
	}
	return nil
}

func _DeviceLocation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*DeviceLocation)
	switch tag {
	case 1: // type.coordinates
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_type.LatLng)
		err := b.DecodeMessage(msg)
		m.Type = &DeviceLocation_Coordinates{msg}
		return true, err
	default:
		return false, nil
	}
}

func _DeviceLocation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*DeviceLocation)
	// type
	switch x := m.Type.(type) {
	case *DeviceLocation_Coordinates:
		s := proto.Size(x.Coordinates)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterType((*AssistConfig)(nil), "google.assistant.embedded.v1alpha2.AssistConfig")
	proto.RegisterType((*AudioInConfig)(nil), "google.assistant.embedded.v1alpha2.AudioInConfig")
	proto.RegisterType((*AudioOutConfig)(nil), "google.assistant.embedded.v1alpha2.AudioOutConfig")
	proto.RegisterType((*DialogStateIn)(nil), "google.assistant.embedded.v1alpha2.DialogStateIn")
	proto.RegisterType((*AudioOut)(nil), "google.assistant.embedded.v1alpha2.AudioOut")
	proto.RegisterType((*DialogStateOut)(nil), "google.assistant.embedded.v1alpha2.DialogStateOut")
	proto.RegisterType((*AssistRequest)(nil), "google.assistant.embedded.v1alpha2.AssistRequest")
	proto.RegisterType((*AssistResponse)(nil), "google.assistant.embedded.v1alpha2.AssistResponse")
	proto.RegisterType((*SpeechRecognitionResult)(nil), "google.assistant.embedded.v1alpha2.SpeechRecognitionResult")
	proto.RegisterType((*DeviceConfig)(nil), "google.assistant.embedded.v1alpha2.DeviceConfig")
	proto.RegisterType((*DeviceAction)(nil), "google.assistant.embedded.v1alpha2.DeviceAction")
	proto.RegisterType((*DeviceLocation)(nil), "google.assistant.embedded.v1alpha2.DeviceLocation")
	proto.RegisterEnum("google.assistant.embedded.v1alpha2.AudioInConfig_Encoding", AudioInConfig_Encoding_name, AudioInConfig_Encoding_value)
	proto.RegisterEnum("google.assistant.embedded.v1alpha2.AudioOutConfig_Encoding", AudioOutConfig_Encoding_name, AudioOutConfig_Encoding_value)
	proto.RegisterEnum("google.assistant.embedded.v1alpha2.DialogStateOut_MicrophoneMode", DialogStateOut_MicrophoneMode_name, DialogStateOut_MicrophoneMode_value)
	proto.RegisterEnum("google.assistant.embedded.v1alpha2.AssistResponse_EventType", AssistResponse_EventType_name, AssistResponse_EventType_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for EmbeddedAssistant service

type EmbeddedAssistantClient interface {
	// Initiates or continues a conversation with the embedded Assistant Service.
	// Each call performs one round-trip, sending an audio request to the service
	// and receiving the audio response. Uses bidirectional streaming to receive
	// results, such as the `END_OF_UTTERANCE` event, while sending audio.
	//
	// A conversation is one or more gRPC connections, each consisting of several
	// streamed requests and responses.
	// For example, the user says *Add to my shopping list* and the Assistant
	// responds *What do you want to add?*. The sequence of streamed requests and
	// responses in the first gRPC message could be:
	//
	// *   AssistRequest.config
	// *   AssistRequest.audio_in
	// *   AssistRequest.audio_in
	// *   AssistRequest.audio_in
	// *   AssistRequest.audio_in
	// *   AssistResponse.event_type.END_OF_UTTERANCE
	// *   AssistResponse.speech_results.transcript "add to my shopping list"
	// *   AssistResponse.dialog_state_out.microphone_mode.DIALOG_FOLLOW_ON
	// *   AssistResponse.audio_out
	// *   AssistResponse.audio_out
	// *   AssistResponse.audio_out
	//
	//
	// The user then says *bagels* and the Assistant responds
	// *OK, I've added bagels to your shopping list*. This is sent as another gRPC
	// connection call to the `Assist` method, again with streamed requests and
	// responses, such as:
	//
	// *   AssistRequest.config
	// *   AssistRequest.audio_in
	// *   AssistRequest.audio_in
	// *   AssistRequest.audio_in
	// *   AssistResponse.event_type.END_OF_UTTERANCE
	// *   AssistResponse.dialog_state_out.microphone_mode.CLOSE_MICROPHONE
	// *   AssistResponse.audio_out
	// *   AssistResponse.audio_out
	// *   AssistResponse.audio_out
	// *   AssistResponse.audio_out
	//
	// Although the precise order of responses is not guaranteed, sequential
	// `AssistResponse.audio_out` messages will always contain sequential portions
	// of audio.
	Assist(ctx context.Context, opts ...grpc.CallOption) (EmbeddedAssistant_AssistClient, error)
}

type embeddedAssistantClient struct {
	cc *grpc.ClientConn
}

func NewEmbeddedAssistantClient(cc *grpc.ClientConn) EmbeddedAssistantClient {
	return &embeddedAssistantClient{cc}
}

func (c *embeddedAssistantClient) Assist(ctx context.Context, opts ...grpc.CallOption) (EmbeddedAssistant_AssistClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_EmbeddedAssistant_serviceDesc.Streams[0], c.cc, "/google.assistant.embedded.v1alpha2.EmbeddedAssistant/Assist", opts...)
	if err != nil {
		return nil, err
	}
	x := &embeddedAssistantAssistClient{stream}
	return x, nil
}

type EmbeddedAssistant_AssistClient interface {
	Send(*AssistRequest) error
	Recv() (*AssistResponse, error)
	grpc.ClientStream
}

type embeddedAssistantAssistClient struct {
	grpc.ClientStream
}

func (x *embeddedAssistantAssistClient) Send(m *AssistRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *embeddedAssistantAssistClient) Recv() (*AssistResponse, error) {
	m := new(AssistResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for EmbeddedAssistant service

type EmbeddedAssistantServer interface {
	// Initiates or continues a conversation with the embedded Assistant Service.
	// Each call performs one round-trip, sending an audio request to the service
	// and receiving the audio response. Uses bidirectional streaming to receive
	// results, such as the `END_OF_UTTERANCE` event, while sending audio.
	//
	// A conversation is one or more gRPC connections, each consisting of several
	// streamed requests and responses.
	// For example, the user says *Add to my shopping list* and the Assistant
	// responds *What do you want to add?*. The sequence of streamed requests and
	// responses in the first gRPC message could be:
	//
	// *   AssistRequest.config
	// *   AssistRequest.audio_in
	// *   AssistRequest.audio_in
	// *   AssistRequest.audio_in
	// *   AssistRequest.audio_in
	// *   AssistResponse.event_type.END_OF_UTTERANCE
	// *   AssistResponse.speech_results.transcript "add to my shopping list"
	// *   AssistResponse.dialog_state_out.microphone_mode.DIALOG_FOLLOW_ON
	// *   AssistResponse.audio_out
	// *   AssistResponse.audio_out
	// *   AssistResponse.audio_out
	//
	//
	// The user then says *bagels* and the Assistant responds
	// *OK, I've added bagels to your shopping list*. This is sent as another gRPC
	// connection call to the `Assist` method, again with streamed requests and
	// responses, such as:
	//
	// *   AssistRequest.config
	// *   AssistRequest.audio_in
	// *   AssistRequest.audio_in
	// *   AssistRequest.audio_in
	// *   AssistResponse.event_type.END_OF_UTTERANCE
	// *   AssistResponse.dialog_state_out.microphone_mode.CLOSE_MICROPHONE
	// *   AssistResponse.audio_out
	// *   AssistResponse.audio_out
	// *   AssistResponse.audio_out
	// *   AssistResponse.audio_out
	//
	// Although the precise order of responses is not guaranteed, sequential
	// `AssistResponse.audio_out` messages will always contain sequential portions
	// of audio.
	Assist(EmbeddedAssistant_AssistServer) error
}

func RegisterEmbeddedAssistantServer(s *grpc.Server, srv EmbeddedAssistantServer) {
	s.RegisterService(&_EmbeddedAssistant_serviceDesc, srv)
}

func _EmbeddedAssistant_Assist_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(EmbeddedAssistantServer).Assist(&embeddedAssistantAssistServer{stream})
}

type EmbeddedAssistant_AssistServer interface {
	Send(*AssistResponse) error
	Recv() (*AssistRequest, error)
	grpc.ServerStream
}

type embeddedAssistantAssistServer struct {
	grpc.ServerStream
}

func (x *embeddedAssistantAssistServer) Send(m *AssistResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *embeddedAssistantAssistServer) Recv() (*AssistRequest, error) {
	m := new(AssistRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _EmbeddedAssistant_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.assistant.embedded.v1alpha2.EmbeddedAssistant",
	HandlerType: (*EmbeddedAssistantServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Assist",
			Handler:       _EmbeddedAssistant_Assist_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/assistant/embedded/v1alpha2/embedded_assistant.proto",
}

func init() {
	proto.RegisterFile("google/assistant/embedded/v1alpha2/embedded_assistant.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 1141 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x56, 0xdd, 0x6e, 0xdb, 0x36,
	0x14, 0x8e, 0xec, 0x34, 0xb5, 0x4f, 0x62, 0xc5, 0x61, 0x8b, 0xd5, 0x4b, 0xbb, 0xb5, 0xd0, 0x80,
	0x22, 0xfb, 0xb3, 0x9b, 0x14, 0xd8, 0x80, 0xb6, 0x1b, 0xe0, 0xda, 0x4a, 0xa2, 0xc2, 0xb1, 0x5c,
	0xc6, 0x69, 0xd1, 0xfd, 0x80, 0x60, 0x24, 0x4e, 0x51, 0x21, 0x93, 0xaa, 0x44, 0x07, 0xcd, 0xae,
	0x76, 0x35, 0xec, 0xb2, 0x0f, 0xb1, 0x07, 0xd9, 0x2b, 0xec, 0x59, 0xf6, 0x02, 0x03, 0x29, 0xc9,
	0xb5, 0xb6, 0x66, 0xb3, 0xb7, 0x3b, 0xf1, 0x1c, 0x9e, 0x8f, 0xe4, 0x39, 0xe7, 0xfb, 0x8e, 0xe0,
	0x61, 0x20, 0x44, 0x10, 0xb1, 0x0e, 0x4d, 0xd3, 0x30, 0x95, 0x94, 0xcb, 0x0e, 0x9b, 0x9c, 0x32,
	0xdf, 0x67, 0x7e, 0xe7, 0x7c, 0x97, 0x46, 0xf1, 0x19, 0xdd, 0x9b, 0x59, 0xc8, 0x6c, 0x53, 0x3b,
	0x4e, 0x84, 0x14, 0xc8, 0xca, 0x82, 0xdb, 0x6f, 0xed, 0xc5, 0xd6, 0x76, 0x11, 0xbc, 0x7d, 0xab,
	0x38, 0x20, 0x0e, 0x3b, 0x94, 0x73, 0x21, 0xa9, 0x0c, 0x05, 0x4f, 0x33, 0x84, 0xed, 0x56, 0xee,
	0x95, 0x17, 0x31, 0xeb, 0x44, 0x54, 0x46, 0x3c, 0xc8, 0x3c, 0xd6, 0xaf, 0x55, 0xd8, 0xe8, 0x6a,
	0xdc, 0x9e, 0xe0, 0x3f, 0x84, 0x01, 0xfa, 0x16, 0x36, 0xe9, 0xd4, 0x0f, 0x05, 0x09, 0x39, 0xf1,
	0xb4, 0xa9, 0x65, 0xdc, 0x31, 0x76, 0xd6, 0xf7, 0x76, 0xdb, 0xff, 0x7e, 0x8d, 0x76, 0x57, 0x85,
	0x3a, 0x3c, 0xc3, 0x3a, 0x5c, 0xc1, 0x0d, 0x3a, 0x6f, 0x40, 0xb7, 0x01, 0x24, 0x7b, 0x2d, 0xc9,
	0xab, 0x29, 0x4b, 0x2e, 0x5a, 0x6b, 0x77, 0x8c, 0x9d, 0xfa, 0xe1, 0x0a, 0xae, 0x2b, 0xdb, 0x53,
	0x65, 0x42, 0xdf, 0x41, 0x33, 0x3b, 0x5d, 0x4c, 0x65, 0x71, 0x7c, 0x45, 0x1f, 0xbf, 0xb7, 0xf0,
	0xf1, 0xee, 0x34, 0x7f, 0x0b, 0x36, 0x69, 0x69, 0x8d, 0x5e, 0xc0, 0xa6, 0x1f, 0xd2, 0x48, 0x04,
	0x24, 0x95, 0x54, 0x32, 0x12, 0xf2, 0x56, 0x75, 0xf1, 0xb7, 0xf5, 0x75, 0xe8, 0xb1, 0x8a, 0x74,
	0x38, 0x6e, 0xf8, 0xf3, 0x4b, 0x74, 0x02, 0x0d, 0x9f, 0x9d, 0x87, 0x1e, 0x2b, 0x6e, 0xbd, 0xaa,
	0x81, 0xef, 0x2d, 0x04, 0xac, 0x03, 0xf3, 0x3b, 0x6f, 0xf8, 0x73, 0xab, 0xc7, 0x6b, 0xb0, 0xaa,
	0x6a, 0x66, 0xfd, 0x6e, 0x40, 0xa3, 0x94, 0x5b, 0xf4, 0x0c, 0x6a, 0x8c, 0x7b, 0xc2, 0x0f, 0x79,
	0x56, 0x20, 0x73, 0xef, 0xc1, 0xd2, 0x05, 0x6a, 0xdb, 0x39, 0x02, 0x9e, 0x61, 0xa1, 0x4f, 0x60,
	0x2b, 0xa5, 0x93, 0x38, 0x62, 0x24, 0x51, 0x29, 0x3a, 0x63, 0x89, 0xfc, 0x51, 0x97, 0xe0, 0x0a,
	0xde, 0xcc, 0x1c, 0x98, 0x4a, 0x76, 0xa8, 0xcc, 0xd6, 0x23, 0xa8, 0x15, 0x08, 0xa8, 0x05, 0xd7,
	0xed, 0x61, 0xcf, 0xed, 0x3b, 0xc3, 0x03, 0x72, 0x32, 0x3c, 0x1e, 0xd9, 0x3d, 0x67, 0xdf, 0xb1,
	0xfb, 0xcd, 0x15, 0xb4, 0x01, 0xb5, 0x81, 0x33, 0xb4, 0xbb, 0x78, 0xf7, 0x8b, 0xa6, 0x81, 0x6a,
	0xb0, 0xba, 0x3f, 0xe8, 0xf6, 0x9a, 0x15, 0xeb, 0x4d, 0x05, 0xcc, 0x72, 0xc1, 0xd0, 0xf3, 0xbf,
	0x3d, 0xea, 0xe1, 0xf2, 0x65, 0xff, 0x9f, 0xaf, 0x42, 0x9f, 0xc2, 0xd6, 0xb9, 0x88, 0xa6, 0x13,
	0x46, 0x62, 0x96, 0x78, 0x8c, 0x4b, 0x1a, 0x30, 0xdd, 0x27, 0x57, 0x70, 0x33, 0x73, 0x8c, 0x66,
	0x76, 0x6b, 0xf0, 0x1f, 0x52, 0x70, 0x15, 0xaa, 0x47, 0xa3, 0xfb, 0xcd, 0x0a, 0xda, 0x84, 0x75,
	0x77, 0x74, 0x72, 0x4c, 0x9c, 0x21, 0x71, 0x0f, 0x0e, 0x9a, 0x55, 0xeb, 0x37, 0x03, 0x1a, 0xa5,
	0x36, 0x43, 0x9f, 0x03, 0xf2, 0x04, 0x3f, 0x67, 0x49, 0xaa, 0x09, 0x9d, 0x35, 0xae, 0xce, 0xcd,
	0x06, 0xde, 0x9a, 0xf7, 0xe8, 0x00, 0xf4, 0x11, 0x34, 0x22, 0xca, 0x83, 0x29, 0x0d, 0x54, 0x23,
	0xfa, 0x4c, 0xbf, 0xb1, 0x8e, 0x37, 0x0a, 0x63, 0x4f, 0xf8, 0x4c, 0x51, 0x3c, 0xef, 0xd5, 0x48,
	0x78, 0x3a, 0xb8, 0x75, 0x65, 0x71, 0x8e, 0x65, 0xdd, 0x3a, 0xc8, 0x23, 0xb1, 0xe9, 0x97, 0xd6,
	0xd6, 0xc7, 0x50, 0x2b, 0xca, 0x81, 0x3e, 0x00, 0xc8, 0xd8, 0xec, 0x53, 0x49, 0xf3, 0x4b, 0xd7,
	0xb5, 0xa5, 0x4f, 0x25, 0xb5, 0xfe, 0xa8, 0x80, 0x39, 0xf7, 0x5a, 0x15, 0xf1, 0x00, 0xde, 0x4f,
	0xa7, 0x71, 0x1c, 0xb1, 0x89, 0xca, 0x6f, 0x44, 0xfc, 0x30, 0x8d, 0x23, 0x7a, 0x41, 0x94, 0x42,
	0x68, 0x80, 0x3a, 0xbe, 0x31, 0xbf, 0xa1, 0x9f, 0xf9, 0xc7, 0xec, 0xb5, 0xbc, 0x24, 0x55, 0x95,
	0xcb, 0x52, 0xf5, 0x12, 0x36, 0x27, 0xa1, 0x97, 0x88, 0xf8, 0x4c, 0x70, 0x46, 0x26, 0x2a, 0x59,
	0x55, 0xdd, 0x72, 0xdd, 0x25, 0xc5, 0xc0, 0x9d, 0xca, 0xf6, 0xd1, 0x0c, 0xe9, 0x48, 0xf8, 0x0c,
	0x9b, 0x93, 0xd2, 0xfa, 0xdd, 0x2d, 0xb5, 0x7a, 0x49, 0x4b, 0x7d, 0x0f, 0x66, 0x19, 0x0e, 0xdd,
	0x86, 0x9b, 0x47, 0x4e, 0x0f, 0xbb, 0xa3, 0x43, 0x77, 0x68, 0x93, 0x23, 0xb7, 0x6f, 0xff, 0xa5,
	0xbf, 0xae, 0x43, 0xb3, 0x37, 0x70, 0x8f, 0x6d, 0xf2, 0x76, 0x5b, 0xd3, 0x50, 0xd6, 0xbe, 0xd3,
	0x1d, 0xb8, 0x07, 0x64, 0xdf, 0x1d, 0x0c, 0xdc, 0xe7, 0xc4, 0x1d, 0x36, 0x2b, 0xd6, 0x4f, 0x4a,
	0x4a, 0xf4, 0xcb, 0x30, 0x7b, 0x35, 0x65, 0xa9, 0x44, 0x4f, 0x60, 0xad, 0xa4, 0xf4, 0x0b, 0x89,
	0xd6, 0xfc, 0xd0, 0x38, 0x5c, 0xc1, 0x39, 0x02, 0xba, 0x09, 0xb5, 0x62, 0x7c, 0x64, 0xa9, 0x3f,
	0x5c, 0xc1, 0x57, 0xf3, 0x21, 0x30, 0x53, 0xb3, 0x37, 0xab, 0x60, 0x16, 0x57, 0x48, 0x63, 0xc1,
	0x53, 0xd5, 0x93, 0xc0, 0xce, 0x19, 0x97, 0x44, 0x6d, 0xc8, 0xb9, 0xff, 0x68, 0xf1, 0x7b, 0x14,
	0x38, 0x6d, 0x5b, 0x81, 0x8c, 0x2f, 0x62, 0x86, 0xeb, 0xac, 0xf8, 0x44, 0x0e, 0xd4, 0x67, 0x53,
	0x25, 0x57, 0xfc, 0xcf, 0x96, 0xd1, 0x15, 0x5c, 0x2b, 0x06, 0xc9, 0x9c, 0xce, 0x53, 0x4f, 0x33,
	0x67, 0x6d, 0x59, 0x9d, 0xef, 0xea, 0xb8, 0x42, 0xe7, 0xb3, 0x15, 0x3a, 0x05, 0x33, 0x8d, 0x19,
	0xf3, 0xce, 0x48, 0xc2, 0xd2, 0x69, 0x24, 0xd3, 0x56, 0xe5, 0x4e, 0x75, 0x67, 0x7d, 0x31, 0xf9,
	0x3b, 0xd6, 0x91, 0x98, 0x79, 0x22, 0xe0, 0xa1, 0x06, 0xd7, 0x18, 0xb8, 0x91, 0xe6, 0x0e, 0x8d,
	0xa8, 0x66, 0x6b, 0x69, 0xfa, 0xa9, 0x64, 0x2c, 0xc3, 0xfb, 0x52, 0xc7, 0x63, 0xd3, 0x2f, 0xad,
	0xad, 0xaf, 0xa0, 0x3e, 0xcb, 0x3d, 0xda, 0x86, 0xf7, 0xec, 0x67, 0xf6, 0x70, 0x4c, 0xc6, 0x2f,
	0x46, 0xef, 0xe8, 0x55, 0x7b, 0xd8, 0x27, 0xee, 0x3e, 0x39, 0x19, 0x8f, 0x6d, 0xdc, 0x1d, 0xf6,
	0xec, 0xa6, 0x61, 0x3d, 0x87, 0x1b, 0x97, 0x3c, 0x03, 0x7d, 0x08, 0x20, 0x13, 0xca, 0x53, 0x2f,
	0x09, 0xe3, 0x42, 0x04, 0xe6, 0x2c, 0xe8, 0x16, 0xd4, 0x53, 0x49, 0x4f, 0xc3, 0x28, 0x94, 0x17,
	0xba, 0xe7, 0x2a, 0xf8, 0xad, 0xc1, 0x3a, 0x86, 0x8d, 0xf9, 0xf9, 0x8a, 0x6e, 0x42, 0x3d, 0x2f,
	0x60, 0xe8, 0xe7, 0x60, 0xb5, 0xcc, 0xe0, 0xf8, 0xe8, 0xee, 0x4c, 0x19, 0x95, 0x1e, 0x44, 0x6a,
	0x4b, 0x55, 0x6f, 0xc9, 0x8b, 0xae, 0xd8, 0x18, 0x39, 0xbe, 0xf5, 0x75, 0x01, 0x9a, 0x97, 0xaf,
	0x0d, 0xd7, 0xf2, 0xb8, 0x24, 0xe3, 0x14, 0x79, 0x99, 0x0a, 0x9e, 0xc3, 0x6f, 0x65, 0xae, 0x9c,
	0x6d, 0x4f, 0x52, 0xc1, 0xad, 0xa7, 0x60, 0x96, 0x65, 0x14, 0x7d, 0x09, 0xeb, 0x9e, 0x10, 0x89,
	0x1f, 0x72, 0x2a, 0x59, 0x9a, 0x13, 0xf1, 0x5a, 0x51, 0x17, 0x45, 0x8a, 0xf6, 0x80, 0xca, 0x01,
	0x57, 0x5c, 0x9b, 0xdf, 0x59, 0x70, 0x6a, 0xef, 0x17, 0x03, 0xb6, 0xec, 0xbc, 0x68, 0xdd, 0xa2,
	0x8c, 0x28, 0x85, 0xb5, 0x6c, 0x81, 0x76, 0x97, 0x21, 0x93, 0xbe, 0xe9, 0xf6, 0xde, 0xf2, 0xfc,
	0xdb, 0x31, 0xee, 0x19, 0x8f, 0x7f, 0x36, 0xe0, 0xae, 0x27, 0x26, 0x0b, 0x44, 0x3f, 0x36, 0x67,
	0x57, 0x1d, 0xa9, 0xdf, 0xd1, 0x91, 0xf1, 0xcd, 0x93, 0x3c, 0x2a, 0x10, 0x6a, 0x66, 0xb5, 0x45,
	0x12, 0x74, 0x02, 0xc6, 0xf5, 0xcf, 0x6a, 0x27, 0x73, 0xd1, 0x38, 0x4c, 0xff, 0xe9, 0x47, 0xfa,
	0x61, 0x61, 0x39, 0x5d, 0xd3, 0x61, 0xf7, 0xff, 0x0c, 0x00, 0x00, 0xff, 0xff, 0x3d, 0x7a, 0x00,
	0x97, 0x7e, 0x0b, 0x00, 0x00,
}
