/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.text.Char;
import gnu.text.ReportFormat;
import java.io.IOException;
import java.io.Writer;
import java.text.FieldPosition;

class LispCharacterFormat
extends ReportFormat {
    boolean seenAt;
    boolean seenColon;
    int count;
    int charVal;

    LispCharacterFormat() {
    }

    public static LispCharacterFormat getInstance(int charVal, int count, boolean seenAt, boolean seenColon) {
        LispCharacterFormat fmt = new LispCharacterFormat();
        fmt.count = count;
        fmt.charVal = charVal;
        fmt.seenAt = seenAt;
        fmt.seenColon = seenColon;
        return fmt;
    }

    public int format(Object[] args, int start, Writer dst, FieldPosition fpos) throws IOException {
        int count = LispCharacterFormat.getParam(this.count, 1, args, start);
        if (this.count == -1610612736) {
            ++start;
        }
        char charVal = LispCharacterFormat.getParam(this.charVal, '?', args, start);
        if (this.charVal == -1610612736) {
            ++start;
        }
        while (--count >= 0) {
            LispCharacterFormat.printChar(charVal, this.seenAt, this.seenColon, dst);
        }
        return start;
    }

    public static void printChar(int ch, boolean seenAt, boolean seenColon, Writer dst) throws IOException {
        if (seenAt) {
            LispCharacterFormat.print(dst, Char.toScmReadableString(ch));
        } else if (seenColon) {
            if (ch < 32) {
                dst.write(94);
                dst.write(ch + 64);
            } else if (ch >= 127) {
                LispCharacterFormat.print(dst, "#\\");
                LispCharacterFormat.print(dst, Integer.toString(ch, 8));
            } else {
                dst.write(ch);
            }
        } else {
            dst.write(ch);
        }
    }
}

