/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.assembler.assemblers;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.JA;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.InfModelAssembler;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.StmtIterator;

public class OntModelAssembler
extends InfModelAssembler
implements Assembler {
    private static final OntModelSpec defaultSpec = OntModelSpec.OWL_MEM_RDFS_INF;

    @Override
    public Model openEmptyModel(Assembler a, Resource root, Mode mode) {
        this.checkType(root, JA.OntModel);
        Model baseModel = this.getBase(a, root, mode);
        OntModelSpec oms = this.getOntModelSpec(a, root);
        OntModel om = ModelFactory.createOntologyModel(oms, baseModel);
        this.addSubModels(a, root, mode, om);
        return om;
    }

    private void addSubModels(Assembler a, Resource root, Mode mode, OntModel om) {
        List<Model> subModels = this.getSubModels(a, root, mode);
        for (Model subModel : subModels) {
            om.addSubModel(subModel);
        }
    }

    private List<Model> getSubModels(Assembler a, Resource root, Mode mode) {
        ArrayList<Model> result = new ArrayList<Model>();
        StmtIterator it = root.listProperties(JA.subModel);
        while (it.hasNext()) {
            result.add(a.openModel(it.nextStatement().getResource(), mode));
        }
        return result;
    }

    protected OntModelSpec getOntModelSpec(Assembler a, Resource root) {
        Resource r = OntModelAssembler.getUniqueResource(root, JA.ontModelSpec);
        return r == null ? defaultSpec : (OntModelSpec)a.open(r);
    }
}

