/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.text;

import java.awt.Font;
import java.text.ParseException;
import java.util.HashMap;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;

public class FontFormatter
extends DefaultFormatter {
    private boolean allowsNullValue = false;
    private boolean allowsUnknownFont = false;
    private HashMap<String, Font> genericFontFamilies = new HashMap();

    public FontFormatter() {
        this(true);
    }

    public FontFormatter(boolean bl) {
        this.allowsNullValue = bl;
        this.setOverwriteMode(false);
        this.putGenericFontFamily("serif", new Font("Serif", 0, 12));
        this.putGenericFontFamily("sans-serif", new Font("SansSerif", 0, 12));
        this.putGenericFontFamily("cursive", new Font("SansSerif", 2, 12));
        this.putGenericFontFamily("fantasy", new Font("Serif", 0, 12));
        this.putGenericFontFamily("monospace", new Font("Monospaced", 0, 12));
    }

    public void setAllowsNullValue(boolean bl) {
        this.allowsNullValue = bl;
    }

    public boolean getAllowsNullValue() {
        return this.allowsNullValue;
    }

    public void setAllowsUnknownFont(boolean bl) {
        this.allowsUnknownFont = bl;
    }

    public boolean getAllowsUnknownFont() {
        return this.allowsUnknownFont;
    }

    public void clearGenericFontFamilies() {
        this.genericFontFamilies = null;
    }

    public void putGenericFontFamily(String string, Font font) {
        this.genericFontFamilies.put(string.toLowerCase(), font);
    }

    @Override
    public Object stringToValue(String string) throws ParseException {
        if (string == null || string.trim().length() == 0) {
            if (this.allowsNullValue) {
                return null;
            }
            throw new ParseException("Null value is not allowed.", 0);
        }
        String string2 = string.trim().toLowerCase();
        Font font = null;
        font = this.genericFontFamilies.get(string2);
        if (font == null) {
            font = Font.decode(string);
            if (font == null) {
                throw new ParseException(string, 0);
            }
            if (!this.allowsUnknownFont) {
                String string3 = font.getFontName().toLowerCase();
                String string4 = font.getFamily().toLowerCase();
                if (!(string3.equals(string2) || string4.equals(string2) || string3.equals(string2 + "-derived"))) {
                    throw new ParseException(string, 0);
                }
            }
        }
        return font;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String valueToString(Object object) throws ParseException {
        String string = null;
        if (object == null) {
            if (!this.allowsNullValue) throw new ParseException("Null value is not allowed.", 0);
            return "";
        }
        if (!(object instanceof Font)) {
            throw new ParseException("Value is not a font " + object, 0);
        }
        Font font = (Font)object;
        return font.getFontName();
    }

    public static JFormattedTextField.AbstractFormatterFactory createFormatterFactory() {
        return FontFormatter.createFormatterFactory(false);
    }

    public static JFormattedTextField.AbstractFormatterFactory createFormatterFactory(boolean bl) {
        return new DefaultFormatterFactory(new FontFormatter(bl));
    }
}

