/*
 * Plasma applet to display indicators from libindicate
 *
 * Copyright 2009 Canonical Ltd.
 *
 * Authors:
 * - Aurélien Gâteau <aurelien.gateau@canonical.com>
 *
 * License: GPL v3
 */
#ifndef LISTENERMODELTEST_H
#define LISTENERMODELTEST_H

// Qt
#include <QObject>

// libindicate-qt
#include <qindicateserver.h>

// Local
#include <listenermodel.h>

/**
 * Test the listener model
 */
class ListenerModelTest : public QObject
{
Q_OBJECT
private Q_SLOTS:
    void initTestCase();
    void init();
    void cleanup();
    void testAddServers();
    void testAddIndicators();
    void testAddIndicatorsAfterModel();
    void testGetProxiesFromIndex();
    void testUpdateIndicator();

private:
    QIndicate::Listener* mListener;
    QIndicate::Server* mServer;
    ListenerModel* mModel;
};

#endif /* LISTENERMODELTEST_H */
