// Code generated by re2c, DO NOT EDIT.
//go:generate re2go -c $INPUT -o $OUTPUT --loop-switch -i
package main

import (
	"errors"
	"testing"
)

var (
	eSyntax   = errors.New("syntax error")
	eOverflow = errors.New("overflow error")
)

const (
	yycinit = 0
	yycbin = 10
	yycdec = 14
	yychex = 18
	yycoct = 24
)


const u32Limit uint64 = 1<<32

func parse_u32(str string) (uint32, error) {
	var cursor, marker int
	result := uint64(0)
	cond := yycinit

	add_digit := func(base uint64, offset byte) {
		result = result * base + uint64(str[cursor-1] - offset)
		if result >= u32Limit {
			result = u32Limit
		}
	}

loop:
	
{
	var yych byte
	yystate := cond
yyl:
	for {
		switch (yystate) {
		case 0:
			yych = str[cursor]
			cursor += 1
			switch (yych) {
			case '0':
				yystate = 2
				continue yyl
			case '1','2','3','4','5','6','7','8','9':
				yystate = 4
				continue yyl
			default:
				yystate = 1
				continue yyl
			}
		case 1:
			{ return 0, eSyntax }
		case 2:
			marker = cursor
			yych = str[cursor]
			switch (yych) {
			case 'B':
				fallthrough
			case 'b':
				cursor += 1
				yystate = 5
				continue yyl
			case 'X':
				fallthrough
			case 'x':
				cursor += 1
				yystate = 7
				continue yyl
			default:
				yystate = 3
				continue yyl
			}
		case 3:
			cond = yycoct
			yystate = yycoct
			continue yyl
		case 4:
			cursor += -1
			cond = yycdec
			yystate = yycdec
			continue yyl
		case 5:
			yych = str[cursor]
			switch (yych) {
			case '0','1':
				cursor += 1
				yystate = 8
				continue yyl
			default:
				yystate = 6
				continue yyl
			}
		case 6:
			cursor = marker
			yystate = 3
			continue yyl
		case 7:
			yych = str[cursor]
			switch (yych) {
			case '0','1','2','3','4','5','6','7','8','9':
				fallthrough
			case 'A','B','C','D','E','F':
				fallthrough
			case 'a','b','c','d','e','f':
				cursor += 1
				yystate = 9
				continue yyl
			default:
				yystate = 6
				continue yyl
			}
		case 8:
			cursor += -1
			cond = yycbin
			yystate = yycbin
			continue yyl
		case 9:
			cursor += -1
			cond = yychex
			yystate = yychex
			continue yyl
		case 10:
			yych = str[cursor]
			cursor += 1
			switch (yych) {
			case 0x00:
				yystate = 11
				continue yyl
			case '0','1':
				yystate = 13
				continue yyl
			default:
				yystate = 12
				continue yyl
			}
		case 11:
			{
		if result < u32Limit {
			return uint32(result), nil
		} else {
			return 0, eOverflow
		}
	}
		case 12:
			{ return 0, eSyntax }
		case 13:
			{ add_digit(2, '0');     goto loop }
		case 14:
			yych = str[cursor]
			cursor += 1
			switch (yych) {
			case 0x00:
				yystate = 15
				continue yyl
			case '0','1','2','3','4','5','6','7','8','9':
				yystate = 17
				continue yyl
			default:
				yystate = 16
				continue yyl
			}
		case 15:
			{
		if result < u32Limit {
			return uint32(result), nil
		} else {
			return 0, eOverflow
		}
	}
		case 16:
			{ return 0, eSyntax }
		case 17:
			{ add_digit(10, '0');    goto loop }
		case 18:
			yych = str[cursor]
			cursor += 1
			switch (yych) {
			case 0x00:
				yystate = 19
				continue yyl
			case '0','1','2','3','4','5','6','7','8','9':
				yystate = 21
				continue yyl
			case 'A','B','C','D','E','F':
				yystate = 22
				continue yyl
			case 'a','b','c','d','e','f':
				yystate = 23
				continue yyl
			default:
				yystate = 20
				continue yyl
			}
		case 19:
			{
		if result < u32Limit {
			return uint32(result), nil
		} else {
			return 0, eOverflow
		}
	}
		case 20:
			{ return 0, eSyntax }
		case 21:
			{ add_digit(16, '0');    goto loop }
		case 22:
			{ add_digit(16, 'A'-10); goto loop }
		case 23:
			{ add_digit(16, 'a'-10); goto loop }
		case 24:
			yych = str[cursor]
			cursor += 1
			switch (yych) {
			case 0x00:
				yystate = 25
				continue yyl
			case '0','1','2','3','4','5','6','7':
				yystate = 27
				continue yyl
			default:
				yystate = 26
				continue yyl
			}
		case 25:
			{
		if result < u32Limit {
			return uint32(result), nil
		} else {
			return 0, eOverflow
		}
	}
		case 26:
			{ return 0, eSyntax }
		case 27:
			{ add_digit(8, '0');     goto loop }
		default:
			panic("internal lexer error")
		}
	}
}

}

func TestLex(t *testing.T) {
	var tests = []struct {
		num uint32
		str string
		err error
	}{
		{1234567890, "1234567890\000", nil},
		{13, "0b1101\000", nil},
		{0x7fe, "0x007Fe\000", nil},
		{0644, "0644\000", nil},
		{0, "9999999999\000", eOverflow},
		{0, "123??\000", eSyntax},
	}

	for _, x := range tests {
		t.Run(x.str, func(t *testing.T) {
			num, err := parse_u32(x.str)
			if !(num == x.num && err == x.err) {
				t.Errorf("got %d, want %d", num, x.num)
			}
		})
	}
}
