/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.pipeline;

import htsjdk.samtools.metrics.MetricBase;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.gatk.utils.classloader.JVMUtils;

public class MetricsUtils {
    public static <BEAN extends MetricBase> BEAN getSampleMetric(List<BEAN> metrics) {
        return MetricsUtils.getLibraryMetric(metrics, null);
    }

    public static <BEAN extends MetricBase> BEAN getLibraryMetric(List<BEAN> metrics, String library) {
        List<BEAN> filteredMetrics = MetricsUtils.filterMetrics(metrics, "LIBRARY", library);
        if (filteredMetrics.size() > 1) {
            throw new IllegalStateException(String.format("%d metrics returned", filteredMetrics.size()));
        }
        if (filteredMetrics.size() == 0) {
            return null;
        }
        return (BEAN)((MetricBase)filteredMetrics.get(0));
    }

    public static <BEAN extends MetricBase> List<BEAN> filterMetrics(List<BEAN> metrics, String fieldName, String value) {
        ArrayList<MetricBase> filteredMetrics = new ArrayList<MetricBase>();
        for (MetricBase metric : metrics) {
            Field field = JVMUtils.findField(metric.getClass(), fieldName);
            if (field == null) continue;
            Object fieldValue = JVMUtils.getFieldValue(field, metric);
            if (value == null) {
                if (fieldValue != null) continue;
                filteredMetrics.add(metric);
                continue;
            }
            if (fieldValue == null || !value.equals(fieldValue.toString())) continue;
            filteredMetrics.add(metric);
        }
        return filteredMetrics;
    }

    public static <BEAN extends MetricBase> List<String> getFieldNames(Class<BEAN> metricClass) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Field field : metricClass.getFields()) {
            String name = field.getName();
            if (name.startsWith("__")) continue;
            fieldNames.add(name);
        }
        return fieldNames;
    }
}

