/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.readers;

import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.tribble.readers.LineReader;
import htsjdk.tribble.readers.LongLineBufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public final class SynchronousLineReader
implements LineReader {
    private final LongLineBufferedReader longLineBufferedReader;

    public SynchronousLineReader(InputStream stream) {
        this(new InputStreamReader(stream));
    }

    public SynchronousLineReader(Reader reader) {
        this.longLineBufferedReader = new LongLineBufferedReader(reader);
    }

    @Override
    public String readLine() {
        try {
            return this.longLineBufferedReader.readLine();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void close() {
        CloserUtil.close(this.longLineBufferedReader);
    }
}

