/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors.output;

import amazon.fws.clicommando.config.ColumnConfig;
import amazon.fws.clicommando.config.OutputDescriptionConfig;
import amazon.fws.clicommando.exceptions.InternalErrorException;
import amazon.fws.clicommando.processors.output.Printable;
import amazon.fws.clicommando.processors.output.PrintableRow;
import amazon.fws.clicommando.processors.output.PrintableValue;
import amazon.fws.clicommando.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintableTable
extends Printable {
    private OutputDescriptionConfig outDesc;
    private PrintableRow header;
    private ArrayList<Integer> maxSizeList = null;
    private ArrayList<Boolean> isColumnUsed = null;
    private List<ColumnConfig> columns = null;

    private void initializeMaxSizeArray() {
        this.maxSizeList = new ArrayList();
        this.isColumnUsed = new ArrayList();
        for (int i = 0; i < this.outDesc.getColumns().size(); ++i) {
            if (this.outDesc.getColumns().get(i).getMinSize() > 0) {
                this.maxSizeList.add(this.outDesc.getColumns().get(i).getMinSize());
            } else {
                this.maxSizeList.add(0);
            }
            this.isColumnUsed.add(false);
        }
    }

    public PrintableTable(OutputDescriptionConfig outDesc, ColumnConfig.ColumnListType columnsToDisplay) {
        if (outDesc != null) {
            this.outDesc = outDesc;
            this.columns = outDesc.getColumnsByType(columnsToDisplay);
            this.initializeMaxSizeArray();
        }
    }

    public PrintableTable() {
        this(null, null);
    }

    public List<Printable> getRows() {
        return this.getValues();
    }

    public void addRow(PrintableRow row) {
        this.addValue(row);
        row.setParentTable(this);
    }

    public PrintableRow getHeader() {
        return this.header;
    }

    public void setHeader(PrintableRow header) {
        this.header = header;
        header.setParentTable(this);
    }

    public OutputDescriptionConfig getOutDesc() {
        return this.outDesc;
    }

    public ArrayList<Integer> getMaxSizeList() {
        return this.maxSizeList;
    }

    public ArrayList<Boolean> getIsColumnUsedList() {
        return this.isColumnUsed;
    }

    public List<ColumnConfig> getColumns() {
        return this.columns;
    }

    public void sortTable() throws IndexOutOfBoundsException {
        Integer sortIndex;
        if (this.outDesc != null && (sortIndex = this.outDesc.getSortByColumn()) != null) {
            ColumnConfig col = this.outDesc.getColumns().get(sortIndex);
            Comparator<Printable> resultComp = this.getComparatorForColumn(col.getSortBy(), sortIndex);
            List<Printable> values = this.getValues();
            Collections.sort(values, resultComp);
        }
    }

    @Override
    public String print() {
        StringBuilder ret = new StringBuilder();
        try {
            this.sortTable();
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        if (this.header != null && this.getValues().size() != 0) {
            this.registerColumn(this.header, false);
        }
        for (Printable value : this.getValues()) {
            if (value instanceof PrintableRow) {
                this.registerColumn((PrintableRow)value, true);
                continue;
            }
            if (value instanceof PrintableTable) continue;
            throw new InternalErrorException("A PrintableTable doesn't know how to handle row of type " + value.getClass().toString());
        }
        if (this.header != null && this.getValues().size() != 0) {
            ret.append(this.header.print());
        }
        for (int i = 0; i < this.getValues().size(); ++i) {
            Printable value;
            value = this.getValues().get(i);
            if (value instanceof PrintableRow) {
                PrintableRow row = (PrintableRow)value;
                ret.append(row.print());
                continue;
            }
            if (value instanceof PrintableTable) {
                ret.append(((PrintableTable)value).print());
                continue;
            }
            throw new InternalErrorException("PrintableTable doesn't know how to handle row of type " + value.getClass().toString());
        }
        return ret.toString();
    }

    private void registerColumn(PrintableRow row, boolean setColumActive) {
        for (int i = 0; i < row.getValues().size(); ++i) {
            Printable value = row.getValues().get(i);
            if (value instanceof PrintableTable) continue;
            if (value instanceof PrintableValue) {
                String col = ((PrintableValue)value).getValue();
                if (useWSPadding) {
                    this.registerColSize(col, i);
                }
                if (!setColumActive) continue;
                this.registerColUse(col, i);
                continue;
            }
            throw new InternalErrorException("Can't embed a row inside a row without a table. " + value.getClass().toString());
        }
    }

    private void registerColSize(String input, int columnIndex) {
        int maxSize = this.columns.get(columnIndex).getColSize();
        int inLen = input.length();
        if (inLen > maxSize && maxSize > 0) {
            inLen = maxSize;
        }
        if (inLen > this.maxSizeList.get(columnIndex)) {
            this.maxSizeList.set(columnIndex, inLen);
        }
    }

    private void registerColUse(String input, int columnIndex) {
        if (StringUtils.notEmpty(input)) {
            this.isColumnUsed.set(columnIndex, true);
        }
    }

    private Comparator<Printable> getComparatorForColumn(final ColumnConfig.SortType sortBy, final int sortIndex) {
        Comparator<Printable> ret = null;
        ret = new Comparator<Printable>(){

            @Override
            public int compare(Printable e1, Printable e2) {
                if (!(e1 instanceof PrintableRow) || !(e2 instanceof PrintableRow)) {
                    return 0;
                }
                PrintableRow r1 = (PrintableRow)e1;
                PrintableRow r2 = (PrintableRow)e2;
                String v1 = r1.getValues().get(sortIndex).toString();
                String v2 = r2.getValues().get(sortIndex).toString();
                SimpleDateFormat iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                switch (sortBy) {
                    case ASC: {
                        return v1.toLowerCase().compareTo(v2.toLowerCase());
                    }
                    case DESC: {
                        return v2.toLowerCase().compareTo(v1.toLowerCase());
                    }
                    case DATEASC: {
                        Date v2date;
                        Date v1date;
                        try {
                            v1date = iso8601.parse(v1);
                            v2date = iso8601.parse(v2);
                        }
                        catch (ParseException e) {
                            return 0;
                        }
                        return v1date.compareTo(v2date);
                    }
                    case DATEDESC: {
                        Date v2date;
                        Date v1date;
                        try {
                            v1date = iso8601.parse(v1);
                            v2date = iso8601.parse(v2);
                        }
                        catch (ParseException e) {
                            return 0;
                        }
                        return v2date.compareTo(v1date);
                    }
                }
                return 0;
            }
        };
        return ret;
    }
}

