/*****************************************************************************
 * Copyright (c) 2014-2024 OpenRCT2 developers
 *
 * For a complete list of all authors, please refer to contributors.md
 * Interested in contributing? Visit https://github.com/OpenRCT2/OpenRCT2
 *
 * OpenRCT2 is licensed under the GNU General Public License version 3.
 *****************************************************************************/

#pragma once

#include "GameAction.h"

class GameSetSpeedAction final : public GameActionBase<GameCommand::SetGameSpeed>
{
private:
    int32_t _speed{ 1 };

public:
    GameSetSpeedAction() = default;
    GameSetSpeedAction(int32_t speed);

    void AcceptParameters(GameActionParameterVisitor& visitor) override;

    uint16_t GetActionFlags() const override;

    void Serialise(DataSerialiser& stream) override;
    GameActions::Result Query() const override;
    GameActions::Result Execute() const override;

private:
    bool IsValidSpeed(int32_t speed) const;
};
