#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Puddle
# send your bug reports to contact@dotslashplay.it
###

script_version=20230730.2

GAME_ID='puddle'
GAME_NAME='Puddle'

ARCHIVE_BASE_0='setup_puddle_2.1.0.6.exe'
ARCHIVE_BASE_0_MD5='e1773a7bd360125ad67ce864963be586'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_VERSION='1.0-gog2.1.0.6'
ARCHIVE_BASE_0_SIZE='700000'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/puddle'

CONTENT_PATH_DEFAULT='app'
CONTENT_GAME_BIN_FILES='
*.exe
*.dll'
CONTENT_GAME_DATA_FILES='
data
de
es
fr
it'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/Documents/Puddle'

APP_MAIN_EXE='launcher.exe'
APP_MAIN_ICON='puddle.exe'
## Type must be set explicitly,
## or it will be wrongly identified as a Mono application.
APP_MAIN_TYPE='wine'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Load common functions

target_version='2.25'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Include Mono in the WINE prefix

ARCHIVE_REQUIRED_MONO='wine-mono-8.0.0-x86.msi'
ARCHIVE_REQUIRED_MONO_MD5='4fe5c683fcd9634c7f6571f252b3603c'
ARCHIVE_REQUIRED_MONO_URL='https://dl.winehq.org/wine/wine-mono/8.0.0/'

archive_initialize_required 'ARCHIVE_MONO' 'ARCHIVE_REQUIRED_MONO'

mono_installer_source=$(archive_find_path 'ARCHIVE_MONO')
mono_installer_destination="$(package_path 'PKG_BIN')$(path_game_data)/mono/wine-mono-8.0.0-x86.msi"
install -D --mode=644 "$mono_installer_source" "$mono_installer_destination"

WINE_DLLOVERRIDES_DEFAULT='winemenubuilder.exe,mshtml='

APP_MAIN_PRERUN="${APP_MAIN_PRERUN:-}"'
# Include Mono in the WINE prefix
if [ ! -e .mono_installed ]; then
	$(wine_command) mono/wine-mono-8.0.0-x86.msi
	touch .mono_installed
fi
'

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

packages_generation

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
