#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# A Tale of Paper
# send your bug reports to contact@dotslashplay.it
###

script_version=20230706.1

GAME_ID='a-tale-of-paper'
GAME_NAME='A Tale of Paper: Refolded'

GAME_ID_DEMO="${GAME_ID}-demo"
GAME_NAME_DEMO="$GAME_NAME (demo)"

# Archives

## Full game

ARCHIVE_BASE_0='setup_a_tale_of_paper_1.0_(56083).exe'
ARCHIVE_BASE_0_MD5='8a1acfc78e34a89ce608e275674a829a'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1='setup_a_tale_of_paper_1.0_(56083)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='664731f03da4cffe8a9771d298476cb2'
ARCHIVE_BASE_0_SIZE='4100000'
ARCHIVE_BASE_0_VERSION='1.0-gog56083'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/a_tale_of_paper_refolded'

## Demo

ARCHIVE_BASE_DEMO_0='setup_a_tale_of_paper_demo_1.0_(54424).exe'
ARCHIVE_BASE_DEMO_0_MD5='9c154ee673c94bc896b1b08ac7c6b13b'
ARCHIVE_BASE_DEMO_0_TYPE='innosetup'
ARCHIVE_BASE_DEMO_0_SIZE='930000'
ARCHIVE_BASE_DEMO_0_VERSION='1.0-gog54424'
ARCHIVE_BASE_DEMO_0_URL='https://www.gog.com/game/a_tale_of_paper_demo'

# Archive contents

CONTENT_PATH_DEFAULT='.'

## Full game

UNREALENGINE4_NAME='ataleofpaper'

CONTENT_GAME_BIN_FILES="
engine
${UNREALENGINE4_NAME}/binaries
${UNREALENGINE4_NAME}/plugins
${UNREALENGINE4_NAME}.exe"
CONTENT_GAME_DATA_FILES="
${UNREALENGINE4_NAME}"

## Demo

UNREALENGINE4_NAME_DEMO='prototipo'

CONTENT_GAME_BIN_FILES_DEMO="
engine
${UNREALENGINE4_NAME_DEMO}/binaries
${UNREALENGINE4_NAME_DEMO}/plugins
ataleofpaper.exe"
CONTENT_GAME_DATA_FILES_DEMO="
${UNREALENGINE4_NAME_DEMO}"


WINE_DIRECT3D_RENDERER='dxvk'

WINE_PERSISTENT_DIRECTORIES="
users/\${USER}/AppData/Local/${UNREALENGINE4_NAME}/Saved"
WINE_PERSISTENT_DIRECTORIES_DEMO="
users/\${USER}/AppData/Local/${UNREALENGINE4_NAME_DEMO}/Saved"

APP_MAIN_EXE="${UNREALENGINE4_NAME}.exe"
APP_MAIN_EXE_DEMO='ataleofpaper.exe'
APP_MAIN_ICON_WRESTOOL_OPTIONS='--type=14 --name=101'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_ID_DEMO="${GAME_ID_DEMO}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPS_DEMO="$PKG_DATA_ID_DEMO"
PKG_BIN_DEPENDENCIES_GSTREAMER_PLUGINS='
video/quicktime, variant=(string)iso'

# Install required Microsoft Visual C++ libraries

APP_WINETRICKS="${APP_WINETRICKS:-} vcrun2019"

# Load common functions

target_version='2.23'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
