!{\src2tex{textfont=tt}}
!!****f* ABINIT/rdqps
!! NAME
!! rdqps
!!
!! FUNCTION
!!  Read a _QPS file
!!
!! COPYRIGHT
!!  Copyright (C) 2005-2007 ABINIT group (FBruneval, MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  ns= 1 for unpolarized, 2 for spin-polarized
!!  nb= number of bands considered in the calculation of the screning  
!!  nk= number of irreducible k-points
!!  gwcalctyp= type of GW calculation (see related input variable) 
!!  dtfil= to be descfribed
!!  en(nk,nb,ns)= energies for each k-point, band and spin 
!!  kibz(3,nk)= reduced coordinates of each irreducible k-point
!!
!! OUTPUT
!!  nscf= number of iterations that have been performed (==0 if we start from a KS calculation)  
!!  en_qp(nk,nb,ns)=  QP energies at iteration nscf 
!!  m_lda_to_qp(nb,nb,nk,ns)= matrix giving the decomposition of the QP
!!   wavefunction along the mainfold generated by the KS wavefunctions 
!!   (i.e $ m_lda_to_qp(ib,jb,k,s) := \langle \psi_{ib,k,s}^{KS}| \psi_{jb,k,s}^{QP}\rangle $
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!      screening,sigma
!!
!! CHILDREN
!!      leave_new,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine rdqps(dtfil,gwcalctyp,nk,nb,ns,kibz,nscf,nr,en,en_qp,m_lda_to_qp,rho_p,min_band_proc,max_band_proc,mpi_enreg)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: gwcalctyp,max_band_proc,min_band_proc,nb,nk,nr,ns
 integer,intent(out) :: nscf
 type(MPI_type),intent(in) :: mpi_enreg
 type(datafiles_type),intent(in) :: dtfil
!arrays
 real(dp),intent(in) :: en(nk,min_band_proc:max_band_proc,ns),kibz(3,nk)
 real(dp),intent(inout) :: rho_p(nr,ns)
 real(dp),intent(out) :: en_qp(nk,min_band_proc:max_band_proc,ns)
 complex,intent(out) :: m_lda_to_qp(min_band_proc:max_band_proc,min_band_proc:max_band_proc,nk,ns)

!Local variables-------------------------------
!scalars
 integer,parameter :: unitfile=999
 integer :: ib,ik,isppol,nbmin,nbr,nkr,nsr
 logical :: lfile
 character(len=500) :: message
!arrays
 real(dp) :: k(3)
 real(dp),allocatable :: en_tmp(:)
 complex,allocatable :: mtmp(:,:)

! *************************************************************************

 !initialize with KS eigenelements
 !MG060914 what about changing the name of the array? 
 !         it is a little bit misleading, better to use something like m_ks_to_qp
 m_lda_to_qp(:,:,:,:)=0.
 do ib=min_band_proc,max_band_proc
  m_lda_to_qp(ib,ib,:,:)=1.
 end do
 en_qp(:,:,:)=en(:,:,:)

 !if non self-consistent calculation, exit immediately
 if(gwcalctyp<10) return

 !self-consistency: check files
 write(message,'(a)')' rdqps: looking for '//trim(dtfil%filqps)
 call wrtout(6,message,'COLL')
!MG FIXME It should be written to ab_out, but the automatic test fails
! call wrtout(ab_out,message,'COLL')

 inquire(file=trim(dtfil%filqps),exist=lfile)

 if(.not.(lfile)) then
  write(message,'(4a)')' file not found',ch10,&
& ' 1st iteration initialized with KS eigenelements',ch10
  call wrtout(6,message,'COLL')
!MG FIXME It should be written to ab_out, but the automatic test fails
! call wrtout(ab_out,message,'COLL')
  nscf=0
  return
 else
  open(unit=unitfile,file=trim(dtfil%filqps),form='formatted',status='unknown')
!MG060914 the _QPS file should contain the Abinit header 
  read(unitfile,*) nscf
  write(message,'(a,i4,a)')' iteration(s) already performed: ',nscf,ch10
  call wrtout(6,message,'COLL')
!MG It should be written to ab_out, but the automatic test fails
!  call wrtout(ab_out,message,'COLL')
  read(unitfile,*) nkr
  if(nkr/=nk) then 
   write(message,'(4a)')&
&   ' rdqps: ERROR -',ch10,&
&   ' wrong number of kpoints in ',trim(dtfil%filqps)
   call wrtout(6,message,'COLL')
   call leave_new('COLL')
  end if
  read(unitfile,*) nbr
  nbmin=min(nbr,nb)
  allocate(mtmp(nbr,nbr))
  allocate(en_tmp(nbr))
  read(unitfile,*) nsr

!MG060914 added external loop on spin, anyway the format of the QPS file must be
!standardized !!!
  do isppol=1,ns 
   do ik=1,nk
    write(*,*) 'reading k= ',ik
    read(unitfile,*) k(:)
    write(*,*) k(:)
    if(any(abs(k(:)-kibz(:,ik))>0.001)) then 
     write(message,'(4a)')&
&     ' rdqps: ERROR-  ',ch10,&
&     ' wrong kpoint read in ',trim(dtfil%filqps)
     call wrtout(6,message,'COLL')
     call leave_new('COLL')
    end if 
    do ib=1,nbr
     read(unitfile,*) en_tmp(ib)
     read(unitfile,*) mtmp(:,ib)
    end do !ib
    m_lda_to_qp(1:nbmin,1:nbmin,ik,isppol)=mtmp(1:nbmin,1:nbmin)
    en_qp(ik,1:nbmin,isppol)=en_tmp(1:nbmin)
   end do !ik
  end do !isppol 
  read(unitfile,*) rho_p(:,:)

  deallocate(mtmp,en_tmp)
  close(unitfile)
 end if

end subroutine rdqps
!***
!!***
