!!****m* ABINIT/interfaces_11util
!! NAME
!! interfaces_11util
!!
!! FUNCTION
!! This module contains the interfaces of the routines
!! in the directory src/11util
!!
!! COPYRIGHT
!! Copyright (C) 2005 ABINIT group
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! NOTES
!! THIS FILE IS GENERATED AUTOMATICALLY BY abilint.
!! To do that: abilint . .
!!             (see util/maintainers/abilint.py)
!!
!! SOURCE

module interfaces_11util

 interface
  subroutine appdig(integ,string,strinn)
   integer,intent(in) :: integ
   character(len=*),intent(in) :: string
   character(len=*),intent(out) :: strinn
  end subroutine appdig
 end interface

 interface
  subroutine atmdata(amu,rcov,symbol,znucl)
   use defs_basis
   real(dp),intent(out) :: amu
   real(dp),intent(out) :: rcov
   character(len=2),intent(out) :: symbol
   real(dp),intent(in) :: znucl
  end subroutine atmdata
 end interface

 interface
  subroutine besjm(arg,besjx,cosx,nn,nx,sinx,xx)
   use defs_basis
   integer,intent(in) :: nn
   integer,intent(in) :: nx
   real(dp),intent(in) :: arg
   real(dp),intent(out) :: besjx(nx)
   real(dp),intent(in) :: cosx(nx)
   real(dp),intent(in) :: sinx(nx)
   real(dp),intent(in) :: xx(nx)
  end subroutine besjm
 end interface

 interface
  subroutine calc_psden(ff,mesh,nc,rc,step)
   use defs_basis
   integer,intent(in) :: mesh
   real(dp),intent(in) :: rc
   real(dp),intent(in) :: step
   real(dp),intent(out) :: ff(mesh)
   real(dp),intent(in) :: nc(mesh)
  end subroutine calc_psden
 end interface

 interface
  subroutine calc_psden_log(ff,mmax,nc,rc,rad)
   use defs_basis
   integer,intent(in) :: mmax
   real(dp),intent(in) :: rc
   real(dp),intent(out) :: ff(mmax)
   real(dp),intent(in) :: nc(mmax)
   real(dp),intent(in) :: rad(mmax)
  end subroutine calc_psden_log
 end interface

 interface
  subroutine calc_vhtnzc(nc,rc,vhtnzc,mesh,rad,znucl)
   use defs_basis
   integer,intent(in) :: mesh
   real(dp),intent(inout) :: rc
   real(dp),intent(in) :: znucl
   real(dp),intent(in) :: nc(mesh)
   real(dp),intent(in) :: rad(mesh)
   real(dp),intent(out) :: vhtnzc(mesh)
  end subroutine calc_vhtnzc
 end interface

 interface
  subroutine canon9(num,red,shift)
   use defs_basis
   real(dp),intent(in) :: num
   real(dp),intent(out) :: red
   real(dp),intent(out) :: shift
  end subroutine canon9
 end interface

 interface
  subroutine chknm8(nmxpct,nmfond)
   character(len=9),intent(in) :: nmfond
   character(len=9),intent(in) :: nmxpct
  end subroutine chknm8
 end interface

 interface
  subroutine clsopn(wff)
   use defs_datatypes
   type(wffile_type),intent(inout) :: wff
  end subroutine clsopn
 end interface

 interface
  subroutine compmesh(mesh,r_for_intg)
   use defs_basis
   use defs_datatypes
   type(pawrad_type),intent(inout) :: mesh
   real(dp),intent(in) :: r_for_intg
  end subroutine compmesh
 end interface

 interface
  subroutine copymesh(mesh1,mesh2)
   use defs_datatypes
   type(pawrad_type),intent(in) :: mesh1
   type(pawrad_type),intent(out) :: mesh2
  end subroutine copymesh
 end interface

 interface
  subroutine ctrap(imax,ff,hh,ans)
   use defs_basis
   integer,intent(in) :: imax
   real(dp),intent(out) :: ans
   real(dp),intent(in) :: hh
   real(dp),intent(in) :: ff(imax)
  end subroutine ctrap
 end interface

 interface
  subroutine ctrap_gen(intg,func,radmesh)
   use defs_basis
   use defs_datatypes
   real(dp),intent(out) :: intg
   type(pawrad_type),intent(in) :: radmesh
   real(dp),intent(in) :: func(radmesh%int_meshsz)
  end subroutine ctrap_gen
 end interface

 interface
  subroutine deducer0(func,funcsz,radmesh)
   use defs_basis
   use defs_datatypes
   integer :: funcsz
   type(pawrad_type),intent(in) :: radmesh
   real(dp) :: func(funcsz)
  end subroutine deducer0
 end interface

 interface
  subroutine derf(derf_yy,yy)
   use defs_basis
   real(dp),intent(out) :: derf_yy
   real(dp),intent(in) :: yy
  end subroutine derf
 end interface

 interface
  subroutine derfc(derfc_yy,yy)
   use defs_basis
   real(dp),intent(out) :: derfc_yy
   real(dp),intent(in) :: yy
  end subroutine derfc
 end interface

 interface
  subroutine dtsetCopy(dtout, dtin)
   use defs_datatypes
   type(dataset_type),intent(in) :: dtin
   type(dataset_type),intent(out) :: dtout
  end subroutine dtsetCopy
 end interface

 interface
  subroutine  tells_sizes(chosen_size,name,index,default_size,actual_size)
   integer, intent(in) :: actual_size
   integer, intent(out) :: chosen_size
   integer, intent(in) :: default_size
   integer, intent(in) :: index
   character(len=12),intent(in) :: name
  end subroutine tells_sizes
 end interface

 interface
  subroutine dtsetFree(dtset)
   use defs_datatypes
   type(dataset_type),intent(inout) :: dtset
  end subroutine dtsetFree
 end interface

 interface
  subroutine energies_init(energies)
   use defs_datatypes
   type(energies_type), intent(out) :: energies
  end subroutine energies_init
 end interface

 interface
  function factorial(nn)
   use defs_basis
   integer,intent(in) :: nn
   real(dp) :: factorial
  end function factorial
 end interface

 interface
  subroutine handle_ncerr(ncerr,message)
   integer         ,intent(in) :: ncerr
   character(len=*),intent(in) :: message
  end subroutine handle_ncerr
 end interface

 interface
  subroutine hermit(chmin,chmout,ierr,ndim)
   use defs_basis
   integer,intent(out) :: ierr
   integer,intent(in) :: ndim
   real(dp),intent(in) :: chmin(ndim*ndim+ndim)
   real(dp),intent(out) :: chmout(ndim*ndim+ndim)
  end subroutine hermit
 end interface

 interface
  function ifromr(radmesh,rr)
   use defs_basis
   use defs_datatypes
   integer :: ifromr
   type(pawrad_type),intent(in) :: radmesh
   real(dp),intent(in) :: rr
  end function ifromr
 end interface

 interface
  subroutine int2char(iint,string)
   integer,intent(in) :: iint
   character(len=10),intent(out) :: string
  end subroutine int2char
 end interface

 interface
  subroutine int2char4(iint,string)
   integer,intent(in) :: iint
   character(len=4),intent(out) :: string
  end subroutine int2char4
 end interface

 interface
  subroutine interpol3d(r,nr1,nr2,nr3,denval,grid)
   use defs_basis
   integer,intent(in) :: nr1
   integer,intent(in) :: nr2
   integer,intent(in) :: nr3
   real(dp),intent(out) :: denval
   real(dp),intent(in) :: r(3)
   real(dp),intent(in) :: grid(nr1,nr2,nr3)
  end subroutine interpol3d
 end interface

 interface
  subroutine inupper(string)
   character(len=*),intent(inout) :: string
  end subroutine inupper
 end interface

 interface
  subroutine isfile(filnam,status)
   use defs_basis
   character(len=fnlen),intent(inout) :: filnam
   character(len=3),intent(in) :: status
  end subroutine isfile
 end interface

 interface
  subroutine jbessel(bes,besp,bespp,ll,order,xx)
   use defs_basis
   integer,intent(in) :: ll
   integer,intent(in) :: order
   real(dp),intent(out) :: bes
   real(dp),intent(out) :: besp
   real(dp),intent(out) :: bespp
   real(dp),intent(in) :: xx
  end subroutine jbessel
 end interface

 interface
  subroutine matcginv(a,lda,n)
   integer,intent(in) :: lda
   integer,intent(in) :: n
   complex,intent(inout) :: a(lda,n)
  end subroutine matcginv
 end interface

 interface
  subroutine mati3inv(mm,mit)
   integer,intent(out) :: mit(3,3)
   integer,intent(in) :: mm(3,3)
  end subroutine mati3inv
 end interface

 interface
  subroutine matr3eigval(eigval,matr)
   use defs_basis
   real(dp),intent(out) :: eigval(3)
   real(dp),intent(in) :: matr(3,3)
  end subroutine matr3eigval
 end interface

 interface
  subroutine matr3inv(aa,ait)
   use defs_basis
   real(dp),intent(in) :: aa(3,3)
   real(dp),intent(out) :: ait(3,3)
  end subroutine matr3inv
 end interface

 interface
  subroutine matrginv(a,lda,n)
   use defs_basis
   integer,intent(in) :: lda
   integer,intent(in) :: n
   real(dp),intent(inout) :: a(lda,n)
  end subroutine matrginv
 end interface

 interface
  subroutine mkfilename(filnam,filnam_out,get,idtset,&  
&  ird,jdtset_,ndtset,stringfil,stringvar,will_read)
   use defs_basis
   integer,intent(in) :: get
   integer,intent(in) :: idtset
   integer,intent(in) :: ird
   integer,intent(in) :: ndtset
   integer,intent(out) :: will_read
   character(len=fnlen),intent(out) :: filnam_out
   character(len=4),intent(in) :: stringfil
   character(len=9),intent(in) :: stringvar
   character(len=fnlen),intent(in) :: filnam(5)
   integer,intent(in) :: jdtset_(0:ndtset)
  end subroutine mkfilename
 end interface

 interface
  subroutine mkherm(array,ndim)
   use defs_basis
   integer,intent(in) :: ndim
   real(dp),intent(inout) :: array(2,ndim,ndim)
  end subroutine mkherm
 end interface

 interface
  subroutine mvrecord(ierr,nrec,unitfile)
   integer,intent(out) :: ierr
   integer,intent(in) :: nrec
   integer,intent(in) :: unitfile
  end subroutine mvrecord
 end interface

 interface
  subroutine nderiv(hh,yy,zz,ndim,norder)
   use defs_basis
   integer,intent(in) :: ndim
   integer,intent(in) :: norder
   real(dp),intent(in) :: hh
   real(dp),intent(in) :: yy(ndim)
   real(dp),intent(out) :: zz(ndim)
  end subroutine nderiv
 end interface

 interface
  subroutine nderiv_gen(der,func,nder,radmesh)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: nder
   type(pawrad_type),intent(in) :: radmesh
   real(dp),intent(out) :: der(radmesh%mesh_size,nder)
   real(dp),intent(in) :: func(radmesh%mesh_size)
  end subroutine nderiv_gen
 end interface

 interface
  subroutine normev(evec,ndim,num)
   use defs_basis
   integer,intent(in) :: ndim
   integer,intent(in) :: num
   real(dp),intent(inout) :: evec(2*ndim,num)
  end subroutine normev
 end interface

 interface
  subroutine pl_deriv(mpsang,pl_d2,xx)
   use defs_basis
   integer,intent(in) :: mpsang
   real(dp),intent(in) :: xx
   real(dp),intent(out) :: pl_d2(mpsang)
  end subroutine pl_deriv
 end interface

 interface
  subroutine plm_coeff(blm,mpsang,xx)
   use defs_basis
   integer,intent(in) :: mpsang
   real(dp),intent(in) :: xx
   real(dp),intent(out) :: blm(5,mpsang*mpsang)
  end subroutine plm_coeff
 end interface

 interface
  subroutine plm_d2theta(mpsang,plm_d2t,xx)
   use defs_basis
   integer,intent(in) :: mpsang
   real(dp),intent(in) :: xx
   real(dp),intent(out) :: plm_d2t(mpsang*mpsang)
  end subroutine plm_d2theta
 end interface

 interface
  function plm_dphi(ll,mm,xx)
   use defs_basis
   integer,intent(in) :: ll
   integer,intent(in) :: mm
   real(dp) :: plm_dphi
   real(dp),intent(in) :: xx
  end function plm_dphi
 end interface

 interface
  function plm_dtheta(ll,mm,xx)
   use defs_basis
   integer,intent(in) :: ll
   integer,intent(in) :: mm
   real(dp) :: plm_dtheta
   real(dp),intent(in) :: xx
  end function plm_dtheta
 end interface

 interface
  subroutine poisson(den,ll,qq,radmesh,rv)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: ll
   real(dp),intent(out) :: qq
   type(pawrad_type),intent(in) :: radmesh
   real(dp),intent(in) :: den(radmesh%mesh_size)
   real(dp),intent(out) :: rv(radmesh%mesh_size)
  end subroutine poisson
 end interface

 interface
  subroutine print_ij(a_ij,adim,ndim,opt_io,opt_l,opt_l_index,opt_pack,pack2ij,test_value,unt)
   use defs_basis
   integer,intent(in) :: adim
   integer,intent(in) :: ndim
   integer,intent(in) :: opt_io
   integer,intent(in) :: opt_l
   integer,intent(in) :: opt_pack
   integer,intent(in) :: unt
   real(dp),intent(in) :: test_value
   real(dp),intent(in) :: a_ij(adim)
   integer,intent(in) :: opt_l_index(ndim*min(1+opt_l,1))
   integer,intent(in) :: pack2ij(adim*opt_pack)
  end subroutine print_ij
 end interface

 interface
  subroutine prmat (mat, ni, nj, mi)
   use defs_basis
   integer,intent(in) :: mi
   integer,intent(in) :: ni
   integer,intent(in) :: nj
   real(dp),intent(in) :: mat(mi,nj)
  end subroutine prmat
 end interface

 interface
  subroutine simp_gen(intg,func,radmesh)
   use defs_basis
   use defs_datatypes
   real(dp),intent(out) :: intg
   type(pawrad_type),intent(in) :: radmesh
   real(dp),intent(in) :: func(radmesh%int_meshsz)
  end subroutine simp_gen
 end interface

 interface
  subroutine status(counter,filstat,istatr,level,routine)
   use defs_basis
   integer,intent(in) :: counter
   integer,intent(in) :: istatr
   integer,intent(in) :: level
   character(len=fnlen),intent(in) :: filstat
   character(len=*),intent(in) :: routine
  end subroutine status
 end interface

 interface
  function ylmc(il,im,kcart)
   use defs_basis
   integer,intent(in) :: il
   integer,intent(in) :: im
   complex(dpc) :: ylmc
   real(dp),intent(in) :: kcart(3)
  end function ylmc
 end interface

 interface
  subroutine ylmcd(il,im,kcart,dth,dphi)
   use defs_basis
   integer,intent(in) :: il
   integer,intent(in) :: im
   complex(dpc),intent(out) :: dphi
   complex(dpc),intent(out) :: dth
   real(dp),intent(in) :: kcart(3)
  end subroutine ylmcd
 end interface

end module interfaces_11util
!!***
