      SUBROUTINE SETUPS(ICORE,ICRSIZ,I010,I020,I030,I040,I050,LISTW1,
     &                  LISTW2,LISTT1,LISTT2,NWDIS,NWDSZ,NT2DIS,
     &                  NT2DSZ)
C
C THIS ROUTINE RETURNS THE SYMMETRY INFORMATION ABOUT THE LISTS
C   ON MOIO(LISTT1,LISTT2) AND MOIO(LISTW1,LISTW2), ALONG WITH
C   OFFSETS INTO THE CORE ARRAY WHERE THESE LISTS BEGIN.
C
C       ICORE - CORE VECTOR (PASSED IN)
C       ICRSIZ- SIZE OF WORKING AREA.
C       I010  - OFFSET TO BEGINNING OF THE POPULATION COUNT VECTOR FOR
C                THE MOIO(LISTW1,LISTW2) LIST.
C       I020  - OFFSET TO BEGINNING OF THE SYMMETRY VECTOR FOR
C                THE MOIO(LISTW1,LISTW2) LIST.
C       I030  - OFFSET TO BEGINNING OF THE POPULATION COUNT VECTOR FOR
C                THE MOIO(LISTT1,LISTT2) LIST.
C       I040  - OFFSET TO BEGINNING OF THE SYMMETRY VECTOR FOR
C                THE MOIO(LISTT1,LISTT2) LIST.
C       I050  - TOTAL CORE REQUIRED FOR SYMMETRY INFORMATION.
C       LISTT1- "SPIN CASE" FOR THE T LIST.
C       LISTT2- LIST TYPE FOR T LIST.
C       LISTW1- "SPIN CASE" FOR THE W LIST.
C       LISTW2- LIST TYPE FOR THE W LIST.
C       NWDIS - TOTAL NUMBER OF W DISTRIBUTIONS (IN C1).
C       NWDSZ - SIZE OF W DISTRIBUTIONS (IN C1).
C       NT2DIS- TOTAL NUMBER OF T DISTRIBUTIONS (IN C1).
C       NT2DSZ- SIZE OF T DISTRIBUTIONS (IN C1).
C
CEND
      IMPLICIT INTEGER (A-Z)
      DIMENSION DISTYP(18,8),ICORE(ICRSIZ)
      COMMON /SYMINF/ NSTART,NIRREP,IRREPA(255),IRREPB(255),
     &DIRPRD(8,8)
      DATA DISTYP /3,3,4,4,14,14,0,0,0,0,0,0,0,0,0,0,0,0,
     &            3,16,4,17,14,11,14,18,0,0,0,0,0,0,0,0,0,0,
     &            1,3,2,4,13,14,10,9,9,10,9,9,10,10,11,12,0,0,
     &            9,9,10,10,11,11,12,12,0,0,0,0,0,0,0,0,0,0,
     &            1,9,2,10,13,18,13,11,0,0,0,0,0,0,0,0,0,0,
     &            1,1,2,2,13,13,0,0,0,0,0,0,0,0,0,0,0,0,
     &            1,3,2,4,13,14,9,9,10,10,10,9,9,10,12,11,11,12,
     &            1,3,2,4,13,14,9,9,10,10,10,9,9,10,12,11,11,12/
      IPOS(I)=2*(I-1)+1
      WDSTPL=DISTYP(IPOS(LISTW1),LISTW2)
      WDSTPR=DISTYP(IPOS(LISTW1)+1,LISTW2)
      TDSTPL=DISTYP(IPOS(LISTT1),LISTT2)
      TDSTPR=DISTYP(IPOS(LISTT1)+1,LISTT2)
      I010=1
      I020=I010+2*NIRREP
      I030=I020+NWDIS+NWDSZ
      I040=I030+2*NIRREP
      I050=I040+NT2DIS+NT2DSZ
      IF(MOD(I050,2).EQ.0)I050=I050+1
C
C INTEGRAL POINTERS.
C
      CALL GETGSV(WDSTPL,NWDSZ,WDSTPR,NWDIS,NIRREP,
     &             ICORE(I010),ICORE(I020))
C
C T2 AMPLITUDE POINTERS.
C
      CALL GETGSV(TDSTPL,NT2DSZ,TDSTPR,NT2DIS,NIRREP,
     &             ICORE(I030),ICORE(I040))
      RETURN
      END
