/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:36:31 GMT 2018
 */

package uk.ac.sanger.artemis.sequence;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.SequenceChangeEvent;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class SequenceChangeEvent_ESTest extends SequenceChangeEvent_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Range range0 = new Range(0);
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(0, 0, range0);
      int int0 = sequenceChangeEvent0.getType();
      assertEquals(0, sequenceChangeEvent0.getPosition());
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("All SymbolLists must be the same length: ");
      Bases bases0 = new Bases(genbankStreamSequence0);
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, (-5), (Range) null, 1);
      int int0 = sequenceChangeEvent0.getType();
      assertEquals(1, sequenceChangeEvent0.getLength());
      assertEquals((-5), int0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      Range range0 = new Range(0);
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(0, 0, range0);
      sequenceChangeEvent0.getSubSequence();
      assertEquals(0, sequenceChangeEvent0.getType());
      assertEquals(0, sequenceChangeEvent0.getPosition());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, 1, 1, "2uW#Jz=K{}");
      sequenceChangeEvent0.getSubSequence();
      assertEquals(1, sequenceChangeEvent0.getPosition());
      assertEquals(1, sequenceChangeEvent0.getType());
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, 1, 1, "2uW#Jz=K{}");
      sequenceChangeEvent0.getRange();
      assertEquals(1, sequenceChangeEvent0.getPosition());
      assertEquals(1, sequenceChangeEvent0.getType());
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      Range range0 = new Range(3278, 3278);
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(3278, 3278, range0);
      sequenceChangeEvent0.getRange();
      assertEquals(3278, sequenceChangeEvent0.getType());
      assertEquals(3278, sequenceChangeEvent0.getPosition());
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Range range0 = new Range((-2898), 71);
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, (-1780), range0, (byte) (-71));
      sequenceChangeEvent0.getRange();
      assertEquals((-71), sequenceChangeEvent0.getLength());
      assertEquals((-1780), sequenceChangeEvent0.getType());
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      Range range0 = new Range((-4935), (-4935));
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent((-4935), (-4935), range0);
      sequenceChangeEvent0.getRange();
      assertEquals((-4935), sequenceChangeEvent0.getType());
      assertEquals((-4935), sequenceChangeEvent0.getPosition());
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("getCvTermsByCvName LOADING CVTERMS");
      Bases bases0 = new Bases(genbankStreamSequence0);
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, 2, 0, "getCvTermsByCvName LOADING CVTERMS");
      int int0 = sequenceChangeEvent0.getPosition();
      assertEquals(0, int0);
      assertEquals(2, sequenceChangeEvent0.getType());
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, 1, 1, "2uW#Jz=K{}");
      int int0 = sequenceChangeEvent0.getPosition();
      assertEquals(1, sequenceChangeEvent0.getType());
      assertEquals(1, int0);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      Range range0 = new Range(0);
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(0, 0, range0);
      int int0 = sequenceChangeEvent0.getLength();
      assertEquals(0, int0);
      assertEquals(0, sequenceChangeEvent0.getType());
      assertEquals(0, sequenceChangeEvent0.getPosition());
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("All SymbolLists must be the same length: ");
      Bases bases0 = new Bases(genbankStreamSequence0);
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, (-5), (Range) null, 1);
      int int0 = sequenceChangeEvent0.getLength();
      assertEquals((-5), sequenceChangeEvent0.getType());
      assertEquals(1, int0);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      Range range0 = new Range(3278);
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(3278, 3278, range0);
      // Undeclared exception!
      try { 
        sequenceChangeEvent0.getBases();
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // uk.ac.sanger.artemis.io.Range cannot be cast to uk.ac.sanger.artemis.sequence.Bases
         //
         verifyException("uk.ac.sanger.artemis.sequence.SequenceChangeEvent", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      SequenceChangeEvent sequenceChangeEvent0 = null;
      try {
        sequenceChangeEvent0 = new SequenceChangeEvent((Bases) null, 0, (Range) null, (-1));
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // null source
         //
         verifyException("java.util.EventObject", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      SequenceChangeEvent sequenceChangeEvent0 = null;
      try {
        sequenceChangeEvent0 = new SequenceChangeEvent((Bases) null, 0, 5, (String) null);
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // null source
         //
         verifyException("java.util.EventObject", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      SequenceChangeEvent sequenceChangeEvent0 = null;
      try {
        sequenceChangeEvent0 = new SequenceChangeEvent((Bases) null, (-601));
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // null source
         //
         verifyException("java.util.EventObject", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      SequenceChangeEvent sequenceChangeEvent0 = null;
      try {
        sequenceChangeEvent0 = new SequenceChangeEvent(0, 0, (Range) null);
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // null source
         //
         verifyException("java.util.EventObject", e);
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Range range0 = new Range((-2898), 71);
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, (-1780), range0, (byte) (-71));
      int int0 = sequenceChangeEvent0.getLength();
      assertEquals((-1780), sequenceChangeEvent0.getType());
      assertEquals((-71), int0);
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      Range range0 = new Range((-57));
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(424, (-1652), range0);
      int int0 = sequenceChangeEvent0.getPosition();
      assertEquals((-1652), int0);
      assertEquals(424, sequenceChangeEvent0.getType());
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Range range0 = new Range((-2898), 71);
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, (-1780), range0, (byte) (-71));
      sequenceChangeEvent0.getBases();
      assertEquals((-71), sequenceChangeEvent0.getLength());
      assertEquals((-1780), sequenceChangeEvent0.getType());
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      Range range0 = new Range(0, 0);
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(0, 0, range0);
      sequenceChangeEvent0.getRange();
      assertEquals(0, sequenceChangeEvent0.getPosition());
      assertEquals(0, sequenceChangeEvent0.getType());
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, 0, 823, "");
      sequenceChangeEvent0.getSubSequence();
      assertEquals(823, sequenceChangeEvent0.getPosition());
      assertEquals(0, sequenceChangeEvent0.getType());
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("}80tHIH7'X");
      Bases bases0 = new Bases(genbankStreamSequence0);
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, 57);
      int int0 = sequenceChangeEvent0.getType();
      assertEquals(0, sequenceChangeEvent0.getPosition());
      assertEquals(57, int0);
  }
}
