/* gcc.c -
 *
 ****************************************************************
 * Copyright (C) 1999 Tom Lord
 * 
 * See the file "COPYING.PIW" for further information about
 * the copyright and warranty status of this work.
 */


/* This #include is for compile-time error checking.
 */

#define PIW_NO_ATTRIBUTES
#define PIW_CHECK_WRITES
#define PIW_LOG_WRITES
#define PIW_WATCHPOINTS
#include "hackerlab/piw-malloc/piw-write-barriers.h"




#if 0


/*(h1 "GCC Features for Write Barriers")
 * 
 * Write barriers effect all expressions which modify memory.  The
 * l-value subexpression of any such expression is implicitly replaced
 * by an expression of the form:
 * 
 *    *(typeof (l_value) *)
 *      __user_supplied_write_barrier ((void *)&l-value, sizeof (l-value))
 * 
 * as in this example,
 * 
 *   {
 *     int x;
 *     x = 10;
 *   }
 * 
 * which becomes
 * 
 *   {
 *     int x;
 *     *(int *)__user_supplied_write_barrier ((void *)&x, sizeof (x)) = 10;
 *   }
 * 
 * 
 * and this example:
 * 
 *   {
 *     long x;
 *     ++x;
 *   }
 * 
 * which becomes
 * 
 *   {
 *     int x;
 *     ++(*(int *)__user_supplied_write_barrier ((void *)&x, sizeof (x)));
 *   }
 * 
 * 
 * As the name suggests, `__user_supplied_write_barrier' is a function
 * that your program must provide.  It may be an ordinary function or
 * an in-line function.  PIW includes in-line functions for this
 * purpose; they are described in the next section.
 * 
 */
/*(menu)
 */

/*(h2 "-fwrite-barriers")
 * 
 * Write barriers can be imposed on an entire module by using the
 * compiler flag `-fwrite-barrier' when compiling that module:
 * 
 *   % gcc -fwrite-barrier -c sed.c
 */

/*(h2 "The write_barrier and no_write_barrier Attributes")
 * 
 * Function attributes can be used to impose a write barrier on a
 * specific function or to guarantee that a write barrier is not
 * imposed:
 * 
 insert*/

/* This function will be compiled without a write
 * barrier, regardless of the "-fwrite-barrier" flag.
 *
 * We use this attribute for __user_supplied_write_barrier
 * to prevent an undesired recursion.
 */
static __inline__ int __attribute__((no_write_barrier))
__user_supplied_write_barrier (void * addr, int length)
{
  ...
}

/* This function will be compiled with a write
 * barrier, even if the "-fwrite-barrier" flag
 * is not used.
 */
void __attribute__((write_barrier))
this_fn (void)
{
  ...
}
/*end-insert
 */

/*(h2 "Spurious Compiler Warnings")
 * 
 * Compiling with write barriers can generate extra warnings, which
 * may be safely disregarded.  In particular, an assignment to a
 * register variable will implicitly cause the address of that
 * variable to be taken -- which generates a warning.
 * 
 */

#endif
