/*
 * Copyright (c) 2007, Olof Naessen and Per Larsson
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 *
 *    * Redistributions of source code must retain the above copyright notice, 
 *      this list of conditions and the following disclaimer.
 *    * Redistributions in binary form must reproduce the above copyright notice, 
 *      this list of conditions and the following disclaimer in the documentation 
 *      and/or other materials provided with the distribution.
 *    * Neither the name of the Darkbits nor the names of its contributors may be 
 *      used to endorse or promote products derived from this software without 
 *      specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef BALLZ_DOORBUTTONTILE_HPP
#define BALLZ_DOORBUTTONTILE_HPP

#include <allegro.h>
#include <string>
#include <vector>
#include "doortile.hpp"

#include "animatedtile.hpp"

class DoorButtonTile: public AnimatedTile
{
public:
    DoorButtonTile(int x, int y, std::string filename);
	DoorButtonTile(int x, int y, BITMAP *animation);
    ~DoorButtonTile();
    bool isSolid() { return false; }
    void logic();
    void draw(BITMAP* dest, int frame, int scroll);
    void setPressed(bool pressed) { mPressed = pressed; }
    bool isPressed() { return mPressed; }
    void addDoorTile(DoorTile* doorTile) { mDoors.push_back(doorTile); }
    void collision(Level* level, Ball* ball);

protected:
    bool mPressed;
    std::vector<DoorTile*> mDoors;
    bool mCollisionThisFrame;
    bool mDoorClosed;
};
#endif
