{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetInitialDestination: TVector4;
    procedure SetInitialDestination(const Value: TVector4);
    function GetInitialValue: TVector4;
    procedure SetInitialValue(const Value: TVector4);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FEventSet_destination: TSFRotationEvent;
    {  }
    public property EventSet_destination: TSFRotationEvent read FEventSet_destination;

    strict private FEventSet_value: TSFRotationEvent;
    {  }
    public property EventSet_value: TSFRotationEvent read FEventSet_value;

    strict private FEventValue_changed: TSFRotationEvent;
    {  }
    public property EventValue_changed: TSFRotationEvent read FEventValue_changed;

    strict private FFdInitialDestination: TSFRotation;
    { Internal wrapper for property @code(InitialDestination). This wrapper API may change, we advise to access simpler @code(InitialDestination) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdInitialDestination: TSFRotation read FFdInitialDestination;
    {  }
    property InitialDestination: TVector4 read GetInitialDestination write SetInitialDestination;

    strict private FFdInitialValue: TSFRotation;
    { Internal wrapper for property @code(InitialValue). This wrapper API may change, we advise to access simpler @code(InitialValue) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdInitialValue: TSFRotation read FFdInitialValue;
    {  }
    property InitialValue: TVector4 read GetInitialValue write SetInitialValue;

{$endif read_interface}

{$ifdef read_implementation}

{ TOrientationDamperNode ----------------------------------------------- }

function TOrientationDamperNode.GetInitialDestination: TVector4;
begin
  Result := FdInitialDestination.Value;
end;

procedure TOrientationDamperNode.SetInitialDestination(const Value: TVector4);
begin
  FdInitialDestination.Send(Value);
end;

function TOrientationDamperNode.GetInitialValue: TVector4;
begin
  Result := FdInitialValue.Value;
end;

procedure TOrientationDamperNode.SetInitialValue(const Value: TVector4);
begin
  FdInitialValue.Send(Value);
end;

class function TOrientationDamperNode.ClassX3DType: String;
begin
  Result := 'OrientationDamper';
end;

procedure TOrientationDamperNode.CreateNode;
begin
  inherited;

  FEventSet_destination := TSFRotationEvent.Create(Self, 'set_destination', true);
  AddEvent(FEventSet_destination);

  FEventSet_value := TSFRotationEvent.Create(Self, 'set_value', true);
  AddEvent(FEventSet_value);

  FEventValue_changed := TSFRotationEvent.Create(Self, 'value_changed', false);
  AddEvent(FEventValue_changed);

  FFdInitialDestination := TSFRotation.Create(Self, False, 'initialDestination', Vector3(0, 1, 0), 0);
   FdInitialDestination.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdInitialDestination);

  FFdInitialValue := TSFRotation.Create(Self, False, 'initialValue', Vector3(0, 1, 0), 0);
   FdInitialValue.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdInitialValue);
end;

{$endif read_implementation}
