/* type1Encoding.h
 * Default encoding of type 1 fonts used for Type 1 import
 *
 * Copyright (C) 1995-2014 by Cenon GmbH
 * Author: Georg Fleischmann
 *
 * Created:  1995-07-30
 * Modified: 2004-12-13
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Cenon Public License as
 * published by Cenon GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Cenon Public License for more details.
 *
 * You should have received a copy of the Cenon Public License along
 * with this program; see the file LICENSE. If not, write to Cenon.
 *
 * Cenon GmbH, Schwabstr. 45, 72108 Rottenburg a.N., Germany
 * eMail: info@Cenon.com
 * http://www.Cenon.de
 */

#ifndef CEN_H_TYPE1ENCODING
#define CEN_H_TYPE1ENCODING

#include "Type1Font.h"

/* standard encoding vectors */
#define StandardEncodingCnt 224
static Encoding standardEncoding[] = {{".notdef", 0}, {"A", 0101}, {"AE", 0341}, {"Aacute", 0202}, {"Acircumflex", 0203}, {"Adieresis", 0205}, {"Agrave", 0201}, {"Aring", 0206}, {"Atilde", 0204}, {"B", 0102}, {"C", 0103}, {"Ccedilla", 0207}, {"D", 0104}, {"E", 0105}, {"Eacute", 0211}, {"Ecircumflex", 0212}, {"Edieresis", 0213}, {"Egrave", 0210}, {"Eth", 0220}, {"F", 0106}, {"G", 0107}, {"H", 0110}, {"I", 0111}, {"Iacute", 0215}, {"Icircumflex", 0216}, {"Idieresis", 0217}, {"Igrave", 0214}, {"J", 0112}, {"K", 0113}, {"L", 0114}, {"Lslash", 0350}, {"M", 0115}, {"N", 0116}, {"Ntilde", 0221}, {"O", 0117}, {"OE", 0352}, {"Oacute", 0223}, {"Ocircumflex", 0224}, {"Odieresis", 0226}, {"Ograve", 0222}, {"Oslash", 0351}, {"Otilde", 0225}, {"P", 0120}, {"Q", 0121}, {"R", 0122}, {"S", 0123}, {"Scaron", 0200}, {"T", 0124}, {"Thorn", 0234}, {"U", 0125}, {"Uacute", 0230}, {"Ucircumflex", 0231}, {"Udieresis", 0232}, {"Ugrave", 0227}, {"V", 0126}, {"W", 0127}, {"X", 0130}, {"Y", 0131}, {"Yacute", 0233}, {"Ydieresis", 0177}, {"Z", 0132}, {"a", 0141}, {"aacute", 0326}, {"acircumflex", 0327}, {"acute", 0302}, {"adieresis", 0331}, {"ae", 0361}, {"agrave", 0325}, {"ampersand", 0046}, {"aring", 0332}, {"asciicircum", 0136}, {"asciitilde", 0176}, {"asterisk", 0052}, {"at", 0100}, {"atilde", 0330}, {"b", 0142}, {"backslash", 0134}, {"bar", 0174}, {"braceleft", 0173}, {"braceright", 0175}, {"bracketleft", 0133}, {"bracketright", 0135}, {"breve", 0306}, {"brokenbar", 0265}, {"bullet", 0267}, {"c", 0143}, {"caron", 0317}, {"ccedilla", 0333}, {"cedilla", 0313}, {"cent", 0242}, {"circumflex", 0303}, {"colon", 0072}, {"comma", 0054}, {"copyright", 0240}, {"currency", 0250}, {"d", 0144}, {"dagger", 0262}, {"daggerdbl", 0263}, {"dieresis", 0310}, {"divide", 0237}, {"dollar", 0044}, {"dotaccent", 0307}, {"dotlessi", 0365}, {"e", 0145}, {"eacute", 0335}, {"ecircumflex", 0336}, {"edieresis", 0337}, {"egrave", 0334}, {"eight", 0070}, {"ellipsis", 0274}, {"emdash", 0320}, {"endash", 0261}, {"equal", 0075}, {"eth", 0346}, {"exclam", 0041}, {"exclamdown", 0241}, {"f", 0146}, {"fi", 0256}, {"five", 0065}, {"fl", 0257}, {"florin", 0246}, {"four", 0064}, {"fraction", 0244}, {"g", 0147}, {"germandbls", 0373}, {"grave", 0301}, {"greater", 0076}, {"guillemotleft", 0253}, {"guillemotright", 0273}, {"guilsinglleft", 0254}, {"guilsinglright", 0255}, {"h", 0150}, {"hungarumlaut", 0315}, {"hyphen", 0055}, {"i", 0151}, {"iacute", 0342}, {"icircumflex", 0344}, {"idieresis", 0345}, {"igrave", 0340}, {"j", 0152}, {"k", 0153}, {"l", 0154}, {"less", 0074}, {"logicalnot", 0376}, {"lslash", 0370}, {"m", 0155}, {"macron", 0305}, {"mu", 0235}, {"multiply", 0236}, {"n", 0156}, {"nine", 0071}, {"ntilde", 0347}, {"numbersign", 0043}, {"o", 0157}, {"oacute", 0355}, {"ocircumflex", 0356}, {"odieresis", 0360}, {"oe", 0372}, {"ogonek", 0316}, {"ograve", 0354}, {"one", 0061}, {"onehalf", 0323}, {"onequarter", 0322}, {"onesuperior", 0300}, {"ordfeminine", 0343}, {"ordmasculine", 0353}, {"oslash", 0371}, {"otilde", 0357}, {"p", 0160}, {"paragraph", 0266}, {"parenleft", 0050}, {"parenright", 0051}, {"percent", 0045}, {"period", 0056}, {"periodcentered", 0264}, {"perthousand", 0275}, {"plus", 0053}, {"plusminus", 0321}, {"q", 0161}, {"question", 0077}, {"questiondown", 0277}, {"quotedbl", 0042}, {"quotedblbase", 0271}, {"quotedblleft", 0252}, {"quotedblright", 0272}, {"quoteleft", 0140}, {"quoteright", 0047}, {"quotesinglbase", 0270}, {"quotesingle", 0251}, {"r", 0162}, {"registered", 0260}, {"ring", 0312}, {"s", 0163}, {"scaron", 0276}, {"section", 0247}, {"semicolon", 0073}, {"seven", 0067}, {"six", 0066}, {"slash", 0057}, {"space", 0040}, {"sterling", 0243}, {"t", 0164}, {"thorn", 0374}, {"three", 0063}, {"threequarters", 0324}, {"threesuperior", 0314}, {"tilde", 0304}, {"two", 0062}, {"twosuperior", 0311}, {"u", 0165}, {"uacute", 0363}, {"ucircumflex", 0364}, {"udieresis", 0366}, {"ugrave", 0362}, {"underscore", 0137}, {"v", 0166}, {"w", 0167}, {"x", 0170}, {"y", 0171}, {"yacute", 0367}, {"ydieresis", 0375}, {"yen", 0245}, {"z", 0172}, {"zero", 0060}};

#if 0
#define StandardEncodingCnt 222
static Encoding standardEncoding[] = {{".notdef", 0}, {"A", 0101}, {"AE", 0341}, {"Aacute", 0202}, {"Acircumflex", 0203}, {"Adieresis", 0205}, {"Agrave", 0201}, {"Aring", 0206}, {"Atilde", 0204}, {"B", 0102}, {"C", 0103}, {"Ccedilla", 0207}, {"D", 0104}, {"E", 0105}, {"Eacute", 0211}, {"Ecircumflex", 0212}, {"Edieresis", 0213}, {"Egrave", 0210}, {"Eth", 0220}, {"F", 0106}, {"G", 0107}, {"H", 0110}, {"I", 0111}, {"Iacute", 0215}, {"Icircumflex", 0216}, {"Idieresis", 0217}, {"Igrave", 0214}, {"J", 0112}, {"K", 0113}, {"L", 0114}, {"Lslash", 0350}, {"M", 0115}, {"N", 0116}, {"Ntilde", 0221}, {"O", 0117}, {"OE", 0352}, {"Oacute", 0223}, {"Ocircumflex", 0224}, {"Odieresis", 0226}, {"Ograve", 0222}, {"Oslash", 0351}, {"Otilde", 0225}, {"P", 0120}, {"Q", 0121}, {"R", 0122}, {"S", 0123}, {"T", 0124}, {"Thorn", 0234}, {"U", 0125}, {"Uacute", 0230}, {"Ucircumflex", 0231}, {"Udieresis", 0232}, {"Ugrave", 0227}, {"V", 0126}, {"W", 0127}, {"X", 0130}, {"Y", 0131}, {"Yacute", 0233}, {"Z", 0132}, {"a", 0141}, {"aacute", 0326}, {"acircumflex", 0327}, {"acute", 0302}, {"adieresis", 0331}, {"ae", 0361}, {"agrave", 0325}, {"ampersand", 0046}, {"aring", 0332}, {"asciicircum", 0136}, {"asciitilde", 0176}, {"asterisk", 0052}, {"at", 0100}, {"atilde", 0330}, {"b", 0142}, {"backslash", 0134}, {"bar", 0174}, {"braceleft", 0173}, {"braceright", 0175}, {"bracketleft", 0133}, {"bracketright", 0135}, {"breve", 0306}, {"bullet", 0267}, {"c", 0143}, {"caron", 0317}, {"ccedilla", 0333}, {"cedilla", 0313}, {"cent", 0242}, {"circumflex", 0303}, {"colon", 0072}, {"comma", 0054}, {"copyright", 0240}, {"currency", 0250}, {"d", 0144}, {"dagger", 0262}, {"daggerdbl", 0263}, {"degree", 0312}, {"dieresis", 0310}, {"divide", 0237}, {"dollar", 0044}, {"dotaccent", 0307}, {"dotlessi", 0365}, {"e", 0145}, {"eacute", 0335}, {"ecircumflex", 0336}, {"edieresis", 0337}, {"egrave", 0334}, {"eight", 0070}, {"ellipsis", 0274}, {"emdash", 0320}, {"endash", 0261}, {"equal", 0075}, {"eth", 0346}, {"exclam", 0041}, {"exclamdown", 0241}, {"f", 0146}, {"fi", 0256}, {"five", 0065}, {"fl", 0257}, {"florin", 0246}, {"four", 0064}, {"fraction", 0244}, {"g", 0147}, {"germandbls", 0373}, {"grave", 0301}, {"greater", 0076}, {"guillemotleft", 0253}, {"guillemotright", 0273}, {"guilsinglleft", 0254}, {"guilsinglright", 0255}, {"h", 0150}, {"hungarumlaut", 0315}, {"hyphen", 0055}, {"i", 0151}, {"iacute", 0342}, {"icircumflex", 0344}, {"idieresis", 0345}, {"igrave", 0340}, {"j", 0152}, {"k", 0153}, {"l", 0154}, {"less", 0074}, {"logicalnot", 0376}, {"lslash", 0370}, {"m", 0155}, {"macron", 0305}, {"minus", 0055}, {"mu", 0235}, {"multiply", 0236}, {"n", 0156}, {"nine", 0071}, {"ntilde", 0347}, {"numbersign", 0043}, {"o", 0157}, {"oacute", 0355}, {"ocircumflex", 0356}, {"odieresis", 0360}, {"oe", 0372}, {"ogonek", 0236}, {"ograve", 0354}, {"one", 0061}, {"onehalf", 0323}, {"onequarter", 0322}, {"onesuperior", 0300}, {"ordfeminine", 0343}, {"ordmasculine", 0353}, {"oslash", 0371}, {"otilde", 0357}, {"p", 0160}, {"paragraph", 0266}, {"parenleft", 0050}, {"parenright", 0051}, {"percent", 0045}, {"period", 0056}, {"periodcentered", 0264}, {"perthousand", 0275}, {"plus", 0053}, {"plusminus", 0321}, {"q", 0161}, {"question", 0077}, {"questiondown", 0277}, {"quotedbl", 0042}, {"quotedblbase", 0271}, {"quotedblleft", 0252}, {"quotedblright", 0272}, {"quoteleft", 0140}, {"quoteright", 0047}, {"quotesinglbase", 0270}, {"quotesingle", 0251}, {"r", 0162}, {"registered", 0260}, {"ring", 0312}, {"s", 0163}, {"section", 0247}, {"semicolon", 0073}, {"seven", 0067}, {"six", 0066}, {"slash", 0057}, {"space", 0040}, {"sterling", 0243}, {"t", 0164}, {"thorn", 0374}, {"three", 0063}, {"threequarters", 0324}, {"threesuperior", 0314}, {"tilde", 0304}, {"two", 0062}, {"twosuperior", 0311}, {"u", 0165}, {"uacute", 0363}, {"ucircumflex", 0364}, {"udieresis", 0366}, {"ugrave", 0362}, {"underscore", 0137}, {"v", 0166}, {"w", 0167}, {"x", 0170}, {"y", 0171}, {"yacute", 0367}, {"ydieresis", 0375}, {"yen", 0245}, {"z", 0172}, {"zero", 0060}};
#endif

#define IsoLatin1EncodingCnt 201
static Encoding isoLatin1Encoding[] = {{"A", 0101}, {"AE", 0306}, {"Aacute", 0301}, {"Acircumflex", 0302}, {"Adieresis", 0304}, {"Agrave", 0300}, {"Aring", 0305}, {"Atilde", 0303}, {"B", 0102}, {"C", 0103}, {"Ccedilla", 0307}, {"D", 0104}, {"E", 0105}, {"Eacute", 0311}, {"Ecircumflex", 312}, {"Edieresis", 0313}, {"Egrave", 0310}, {"Eth", 0320}, {"F", 0106}, {"G", 0107}, {"H", 0110}, {"I", 0111}, {"Iacute", 0315}, {"Icircumflex", 0316}, {"Idieresis", 0317}, {"Igrave", 0314}, {"J", 0112}, {"K", 0113}, {"L", 0114}, {"M", 0115}, {"N", 0116}, {"Ntilde", 0321}, {"O", 0117}, {"Oacute", 0323}, {"Ocircumflex", 0324}, {"Odieresis", 0326}, {"Ograve", 0322}, {"Oslash", 0330}, {"Otilde", 0325}, {"P", 0120}, {"Q", 0121}, {"R", 0122}, {"S", 0123}, {"T", 0124}, {"Thorn", 0336}, {"U", 0125}, {"Uacute", 0332}, {"Ucircumflex", 0333}, {"Udieresis", 0334}, {"Ugrave", 0331}, {"V", 0126}, {"W", 0127}, {"X", 0130}, {"Y", 0131}, {"Yacute", 0335}, {"Z", 0132}, {"a", 0141}, {"aacute", 0341}, {"acircumflex", 0342}, {"acute", 0222}, {"acute", 0264}, {"adieresis", 0344}, {"ae", 0346}, {"agrave", 0340}, {"ampersand", 0046}, {"aring", 0345}, {"asciicircum", 0136}, {"asciitilde", 0176}, {"asterisk", 0052}, {"at", 0100}, {"atilde", 0343}, {"b", 0142}, {"backslash", 0134}, {"bar", 0174}, {"braceleft", 0173}, {"braceright", 0175}, {"bracketleft", 0133}, {"bracketright", 0135}, {"breve", 0226}, {"brokenbar", 0246}, {"c", 0143}, {"caron", 0237}, {"ccedilla", 0347}, {"cedilla", 0270}, {"cent", 0242}, {"cirumflex", 0223}, {"colon", 0072}, {"comma", 0054}, {"copyright", 0251}, {"currency", 0244}, {"d", 0144}, {"degree", 0260}, {"dieresis", 0250}, {"divide", 0367}, {"dollar", 0044}, {"dotaccent", 0227}, {"dotlessi", 0220}, {"e", 0145}, {"eacute", 0351}, {"ecircumflex", 0352}, {"edieresis", 0353}, {"egrave", 0350}, {"eight", 0070}, {"equal", 0075}, {"eth", 0360}, {"exclam", 0041}, {"exclamdown", 0241}, {"f", 0146}, {"five", 0065}, {"four", 0064}, {"g", 0147}, {"germandbls", 0337}, {"grave", 0221}, {"greater", 0076}, {"guillemotleft", 0253}, {"guillemotright", 0273}, {"h", 0150}, {"hungarumlaut", 0235}, {"hyphen", 0255}, {"i", 0151}, {"iacute", 0355}, {"icircumflex", 0356}, {"idiresis", 0357}, {"igrave", 0354}, {"j", 0152}, {"k", 0153}, {"l", 0154}, {"less", 0074}, {"logicalnot", 0254}, {"m", 0155}, {"macron", 0257}, {"minus", 0055}, {"mu", 0265}, {"multiply", 0327}, {"n", 0156}, {"nine", 0071}, {"ntilde", 0361}, {"numbersign", 0043}, {"o", 0157}, {"oacute", 0363}, {"ocirumflex", 0364}, {"odiresis", 0366}, {"ogonek", 0236}, {"ograve", 0362}, {"one", 0061}, {"onehalf", 0275}, {"onequarter", 0274}, {"onesuperior", 0271}, {"ordfeminine", 0252}, {"ordmasculine", 0272}, {"oslash", 0370}, {"otilde", 0365}, {"p", 0160}, {"paragraph", 0266}, {"parenleft", 0050}, {"parenright", 0051}, {"percent", 0045}, {"period", 0056}, {"periodcentered", 0267}, {"plus", 0053}, {"plusminus", 0261}, {"q", 0161}, {"question", 0077}, {"questiondown", 0277}, {"quotedbl", 0042}, {"quoteleft", 0140}, {"quoteright", 0047}, {"r", 0162}, {"registered", 0256}, {"ring", 0232}, {"s", 0163}, {"section", 0247}, {"semicolon", 0073}, {"seven", 0067}, {"six", 0066}, {"slash", 0057}, {"space", 0040}, {"sterling", 0243}, {"t", 0164}, {"thorn", 0376}, {"three", 0063}, {"threequarters", 0276}, {"threesuperior", 0263}, {"tilde", 0224}, {"two", 0062}, {"twosuperior", 0262}, {"u", 0165}, {"uacute", 0372}, {"ucircumflex", 0373}, {"udieresis", 0374}, {"ugrave", 0371}, {"underscore", 0137}, {"v", 0166}, {"w", 0167}, {"x", 0170}, {"y", 0171}, {"yacute", 0375}, {"ydieresis", 0377}, {"yen", 0245}, {"z", 0172}, {"zero", 0060}};

#endif // CEN_H_TYPE1ENCODING
