//
// File: PanelResultat.cc
// Created by: Éric Laly <elaly@free.fr>
// Created on: Thu Nov  9 10:00:46 2006
//

#include "PanelResultat.h"

#include <wx/progdlg.h>


PanelResultat::PanelResultat(PanelCadres *panelcadres, PanelSaisieParametresSignature *panelsaisieparametresignature,
                                    PanelChoixImages *panelchoiximage, PanelParametresSortie *panelparametressortie,
                                    wxWindow* parent, int id):wxPanel(parent, id)
{
    panel_cadres=panelcadres;
    panel_signature=panelsaisieparametresignature;
    panel_choix_images=panelchoiximage;
    panel_parametres_sortie=panelparametressortie;
    mon_parent=parent;
    traitement_en_cours=false;
    
    sizer_panel_resultat = new wxBoxSizer(wxVERTICAL);
    
    // sizer jauge avancement global
    sizer_avancement_global_staticbox = new wxStaticBox(this, -1, wxT("Avancement Global"));
    label_avancement_global = new wxStaticText(this, -1, wxT(""));
    gauge_avancement_global = new wxGauge(this, -1, 10, wxDefaultPosition, wxDefaultSize, wxGA_HORIZONTAL|wxGA_SMOOTH);
    wxStaticBoxSizer* sizer_avancement_global = new wxStaticBoxSizer(sizer_avancement_global_staticbox, wxVERTICAL);
    sizer_avancement_global->Add(label_avancement_global, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 2);
    sizer_avancement_global->Add(gauge_avancement_global, 0, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_panel_resultat->Add(sizer_avancement_global, 0, wxALL|wxEXPAND, 3);

    // sizer jauge avancement local
    sizer_avancement_local_staticbox = new wxStaticBox(this, -1, wxT("Avancement Local"));
    label_avancement_local = new wxStaticText(this, -1, wxT(""));
    label_nom_fichier_traite= new wxStaticText(this, -1, wxT(""));
    gauge_avancement_local = new wxGauge(this, -1, 10, wxDefaultPosition, wxDefaultSize, wxGA_HORIZONTAL|wxGA_SMOOTH);
    wxStaticBoxSizer* sizer_avancement_local = new wxStaticBoxSizer(sizer_avancement_local_staticbox, wxVERTICAL);
    sizer_avancement_local->Add(label_avancement_local, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 2);
    sizer_avancement_local->Add(label_nom_fichier_traite, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 2);
    sizer_avancement_local->Add(gauge_avancement_local, 0, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_panel_resultat->Add(sizer_avancement_local, 0, wxALL|wxEXPAND, 3);

    // sizer bouton actions
    button_encadrer = new wxButton(this, -1, wxT("Encadrer"), wxDefaultPosition, wxDefaultSize, wxBU_EXACTFIT);
    button_annuler = new wxButton(this, wxID_CANCEL, wxT(""), wxDefaultPosition, wxDefaultSize, wxBU_EXACTFIT);
    wxBoxSizer* sizer_boutons_resultat = new wxBoxSizer(wxHORIZONTAL);
    sizer_boutons_resultat->Add(button_encadrer, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    sizer_boutons_resultat->Add(button_annuler, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 3);
    button_annuler->Hide();
    sizer_panel_resultat->Add(sizer_boutons_resultat, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 3);
    SetSizer(sizer_panel_resultat);

    // on connecte les événements
	Connect(button_encadrer->GetId( ), wxEVT_COMMAND_BUTTON_CLICKED, 
											(wxObjectEventFunction) &PanelResultat::on_click_button_encadrer);
	Connect(button_annuler->GetId( ), wxEVT_COMMAND_BUTTON_CLICKED, 
											(wxObjectEventFunction) &PanelResultat::on_click_button_annuler);
	
}


PanelResultat::~PanelResultat()
{
	// TODO: put destructor code here
}


void PanelResultat::on_click_button_annuler(wxCommandEvent& event)
{
    if (wxMessageBox(wxT("Voulez-vous vraiment interrompre le traitement ?"),wxT("Encadre_Image"),wxYES_NO|wxICON_QUESTION)==wxYES)
    {    
        // on demande au thread de traitement de se terminer
        thread_traitement->Delete();
        // et on attend sa fin
        thread_traitement->Wait();
        gauge_avancement_global->SetValue(0);
        gauge_avancement_local->SetValue(0);
        label_avancement_global->SetLabel(wxT("Traitement annulé !!!"));
        label_avancement_local->SetLabel(wxT("Traitement annulé !!!"));
        label_nom_fichier_traite->SetLabel(wxT(""));
        button_encadrer->Show(true);
        button_annuler->Hide();
        traitement_en_cours=false;
    }        
}    

void PanelResultat::on_click_button_encadrer(wxCommandEvent& event)
{
    traitement_en_cours=true;
    button_annuler->Show(true);
    button_encadrer->Hide();
    Layout();
    // on crée le thread de lecture des codes-barres
	thread_traitement = new ThreadTraitement(panel_cadres,panel_signature,panel_choix_images,panel_parametres_sortie,this);
	if ( thread_traitement->Create() != wxTHREAD_NO_ERROR )
    {
        wxLogFatalError(wxT("Création thread traitement impossible!"));
    }
	else
	{
		thread_traitement->Run();
	}
}

void PanelResultat::GaugeAvancementGlobalSetValue(int valeur)
{
    wxMutexGuiEnter();
    gauge_avancement_global->SetValue(valeur);     
    sizer_panel_resultat->Layout();
    wxMutexGuiLeave();
}

void PanelResultat::GaugeAvancementLocalSetValue(int valeur)
{
    wxMutexGuiEnter();
    gauge_avancement_local->SetValue(valeur);     
    sizer_panel_resultat->Layout();
    wxMutexGuiLeave();
}

void PanelResultat::GaugeAvancementGlobalSetRange(int valeur)
{
   gauge_avancement_global->SetRange(valeur); 
}   

void PanelResultat::GaugeAvancementLocalSetRange(int valeur)
{
    gauge_avancement_local->SetRange (valeur);    
}   

void PanelResultat::TraitementTermine()
{
    wxMutexGuiEnter();
    button_encadrer->Show(true);
    button_annuler->Hide();
    label_avancement_global->SetLabel(wxT("Terminé !!!"));
    label_avancement_local->SetLabel(wxT("Terminé !!!"));
    label_nom_fichier_traite->SetLabel(wxT(""));
    wxMutexGuiLeave();
    traitement_en_cours=false;    
}   

void PanelResultat::SetLabelAvancementGlobal(wxString label)
{
    wxMutexGuiEnter();
    label_avancement_global->SetLabel(label);     
    sizer_panel_resultat->Layout();
    wxMutexGuiLeave();
}

void PanelResultat::SetLabelAvancementLocal(wxString label)
{
    wxMutexGuiEnter();
    label_avancement_local->SetLabel(label);     
    sizer_panel_resultat->Layout();
    wxMutexGuiLeave();
}

void PanelResultat::SetLabelNomFichierTraite(wxString label)
{
    wxMutexGuiEnter();
    label_nom_fichier_traite->SetLabel(label);     
    sizer_panel_resultat->Layout();
    wxMutexGuiLeave();
}

bool PanelResultat::TraitementEnCours()
{
    return traitement_en_cours;
}
