// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file bitmask_struct.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__BITMASK_STRUCT_HPP
#define FAST_DDS_GENERATED__BITMASK_STRUCT_HPP

#include <cstdint>
#include <utility>

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(BITMASK_STRUCT_SOURCE)
#define BITMASK_STRUCT_DllAPI __declspec( dllexport )
#else
#define BITMASK_STRUCT_DllAPI __declspec( dllimport )
#endif // BITMASK_STRUCT_SOURCE
#else
#define BITMASK_STRUCT_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define BITMASK_STRUCT_DllAPI
#endif // _WIN32

/*!
 * @brief This enumeration represents the ColorBitmask bitflags defined by the user in the IDL file.
 * @ingroup bitmask_struct
 */
enum ColorBitmaskBits : uint8_t
{
    red = 0x01ull << 0,
    green = 0x01ull << 2,
    blue = 0x01ull << 3,
    yellow = 0x01ull << 5
};
typedef uint8_t ColorBitmask;
/*!
 * @brief This class represents the structure BitmaskStruct defined by the user in the IDL file.
 * @ingroup bitmask_struct
 */
class BitmaskStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport BitmaskStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~BitmaskStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object BitmaskStruct that will be copied.
     */
    eProsima_user_DllExport BitmaskStruct(
            const BitmaskStruct& x)
    {
                    m_my_bitmask = x.m_my_bitmask;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object BitmaskStruct that will be copied.
     */
    eProsima_user_DllExport BitmaskStruct(
            BitmaskStruct&& x) noexcept
    {
        m_my_bitmask = std::move(x.m_my_bitmask);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object BitmaskStruct that will be copied.
     */
    eProsima_user_DllExport BitmaskStruct& operator =(
            const BitmaskStruct& x)
    {

                    m_my_bitmask = x.m_my_bitmask;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object BitmaskStruct that will be copied.
     */
    eProsima_user_DllExport BitmaskStruct& operator =(
            BitmaskStruct&& x) noexcept
    {

        m_my_bitmask = std::move(x.m_my_bitmask);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x BitmaskStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const BitmaskStruct& x) const
    {
        return (m_my_bitmask == x.m_my_bitmask);
    }

    /*!
     * @brief Comparison operator.
     * @param x BitmaskStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const BitmaskStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member my_bitmask
     * @param _my_bitmask New value to be copied in member my_bitmask
     */
    eProsima_user_DllExport void my_bitmask(
            const ColorBitmask& _my_bitmask)
    {
        m_my_bitmask = _my_bitmask;
    }

    /*!
     * @brief This function moves the value in member my_bitmask
     * @param _my_bitmask New value to be moved in member my_bitmask
     */
    eProsima_user_DllExport void my_bitmask(
            ColorBitmask&& _my_bitmask)
    {
        m_my_bitmask = std::move(_my_bitmask);
    }

    /*!
     * @brief This function returns a constant reference to member my_bitmask
     * @return Constant reference to member my_bitmask
     */
    eProsima_user_DllExport const ColorBitmask& my_bitmask() const
    {
        return m_my_bitmask;
    }

    /*!
     * @brief This function returns a reference to member my_bitmask
     * @return Reference to member my_bitmask
     */
    eProsima_user_DllExport ColorBitmask& my_bitmask()
    {
        return m_my_bitmask;
    }



private:

    ColorBitmask m_my_bitmask{0};

};

#endif // _FAST_DDS_GENERATED_BITMASK_STRUCT_HPP_


