/*
 *  $Id: smi-redirect.S,v 1.3 2009-01-28 14:38:04 potyra Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifdef INIT_RM

#define APMS		$0xb3
#define GLBSTS		$0x4018
#define GLBCTL_H	$0x402a

.section .text.smi_redirect

.code16

asm_smi_handler:
	/* APMS holds the 64k-"segment" where SMMEM starts */
	movw	APMS, %dx
	inb	%dx, %al
	
	/* SMBASE is a doubleword at CS:FEF8. */
	movzbw	%al, %ax
	movw	%ax, %cs:0xfefa /* upper 16 bits APMS */
	movw	$0x0, %ax
	movw	%ax, %cs:0xfef8 /* lower 16 bit zeroed out */

	/* Reset APM_STS. */
	movw	$0x0020, %ax	# writing bits to GLBSTS clears them
	movw	GLBSTS, %dx
	outw	%ax, %dx

	/* Set EOS bit. */
	movw	GLBCTL_H, %dx
	inb	%dx, %al
	andb	$0xfe, %al	# mask reserved bits
	orb	$0x01, %al	# EOS is bit 16 => bit 0 of GLBCTL_H
	outb	%al, %dx

	rsm

#endif /* INIT_RM */
