#!/bin/sh
#
#       fhist - file history and comparison tools
#       Copyright (C) 1993, 1994, 1998, 2000, 2003, 2004, 2008 Peter Miller
#
#       This program is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published by
#       the Free Software Foundation; either version 3 of the License, or
#       (at your option) any later version.
#
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#
#       You should have received a copy of the GNU General Public License
#       along with this program. If not, see
#       <http://www.gnu.org/licenses/>.
#

work=/tmp/$$
PAGER=cat
export PAGER
LINES=24
export LINES
COLS=80
export COLS

fail()
{
        set +x
        echo FAILED test of the fcomp -u option 1>&2
        cd $here
        rm -rf $work
        exit 1
}
pass()
{
        set +x
        echo PASSED 1>&2
        cd $here
        rm -rf $work
        exit 0
}
trap "fail" 1 2 3 15

#
# use the built-in error messages
#
FHIST_MESSAGE_LIBRARY=$$work/no-such-dir
export FHIST_MESSAGE_LIBRARY
unset LANG
unset LANGUAGE

here=`pwd`
if test $? -ne 0 ; then exit 1; fi
mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

if [ "$1" != "" ]; then bin=$here/$1/bin; else bin=$here/bin; fi

#
# test for deletion
#
cat > test.first << 'fubar'
one
two
three
four
five
six
seven
eight
nine
ten
fubar
if test $? -ne 0 ; then fail; fi
cat > test.second << 'fubar'
Two
Four
Five
Six
Seven
Eight
fubar
if test $? -ne 0 ; then fail; fi
cat > test.ok << 'fubar'
FILE A: test.first
FILE B: test.second
TOTALS: 0 inserted  4 deleted  6 matched

******************** DELETE [A 1, B 1]:
one

******************** DELETE [A 3, B 2]:
three

******************** DELETE [A 9-10, B 7]:
nine
ten
fubar
if test $? -ne 0 ; then fail; fi
$bin/fcomp -u test.first test.second > test.out
if test $? -ne 0 ; then fail; fi
diff test.ok test.out
if test $? -ne 0 ; then fail; fi

#
# test for insertion
#
cat > test.first << 'fubar'
one
two
three
four
five
six
seven
eight
nine
ten
fubar
if test $? -ne 0 ; then fail; fi
cat > test.second << 'fubar'
One
Two
Three
Four
Five
Six
Six and a half
Seven
Eight
Nine
Ten
Eleven
Twelve
Thirteen
fubar
if test $? -ne 0 ; then fail; fi
cat > test.ok << 'fubar'
FILE A: test.first
FILE B: test.second
TOTALS: 4 inserted  0 deleted  10 matched

******************** INSERT [A 7, B 7]:
Six and a half

******************** INSERT [A 11, B 12-14]:
Eleven
Twelve
Thirteen
fubar
if test $? -ne 0 ; then fail; fi
$bin/fcomp -u test.first test.second > test.out
if test $? -ne 0 ; then fail; fi
diff test.ok test.out
if test $? -ne 0 ; then fail; fi

#
# test for replace
#
cat > test.first << 'fubar'
one
two
three
four
five
six
seven
eight
nine
ten
fubar
if test $? -ne 0 ; then fail; fi
cat > test.second << 'fubar'
One
Two
Three
Ruof
Evif
Xis
Seven
Eight
Nine
Ten
fubar
if test $? -ne 0 ; then fail; fi
cat > test.ok << 'fubar'
FILE A: test.first
FILE B: test.second
TOTALS: 3 inserted  3 deleted  7 matched

******************** REPLACE [A 4-6, B 4-6]:
four
five
six
******************** WITH:
Ruof
Evif
Xis
fubar
if test $? -ne 0 ; then fail; fi
$bin/fcomp -u test.first test.second -o test.out
if test $? -ne 0 ; then fail; fi
diff test.ok test.out
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
