/* plugin.c generated by valac 0.16.1, the Vala compiler
 * generated from plugin.vala, do not modify */

/*
 * (C) 2009-2012 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 * (C) 2009-2012 Sudharshan "Sup3rkiddo" S <sudharsh@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <fsobasics.h>
#include <freesmartphone.h>
#include <fsoframework.h>
#include <fcntl.h>
#include <sys/types.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <gio/gio.h>
#include <glib/gstdio.h>


#define KERNEL26_TYPE_DISPLAY (kernel26_display_get_type ())
#define KERNEL26_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KERNEL26_TYPE_DISPLAY, Kernel26Display))
#define KERNEL26_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KERNEL26_TYPE_DISPLAY, Kernel26DisplayClass))
#define KERNEL26_IS_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KERNEL26_TYPE_DISPLAY))
#define KERNEL26_IS_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KERNEL26_TYPE_DISPLAY))
#define KERNEL26_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KERNEL26_TYPE_DISPLAY, Kernel26DisplayClass))

typedef struct _Kernel26Display Kernel26Display;
typedef struct _Kernel26DisplayClass Kernel26DisplayClass;
typedef struct _Kernel26DisplayPrivate Kernel26DisplayPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct __kernel26_display_setBrightnessSoftData _kernel26_display_setBrightnessSoftData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Kernel26DisplayGetInfoData Kernel26DisplayGetInfoData;
typedef struct _Kernel26DisplaySetBrightnessData Kernel26DisplaySetBrightnessData;
typedef struct _Kernel26DisplayGetBrightnessData Kernel26DisplayGetBrightnessData;
typedef struct _Kernel26DisplayGetBacklightPowerData Kernel26DisplayGetBacklightPowerData;
typedef struct _Kernel26DisplaySetBacklightPowerData Kernel26DisplaySetBacklightPowerData;

struct _Kernel26Display {
	FsoFrameworkAbstractObject parent_instance;
	Kernel26DisplayPrivate * priv;
};

struct _Kernel26DisplayClass {
	FsoFrameworkAbstractObjectClass parent_class;
};

struct _Kernel26DisplayPrivate {
	FsoFrameworkSubsystem* subsystem;
	gboolean smoothup;
	gboolean smoothdown;
	gboolean smoothInProgress;
	gint max_brightness;
	gint current_brightness;
	gchar* sysfsnode;
	gint fb_fd;
};

struct __kernel26_display_setBrightnessSoftData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Kernel26Display* self;
	gint brightness;
	gint _tmp0_;
	gint _tmp1_;
	gdouble current;
	gint _tmp2_;
	gint _tmp3_;
	gdouble interval;
	gdouble dt;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	gdouble x;
	gdouble _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	gdouble _tmp16_;
	gdouble _tmp17_;
	gdouble fx;
	gdouble _tmp18_;
	gdouble _tmp19_;
	gdouble _tmp20_;
	gdouble _tmp21_;
	gdouble _tmp22_;
	gdouble _tmp23_;
	gdouble _tmp24_;
	gdouble _tmp25_;
	gdouble _tmp26_;
	gdouble val;
	gboolean _tmp27_;
	gdouble _tmp28_;
	gdouble _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gint _tmp42_;
	FsoFrameworkLogger* _tmp43_;
	gint _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gboolean _tmp49_;
	gint _tmp50_;
};

struct _Kernel26DisplayGetInfoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Kernel26Display* self;
	GHashTable* result;
	gchar* _leaf;
	GVariant* val;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* info_table;
	const gchar* _tmp3_;
	GDir* _tmp4_;
	GDir* dir;
	GDir* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gboolean _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	const gchar* _tmp18_;
	gboolean _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	GVariant* _tmp30_;
	GHashTable* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	GVariant* _tmp34_;
	GVariant* _tmp35_;
	GError* _error_;
	FsoFrameworkLogger* _tmp36_;
	GError* _tmp37_;
	const gchar* _tmp38_;
	GError * _inner_error_;
};

struct _Kernel26DisplaySetBrightnessData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Kernel26Display* self;
	gint brightness;
	gint _tmp0_;
	gint _tmp1_;
};

struct _Kernel26DisplayGetBrightnessData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Kernel26Display* self;
	gint result;
	gint _tmp0_;
};

struct _Kernel26DisplayGetBacklightPowerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Kernel26Display* self;
	gboolean result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gint _tmp5_;
	gboolean _tmp6_;
};

struct _Kernel26DisplaySetBacklightPowerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Kernel26Display* self;
	gboolean power;
	gboolean _tmp0_;
};


static gpointer kernel26_display_parent_class = NULL;
static guint kernel26_display_counter;
static guint kernel26_display_counter = 0U;
extern gchar* dev_fb0;
static FreeSmartphoneDeviceDisplayIface* kernel26_display_free_smartphone_device_display_parent_iface = NULL;
static FreeSmartphoneInfoIface* kernel26_display_free_smartphone_info_parent_iface = NULL;
static GType kernel26_display_type_id = 0;
gchar* dev_fb0 = NULL;
extern gchar* sys_class_backlight;
gchar* sys_class_backlight = NULL;
extern GList* instances;
GList* instances = NULL;

#define KERNEL26_DISPLAY_PLUGIN_NAME "fsodevice.kernel26_display"
#define KERNEL26_DISPLAY_SMOOTH_PERIOD (1 * 0.7)
#define KERNEL26_DISPLAY_SMOOTH_STEP (1 * 0.03)
GType kernel26_display_get_type (void) G_GNUC_CONST;
GType kernel26_display_register_type (GTypeModule * module);
#define KERNEL26_DISPLAY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KERNEL26_TYPE_DISPLAY, Kernel26DisplayPrivate))
enum  {
	KERNEL26_DISPLAY_DUMMY_PROPERTY
};
#define KERNEL26_DISPLAY_FBIOBLANK 0x4611
#define KERNEL26_DISPLAY_FB_BLANK_UNBLANK 0
#define KERNEL26_DISPLAY_FB_BLANK_POWERDOWN 4
Kernel26Display* kernel26_display_new (FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode);
Kernel26Display* kernel26_display_construct (GType object_type, FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode);
static gint _kernel26_display_getBrightness (Kernel26Display* self);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static gchar* kernel26_display_real_repr (FsoFrameworkAbstractObject* base);
static void _kernel26_display_setBacklightPower (Kernel26Display* self, gboolean on);
static gint _kernel26_display_valueToPercent (Kernel26Display* self, gint value);
static gint _kernel26_display_percentToValue (Kernel26Display* self, gint percent);
static void _kernel26_display_setBrightnessSoft_data_free (gpointer _data);
static void _kernel26_display_setBrightnessSoft (Kernel26Display* self, gint brightness, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _kernel26_display_setBrightnessSoft_finish (Kernel26Display* self, GAsyncResult* _res_);
static gboolean _kernel26_display_setBrightnessSoft_co (_kernel26_display_setBrightnessSoftData* _data_);
static gboolean __kernel26_display_setBrightnessSoft_co_gsource_func (gpointer self);
static void _kernel26_display_setBrightness (Kernel26Display* self, gint brightness);
static void kernel26_display_real_get_info_data_free (gpointer _data);
static void kernel26_display_real_get_info (FreeSmartphoneInfo* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean kernel26_display_real_get_info_co (Kernel26DisplayGetInfoData* _data_);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static GVariant* _variant_new1 (gchar* value);
static void kernel26_display_real_set_brightness_data_free (gpointer _data);
static void kernel26_display_real_set_brightness (FreeSmartphoneDeviceDisplay* base, gint brightness, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean kernel26_display_real_set_brightness_co (Kernel26DisplaySetBrightnessData* _data_);
static void kernel26_display_real_get_brightness_data_free (gpointer _data);
static void kernel26_display_real_get_brightness (FreeSmartphoneDeviceDisplay* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean kernel26_display_real_get_brightness_co (Kernel26DisplayGetBrightnessData* _data_);
static void kernel26_display_real_get_backlight_power_data_free (gpointer _data);
static void kernel26_display_real_get_backlight_power (FreeSmartphoneDeviceDisplay* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean kernel26_display_real_get_backlight_power_co (Kernel26DisplayGetBacklightPowerData* _data_);
static void kernel26_display_real_set_backlight_power_data_free (gpointer _data);
static void kernel26_display_real_set_backlight_power (FreeSmartphoneDeviceDisplay* base, gboolean power, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean kernel26_display_real_set_backlight_power_co (Kernel26DisplaySetBacklightPowerData* _data_);
static void kernel26_display_finalize (GObject* obj);
gchar* fso_factory_function (FsoFrameworkSubsystem* subsystem, GError** error);
void fso_register_function (GTypeModule* module);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


Kernel26Display* kernel26_display_construct (GType object_type, FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode) {
	Kernel26Display * self = NULL;
	FsoFrameworkSubsystem* _tmp0_;
	FsoFrameworkSubsystem* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	const gchar* _tmp11_;
	gint _tmp12_ = 0;
	gint _tmp13_;
	FsoFrameworkSmartKeyFile* _tmp22_;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_;
	gchar* smooth;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar** _tmp29_ = NULL;
	gchar** _tmp30_;
	gint _tmp30__length1;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar** _tmp33_ = NULL;
	gchar** _tmp34_;
	gint _tmp34__length1;
	gboolean _tmp35_;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_;
	gboolean _tmp38_;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_;
	gchar* _tmp41_ = NULL;
	gchar* _tmp42_;
	FsoFrameworkSubsystem* _tmp43_;
	guint _tmp44_;
	gchar* _tmp45_ = NULL;
	gchar* _tmp46_;
	FsoFrameworkSubsystem* _tmp47_;
	guint _tmp48_;
	gchar* _tmp49_ = NULL;
	gchar* _tmp50_;
	FsoFrameworkLogger* _tmp51_;
	gint _tmp52_;
	gchar* _tmp53_ = NULL;
	gchar* _tmp54_;
	gboolean _tmp55_;
	gchar* _tmp56_ = NULL;
	gchar* _tmp57_;
	gboolean _tmp58_;
	gchar* _tmp59_ = NULL;
	gchar* _tmp60_;
	gchar* _tmp61_ = NULL;
	gchar* _tmp62_;
	g_return_val_if_fail (subsystem != NULL, NULL);
	g_return_val_if_fail (sysfsnode != NULL, NULL);
	self = (Kernel26Display*) fso_framework_abstract_object_construct (object_type);
	_tmp0_ = subsystem;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->subsystem);
	self->priv->subsystem = _tmp1_;
	_tmp2_ = sysfsnode;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->sysfsnode);
	self->priv->sysfsnode = _tmp3_;
	_tmp4_ = self->priv->sysfsnode;
	_tmp5_ = g_strconcat (_tmp4_, "/max_brightness", NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = fso_framework_file_handling_read (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = atoi (_tmp8_);
	self->priv->max_brightness = _tmp9_;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_tmp10_ = _kernel26_display_getBrightness (self);
	self->priv->current_brightness = _tmp10_;
	_tmp11_ = dev_fb0;
	_tmp12_ = open (_tmp11_, O_RDONLY, (mode_t) 0);
	self->priv->fb_fd = _tmp12_;
	_tmp13_ = self->priv->fb_fd;
	if (_tmp13_ == (-1)) {
		FsoFrameworkLogger* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_ = NULL;
		gint _tmp17_;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		_tmp14_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp15_ = dev_fb0;
		_tmp16_ = string_to_string (_tmp15_);
		_tmp17_ = errno;
		_tmp18_ = g_strerror (_tmp17_);
		_tmp19_ = string_to_string (_tmp18_);
		_tmp20_ = g_strconcat ("Can't open ", _tmp16_, " (", _tmp19_, "). Full display power control not available.", NULL);
		_tmp21_ = _tmp20_;
		fso_framework_logger_warning (_tmp14_, _tmp21_);
		_g_free0 (_tmp21_);
	}
	_tmp22_ = ((FsoFrameworkAbstractObject*) self)->config;
	_tmp23_ = fso_framework_smart_key_file_stringValue (_tmp22_, KERNEL26_DISPLAY_PLUGIN_NAME, "smooth", "none");
	_tmp24_ = _tmp23_;
	_tmp25_ = g_utf8_strdown (_tmp24_, (gssize) (-1));
	_tmp26_ = _tmp25_;
	_g_free0 (_tmp24_);
	smooth = _tmp26_;
	_tmp27_ = g_strdup ("up");
	_tmp28_ = g_strdup ("always");
	_tmp29_ = g_new0 (gchar*, 2 + 1);
	_tmp29_[0] = _tmp27_;
	_tmp29_[1] = _tmp28_;
	_tmp30_ = _tmp29_;
	_tmp30__length1 = 2;
	self->priv->smoothup = _vala_string_array_contains (_tmp30_, 2, smooth);
	_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
	_tmp31_ = g_strdup ("down");
	_tmp32_ = g_strdup ("always");
	_tmp33_ = g_new0 (gchar*, 2 + 1);
	_tmp33_[0] = _tmp31_;
	_tmp33_[1] = _tmp32_;
	_tmp34_ = _tmp33_;
	_tmp34__length1 = 2;
	self->priv->smoothdown = _vala_string_array_contains (_tmp34_, 2, smooth);
	_tmp34_ = (_vala_array_free (_tmp34_, _tmp34__length1, (GDestroyNotify) g_free), NULL);
	_tmp35_ = self->priv->smoothup;
	_tmp36_ = bool_to_string (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = self->priv->smoothdown;
	_tmp39_ = bool_to_string (_tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = g_strconcat ("smoothup = ", _tmp37_, ", smoothdown = ", _tmp40_, NULL);
	_tmp42_ = _tmp41_;
	g_debug ("plugin.vala:65: %s", _tmp42_);
	_g_free0 (_tmp42_);
	_g_free0 (_tmp40_);
	_g_free0 (_tmp37_);
	_tmp43_ = subsystem;
	_tmp44_ = kernel26_display_counter;
	_tmp45_ = g_strdup_printf ("%s/%u", FSO_FRAMEWORK_DEVICE_DisplayServicePath, _tmp44_);
	_tmp46_ = _tmp45_;
	fso_framework_subsystem_registerObjectForService (_tmp43_, FREE_SMARTPHONE_DEVICE_TYPE_DISPLAY, (GBoxedCopyFunc) g_object_ref, g_object_unref, FSO_FRAMEWORK_DEVICE_ServiceDBusName, _tmp46_, (FreeSmartphoneDeviceDisplay*) self);
	_g_free0 (_tmp46_);
	_tmp47_ = subsystem;
	_tmp48_ = kernel26_display_counter;
	kernel26_display_counter = _tmp48_ + 1;
	_tmp49_ = g_strdup_printf ("%s/%u", FSO_FRAMEWORK_DEVICE_DisplayServicePath, _tmp48_);
	_tmp50_ = _tmp49_;
	fso_framework_subsystem_registerObjectForService (_tmp47_, FREE_SMARTPHONE_TYPE_INFO, (GBoxedCopyFunc) g_object_ref, g_object_unref, FSO_FRAMEWORK_DEVICE_ServiceDBusName, _tmp50_, (FreeSmartphoneInfo*) self);
	_g_free0 (_tmp50_);
	_tmp51_ = ((FsoFrameworkAbstractObject*) self)->logger;
	_tmp52_ = self->priv->max_brightness;
	_tmp53_ = g_strdup_printf ("%i", _tmp52_);
	_tmp54_ = _tmp53_;
	_tmp55_ = self->priv->smoothup;
	_tmp56_ = bool_to_string (_tmp55_);
	_tmp57_ = _tmp56_;
	_tmp58_ = self->priv->smoothdown;
	_tmp59_ = bool_to_string (_tmp58_);
	_tmp60_ = _tmp59_;
	_tmp61_ = g_strconcat ("Created w/ max brightness = ", _tmp54_, ", smooth up = ", _tmp57_, ", smooth down = ", _tmp60_, NULL);
	_tmp62_ = _tmp61_;
	fso_framework_logger_info (_tmp51_, _tmp62_);
	_g_free0 (_tmp62_);
	_g_free0 (_tmp60_);
	_g_free0 (_tmp57_);
	_g_free0 (_tmp54_);
	_g_free0 (smooth);
	return self;
}


Kernel26Display* kernel26_display_new (FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode) {
	return kernel26_display_construct (KERNEL26_TYPE_DISPLAY, subsystem, sysfsnode);
}


static gchar* kernel26_display_real_repr (FsoFrameworkAbstractObject* base) {
	Kernel26Display * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	self = (Kernel26Display*) base;
	_tmp0_ = self->priv->sysfsnode;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = g_strconcat ("<", _tmp1_, ">", NULL);
	result = _tmp2_;
	return result;
}


static void _kernel26_display_setBacklightPower (Kernel26Display* self, gboolean on) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* value;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gint _tmp8_;
	gboolean _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp1_ = on;
	if (_tmp1_) {
		_tmp0_ = "0";
	} else {
		_tmp0_ = "1";
	}
	_tmp2_ = _tmp0_;
	_tmp3_ = g_strdup (_tmp2_);
	value = _tmp3_;
	_tmp4_ = value;
	_tmp5_ = self->priv->sysfsnode;
	_tmp6_ = g_strconcat (_tmp5_, "/bl_power", NULL);
	_tmp7_ = _tmp6_;
	fso_framework_file_handling_write (_tmp4_, _tmp7_, FALSE);
	_g_free0 (_tmp7_);
	_tmp8_ = self->priv->fb_fd;
	if (_tmp8_ != (-1)) {
		gint _tmp9_ = 0;
		gboolean _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		_tmp10_ = on;
		if (_tmp10_) {
			_tmp9_ = KERNEL26_DISPLAY_FB_BLANK_UNBLANK;
		} else {
			_tmp9_ = KERNEL26_DISPLAY_FB_BLANK_POWERDOWN;
		}
		_tmp11_ = self->priv->fb_fd;
		_tmp12_ = _tmp9_;
		ioctl (_tmp11_, KERNEL26_DISPLAY_FBIOBLANK, _tmp12_);
	}
	_tmp13_ = on;
	g_signal_emit_by_name ((FreeSmartphoneDeviceDisplay*) self, "backlight-power", _tmp13_);
	_g_free0 (value);
}


static gint _kernel26_display_valueToPercent (Kernel26Display* self, gint value) {
	gint result = 0;
	gint _tmp0_;
	gdouble max;
	gint _tmp1_;
	gdouble v;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->max_brightness;
	max = (gdouble) _tmp0_;
	_tmp1_ = value;
	v = (gdouble) _tmp1_;
	result = (gint) ((100.0 / max) * v);
	return result;
}


static gint _kernel26_display_percentToValue (Kernel26Display* self, gint percent) {
	gint result = 0;
	gint _tmp0_;
	gdouble p;
	gint _tmp1_;
	gdouble max;
	gdouble value = 0.0;
	gint _tmp2_;
	gdouble _tmp7_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = percent;
	p = (gdouble) _tmp0_;
	_tmp1_ = self->priv->max_brightness;
	max = (gdouble) _tmp1_;
	_tmp2_ = percent;
	if (_tmp2_ >= 100) {
		gint _tmp3_;
		_tmp3_ = self->priv->max_brightness;
		value = (gdouble) _tmp3_;
	} else {
		gint _tmp4_;
		_tmp4_ = percent;
		if (_tmp4_ <= 0) {
			value = (gdouble) 0;
		} else {
			gdouble _tmp5_;
			gdouble _tmp6_;
			_tmp5_ = p;
			_tmp6_ = max;
			value = (_tmp5_ / 100.0) * _tmp6_;
		}
	}
	_tmp7_ = value;
	result = (gint) _tmp7_;
	return result;
}


static gint _kernel26_display_getBrightness (Kernel26Display* self) {
	gint result = 0;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gint _tmp5_ = 0;
	gint _tmp6_;
	gint value;
	gint _tmp7_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->sysfsnode;
	_tmp1_ = g_strconcat (_tmp0_, "/actual_brightness", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = fso_framework_file_handling_read (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = atoi (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	value = _tmp6_;
	_tmp7_ = _kernel26_display_valueToPercent (self, value);
	result = _tmp7_;
	return result;
}


static void _kernel26_display_setBrightnessSoft_data_free (gpointer _data) {
	_kernel26_display_setBrightnessSoftData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (_kernel26_display_setBrightnessSoftData, _data_);
}


static void _kernel26_display_setBrightnessSoft (Kernel26Display* self, gint brightness, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	_kernel26_display_setBrightnessSoftData* _data_;
	Kernel26Display* _tmp0_;
	gint _tmp1_;
	_data_ = g_slice_new0 (_kernel26_display_setBrightnessSoftData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _kernel26_display_setBrightnessSoft);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _kernel26_display_setBrightnessSoft_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = brightness;
	_data_->brightness = _tmp1_;
	_kernel26_display_setBrightnessSoft_co (_data_);
}


static void _kernel26_display_setBrightnessSoft_finish (Kernel26Display* self, GAsyncResult* _res_) {
	_kernel26_display_setBrightnessSoftData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean __kernel26_display_setBrightnessSoft_co_gsource_func (gpointer self) {
	gboolean result;
	result = _kernel26_display_setBrightnessSoft_co (self);
	return result;
}


static gboolean _kernel26_display_setBrightnessSoft_co (_kernel26_display_setBrightnessSoftData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->current_brightness;
	if (_data_->_tmp0_ == 0) {
		_kernel26_display_setBacklightPower (_data_->self, TRUE);
	}
	_data_->self->priv->smoothInProgress = TRUE;
	_data_->_tmp1_ = _data_->self->priv->current_brightness;
	_data_->current = (gdouble) _data_->_tmp1_;
	_data_->_tmp2_ = _data_->brightness;
	_data_->_tmp3_ = _data_->self->priv->current_brightness;
	_data_->interval = (gdouble) (_data_->_tmp2_ - _data_->_tmp3_);
	{
		_data_->dt = (gdouble) 0;
		{
			_data_->_tmp4_ = TRUE;
			while (TRUE) {
				_data_->_tmp5_ = _data_->_tmp4_;
				if (!_data_->_tmp5_) {
					_data_->_tmp6_ = _data_->dt;
					_data_->dt = _data_->_tmp6_ + KERNEL26_DISPLAY_SMOOTH_STEP;
				}
				_data_->_tmp4_ = FALSE;
				_data_->_tmp7_ = _data_->dt;
				if (!(_data_->_tmp7_ < KERNEL26_DISPLAY_SMOOTH_PERIOD)) {
					break;
				}
				_data_->_tmp8_ = _data_->dt;
				_data_->x = _data_->_tmp8_ / KERNEL26_DISPLAY_SMOOTH_PERIOD;
				_data_->_tmp10_ = _data_->interval;
				if (_data_->_tmp10_ > ((gdouble) 0)) {
					_data_->_tmp11_ = _data_->x;
					_data_->_tmp12_ = _data_->x;
					_data_->_tmp13_ = _data_->x;
					_data_->_tmp9_ = (_data_->_tmp11_ * _data_->_tmp12_) * _data_->_tmp13_;
				} else {
					_data_->_tmp14_ = _data_->x;
					_data_->_tmp15_ = _data_->x;
					_data_->_tmp16_ = _data_->x;
					_data_->_tmp9_ = ((1 - _data_->_tmp14_) * (1 - _data_->_tmp15_)) * (1 - _data_->_tmp16_);
				}
				_data_->_tmp17_ = _data_->_tmp9_;
				_data_->fx = _data_->_tmp17_;
				_data_->_tmp19_ = _data_->interval;
				if (_data_->_tmp19_ > ((gdouble) 0)) {
					_data_->_tmp20_ = _data_->current;
					_data_->_tmp21_ = _data_->fx;
					_data_->_tmp22_ = _data_->interval;
					_data_->_tmp18_ = _data_->_tmp20_ + (_data_->_tmp21_ * _data_->_tmp22_);
				} else {
					_data_->_tmp23_ = _data_->current;
					_data_->_tmp24_ = _data_->fx;
					_data_->_tmp25_ = _data_->interval;
					_data_->_tmp18_ = _data_->_tmp23_ + ((1 - _data_->_tmp24_) * _data_->_tmp25_);
				}
				_data_->_tmp26_ = _data_->_tmp18_;
				_data_->val = _data_->_tmp26_;
				_data_->_tmp27_ = _data_->self->priv->smoothInProgress;
				if (!_data_->_tmp27_) {
					if (_data_->_state_ == 0) {
						g_simple_async_result_complete_in_idle (_data_->_async_result);
					} else {
						g_simple_async_result_complete (_data_->_async_result);
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp28_ = _data_->val;
				_data_->_tmp29_ = 0.0;
				_data_->_tmp29_ = round (_data_->_tmp28_);
				_data_->_tmp30_ = NULL;
				_data_->_tmp30_ = g_strdup_printf ("%i", (gint) _data_->_tmp29_);
				_data_->_tmp31_ = _data_->_tmp30_;
				_data_->_tmp32_ = _data_->self->priv->sysfsnode;
				_data_->_tmp33_ = g_strconcat (_data_->_tmp32_, "/brightness", NULL);
				_data_->_tmp34_ = _data_->_tmp33_;
				fso_framework_file_handling_write (_data_->_tmp31_, _data_->_tmp34_, FALSE);
				_g_free0 (_data_->_tmp34_);
				_g_free0 (_data_->_tmp31_);
				_data_->_tmp35_ = _data_->brightness;
				_data_->self->priv->current_brightness = _data_->_tmp35_;
				g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) ((gint) (KERNEL26_DISPLAY_SMOOTH_STEP * 1000)), __kernel26_display_setBrightnessSoft_co_gsource_func, _data_, NULL);
				_data_->_state_ = 1;
				return FALSE;
				_state_1:
				;
			}
		}
	}
	_data_->_tmp36_ = _data_->brightness;
	_data_->_tmp37_ = NULL;
	_data_->_tmp37_ = g_strdup_printf ("%i", _data_->_tmp36_);
	_data_->_tmp38_ = _data_->_tmp37_;
	_data_->_tmp39_ = _data_->self->priv->sysfsnode;
	_data_->_tmp40_ = g_strconcat (_data_->_tmp39_, "/brightness", NULL);
	_data_->_tmp41_ = _data_->_tmp40_;
	fso_framework_file_handling_write (_data_->_tmp38_, _data_->_tmp41_, FALSE);
	_g_free0 (_data_->_tmp41_);
	_g_free0 (_data_->_tmp38_);
	_data_->_tmp42_ = _data_->brightness;
	_data_->self->priv->current_brightness = _data_->_tmp42_;
	_data_->_tmp43_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
	_data_->_tmp44_ = _data_->brightness;
	_data_->_tmp45_ = NULL;
	_data_->_tmp45_ = g_strdup_printf ("%i", _data_->_tmp44_);
	_data_->_tmp46_ = _data_->_tmp45_;
	_data_->_tmp47_ = NULL;
	_data_->_tmp47_ = g_strconcat ("Brightness set to ", _data_->_tmp46_, " [soft]", NULL);
	_data_->_tmp48_ = _data_->_tmp47_;
	_data_->_tmp49_ = FALSE;
	_data_->_tmp49_ = fso_framework_logger_debug (_data_->_tmp43_, _data_->_tmp48_);
	g_assert (_data_->_tmp49_);
	_g_free0 (_data_->_tmp48_);
	_g_free0 (_data_->_tmp46_);
	_data_->_tmp50_ = _data_->brightness;
	if (_data_->_tmp50_ == 0) {
		_kernel26_display_setBacklightPower (_data_->self, FALSE);
	}
	_data_->self->priv->smoothInProgress = FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _kernel26_display_setBrightness (Kernel26Display* self, gint brightness) {
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp6_;
	gboolean _tmp8_ = FALSE;
	gint _tmp9_;
	gint _tmp10_;
	gboolean _tmp12_;
	gint _tmp14_;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gint _tmp20_;
	gint _tmp22_;
	FsoFrameworkLogger* _tmp23_;
	gint _tmp24_;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_;
	gboolean _tmp29_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_brightness;
	_tmp1_ = brightness;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp3_ = self->priv->current_brightness;
	_tmp4_ = brightness;
	if (_tmp3_ < _tmp4_) {
		gboolean _tmp5_;
		_tmp5_ = self->priv->smoothup;
		_tmp2_ = _tmp5_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp6_ = _tmp2_;
	if (_tmp6_) {
		gint _tmp7_;
		_tmp7_ = brightness;
		_kernel26_display_setBrightnessSoft (self, _tmp7_, NULL, NULL);
		return;
	}
	_tmp9_ = self->priv->current_brightness;
	_tmp10_ = brightness;
	if (_tmp9_ > _tmp10_) {
		gboolean _tmp11_;
		_tmp11_ = self->priv->smoothdown;
		_tmp8_ = _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	if (_tmp12_) {
		gint _tmp13_;
		_tmp13_ = brightness;
		_kernel26_display_setBrightnessSoft (self, _tmp13_, NULL, NULL);
		return;
	}
	self->priv->smoothInProgress = FALSE;
	_tmp14_ = brightness;
	_tmp15_ = g_strdup_printf ("%i", _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = self->priv->sysfsnode;
	_tmp18_ = g_strconcat (_tmp17_, "/brightness", NULL);
	_tmp19_ = _tmp18_;
	fso_framework_file_handling_write (_tmp16_, _tmp19_, FALSE);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp16_);
	_tmp20_ = self->priv->current_brightness;
	if (_tmp20_ == 0) {
		_kernel26_display_setBacklightPower (self, TRUE);
	} else {
		gint _tmp21_;
		_tmp21_ = brightness;
		if (_tmp21_ == 0) {
			_kernel26_display_setBacklightPower (self, FALSE);
		}
	}
	_tmp22_ = brightness;
	self->priv->current_brightness = _tmp22_;
	_tmp23_ = ((FsoFrameworkAbstractObject*) self)->logger;
	_tmp24_ = brightness;
	_tmp25_ = g_strdup_printf ("%i", _tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_strconcat ("Brightness set to ", _tmp26_, " [hard]", NULL);
	_tmp28_ = _tmp27_;
	_tmp29_ = fso_framework_logger_debug (_tmp23_, _tmp28_);
	g_assert (_tmp29_);
	_g_free0 (_tmp28_);
	_g_free0 (_tmp26_);
}


static void kernel26_display_real_get_info_data_free (gpointer _data) {
	Kernel26DisplayGetInfoData* _data_;
	_data_ = _data;
	_g_hash_table_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (Kernel26DisplayGetInfoData, _data_);
}


static void kernel26_display_real_get_info (FreeSmartphoneInfo* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	Kernel26Display * self;
	Kernel26DisplayGetInfoData* _data_;
	Kernel26Display* _tmp0_;
	self = (Kernel26Display*) base;
	_data_ = g_slice_new0 (Kernel26DisplayGetInfoData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel26_display_real_get_info);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel26_display_real_get_info_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	kernel26_display_real_get_info_co (_data_);
}


static GHashTable* kernel26_display_real_get_info_finish (FreeSmartphoneInfo* base, GAsyncResult* _res_, GError** error) {
	GHashTable* result;
	Kernel26DisplayGetInfoData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_variant_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static GVariant* _variant_new1 (gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static gboolean kernel26_display_real_get_info_co (Kernel26DisplayGetInfoData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_str_hash;
	_data_->_tmp1_ = g_str_equal;
	_data_->_tmp2_ = g_hash_table_new_full (_data_->_tmp0_, _data_->_tmp1_, _g_free0_, _g_variant_unref0_);
	_data_->info_table = _data_->_tmp2_;
	{
		_data_->_tmp3_ = _data_->self->priv->sysfsnode;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = g_dir_open (_data_->_tmp3_, (guint) 0, &_data_->_inner_error_);
		_data_->dir = _data_->_tmp4_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		while (TRUE) {
			_data_->_tmp5_ = _data_->dir;
			_data_->_tmp6_ = NULL;
			_data_->_tmp6_ = g_dir_read_name (_data_->_tmp5_);
			_data_->_tmp7_ = g_strdup (_data_->_tmp6_);
			_g_free0 (_data_->_leaf);
			_data_->_leaf = _data_->_tmp7_;
			_data_->_tmp8_ = _data_->_leaf;
			if (!(_data_->_tmp8_ != NULL)) {
				break;
			}
			_data_->_tmp10_ = _data_->self->priv->sysfsnode;
			_data_->_tmp11_ = g_strconcat (_data_->_tmp10_, "/", NULL);
			_data_->_tmp12_ = _data_->_tmp11_;
			_data_->_tmp13_ = _data_->_leaf;
			_data_->_tmp14_ = g_strconcat (_data_->_tmp12_, _data_->_tmp13_, NULL);
			_data_->_tmp15_ = _data_->_tmp14_;
			_data_->_tmp16_ = FALSE;
			_data_->_tmp16_ = g_file_test (_data_->_tmp15_, G_FILE_TEST_IS_REGULAR);
			_data_->_tmp17_ = _data_->_tmp16_;
			_g_free0 (_data_->_tmp15_);
			_g_free0 (_data_->_tmp12_);
			if (_data_->_tmp17_) {
				_data_->_tmp18_ = _data_->_leaf;
				_data_->_tmp9_ = g_strcmp0 (_data_->_tmp18_, "uevent") != 0;
			} else {
				_data_->_tmp9_ = FALSE;
			}
			_data_->_tmp19_ = _data_->_tmp9_;
			if (_data_->_tmp19_) {
				_data_->_tmp20_ = _data_->self->priv->sysfsnode;
				_data_->_tmp21_ = g_strconcat (_data_->_tmp20_, "/", NULL);
				_data_->_tmp22_ = _data_->_tmp21_;
				_data_->_tmp23_ = _data_->_leaf;
				_data_->_tmp24_ = g_strconcat (_data_->_tmp22_, _data_->_tmp23_, NULL);
				_data_->_tmp25_ = _data_->_tmp24_;
				_data_->_tmp26_ = NULL;
				_data_->_tmp26_ = fso_framework_file_handling_read (_data_->_tmp25_);
				_data_->_tmp27_ = _data_->_tmp26_;
				_data_->_tmp28_ = NULL;
				_data_->_tmp28_ = string_strip (_data_->_tmp27_);
				_data_->_tmp29_ = _data_->_tmp28_;
				_data_->_tmp30_ = _variant_new1 (_data_->_tmp29_);
				_g_variant_unref0 (_data_->val);
				_data_->val = _data_->_tmp30_;
				_g_free0 (_data_->_tmp29_);
				_g_free0 (_data_->_tmp27_);
				_g_free0 (_data_->_tmp25_);
				_g_free0 (_data_->_tmp22_);
				_data_->_tmp31_ = _data_->info_table;
				_data_->_tmp32_ = _data_->_leaf;
				_data_->_tmp33_ = g_strdup (_data_->_tmp32_);
				_data_->_tmp34_ = _data_->val;
				_data_->_tmp35_ = _g_variant_ref0 (_data_->_tmp34_);
				g_hash_table_insert (_data_->_tmp31_, _data_->_tmp33_, _data_->_tmp35_);
			}
		}
		_g_dir_close0 (_data_->dir);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp36_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
		_data_->_tmp37_ = _data_->_error_;
		_data_->_tmp38_ = _data_->_tmp37_->message;
		fso_framework_logger_warning (_data_->_tmp36_, _data_->_tmp38_);
		_g_error_free0 (_data_->_error_);
	}
	__finally0:
	if (_data_->_inner_error_ != NULL) {
		if ((_data_->_inner_error_->domain == G_DBUS_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_hash_table_unref0 (_data_->info_table);
			_g_variant_unref0 (_data_->val);
			_g_free0 (_data_->_leaf);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_hash_table_unref0 (_data_->info_table);
			_g_variant_unref0 (_data_->val);
			_g_free0 (_data_->_leaf);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->result = _data_->info_table;
	_g_variant_unref0 (_data_->val);
	_g_free0 (_data_->_leaf);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_hash_table_unref0 (_data_->info_table);
	_g_variant_unref0 (_data_->val);
	_g_free0 (_data_->_leaf);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel26_display_real_set_brightness_data_free (gpointer _data) {
	Kernel26DisplaySetBrightnessData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (Kernel26DisplaySetBrightnessData, _data_);
}


static void kernel26_display_real_set_brightness (FreeSmartphoneDeviceDisplay* base, gint brightness, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	Kernel26Display * self;
	Kernel26DisplaySetBrightnessData* _data_;
	Kernel26Display* _tmp0_;
	gint _tmp1_;
	self = (Kernel26Display*) base;
	_data_ = g_slice_new0 (Kernel26DisplaySetBrightnessData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel26_display_real_set_brightness);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel26_display_real_set_brightness_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = brightness;
	_data_->brightness = _tmp1_;
	kernel26_display_real_set_brightness_co (_data_);
}


static void kernel26_display_real_set_brightness_finish (FreeSmartphoneDeviceDisplay* base, GAsyncResult* _res_, GError** error) {
	Kernel26DisplaySetBrightnessData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean kernel26_display_real_set_brightness_co (Kernel26DisplaySetBrightnessData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->brightness;
	_data_->_tmp1_ = 0;
	_data_->_tmp1_ = _kernel26_display_percentToValue (_data_->self, _data_->_tmp0_);
	_kernel26_display_setBrightness (_data_->self, _data_->_tmp1_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel26_display_real_get_brightness_data_free (gpointer _data) {
	Kernel26DisplayGetBrightnessData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (Kernel26DisplayGetBrightnessData, _data_);
}


static void kernel26_display_real_get_brightness (FreeSmartphoneDeviceDisplay* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	Kernel26Display * self;
	Kernel26DisplayGetBrightnessData* _data_;
	Kernel26Display* _tmp0_;
	self = (Kernel26Display*) base;
	_data_ = g_slice_new0 (Kernel26DisplayGetBrightnessData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel26_display_real_get_brightness);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel26_display_real_get_brightness_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	kernel26_display_real_get_brightness_co (_data_);
}


static gint kernel26_display_real_get_brightness_finish (FreeSmartphoneDeviceDisplay* base, GAsyncResult* _res_, GError** error) {
	gint result;
	Kernel26DisplayGetBrightnessData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static gboolean kernel26_display_real_get_brightness_co (Kernel26DisplayGetBrightnessData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = 0;
	_data_->_tmp0_ = _kernel26_display_getBrightness (_data_->self);
	_data_->result = _data_->_tmp0_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel26_display_real_get_backlight_power_data_free (gpointer _data) {
	Kernel26DisplayGetBacklightPowerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (Kernel26DisplayGetBacklightPowerData, _data_);
}


static void kernel26_display_real_get_backlight_power (FreeSmartphoneDeviceDisplay* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	Kernel26Display * self;
	Kernel26DisplayGetBacklightPowerData* _data_;
	Kernel26Display* _tmp0_;
	self = (Kernel26Display*) base;
	_data_ = g_slice_new0 (Kernel26DisplayGetBacklightPowerData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel26_display_real_get_backlight_power);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel26_display_real_get_backlight_power_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	kernel26_display_real_get_backlight_power_co (_data_);
}


static gboolean kernel26_display_real_get_backlight_power_finish (FreeSmartphoneDeviceDisplay* base, GAsyncResult* _res_, GError** error) {
	gboolean result;
	Kernel26DisplayGetBacklightPowerData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static gboolean kernel26_display_real_get_backlight_power_co (Kernel26DisplayGetBacklightPowerData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->sysfsnode;
	_data_->_tmp1_ = g_strconcat (_data_->_tmp0_, "/bl_power", NULL);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = fso_framework_file_handling_read (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = 0;
	_data_->_tmp5_ = atoi (_data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_ == 0;
	_g_free0 (_data_->_tmp4_);
	_g_free0 (_data_->_tmp2_);
	_data_->result = _data_->_tmp6_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel26_display_real_set_backlight_power_data_free (gpointer _data) {
	Kernel26DisplaySetBacklightPowerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (Kernel26DisplaySetBacklightPowerData, _data_);
}


static void kernel26_display_real_set_backlight_power (FreeSmartphoneDeviceDisplay* base, gboolean power, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	Kernel26Display * self;
	Kernel26DisplaySetBacklightPowerData* _data_;
	Kernel26Display* _tmp0_;
	gboolean _tmp1_;
	self = (Kernel26Display*) base;
	_data_ = g_slice_new0 (Kernel26DisplaySetBacklightPowerData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel26_display_real_set_backlight_power);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel26_display_real_set_backlight_power_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = power;
	_data_->power = _tmp1_;
	kernel26_display_real_set_backlight_power_co (_data_);
}


static void kernel26_display_real_set_backlight_power_finish (FreeSmartphoneDeviceDisplay* base, GAsyncResult* _res_, GError** error) {
	Kernel26DisplaySetBacklightPowerData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean kernel26_display_real_set_backlight_power_co (Kernel26DisplaySetBacklightPowerData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->power;
	_kernel26_display_setBacklightPower (_data_->self, _data_->_tmp0_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel26_display_class_init (Kernel26DisplayClass * klass) {
	kernel26_display_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (Kernel26DisplayPrivate));
	FSO_FRAMEWORK_ABSTRACT_OBJECT_CLASS (klass)->repr = kernel26_display_real_repr;
	G_OBJECT_CLASS (klass)->finalize = kernel26_display_finalize;
}


static void kernel26_display_free_smartphone_device_display_interface_init (FreeSmartphoneDeviceDisplayIface * iface) {
	kernel26_display_free_smartphone_device_display_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_brightness = (void (*)(FreeSmartphoneDeviceDisplay*, gint, GError**)) kernel26_display_real_set_brightness;
	iface->set_brightness_finish = kernel26_display_real_set_brightness_finish;
	iface->get_brightness = (gint (*)(FreeSmartphoneDeviceDisplay*, GError**)) kernel26_display_real_get_brightness;
	iface->get_brightness_finish = kernel26_display_real_get_brightness_finish;
	iface->get_backlight_power = (gboolean (*)(FreeSmartphoneDeviceDisplay*, GError**)) kernel26_display_real_get_backlight_power;
	iface->get_backlight_power_finish = kernel26_display_real_get_backlight_power_finish;
	iface->set_backlight_power = (void (*)(FreeSmartphoneDeviceDisplay*, gboolean, GError**)) kernel26_display_real_set_backlight_power;
	iface->set_backlight_power_finish = kernel26_display_real_set_backlight_power_finish;
}


static void kernel26_display_free_smartphone_info_interface_init (FreeSmartphoneInfoIface * iface) {
	kernel26_display_free_smartphone_info_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_info = (GHashTable* (*)(FreeSmartphoneInfo*, GError**)) kernel26_display_real_get_info;
	iface->get_info_finish = kernel26_display_real_get_info_finish;
}


static void kernel26_display_instance_init (Kernel26Display * self) {
	self->priv = KERNEL26_DISPLAY_GET_PRIVATE (self);
	self->priv->smoothInProgress = FALSE;
	self->priv->fb_fd = -1;
}


static void kernel26_display_finalize (GObject* obj) {
	Kernel26Display * self;
	self = KERNEL26_DISPLAY (obj);
	_g_object_unref0 (self->priv->subsystem);
	_g_free0 (self->priv->sysfsnode);
	G_OBJECT_CLASS (kernel26_display_parent_class)->finalize (obj);
}


GType kernel26_display_get_type (void) {
	return kernel26_display_type_id;
}


GType kernel26_display_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (Kernel26DisplayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kernel26_display_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Kernel26Display), 0, (GInstanceInitFunc) kernel26_display_instance_init, NULL };
	static const GInterfaceInfo free_smartphone_device_display_info = { (GInterfaceInitFunc) kernel26_display_free_smartphone_device_display_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo free_smartphone_info_info = { (GInterfaceInitFunc) kernel26_display_free_smartphone_info_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	kernel26_display_type_id = g_type_module_register_type (module, FSO_FRAMEWORK_TYPE_ABSTRACT_OBJECT, "Kernel26Display", &g_define_type_info, 0);
	g_type_module_add_interface (module, kernel26_display_type_id, FREE_SMARTPHONE_DEVICE_TYPE_DISPLAY, &free_smartphone_device_display_info);
	g_type_module_add_interface (module, kernel26_display_type_id, FREE_SMARTPHONE_TYPE_INFO, &free_smartphone_info_info);
	return kernel26_display_type_id;
}


gchar* fso_factory_function (FsoFrameworkSubsystem* subsystem, GError** error) {
	gchar* result = NULL;
	FsoFrameworkSmartKeyFile* _tmp0_;
	FsoFrameworkSmartKeyFile* _tmp1_;
	FsoFrameworkSmartKeyFile* config;
	gchar* _tmp2_ = NULL;
	gchar* sysfs_root;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* dev_root;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	GDir* _tmp7_ = NULL;
	GDir* dir;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* entry;
	gchar* _tmp19_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (subsystem != NULL, NULL);
	_tmp0_ = fso_framework_theConfig;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	config = _tmp1_;
	_tmp2_ = fso_framework_smart_key_file_stringValue (config, "cornucopia", "sysfs_root", "/sys");
	sysfs_root = _tmp2_;
	_tmp3_ = g_strdup_printf ("%s/class/backlight", sysfs_root);
	_g_free0 (sys_class_backlight);
	sys_class_backlight = _tmp3_;
	_tmp4_ = fso_framework_smart_key_file_stringValue (config, "cornucopia", "dev_root", "/dev");
	dev_root = _tmp4_;
	_tmp5_ = g_strdup_printf ("%s/fb0", dev_root);
	_g_free0 (dev_fb0);
	dev_fb0 = _tmp5_;
	_tmp6_ = sys_class_backlight;
	_tmp7_ = g_dir_open (_tmp6_, (guint) 0, &_inner_error_);
	dir = _tmp7_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (dev_root);
		_g_free0 (sysfs_root);
		_g_object_unref0 (config);
		return NULL;
	}
	_tmp8_ = g_dir_read_name (dir);
	_tmp9_ = g_strdup (_tmp8_);
	entry = _tmp9_;
	while (TRUE) {
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_ = NULL;
		gchar* filename;
		FsoFrameworkSubsystem* _tmp14_;
		const gchar* _tmp15_;
		Kernel26Display* _tmp16_;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_;
		_tmp10_ = entry;
		if (!(_tmp10_ != NULL)) {
			break;
		}
		_tmp11_ = sys_class_backlight;
		_tmp12_ = entry;
		_tmp13_ = g_build_filename (_tmp11_, _tmp12_, NULL);
		filename = _tmp13_;
		_tmp14_ = subsystem;
		_tmp15_ = filename;
		_tmp16_ = kernel26_display_new (_tmp14_, _tmp15_);
		instances = g_list_append (instances, _tmp16_);
		_tmp17_ = g_dir_read_name (dir);
		_tmp18_ = g_strdup (_tmp17_);
		_g_free0 (entry);
		entry = _tmp18_;
		_g_free0 (filename);
	}
	_tmp19_ = g_strdup (KERNEL26_DISPLAY_PLUGIN_NAME);
	result = _tmp19_;
	_g_free0 (entry);
	_g_dir_close0 (dir);
	_g_free0 (dev_root);
	_g_free0 (sysfs_root);
	_g_object_unref0 (config);
	return result;
}


void fso_register_function (GTypeModule* module) {
	FsoFrameworkLogger* _tmp0_;
	g_return_if_fail (module != NULL);
	kernel26_display_register_type (module);
	_tmp0_ = fso_framework_theLogger;
	fso_framework_logger_debug (_tmp0_, "fsodevice.kernel26_display fso_register_function()");
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



