import gtk
import gobject



#
# Class for a simplified list box.
#
class ListBox(gtk.ScrolledWindow):

    def __init__(self, headers):

        self.__handler = None


        gtk.ScrolledWindow.__init__(self)
        self.set_shadow_type(gtk.SHADOW_ETCHED_IN)
        self.set_policy(gtk.POLICY_NEVER, gtk.POLICY_AUTOMATIC)

        ncols = len(headers)
        types = [gobject.TYPE_STRING] * ncols
        self.__liststore = apply(gtk.ListStore, types)
        self.__list = gtk.TreeView(self.__liststore)
        self.__list.set_headers_visible(gtk.FALSE)
        self.__list.show()

        for i in xrange(ncols):
            self.__list.append_column(
                gtk.TreeViewColumn(headers[i], gtk.CellRendererText(), text=i))
        #self.add_with_viewport(self.__list)
        self.add(self.__list)


        self.__list.connect("cursor-changed", self.__on_cursor)



    def __on_cursor(self, src):

        row = src.get_cursor()[0][0]
        if (self.__handler): apply(self.__handler, [self, row])




    def connect_select_row(self, handler):

        self.__handler = handler



    def set_headers_visible(self, value):

        self.__list.set_headers_visible(value)



    def set_cursor(self, row):

        self.__list.set_cursor(row, None, gtk.FALSE)



    def get_cursor(self):

        row, col = self.__list.get_cursor()
        return row[0]



    def clear(self):

        self.__liststore.clear()



    def append(self, *args):

        data = []
        col = 0
        for a in args:
            data += [col, a]
            col += 1
        iter = self.__liststore.append()
        apply(self.__liststore.set, [iter] + data)



    def set(self, row, *args):

        data = []
        col = 0
        for a in args:
            data += [col, a]
            col += 1
        iter = self.__liststore.get_iter((row,))
        apply(self.__liststore.set, [iter] + data)
