/*
  gmorgan - a ryhthm station software

  gmorgan.varios.C  -  Miscelaneous functions.
  Copyright (C) 2003-2004 Josep Andreu (Holborn)
  Author: Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License
(version2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

/* Alsa sequencer functions  by Matthias Nagorni 
   modifies by Josep Andreu

*/

#include <iostream>
using namespace std;

#include "GMorgan.h"
#include <FL/fl_message.H>
#include <FL/Fl_Help_Dialog.H>

void

GMO::BorraControles(int Patron)
{

int i;
for (i=1; i<1000; i++)
{
Rt[Patron].EvMidCon[i].pista = 0;
Rt[Patron].EvMidCon[i].posicion = 0;
Rt[Patron].EvMidCon[i].controlador = 0;
Rt[Patron].EvMidCon[i].valor = 0;
}
};

void
GMO::ControlesPon(int Patron)
{
BorraControles(Patron);
int k,i,j;
int NumEvMidCon = 1;
for(k=1; k<=7; k++)
{
for(i=1; i<=31; i++)
 {
for(j=1; j<=128; j++)
 {
if(Ectrl[k][i][j] != 0)
{
Rt[Patron].EvMidCon[NumEvMidCon].pista = k;
Rt[Patron].EvMidCon[NumEvMidCon].controlador = i;
Rt[Patron].EvMidCon[NumEvMidCon].posicion = j;
Rt[Patron].EvMidCon[NumEvMidCon].valor = Ectrl[k][i][j];
NumEvMidCon++;
}
}
}
}
};


/*
void
GMO::newsong()
{

 int i;
 memset (TemT, 0, sizeof TemT);
 TemT[1].bar = 1;
 TemT[1].black = 1;
 TemT[1].tempo = 120;
 bzero(NombreSong, sizeof(NombreSong));
 TempoSong=120;
 SNomi=4;
 InvMode=1;
 for(i=1; i<=128; i++)
       {
         bzero(S[i].ch1,sizeof(S[i].ch1));
         bzero(S[i].ch2,sizeof(S[i].ch2));
         bzero(S[i].ch3,sizeof(S[i].ch3));
         bzero(S[i].ch4,sizeof(S[i].ch4));
         S[i].a=0;
         S[i].b=0;
         S[i].c=0;
         S[i].d=0;
         S[i].e=0;
         S[i].f=0;
         S[i].g=0;
         S[i].h=0;
         S[i].fin=0;
         S[i].ar8=0;
         S[i].ar16=0;
         bzero(S[i].go_to,sizeof(S[i].go_to));
         S[i].times=0;
         bzero(S[i].go_af,sizeof(S[i].go_af));
         S[i].atimes=0;
         S[i].pattern=0;
        }         
};
*/

void
GMO::patternclear(int patron)
{

int i,j,k;

i=patron;


  strcpy(Rt[i].Nom,"Empty");
  strcpy(Rt[i].Nfile,"-");
  Rt[i].bars=1;
  Rt[i].blackn=4;
  Rt[i].octavate=0;
  Rt[i].octavate4=0;
  Rt[i].bassstlt=0;
  Rt[i].acc1stlt=0;
  Rt[i].acc2stlt=0;
  Rt[i].acc3stlt=0;
  Rt[i].acc4stlt=0;
  Rt[i].acc5stlt=0;
  Rt[i].acc2mode=1;
  Rt[i].acc3mode=1;
  Rt[i].acc4mode=1;
  Rt[i].acc5mode=1;
  Rt[i].terceras = 0;
  Rt[i].sextas = 0;
  Rt[i].terceras4 = 0;
  Rt[i].sextas4 = 0;
  Rt[i].swing=0;
  Rt[i].dron=1;
  Rt[i].drpc=0;
  Rt[i].drvol=100;
  Rt[i].drpan=64;
  Rt[i].drrev=0;
  Rt[i].drcho=0;
  Rt[i].drocta=0;
  Rt[i].drBankM=1;
  Rt[i].drpon=0;
  Rt[i].drptime=0;
  Rt[i].basson=1;
  Rt[i].basspc=32;
  Rt[i].bassvol=100;
  Rt[i].basspan=64;
  Rt[i].bassrev=0;
  Rt[i].basscho=0;
  Rt[i].bassocta=0;
  Rt[i].bassBankM=0;
  Rt[i].basspon=0;
  Rt[i].bassptime=0;
  Rt[i].acc1on=0;
  Rt[i].acc1pc=0;
  Rt[i].acc1vol=100;
  Rt[i].acc1pan=64;
  Rt[i].acc1rev=0;
  Rt[i].acc1cho=0;
  Rt[i].acc1octa=0;
  Rt[i].acc1BankM=0;
  Rt[i].acc1pon=0;
  Rt[i].acc1ptime=0;
  Rt[i].acc2on=0;
  Rt[i].acc2pc=24;
  Rt[i].acc2vol=100;
  Rt[i].acc2pan=64;
  Rt[i].acc2rev=0;
  Rt[i].acc2cho=0;
  Rt[i].acc2octa=0;
  Rt[i].acc2BankM=0;
  Rt[i].acc2pon=0;
  Rt[i].acc2ptime=0;
  Rt[i].acc3on=0;
  Rt[i].acc3pc=24;
  Rt[i].acc3vol=100;
  Rt[i].acc3pan=64;
  Rt[i].acc3rev=0;
  Rt[i].acc3cho=0;
  Rt[i].acc3octa=0;
  Rt[i].acc3BankM=0;
  Rt[i].acc3pon=0;
  Rt[i].acc3ptime=0;
  Rt[i].acc4on=0;
  Rt[i].acc4pc=24;
  Rt[i].acc4vol=100;
  Rt[i].acc4pan=64;
  Rt[i].acc4rev=0;
  Rt[i].acc4cho=0;
  Rt[i].acc4octa=0;
  Rt[i].acc4BankM=0;
  Rt[i].acc4pon=0;
  Rt[i].acc4ptime=0;
  Rt[i].acc5on=0;
  Rt[i].acc5pc=24;
  Rt[i].acc5vol=100;
  Rt[i].acc5pan=64;
  Rt[i].acc5rev=0;
  Rt[i].acc5cho=0;
  Rt[i].acc5octa=0;
  Rt[i].acc5BankM=0;
  Rt[i].acc5pon=0;
  Rt[i].acc5ptime=0;
  

PonCeroDrum();
ClearEvDrum(i);


for (j=0; j<3; j++)
{
for (k=0; k<129; k++)
{
  Rt[i].basn[j][k]=0;
if (j<2) Rt[i].acc1n[j][k]=0;
  Rt[i].acc2n[j][k]=0;
  Rt[i].acc3n[j][k]=0;
  Rt[i].acc4n[j][k]=0;
  Rt[i].acc5n[j][k]=0;

}
}


PonCeroControl();
BorraControles(i);

for(k=1; k<1000; k++)
{

Rt[i].EvMidCon[k].pista = 0;
Rt[i].EvMidCon[k].controlador = 0;
Rt[i].EvMidCon[k].posicion= 0;
Rt[i].EvMidCon[k].valor = 0;
}



};


void

GMO::PonControles(int Patron)
{
int k;

PonCeroControl();

for(k=1; k<1000; k++)
{

Ectrl[Rt[Patron].EvMidCon[k].pista][Rt[Patron].EvMidCon[k].controlador][Rt[Patron].EvMidCon[k].posicion]=
Rt[Patron].EvMidCon[k].valor;
}

};


void

GMO::MiraGuia()
{
cout << "rlv MiraGuia " << endl;
fl_message("rlv: MiraGuia"); 
int i;
int ActCompas = ncompas + 1;
for(i=1; i<200; i++)

{ 

     if (GP[i].bar == 0) break;
     if (GP[i].bar == ActCompas) 

      {
       sp = GP[i].pattern;
       sposi = 0;
       cambiapat = 1;
       MeteMixerMidi(sp);
       break;
      }

      
}

};


void
GMO::BuscaSkindir()
{
int i,k;

k=0;


for (i=strlen(SkinFilename); i>=0; i--)

{ 
  if (SkinFilename[i] == '/')  
        {
          k = i;
          break;
        }

}

for (i=0; i<=k; i++) Skindir[i]=SkinFilename[i];


};



void
GMO::panico (int data, int canales)
{

  int i, j;
  for (i=0; i<=POLY; i++) 
	  {
  		note_active[i] = 0;
  		gate[i] = 0;
  	   }


  for (j = 0; j <= canales; j++)
	  {
	  enviocontrol (0, 123, j);
          if (data > 0 ) enviocontrol (0, 121, j);
  	  }

};


int
GMO::BuscaM(int i) {

int k=0;

 while(k<=128)
 
  {
   k++;
   if ((i==1) && (S[k].a == 1)) return(k);
   if ((i==2) && (S[k].b == 1)) return(k);
   if ((i==3) && (S[k].c == 1)) return(k);
   if ((i==4) && (S[k].d == 1)) return(k);
   if ((i==5) && (S[k].e == 1)) return(k);
   if ((i==6) && (S[k].f == 1)) return(k);
   if ((i==7) && (S[k].g == 1)) return(k);
   if ((i==8) && (S[k].h == 1)) return(k);

  }
   return(nb);

};
   

void
GMO::ActualizaPattern()
{


int i,j;

for(i=1; i<=61; i++)
{

  for(j=1; j<=128; j++)
   {

      if (Edr[i][j]!=0)

        {        

          if (veloplus[i]!=0)
  
            {
              
              Edr[i][j] +=veloplus[i];

              if (Edr[i][j] < 0 )  Edr[i][j] = 0;
              if (Edr[i][j] > 127) Edr[i][j] = 127; 



            }
        }

  }


}
};


void

GMO::make_GHelp()
{


if (strlen(HelpFilename)<2)
{
 fl_message(gettext("Please configure your settings. please read the README file for the correct paths and filenames"));
 return;
}

Fl_Help_Dialog *visor = new Fl_Help_Dialog();
visor->load(HelpFilename);
visor->position(1,1);
visor->show();

};

int
GMO::CalculaBanco(int i)
{
int banco;
  banco = (127 * BankLSB[i]) + BankMSB[i]; 
  if (banco<129) return(banco); 
  return(BankMSB[i]);

};



void

GMO::PonCeroDrum()
{

memset(Edr, 0 , sizeof Edr);

};


void

GMO::PonCeroControl()
{
memset(Ectrl, 0 , sizeof Ectrl);

};

void
GMO::PonDrumTemp(int i)
{

int k;

PonCeroDrum();

for (k=0; k<1000; k++)
{
 if (Rt[i].EvDr[k].valor != 0)

    {
     Edr[Rt[i].EvDr[k].nota][Rt[i].EvDr[k].posicion] = Rt[i].EvDr[k].valor;
    }
}
};


void
GMO::PonTempDrum(int i)
{

int k,j,num;

ClearEvDrum(i);
num = 0;

for(k=1; k<=61; k++)
 {
for(j=1; j<=128; j++)
 {
 if (Edr[k][j] != 0)
    {
      Rt[i].EvDr[num].posicion = j;
      Rt[i].EvDr[num].nota = k;
      Rt[i].EvDr[num].valor = Edr[k][j];
      num++;
    }

 }
 }

};


void
GMO::ClearEvDrum(int i)
{
int k;

for(k=1; k<1000; k++)
{
 Rt[i].EvDr[k].posicion = 0;
 Rt[i].EvDr[k].nota = 0;
 Rt[i].EvDr[k].valor = 0;
}



};


void
GMO::UsaTempoTrack()
{

int i;

for (i=1; i<200; i++)
 {
   if (TemT[i].bar == 0) break;
   if ((TemT[i].bar == (ncompas+1)) && (TemT[i].black == (negra+1)))
        bpm = TemT[i].tempo * 2;
        set_tempo();
        
 }
};

void
GMO::BorraTiempo(int i)
{

int j;

for(j=i; j<199; j++)

 {
   TemT[j].bar = TemT[j+1].bar;
   TemT[j].black = TemT[j+1].black;
   TemT[j].tempo = TemT[j+1].tempo;
 }

};

void
GMO::InsertaTiempo(int i)
{

int j;


for (j=198; j>=i; j--)
{
   TemT[j+1].bar = TemT[j].bar;
   TemT[j+1].black = TemT[j].black;
   TemT[j+1].tempo = TemT[j].tempo;
}
};

 
void
GMO::BuscaTempo()
{

int i;

for (i=1; i<200; i++)
{
   if (TemT[i].bar == 0) break;
   if (TemT[i].bar == nb)
         {
           bpm = TemT[i].tempo * 2;
           break;
         }
}
};


void
GMO::copy1(int cc)
{

int j,k;
int pcc = ((cc-1) * (Rt[sp].blackn * 4))+1;
int i = ((sbar-1) * (Rt[sp].blackn * 4))+1;

for (j=0; j<=Rt[sp].blackn * 4; j++)
{
if (selcopy == 0)
{
 for (k=1; k<=61; k++) Edr[k][i+j] = Edr[k][pcc+j];
 PonTempDrum(sp);
}

if ((selcopy==3) || (selcopy==0))
{
Rt[sp].basn[0][i+j] = Rt[sp].basn[0][pcc+j];
Rt[sp].basn[1][i+j] = Rt[sp].basn[1][pcc+j];
Rt[sp].basn[2][i+j] = Rt[sp].basn[2][pcc+j];
}

if ((selcopy==2) || (selcopy ==0))
{
Rt[sp].acc2n[0][i+j] = Rt[sp].acc2n[0][pcc+j];
Rt[sp].acc2n[1][i+j] = Rt[sp].acc2n[1][pcc+j];
Rt[sp].acc2n[2][i+j] = Rt[sp].acc2n[2][pcc+j];
}

if ((selcopy==8) || (selcopy ==0))
{
Rt[sp].acc4n[0][i+j] = Rt[sp].acc4n[0][pcc+j];
Rt[sp].acc4n[1][i+j] = Rt[sp].acc4n[1][pcc+j];
Rt[sp].acc4n[2][i+j] = Rt[sp].acc4n[2][pcc+j];
}

if ((selcopy==6) || (selcopy ==0))
{
Rt[sp].acc3n[0][i+j] = Rt[sp].acc3n[0][pcc+j];
Rt[sp].acc3n[1][i+j] = Rt[sp].acc3n[1][pcc+j];
Rt[sp].acc3n[2][i+j] = Rt[sp].acc3n[2][pcc+j];
}

if ((selcopy==9) || (selcopy ==0))
{
Rt[sp].acc5n[0][i+j] = Rt[sp].acc5n[0][pcc+j];
Rt[sp].acc5n[1][i+j] = Rt[sp].acc5n[1][pcc+j];
Rt[sp].acc5n[2][i+j] = Rt[sp].acc5n[2][pcc+j];
}


if ((selcopy==1) || (selcopy==0))
{
Rt[sp].acc1n[0][i+j] = Rt[sp].acc1n[0][pcc+j];
Rt[sp].acc1n[1][i+j] = Rt[sp].acc1n[1][pcc+j];
}

}
};

void
GMO::copy2(int cc,int gg)
{
int j,k;
int pcc = ((cc-1) * (Rt[sp].blackn * 4))+1;
int i = ((gg-1) * (Rt[sp].blackn * 4))+1;

for (j=0; j<=Rt[sp].blackn * 4; j++)
{

for (k=1; k<=61; k++)
{
if ((selcopy==4) && (sde == k)) Edr[k][i+j] = Edr[k][pcc+j];
if ((selcopy == 0) || (selcopy == 5)) Edr[k][i+j] = Edr[k][pcc+j];
if (k<32)
{
if ((selcopy==14) && (sdec == k)) Ectrl[canaledit][k][i+j] =
Ectrl[canaledit][k][pcc+j];
if ((selcopy == 0) || (selcopy == 15)) Ectrl[canaledit][k][i+j] =
Ectrl[canaledit][k][pcc+j];
}
}  
}

};
