/* Scanner.c generated by valac 0.16.1, the Vala compiler
 * generated from Scanner.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <cstuff.h>
#include <float.h>
#include <math.h>


#define DVB_TYPE_SCANNER (dvb_scanner_get_type ())
#define DVB_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNER, DVBScanner))
#define DVB_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNER, DVBScannerClass))
#define DVB_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNER))
#define DVB_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNER))
#define DVB_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNER, DVBScannerClass))

typedef struct _DVBScanner DVBScanner;
typedef struct _DVBScannerClass DVBScannerClass;
typedef struct _DVBScannerPrivate DVBScannerPrivate;

#define DVB_TYPE_SCANNED_ITEM (dvb_scanned_item_get_type ())
#define DVB_SCANNED_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNED_ITEM, DVBScannedItem))
#define DVB_SCANNED_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNED_ITEM, DVBScannedItemClass))
#define DVB_IS_SCANNED_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNED_ITEM))
#define DVB_IS_SCANNED_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNED_ITEM))
#define DVB_SCANNED_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNED_ITEM, DVBScannedItemClass))

typedef struct _DVBScannedItem DVBScannedItem;
typedef struct _DVBScannedItemClass DVBScannedItemClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define __g_queue_free__gst_structure_free0_0(var) ((var == NULL) ? NULL : (var = (_g_queue_free__gst_structure_free0_ (var), NULL)))
#define _gst_structure_free0(var) ((var == NULL) ? NULL : (var = (gst_structure_free (var), NULL)))
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_IO_TYPE_CHANNEL_LIST_WRITER (dvb_io_channel_list_writer_get_type ())
#define DVB_IO_CHANNEL_LIST_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_IO_TYPE_CHANNEL_LIST_WRITER, DVBioChannelListWriter))
#define DVB_IO_CHANNEL_LIST_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_IO_TYPE_CHANNEL_LIST_WRITER, DVBioChannelListWriterClass))
#define DVB_IO_IS_CHANNEL_LIST_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_IO_TYPE_CHANNEL_LIST_WRITER))
#define DVB_IO_IS_CHANNEL_LIST_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_IO_TYPE_CHANNEL_LIST_WRITER))
#define DVB_IO_CHANNEL_LIST_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_IO_TYPE_CHANNEL_LIST_WRITER, DVBioChannelListWriterClass))

typedef struct _DVBioChannelListWriter DVBioChannelListWriter;
typedef struct _DVBioChannelListWriterClass DVBioChannelListWriterClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _DVBScanner {
	GObject parent_instance;
	DVBScannerPrivate * priv;
	DVBChannelList* channels;
	GstElement* pipeline;
	GQueue* frequencies;
	GstStructure* current_tuning_params;
	GeeHashSet* scanned_frequencies;
};

struct _DVBScannerClass {
	GObjectClass parent_class;
	void (*prepare) (DVBScanner* self);
	DVBScannedItem* (*get_scanned_item) (DVBScanner* self, const GstStructure* structure);
	DVBChannel* (*get_new_channel) (DVBScanner* self);
	void (*add_values_from_structure_to_channel) (DVBScanner* self, const GstStructure* delivery, DVBChannel* channel);
	void (*add_scanning_data_from_string) (DVBScanner* self, const gchar* line);
};

struct _DVBScannerPrivate {
	DVBDevice* _Device;
	GeeArrayList* new_channels;
	GStaticRecMutex __lock_new_channels;
	GSource* check_for_lock_source;
	GSource* wait_for_tables_source;
	GSource* start_scan_source;
	gboolean nit_arrived;
	gboolean sdt_arrived;
	gboolean pat_arrived;
	gboolean pmt_arrived;
	gboolean locked;
	GMainContext* context;
	GMainLoop* loop;
	GThread* worker_thread;
	gboolean running;
	guint bus_watch_id;
};


static gpointer dvb_scanner_parent_class = NULL;
static DVBLoggingLogger* dvb_scanner_log;
static DVBLoggingLogger* dvb_scanner_log = NULL;

GType dvb_scanner_get_type (void) G_GNUC_CONST;
GType dvb_scanned_item_get_type (void) G_GNUC_CONST;
GType dvb_channel_get_type (void) G_GNUC_CONST;
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
GType dvb_device_get_type (void) G_GNUC_CONST;
#define DVB_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_SCANNER, DVBScannerPrivate))
enum  {
	DVB_SCANNER_DUMMY_PROPERTY,
	DVB_SCANNER_DEVICE,
	DVB_SCANNER_CHANNELS
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
static void _gst_structure_free0_ (gpointer var);
static void _g_queue_free__gst_structure_free0_ (GQueue* self);
#define DVB_SCANNER_BASE_PIDS "16:17"
#define DVB_SCANNER_PIPELINE_TEMPLATE "dvbsrc name=dvbsrc adapter=%u frontend=%u pids=%s stats-reporting-inte" \
"rval=100 ! mpegtsparse ! fakesink silent=true"
void dvb_scanner_prepare (DVBScanner* self);
static void dvb_scanner_real_prepare (DVBScanner* self);
DVBScannedItem* dvb_scanner_get_scanned_item (DVBScanner* self, const GstStructure* structure);
static DVBScannedItem* dvb_scanner_real_get_scanned_item (DVBScanner* self, const GstStructure* structure);
DVBChannel* dvb_scanner_get_new_channel (DVBScanner* self);
static DVBChannel* dvb_scanner_real_get_new_channel (DVBScanner* self);
void dvb_scanner_add_values_from_structure_to_channel (DVBScanner* self, const GstStructure* delivery, DVBChannel* channel);
static void dvb_scanner_real_add_values_from_structure_to_channel (DVBScanner* self, const GstStructure* delivery, DVBChannel* channel);
void dvb_scanner_add_scanning_data_from_string (DVBScanner* self, const gchar* line);
static void dvb_scanner_real_add_scanning_data_from_string (DVBScanner* self, const gchar* line);
void dvb_scanner_Run (DVBScanner* self, GError** error);
static void* dvb_scanner_worker (DVBScanner* self);
static gpointer _dvb_scanner_worker_gthread_func (gpointer self);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
DVBChannelList* dvb_channel_list_new (GFile* channels);
DVBChannelList* dvb_channel_list_construct (GType object_type, GFile* channels);
DVBDevice* dvb_scanner_get_Device (DVBScanner* self);
guint dvb_device_get_Adapter (DVBDevice* self);
guint dvb_device_get_Frontend (DVBDevice* self);
gboolean dvb_scanner_bus_watch_func (DVBScanner* self, GstBus* bus, GstMessage* message);
static gboolean _dvb_scanner_bus_watch_func_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self);
void dvb_scanner_queue_start_scan (DVBScanner* self);
void dvb_scanner_Destroy (DVBScanner* self, GError** error);
void dvb_scanner_do_destroy (DVBScanner* self);
void dvb_scanner_destroy_start_scan_source (DVBScanner* self);
void dvb_scanner_remove_check_for_lock_timeout (DVBScanner* self);
void dvb_scanner_remove_wait_for_tables_timeout (DVBScanner* self);
void dvb_scanner_clear_and_reset_all (DVBScanner* self);
void dvb_channel_list_clear (DVBChannelList* self);
gboolean dvb_scanner_WriteAllChannelsToFile (DVBScanner* self, const gchar* path, GError** error);
DVBioChannelListWriter* dvb_io_channel_list_writer_new (GFile* file);
DVBioChannelListWriter* dvb_io_channel_list_writer_construct (GType object_type, GFile* file);
GType dvb_io_channel_list_writer_get_type (void) G_GNUC_CONST;
void dvb_io_channel_list_writer_write (DVBioChannelListWriter* self, DVBChannel* channel, GError** error);
gboolean dvb_io_channel_list_writer_close (DVBioChannelListWriter* self, GError** error);
gboolean dvb_scanner_WriteChannelsToFile (DVBScanner* self, guint* channel_sids, int channel_sids_length1, const gchar* path, GError** error);
DVBChannel* dvb_channel_list_get_channel (DVBChannelList* self, guint sid);
void dvb_logging_logger_warning (DVBLoggingLogger* self, const gchar* format, ...);
gboolean dvb_scanner_AddScanningDataFromFile (DVBScanner* self, const gchar* path, GError** error);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
gboolean dvb_utils_is_readable_file (GFile* file);
void dvb_scanner_clear_frequencies (DVBScanner* self);
void dvb_scanner_add_structure_to_scan (DVBScanner* self, GstStructure* structure);
guint dvb_scanned_item_get_Frequency (DVBScannedItem* self);
gboolean dvb_scanner_start_scan (DVBScanner* self);
void dvb_channel_list_remove (DVBChannelList* self, guint sid);
gboolean dvb_scanner_check_for_lock (DVBScanner* self);
static gboolean _dvb_scanner_check_for_lock_gsource_func (gpointer self);
gboolean dvb_scanner_wait_for_tables (DVBScanner* self);
static gboolean _dvb_scanner_start_scan_gsource_func (gpointer self);
void dvb_scanner_set_uint_property (GstElement* src, const GstStructure* params, const gchar* key);
void dvb_scanner_on_dvb_frontend_stats_structure (DVBScanner* self, const GstStructure* structure);
static gboolean _dvb_scanner_wait_for_tables_gsource_func (gpointer self);
void dvb_scanner_on_dvb_read_failure_structure (DVBScanner* self);
void dvb_scanner_on_pat_structure (DVBScanner* self, const GstStructure* structure);
void dvb_scanner_on_sdt_structure (DVBScanner* self, const GstStructure* structure);
gboolean dvb_channel_list_contains (DVBChannelList* self, guint sid);
void dvb_scanner_add_new_channel (DVBScanner* self, guint sid);
void dvb_channel_set_Scrambled (DVBChannel* self, gboolean value);
void dvb_channel_set_Name (DVBChannel* self, const gchar* value);
void dvb_channel_set_TransportStreamId (DVBChannel* self, guint value);
void dvb_channel_set_Network (DVBChannel* self, const gchar* value);
const gchar* dvb_channel_get_Name (DVBChannel* self);
gboolean dvb_channel_get_Scrambled (DVBChannel* self);
void dvb_scanner_on_nit_structure (DVBScanner* self, const GstStructure* structure);
void dvb_channel_set_LogicalChannelNumber (DVBChannel* self, guint* value);
void dvb_scanner_on_pmt_structure (DVBScanner* self, const GstStructure* structure);
void dvb_channel_set_VideoPID (DVBChannel* self, guint value);
GeeList* dvb_channel_get_AudioPIDs (DVBChannel* self);
gboolean dvb_channel_is_valid (DVBChannel* self);
gboolean dvb_channel_is_radio (DVBChannel* self);
gchar* dvb_channel_to_string (DVBChannel* self);
guint dvb_channel_get_Frequency (DVBChannel* self);
const gchar* dvb_channel_get_Network (DVBChannel* self);
void dvb_channel_set_Sid (DVBChannel* self, guint value);
void dvb_channel_list_add (DVBChannelList* self, DVBChannel* channel);
DVBScanner* dvb_scanner_construct (GType object_type);
static void dvb_scanner_set_Device (DVBScanner* self, DVBDevice* value);
DVBChannelList* dvb_scanner_get_Channels (DVBScanner* self);
static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__DOUBLE_DOUBLE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * dvb_scanner_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
guint dvb_scanned_item_hash (DVBScannedItem* o);
static guint _dvb_scanned_item_hash_ghash_func (gconstpointer key);
gboolean dvb_scanned_item_equal (DVBScannedItem* o1, DVBScannedItem* o2);
static gboolean _dvb_scanned_item_equal_gequal_func (gconstpointer a, gconstpointer b);
static void dvb_scanner_finalize (GObject* obj);
static void _vala_dvb_scanner_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_scanner_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _gst_structure_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gst_structure_free (var), NULL));
}


static void _g_queue_free__gst_structure_free0_ (GQueue* self) {
	g_queue_foreach (self, (GFunc) _gst_structure_free0_, NULL);
	g_queue_free (self);
}


/**
         * Setup the pipeline correctly
         */
static void dvb_scanner_real_prepare (DVBScanner* self) {
	g_critical ("Type `%s' does not implement abstract method `dvb_scanner_prepare'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void dvb_scanner_prepare (DVBScanner* self) {
	g_return_if_fail (self != NULL);
	DVB_SCANNER_GET_CLASS (self)->prepare (self);
}


/**
         * Use the frequency and possibly other data to
         * mark the tuning paramters as already used
         */
static DVBScannedItem* dvb_scanner_real_get_scanned_item (DVBScanner* self, const GstStructure* structure) {
	g_critical ("Type `%s' does not implement abstract method `dvb_scanner_get_scanned_item'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


DVBScannedItem* dvb_scanner_get_scanned_item (DVBScanner* self, const GstStructure* structure) {
	g_return_val_if_fail (self != NULL, NULL);
	return DVB_SCANNER_GET_CLASS (self)->get_scanned_item (self, structure);
}


/**
         * Return a new empty channel
         */
static DVBChannel* dvb_scanner_real_get_new_channel (DVBScanner* self) {
	g_critical ("Type `%s' does not implement abstract method `dvb_scanner_get_new_channel'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


DVBChannel* dvb_scanner_get_new_channel (DVBScanner* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return DVB_SCANNER_GET_CLASS (self)->get_new_channel (self);
}


/**
         * Retrieve the data from structure and add it to the Channel
         */
static void dvb_scanner_real_add_values_from_structure_to_channel (DVBScanner* self, const GstStructure* delivery, DVBChannel* channel) {
	g_critical ("Type `%s' does not implement abstract method `dvb_scanner_add_values_from_structure_to_channel'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void dvb_scanner_add_values_from_structure_to_channel (DVBScanner* self, const GstStructure* delivery, DVBChannel* channel) {
	g_return_if_fail (self != NULL);
	DVB_SCANNER_GET_CLASS (self)->add_values_from_structure_to_channel (self, delivery, channel);
}


/**
         * Called to parse a line from the initial tuning data
         */
static void dvb_scanner_real_add_scanning_data_from_string (DVBScanner* self, const gchar* line) {
	g_critical ("Type `%s' does not implement abstract method `dvb_scanner_add_scanning_data_from_string'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void dvb_scanner_add_scanning_data_from_string (DVBScanner* self, const gchar* line) {
	g_return_if_fail (self != NULL);
	DVB_SCANNER_GET_CLASS (self)->add_scanning_data_from_string (self, line);
}


/**
         * Start the scanner
         */
static gpointer _dvb_scanner_worker_gthread_func (gpointer self) {
	gpointer result;
	result = dvb_scanner_worker (self);
	return result;
}


static gboolean _dvb_scanner_bus_watch_func_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self) {
	gboolean result;
	result = dvb_scanner_bus_watch_func (self, bus, message);
	return result;
}


void dvb_scanner_Run (DVBScanner* self, GError** error) {
	gboolean _tmp0_;
	GMainContext* _tmp1_;
	GMainLoop* _tmp2_;
	DVBChannelList* _tmp8_;
	GstElement* _tmp23_;
	GstBus* _tmp24_ = NULL;
	GstBus* bus;
	GstBus* _tmp25_;
	GMainContext* _tmp26_;
	guint _tmp27_ = 0U;
	GstElement* _tmp28_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->running;
	if (_tmp0_) {
		return;
	}
	self->priv->running = TRUE;
	_tmp1_ = self->priv->context;
	_tmp2_ = g_main_loop_new (_tmp1_, FALSE);
	_g_main_loop_unref0 (self->priv->loop);
	self->priv->loop = _tmp2_;
	{
		GThread* _tmp3_;
		GThread* _tmp4_;
		_tmp3_ = g_thread_try_new ("Scanner-Worker-Thread", _dvb_scanner_worker_gthread_func, self, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			goto __catch151_g_error;
		}
		_g_thread_unref0 (self->priv->worker_thread);
		self->priv->worker_thread = _tmp4_;
	}
	goto __finally151;
	__catch151_g_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = dvb_scanner_log;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		dvb_logging_logger_error (_tmp5_, "Scanner.vala:163: Could not create thread: %s", _tmp7_);
		_g_error_free0 (e);
		return;
	}
	__finally151:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp8_ = dvb_channel_list_new (NULL);
	_g_object_unref0 (self->channels);
	self->channels = _tmp8_;
	{
		DVBDevice* _tmp9_;
		guint _tmp10_;
		guint _tmp11_;
		DVBDevice* _tmp12_;
		guint _tmp13_;
		guint _tmp14_;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		GstElement* _tmp17_ = NULL;
		GstElement* _tmp18_;
		GstElement* _tmp19_;
		_tmp9_ = self->priv->_Device;
		_tmp10_ = dvb_device_get_Adapter (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = self->priv->_Device;
		_tmp13_ = dvb_device_get_Frontend (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strdup_printf (DVB_SCANNER_PIPELINE_TEMPLATE, _tmp11_, _tmp14_, DVB_SCANNER_BASE_PIDS);
		_tmp16_ = _tmp15_;
		_tmp17_ = gst_parse_launch (_tmp16_, &_inner_error_);
		_tmp18_ = _tmp17_;
		_g_free0 (_tmp16_);
		_tmp19_ = _tmp18_;
		if (_inner_error_ != NULL) {
			goto __catch152_g_error;
		}
		_gst_object_unref0 (self->pipeline);
		self->pipeline = _tmp19_;
	}
	goto __finally152;
	__catch152_g_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp20_;
		GError* _tmp21_;
		const gchar* _tmp22_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp20_ = dvb_scanner_log;
		_tmp21_ = e;
		_tmp22_ = _tmp21_->message;
		dvb_logging_logger_error (_tmp20_, "Scanner.vala:174: Could not create pipeline: %s", _tmp22_);
		_g_error_free0 (e);
		return;
	}
	__finally152:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp23_ = self->pipeline;
	_tmp24_ = gst_element_get_bus (_tmp23_);
	bus = _tmp24_;
	_tmp25_ = bus;
	_tmp26_ = self->priv->context;
	_tmp27_ = gst_bus_add_watch_context (_tmp25_, _dvb_scanner_bus_watch_func_gst_bus_func, self, _tmp26_);
	self->priv->bus_watch_id = _tmp27_;
	_tmp28_ = self->pipeline;
	gst_element_set_state (_tmp28_, GST_STATE_READY);
	dvb_scanner_queue_start_scan (self);
	_gst_object_unref0 (bus);
}


/**
         * Abort scanning and cleanup
         */
void dvb_scanner_Destroy (DVBScanner* self, GError** error) {
	g_return_if_fail (self != NULL);
	dvb_scanner_do_destroy (self);
}


void dvb_scanner_do_destroy (DVBScanner* self) {
	DVBChannelList* _tmp0_;
	GMainLoop* _tmp1_;
	g_return_if_fail (self != NULL);
	dvb_scanner_destroy_start_scan_source (self);
	dvb_scanner_remove_check_for_lock_timeout (self);
	dvb_scanner_remove_wait_for_tables_timeout (self);
	dvb_scanner_clear_and_reset_all (self);
	_tmp0_ = self->channels;
	dvb_channel_list_clear (_tmp0_);
	_g_object_unref0 (self->channels);
	self->channels = NULL;
	_tmp1_ = self->priv->loop;
	if (_tmp1_ != NULL) {
		GMainLoop* _tmp2_;
		GThread* _tmp3_;
		_tmp2_ = self->priv->loop;
		g_main_loop_quit (_tmp2_);
		_g_main_loop_unref0 (self->priv->loop);
		self->priv->loop = NULL;
		_tmp3_ = self->priv->worker_thread;
		g_thread_join (_tmp3_);
		_g_thread_unref0 (self->priv->worker_thread);
		self->priv->worker_thread = NULL;
	}
	g_signal_emit_by_name (self, "destroyed");
}


/**
         * @path: Location where the file will be stored
         *
         * Write all the channels stored in this.Channels to file
         */
gboolean dvb_scanner_WriteAllChannelsToFile (DVBScanner* self, const gchar* path, GError** error) {
	gboolean result = FALSE;
	gboolean success;
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_;
	DVBioChannelListWriter* _tmp3_;
	DVBioChannelListWriter* _tmp4_;
	DVBioChannelListWriter* writer;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	success = TRUE;
	_tmp0_ = path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = dvb_io_channel_list_writer_new (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	writer = _tmp4_;
	{
		DVBChannelList* _tmp5_;
		GeeIterator* _tmp6_ = NULL;
		GeeIterator* _c_it;
		_tmp5_ = self->channels;
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
		_c_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			gboolean _tmp8_ = FALSE;
			GeeIterator* _tmp9_;
			gpointer _tmp10_ = NULL;
			DVBChannel* c;
			_tmp7_ = _c_it;
			_tmp8_ = gee_iterator_next (_tmp7_);
			if (!_tmp8_) {
				break;
			}
			_tmp9_ = _c_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			c = (DVBChannel*) _tmp10_;
			{
				DVBioChannelListWriter* _tmp11_;
				DVBChannel* _tmp12_;
				_tmp11_ = writer;
				_tmp12_ = c;
				dvb_io_channel_list_writer_write (_tmp11_, _tmp12_, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch153_g_error;
				}
			}
			goto __finally153;
			__catch153_g_error:
			{
				GError* e = NULL;
				DVBLoggingLogger* _tmp13_;
				GError* _tmp14_;
				const gchar* _tmp15_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp13_ = dvb_scanner_log;
				_tmp14_ = e;
				_tmp15_ = _tmp14_->message;
				dvb_logging_logger_error (_tmp13_, "Scanner.vala:223: Could not write to file: %s", _tmp15_);
				success = FALSE;
				_g_error_free0 (e);
			}
			__finally153:
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_DBUS_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (c);
					_g_object_unref0 (_c_it);
					_g_object_unref0 (writer);
					return FALSE;
				} else {
					_g_object_unref0 (c);
					_g_object_unref0 (_c_it);
					_g_object_unref0 (writer);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
			_g_object_unref0 (c);
		}
		_g_object_unref0 (_c_it);
	}
	{
		DVBioChannelListWriter* _tmp16_;
		_tmp16_ = writer;
		dvb_io_channel_list_writer_close (_tmp16_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch154_g_error;
		}
	}
	goto __finally154;
	__catch154_g_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp17_;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = dvb_scanner_log;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		dvb_logging_logger_error (_tmp17_, "Scanner.vala:231: Could not close file handle: %s", _tmp19_);
		success = FALSE;
		_g_error_free0 (e);
	}
	__finally154:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (writer);
			return FALSE;
		} else {
			_g_object_unref0 (writer);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = success;
	_g_object_unref0 (writer);
	return result;
}


/**
         * @channel_sids: A list of channels' SIDs
         * @path: Location where the file will be stored
         *
         * Write the channels with the given SIDs to file @path
         */
gboolean dvb_scanner_WriteChannelsToFile (DVBScanner* self, guint* channel_sids, int channel_sids_length1, const gchar* path, GError** error) {
	gboolean result = FALSE;
	gboolean success;
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_;
	DVBioChannelListWriter* _tmp3_;
	DVBioChannelListWriter* _tmp4_;
	DVBioChannelListWriter* writer;
	guint* _tmp5_;
	gint _tmp5__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	success = TRUE;
	_tmp0_ = path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = dvb_io_channel_list_writer_new (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	writer = _tmp4_;
	_tmp5_ = channel_sids;
	_tmp5__length1 = channel_sids_length1;
	{
		guint* sid_collection = NULL;
		gint sid_collection_length1 = 0;
		gint _sid_collection_size_ = 0;
		gint sid_it = 0;
		sid_collection = _tmp5_;
		sid_collection_length1 = _tmp5__length1;
		for (sid_it = 0; sid_it < _tmp5__length1; sid_it = sid_it + 1) {
			guint sid = 0U;
			sid = sid_collection[sid_it];
			{
				DVBChannelList* _tmp6_;
				guint _tmp7_;
				DVBChannel* _tmp8_ = NULL;
				DVBChannel* c;
				DVBChannel* _tmp9_;
				_tmp6_ = self->channels;
				_tmp7_ = sid;
				_tmp8_ = dvb_channel_list_get_channel (_tmp6_, _tmp7_);
				c = _tmp8_;
				_tmp9_ = c;
				if (_tmp9_ == NULL) {
					DVBLoggingLogger* _tmp10_;
					guint _tmp11_;
					_tmp10_ = dvb_scanner_log;
					_tmp11_ = sid;
					dvb_logging_logger_warning (_tmp10_, "Scanner.vala:252: Channel with SID 0x%x does not exist", _tmp11_);
					_g_object_unref0 (c);
					continue;
				}
				{
					DVBioChannelListWriter* _tmp12_;
					DVBChannel* _tmp13_;
					_tmp12_ = writer;
					_tmp13_ = c;
					dvb_io_channel_list_writer_write (_tmp12_, _tmp13_, &_inner_error_);
					if (_inner_error_ != NULL) {
						goto __catch155_g_error;
					}
				}
				goto __finally155;
				__catch155_g_error:
				{
					GError* e = NULL;
					DVBLoggingLogger* _tmp14_;
					GError* _tmp15_;
					const gchar* _tmp16_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp14_ = dvb_scanner_log;
					_tmp15_ = e;
					_tmp16_ = _tmp15_->message;
					dvb_logging_logger_error (_tmp14_, "Scanner.vala:258: Could not write to file: %s", _tmp16_);
					success = FALSE;
					_g_error_free0 (e);
				}
				__finally155:
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_DBUS_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (c);
						_g_object_unref0 (writer);
						return FALSE;
					} else {
						_g_object_unref0 (c);
						_g_object_unref0 (writer);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
				}
				_g_object_unref0 (c);
			}
		}
	}
	{
		DVBioChannelListWriter* _tmp17_;
		_tmp17_ = writer;
		dvb_io_channel_list_writer_close (_tmp17_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch156_g_error;
		}
	}
	goto __finally156;
	__catch156_g_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp18_;
		GError* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp18_ = dvb_scanner_log;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		dvb_logging_logger_error (_tmp18_, "Scanner.vala:266: Could not close file handle: %s", _tmp20_);
		success = FALSE;
		_g_error_free0 (e);
	}
	__finally156:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (writer);
			return FALSE;
		} else {
			_g_object_unref0 (writer);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = success;
	_g_object_unref0 (writer);
	return result;
}


static gchar* string_chug (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strchug (_tmp1_);
	result = _result_;
	return result;
}


gboolean dvb_scanner_AddScanningDataFromFile (DVBScanner* self, const gchar* path, GError** error) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* datafile;
	DVBLoggingLogger* _tmp2_;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GDataInputStream* reader = NULL;
	gchar* line;
	gsize len = 0UL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	datafile = _tmp1_;
	_tmp2_ = dvb_scanner_log;
	_tmp3_ = path;
	dvb_logging_logger_debug (_tmp2_, "Scanner.vala:276: Reading scanning data from %s", _tmp3_);
	_tmp4_ = datafile;
	_tmp5_ = dvb_utils_is_readable_file (_tmp4_);
	if (!_tmp5_) {
		result = FALSE;
		_g_object_unref0 (datafile);
		return result;
	}
	{
		GFile* _tmp6_;
		GFileInputStream* _tmp7_ = NULL;
		GFileInputStream* _tmp8_;
		GFileInputStream* _tmp9_;
		GDataInputStream* _tmp10_;
		_tmp6_ = datafile;
		_tmp7_ = g_file_read (_tmp6_, NULL, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			goto __catch157_g_error;
		}
		_tmp9_ = _tmp8_;
		_tmp10_ = g_data_input_stream_new ((GInputStream*) _tmp9_);
		_g_object_unref0 (reader);
		reader = _tmp10_;
		_g_object_unref0 (_tmp9_);
	}
	goto __finally157;
	__catch157_g_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp11_;
		const gchar* _tmp12_;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = dvb_scanner_log;
		_tmp12_ = path;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		dvb_logging_logger_error (_tmp11_, "Scanner.vala:284: Could not open %s: %s", _tmp12_, _tmp14_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (reader);
		_g_object_unref0 (datafile);
		return result;
	}
	__finally157:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (reader);
			_g_object_unref0 (datafile);
			return FALSE;
		} else {
			_g_object_unref0 (reader);
			_g_object_unref0 (datafile);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	line = NULL;
	{
		while (TRUE) {
			GDataInputStream* _tmp15_;
			gsize _tmp16_ = 0UL;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			const gchar* _tmp19_;
			gsize _tmp20_;
			const gchar* _tmp21_;
			gchar* _tmp22_ = NULL;
			const gchar* _tmp23_;
			gboolean _tmp24_ = FALSE;
			const gchar* _tmp25_;
			_tmp15_ = reader;
			_tmp17_ = g_data_input_stream_read_line (_tmp15_, &_tmp16_, NULL, &_inner_error_);
			len = _tmp16_;
			_tmp18_ = _tmp17_;
			if (_inner_error_ != NULL) {
				goto __catch158_g_error;
			}
			_g_free0 (line);
			line = _tmp18_;
			_tmp19_ = line;
			if (!(_tmp19_ != NULL)) {
				break;
			}
			_tmp20_ = len;
			if (_tmp20_ == ((gsize) 0)) {
				continue;
			}
			_tmp21_ = line;
			_tmp22_ = string_chug (_tmp21_);
			_g_free0 (line);
			line = _tmp22_;
			_tmp23_ = line;
			_tmp24_ = g_str_has_prefix (_tmp23_, "#");
			if (_tmp24_) {
				continue;
			}
			_tmp25_ = line;
			dvb_scanner_add_scanning_data_from_string (self, _tmp25_);
		}
	}
	goto __finally158;
	__catch158_g_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp26_;
		const gchar* _tmp27_;
		GError* _tmp28_;
		const gchar* _tmp29_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp26_ = dvb_scanner_log;
		_tmp27_ = path;
		_tmp28_ = e;
		_tmp29_ = _tmp28_->message;
		dvb_logging_logger_error (_tmp26_, "Scanner.vala:300: Could not read %s: %s", _tmp27_, _tmp29_);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (line);
		_g_object_unref0 (reader);
		_g_object_unref0 (datafile);
		return result;
	}
	__finally158:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (line);
			_g_object_unref0 (reader);
			_g_object_unref0 (datafile);
			return FALSE;
		} else {
			_g_free0 (line);
			_g_object_unref0 (reader);
			_g_object_unref0 (datafile);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	{
		GDataInputStream* _tmp30_;
		_tmp30_ = reader;
		g_input_stream_close ((GInputStream*) _tmp30_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch159_g_error;
		}
	}
	goto __finally159;
	__catch159_g_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp31_;
		GError* _tmp32_;
		const gchar* _tmp33_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp31_ = dvb_scanner_log;
		_tmp32_ = e;
		_tmp33_ = _tmp32_->message;
		dvb_logging_logger_error (_tmp31_, "Scanner.vala:307: Could not close file handle: %s", _tmp33_);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (line);
		_g_object_unref0 (reader);
		_g_object_unref0 (datafile);
		return result;
	}
	__finally159:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (line);
			_g_object_unref0 (reader);
			_g_object_unref0 (datafile);
			return FALSE;
		} else {
			_g_free0 (line);
			_g_object_unref0 (reader);
			_g_object_unref0 (datafile);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	_g_free0 (line);
	_g_object_unref0 (reader);
	_g_object_unref0 (datafile);
	return result;
}


static void* dvb_scanner_worker (DVBScanner* self) {
	void* result = NULL;
	GMainLoop* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->loop;
	g_main_loop_run (_tmp0_);
	result = NULL;
	return result;
}


static gpointer _g_source_ref0 (gpointer self) {
	return self ? g_source_ref (self) : NULL;
}


void dvb_scanner_clear_and_reset_all (DVBScanner* self) {
	GstElement* _tmp0_;
	GeeHashSet* _tmp9_;
	GeeArrayList* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->pipeline;
	if (_tmp0_ != NULL) {
		GMainContext* _tmp1_;
		guint _tmp2_;
		GSource* _tmp3_ = NULL;
		GSource* _tmp4_;
		GSource* bus_watch_source;
		GSource* _tmp5_;
		DVBLoggingLogger* _tmp7_;
		GstElement* _tmp8_;
		_tmp1_ = self->priv->context;
		_tmp2_ = self->priv->bus_watch_id;
		_tmp3_ = g_main_context_find_source_by_id (_tmp1_, _tmp2_);
		_tmp4_ = _g_source_ref0 (_tmp3_);
		bus_watch_source = _tmp4_;
		_tmp5_ = bus_watch_source;
		if (_tmp5_ != NULL) {
			GSource* _tmp6_;
			_tmp6_ = bus_watch_source;
			g_source_destroy (_tmp6_);
			self->priv->bus_watch_id = (guint) 0;
		}
		_tmp7_ = dvb_scanner_log;
		dvb_logging_logger_debug (_tmp7_, "Scanner.vala:329: Disposing pipeline");
		_tmp8_ = self->pipeline;
		gst_element_set_state (_tmp8_, GST_STATE_NULL);
		_gst_object_unref0 (self->pipeline);
		self->pipeline = NULL;
		_g_source_unref0 (bus_watch_source);
	}
	_tmp9_ = self->scanned_frequencies;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp9_);
	dvb_scanner_clear_frequencies (self);
	_gst_structure_free0 (self->current_tuning_params);
	self->current_tuning_params = NULL;
	_tmp10_ = self->priv->new_channels;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp10_);
	self->priv->running = FALSE;
}


void dvb_scanner_clear_frequencies (DVBScanner* self) {
	GQueue* _tmp4_;
	g_return_if_fail (self != NULL);
	while (TRUE) {
		GQueue* _tmp0_;
		gboolean _tmp1_ = FALSE;
		GQueue* _tmp2_;
		gpointer _tmp3_ = NULL;
		GstStructure* s;
		_tmp0_ = self->frequencies;
		_tmp1_ = g_queue_is_empty (_tmp0_);
		if (!(!_tmp1_)) {
			break;
		}
		_tmp2_ = self->frequencies;
		_tmp3_ = g_queue_pop_head (_tmp2_);
		s = (GstStructure*) _tmp3_;
		_gst_structure_free0 (s);
		s = NULL;
		_gst_structure_free0 (s);
	}
	_tmp4_ = self->frequencies;
	g_queue_clear (_tmp4_);
}


static gpointer _gst_structure_copy0 (gpointer self) {
	return self ? gst_structure_copy (self) : NULL;
}


void dvb_scanner_add_structure_to_scan (DVBScanner* self, GstStructure* structure) {
	const GstStructure* _tmp0_;
	const GstStructure* _tmp1_;
	DVBScannedItem* _tmp2_ = NULL;
	DVBScannedItem* item;
	GeeHashSet* _tmp3_;
	DVBScannedItem* _tmp4_;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (structure != NULL);
	_tmp0_ = structure;
	if (_tmp0_ == NULL) {
		_gst_structure_free0 (structure);
		return;
	}
	_tmp1_ = structure;
	_tmp2_ = dvb_scanner_get_scanned_item (self, _tmp1_);
	item = _tmp2_;
	_tmp3_ = self->scanned_frequencies;
	_tmp4_ = item;
	_tmp5_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp3_, _tmp4_);
	if (!_tmp5_) {
		DVBLoggingLogger* _tmp6_;
		DVBScannedItem* _tmp7_;
		guint _tmp8_;
		guint _tmp9_;
		GQueue* _tmp10_;
		const GstStructure* _tmp11_;
		GstStructure* _tmp12_;
		GeeHashSet* _tmp13_;
		DVBScannedItem* _tmp14_;
		_tmp6_ = dvb_scanner_log;
		_tmp7_ = item;
		_tmp8_ = dvb_scanned_item_get_Frequency (_tmp7_);
		_tmp9_ = _tmp8_;
		dvb_logging_logger_debug (_tmp6_, "Scanner.vala:357: Queueing new frequency %u", _tmp9_);
		_tmp10_ = self->frequencies;
		_tmp11_ = structure;
		_tmp12_ = _gst_structure_copy0 (_tmp11_);
		g_queue_push_tail (_tmp10_, _tmp12_);
		_tmp13_ = self->scanned_frequencies;
		_tmp14_ = item;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp14_);
	}
	_g_object_unref0 (item);
	_gst_structure_free0 (structure);
}


/**
         * Pick up the next tuning paramters from the queue
         * and start scanning with them
         */
static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _dvb_scanner_check_for_lock_gsource_func (gpointer self) {
	gboolean result;
	result = dvb_scanner_check_for_lock (self);
	return result;
}


gboolean dvb_scanner_start_scan (DVBScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean _tmp5_;
	gboolean _tmp7_;
	gboolean _tmp9_;
	gboolean all_tables;
	DVBLoggingLogger* _tmp10_;
	gboolean _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gboolean _tmp14_;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	gboolean _tmp17_;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_;
	gboolean _tmp20_;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_;
	gboolean _tmp23_;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_;
	const GstStructure* _tmp26_;
	GQueue* _tmp32_;
	gboolean _tmp33_ = FALSE;
	GQueue* _tmp53_;
	gpointer _tmp54_ = NULL;
	guint freq = 0U;
	const GstStructure* _tmp55_;
	guint _tmp56_ = 0U;
	DVBLoggingLogger* _tmp57_;
	guint _tmp58_;
	GQueue* _tmp59_;
	guint _tmp60_ = 0U;
	GstElement* _tmp61_;
	GstElement* _tmp62_;
	GstElement* _tmp63_ = NULL;
	GstElement* dvbsrc;
	GstElement* _tmp64_;
	GSource* _tmp65_;
	GSource* _tmp66_;
	GSource* _tmp67_;
	GMainContext* _tmp68_;
	GstElement* _tmp69_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = self->priv->sdt_arrived;
	if (_tmp3_) {
		gboolean _tmp4_;
		_tmp4_ = self->priv->nit_arrived;
		_tmp2_ = _tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		gboolean _tmp6_;
		_tmp6_ = self->priv->pat_arrived;
		_tmp1_ = _tmp6_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp7_ = _tmp1_;
	if (_tmp7_) {
		gboolean _tmp8_;
		_tmp8_ = self->priv->pmt_arrived;
		_tmp0_ = _tmp8_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp9_ = _tmp0_;
	all_tables = _tmp9_;
	_tmp10_ = dvb_scanner_log;
	_tmp11_ = all_tables;
	_tmp12_ = bool_to_string (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = self->priv->pat_arrived;
	_tmp15_ = bool_to_string (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = self->priv->sdt_arrived;
	_tmp18_ = bool_to_string (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = self->priv->nit_arrived;
	_tmp21_ = bool_to_string (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = self->priv->pmt_arrived;
	_tmp24_ = bool_to_string (_tmp23_);
	_tmp25_ = _tmp24_;
	dvb_logging_logger_debug (_tmp10_, "Scanner.vala:370: Received all tables: %s (pat: %s, sdt: %s, nit: %s, " \
"pmt: %s)", _tmp13_, _tmp16_, _tmp19_, _tmp22_, _tmp25_);
	_g_free0 (_tmp25_);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp13_);
	self->priv->nit_arrived = FALSE;
	self->priv->sdt_arrived = FALSE;
	self->priv->pat_arrived = FALSE;
	self->priv->pmt_arrived = FALSE;
	self->priv->locked = FALSE;
	_tmp26_ = self->current_tuning_params;
	if (_tmp26_ != NULL) {
		guint old_freq = 0U;
		const GstStructure* _tmp27_;
		guint _tmp28_ = 0U;
		guint _tmp29_;
		GQueue* _tmp30_;
		guint _tmp31_;
		_tmp27_ = self->current_tuning_params;
		gst_structure_get_uint (_tmp27_, "frequency", &_tmp28_);
		old_freq = _tmp28_;
		_tmp29_ = old_freq;
		_tmp30_ = self->frequencies;
		_tmp31_ = _tmp30_->length;
		g_signal_emit_by_name (self, "frequency-scanned", _tmp29_, _tmp31_);
	}
	_tmp32_ = self->frequencies;
	_tmp33_ = g_queue_is_empty (_tmp32_);
	if (_tmp33_) {
		g_message ("Scanner.vala:388: Finished scanning");
		{
			GeeArrayList* _tmp34_;
			_tmp34_ = self->priv->new_channels;
			g_static_rec_mutex_lock (&self->priv->__lock_new_channels);
			{
				DVBLoggingLogger* _tmp35_;
				GeeArrayList* _tmp36_;
				gint _tmp37_;
				gint _tmp38_;
				_tmp35_ = dvb_scanner_log;
				_tmp36_ = self->priv->new_channels;
				_tmp37_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp36_);
				_tmp38_ = _tmp37_;
				dvb_logging_logger_debug (_tmp35_, "Scanner.vala:392: %u channels still have missing or invalid informatio" \
"n", (guint) _tmp38_);
				{
					GeeArrayList* _tmp39_;
					GeeArrayList* _tmp40_;
					GeeArrayList* _sid_list;
					GeeArrayList* _tmp41_;
					gint _tmp42_;
					gint _tmp43_;
					gint _sid_size;
					gint _sid_index;
					_tmp39_ = self->priv->new_channels;
					_tmp40_ = _g_object_ref0 (_tmp39_);
					_sid_list = _tmp40_;
					_tmp41_ = _sid_list;
					_tmp42_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp41_);
					_tmp43_ = _tmp42_;
					_sid_size = _tmp43_;
					_sid_index = -1;
					while (TRUE) {
						gint _tmp44_;
						gint _tmp45_;
						gint _tmp46_;
						GeeArrayList* _tmp47_;
						gint _tmp48_;
						gpointer _tmp49_ = NULL;
						guint sid;
						DVBChannelList* _tmp50_;
						guint _tmp51_;
						_tmp44_ = _sid_index;
						_sid_index = _tmp44_ + 1;
						_tmp45_ = _sid_index;
						_tmp46_ = _sid_size;
						if (!(_tmp45_ < _tmp46_)) {
							break;
						}
						_tmp47_ = _sid_list;
						_tmp48_ = _sid_index;
						_tmp49_ = gee_abstract_list_get ((GeeAbstractList*) _tmp47_, _tmp48_);
						sid = GPOINTER_TO_UINT (_tmp49_);
						_tmp50_ = self->channels;
						_tmp51_ = sid;
						dvb_channel_list_remove (_tmp50_, _tmp51_);
					}
					_g_object_unref0 (_sid_list);
				}
			}
			__finally160:
			{
				GeeArrayList* _tmp52_;
				_tmp52_ = self->priv->new_channels;
				g_static_rec_mutex_unlock (&self->priv->__lock_new_channels);
			}
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		dvb_scanner_clear_and_reset_all (self);
		g_signal_emit_by_name (self, "finished");
		result = FALSE;
		return result;
	}
	_tmp53_ = self->frequencies;
	_tmp54_ = g_queue_pop_head (_tmp53_);
	_gst_structure_free0 (self->current_tuning_params);
	self->current_tuning_params = (GstStructure*) _tmp54_;
	_tmp55_ = self->current_tuning_params;
	gst_structure_get_uint (_tmp55_, "frequency", &_tmp56_);
	freq = _tmp56_;
	_tmp57_ = dvb_scanner_log;
	_tmp58_ = freq;
	_tmp59_ = self->frequencies;
	_tmp60_ = g_queue_get_length (_tmp59_);
	dvb_logging_logger_debug (_tmp57_, "Scanner.vala:409: Starting scanning frequency %u (%u left)", _tmp58_, _tmp60_);
	_tmp61_ = self->pipeline;
	gst_element_set_state (_tmp61_, GST_STATE_READY);
	dvb_scanner_prepare (self);
	_tmp62_ = self->pipeline;
	_tmp63_ = gst_bin_get_by_name (GST_BIN (_tmp62_), "dvbsrc");
	dvbsrc = _tmp63_;
	_tmp64_ = dvbsrc;
	g_object_set ((GObject*) _tmp64_, "pids", DVB_SCANNER_BASE_PIDS, NULL);
	_tmp65_ = g_timeout_source_new_seconds ((guint) 5);
	_g_source_unref0 (self->priv->check_for_lock_source);
	self->priv->check_for_lock_source = _tmp65_;
	_tmp66_ = self->priv->check_for_lock_source;
	g_source_set_callback (_tmp66_, _dvb_scanner_check_for_lock_gsource_func, g_object_ref (self), g_object_unref);
	_tmp67_ = self->priv->check_for_lock_source;
	_tmp68_ = self->priv->context;
	g_source_attach (_tmp67_, _tmp68_);
	_tmp69_ = self->pipeline;
	gst_element_set_state (_tmp69_, GST_STATE_PLAYING);
	result = FALSE;
	_gst_object_unref0 (dvbsrc);
	return result;
}


/**
         * Check if we received a lock with the currently
         * used tuning parameters
         */
gboolean dvb_scanner_check_for_lock (DVBScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->locked;
	if (!_tmp0_) {
		GstElement* _tmp1_;
		_tmp1_ = self->pipeline;
		gst_element_set_state (_tmp1_, GST_STATE_READY);
		dvb_scanner_queue_start_scan (self);
	}
	result = FALSE;
	return result;
}


gboolean dvb_scanner_wait_for_tables (DVBScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean _tmp5_;
	gboolean _tmp7_;
	gboolean _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = self->priv->sdt_arrived;
	if (_tmp3_) {
		gboolean _tmp4_;
		_tmp4_ = self->priv->nit_arrived;
		_tmp2_ = _tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		gboolean _tmp6_;
		_tmp6_ = self->priv->pat_arrived;
		_tmp1_ = _tmp6_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp7_ = _tmp1_;
	if (_tmp7_) {
		gboolean _tmp8_;
		_tmp8_ = self->priv->pmt_arrived;
		_tmp0_ = _tmp8_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp9_ = _tmp0_;
	if (!_tmp9_) {
		GstElement* _tmp10_;
		_tmp10_ = self->pipeline;
		gst_element_set_state (_tmp10_, GST_STATE_READY);
		dvb_scanner_queue_start_scan (self);
	}
	result = FALSE;
	return result;
}


void dvb_scanner_destroy_start_scan_source (DVBScanner* self) {
	gboolean _tmp0_ = FALSE;
	GSource* _tmp1_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->start_scan_source;
	if (_tmp1_ != NULL) {
		GSource* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->start_scan_source;
		_tmp3_ = g_source_is_destroyed (_tmp2_);
		_tmp0_ = !_tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		GSource* _tmp5_;
		_tmp5_ = self->priv->start_scan_source;
		g_source_destroy (_tmp5_);
		_g_source_unref0 (self->priv->start_scan_source);
		self->priv->start_scan_source = NULL;
	}
}


void dvb_scanner_remove_check_for_lock_timeout (DVBScanner* self) {
	gboolean _tmp0_ = FALSE;
	GSource* _tmp1_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->check_for_lock_source;
	if (_tmp1_ != NULL) {
		GSource* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->check_for_lock_source;
		_tmp3_ = g_source_is_destroyed (_tmp2_);
		_tmp0_ = !_tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		GSource* _tmp5_;
		_tmp5_ = self->priv->check_for_lock_source;
		g_source_destroy (_tmp5_);
		_g_source_unref0 (self->priv->check_for_lock_source);
		self->priv->check_for_lock_source = NULL;
	}
}


void dvb_scanner_remove_wait_for_tables_timeout (DVBScanner* self) {
	gboolean _tmp0_ = FALSE;
	GSource* _tmp1_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->wait_for_tables_source;
	if (_tmp1_ != NULL) {
		GSource* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->wait_for_tables_source;
		_tmp3_ = g_source_is_destroyed (_tmp2_);
		_tmp0_ = !_tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		GSource* _tmp5_;
		_tmp5_ = self->priv->wait_for_tables_source;
		g_source_destroy (_tmp5_);
		_g_source_unref0 (self->priv->wait_for_tables_source);
		self->priv->wait_for_tables_source = NULL;
	}
}


static gboolean _dvb_scanner_start_scan_gsource_func (gpointer self) {
	gboolean result;
	result = dvb_scanner_start_scan (self);
	return result;
}


void dvb_scanner_queue_start_scan (DVBScanner* self) {
	gboolean _tmp0_ = FALSE;
	GSource* _tmp1_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->start_scan_source;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GSource* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->start_scan_source;
		_tmp3_ = g_source_is_destroyed (_tmp2_);
		_tmp0_ = _tmp3_;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		DVBLoggingLogger* _tmp5_;
		GSource* _tmp6_;
		GSource* _tmp7_;
		GSource* _tmp8_;
		GMainContext* _tmp9_;
		_tmp5_ = dvb_scanner_log;
		dvb_logging_logger_debug (_tmp5_, "Scanner.vala:479: Queueing start_scan");
		_tmp6_ = g_idle_source_new ();
		_g_source_unref0 (self->priv->start_scan_source);
		self->priv->start_scan_source = _tmp6_;
		_tmp7_ = self->priv->start_scan_source;
		g_source_set_callback (_tmp7_, _dvb_scanner_start_scan_gsource_func, g_object_ref (self), g_object_unref);
		_tmp8_ = self->priv->start_scan_source;
		_tmp9_ = self->priv->context;
		g_source_attach (_tmp8_, _tmp9_);
	}
}


void dvb_scanner_set_uint_property (GstElement* src, const GstStructure* params, const gchar* key) {
	guint val = 0U;
	const GstStructure* _tmp0_;
	const gchar* _tmp1_;
	guint _tmp2_ = 0U;
	GstElement* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (src != NULL);
	g_return_if_fail (params != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = params;
	_tmp1_ = key;
	gst_structure_get_uint (_tmp0_, _tmp1_, &_tmp2_);
	val = _tmp2_;
	_tmp3_ = src;
	_tmp4_ = key;
	g_object_set ((GObject*) _tmp3_, _tmp4_, val, NULL);
}


static gboolean _dvb_scanner_wait_for_tables_gsource_func (gpointer self) {
	gboolean result;
	result = dvb_scanner_wait_for_tables (self);
	return result;
}


void dvb_scanner_on_dvb_frontend_stats_structure (DVBScanner* self, const GstStructure* structure) {
	gboolean has_lock = FALSE;
	const GstStructure* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean _tmp5_;
	gint _signal = 0;
	const GstStructure* _tmp11_;
	gint _tmp12_ = 0;
	gint _snr = 0;
	const GstStructure* _tmp13_;
	gint _tmp14_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (structure != NULL);
	_tmp0_ = structure;
	gst_structure_get_boolean (_tmp0_, "lock", &_tmp1_);
	has_lock = _tmp1_;
	_tmp3_ = has_lock;
	if (_tmp3_) {
		gboolean _tmp4_;
		_tmp4_ = self->priv->locked;
		_tmp2_ = !_tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		DVBLoggingLogger* _tmp6_;
		GSource* _tmp7_;
		GSource* _tmp8_;
		GSource* _tmp9_;
		GMainContext* _tmp10_;
		_tmp6_ = dvb_scanner_log;
		dvb_logging_logger_debug (_tmp6_, "Scanner.vala:497: Got lock");
		dvb_scanner_remove_check_for_lock_timeout (self);
		_tmp7_ = g_timeout_source_new_seconds ((guint) 10);
		_g_source_unref0 (self->priv->wait_for_tables_source);
		self->priv->wait_for_tables_source = _tmp7_;
		_tmp8_ = self->priv->wait_for_tables_source;
		g_source_set_callback (_tmp8_, _dvb_scanner_wait_for_tables_gsource_func, g_object_ref (self), g_object_unref);
		_tmp9_ = self->priv->wait_for_tables_source;
		_tmp10_ = self->priv->context;
		g_source_attach (_tmp9_, _tmp10_);
	}
	_tmp11_ = structure;
	gst_structure_get_int (_tmp11_, "signal", &_tmp12_);
	_signal = _tmp12_;
	_tmp13_ = structure;
	gst_structure_get_int (_tmp13_, "snr", &_tmp14_);
	_snr = _tmp14_;
	g_signal_emit_by_name (self, "frontend-stats", _signal / ((gdouble) 0xffff), _snr / ((gdouble) 0xffff));
}


void dvb_scanner_on_dvb_read_failure_structure (DVBScanner* self) {
	DVBLoggingLogger* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = dvb_scanner_log;
	dvb_logging_logger_warning (_tmp0_, "Scanner.vala:514: Read failure");
}


void dvb_scanner_on_pat_structure (DVBScanner* self, const GstStructure* structure) {
	DVBLoggingLogger* _tmp0_;
	GeeHashSet* _tmp1_;
	GeeSet* pid_set;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	const GstStructure* _tmp4_;
	GValue* _tmp5_ = NULL;
	GValue programs;
	guint _tmp6_ = 0U;
	guint size;
	GValue val = {0};
	const GstStructure* program = NULL;
	GString* _tmp21_;
	GString* new_pids;
	gint i;
	DVBLoggingLogger* _tmp41_;
	GeeSet* _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	GString* _tmp45_;
	const gchar* _tmp46_;
	GstElement* _tmp47_;
	GstElement* _tmp48_ = NULL;
	GstElement* dvbsrc;
	GString* _tmp49_;
	const gchar* _tmp50_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (structure != NULL);
	_tmp0_ = dvb_scanner_log;
	dvb_logging_logger_debug (_tmp0_, "Scanner.vala:521: Received PAT");
	_tmp1_ = gee_hash_set_new (G_TYPE_UINT, NULL, NULL, NULL, NULL);
	pid_set = (GeeSet*) _tmp1_;
	_tmp2_ = pid_set;
	gee_collection_add ((GeeCollection*) _tmp2_, GUINT_TO_POINTER ((guint) 16));
	_tmp3_ = pid_set;
	gee_collection_add ((GeeCollection*) _tmp3_, GUINT_TO_POINTER ((guint) 17));
	_tmp4_ = structure;
	_tmp5_ = gst_structure_get_value (_tmp4_, "programs");
	programs = *_tmp5_;
	_tmp6_ = gst_value_list_get_size (&programs);
	size = _tmp6_;
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				gboolean _tmp8_;
				guint _tmp10_;
				guint _tmp11_;
				guint _tmp12_;
				GValue* _tmp13_ = NULL;
				const GstStructure* _tmp14_ = NULL;
				guint sid = 0U;
				const GstStructure* _tmp15_;
				guint _tmp16_ = 0U;
				guint pmt = 0U;
				const GstStructure* _tmp17_;
				guint _tmp18_ = 0U;
				GeeSet* _tmp19_;
				guint _tmp20_;
				_tmp8_ = _tmp7_;
				if (!_tmp8_) {
					guint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp10_ = i;
				_tmp11_ = size;
				if (!(_tmp10_ < _tmp11_)) {
					break;
				}
				_tmp12_ = i;
				_tmp13_ = gst_value_list_get_value (&programs, _tmp12_);
				val = *_tmp13_;
				_tmp14_ = gst_value_get_structure (&val);
				program = _tmp14_;
				_tmp15_ = program;
				gst_structure_get_uint (_tmp15_, "program-number", &_tmp16_);
				sid = _tmp16_;
				_tmp17_ = program;
				gst_structure_get_uint (_tmp17_, "pid", &_tmp18_);
				pmt = _tmp18_;
				_tmp19_ = pid_set;
				_tmp20_ = pmt;
				gee_collection_add ((GeeCollection*) _tmp19_, GUINT_TO_POINTER (_tmp20_));
			}
		}
	}
	_tmp21_ = g_string_new ("");
	new_pids = _tmp21_;
	i = 0;
	{
		GeeSet* _tmp22_;
		GeeIterator* _tmp23_ = NULL;
		GeeIterator* _pid_it;
		_tmp22_ = pid_set;
		_tmp23_ = gee_iterable_iterator ((GeeIterable*) _tmp22_);
		_pid_it = _tmp23_;
		while (TRUE) {
			GeeIterator* _tmp24_;
			gboolean _tmp25_ = FALSE;
			GeeIterator* _tmp26_;
			gpointer _tmp27_ = NULL;
			guint pid;
			gint _tmp28_;
			GeeSet* _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
			gint _tmp40_;
			_tmp24_ = _pid_it;
			_tmp25_ = gee_iterator_next (_tmp24_);
			if (!_tmp25_) {
				break;
			}
			_tmp26_ = _pid_it;
			_tmp27_ = gee_iterator_get (_tmp26_);
			pid = GPOINTER_TO_UINT (_tmp27_);
			_tmp28_ = i;
			_tmp29_ = pid_set;
			_tmp30_ = gee_collection_get_size ((GeeCollection*) _tmp29_);
			_tmp31_ = _tmp30_;
			if ((_tmp28_ + 1) == _tmp31_) {
				GString* _tmp32_;
				guint _tmp33_;
				gchar* _tmp34_ = NULL;
				gchar* _tmp35_;
				_tmp32_ = new_pids;
				_tmp33_ = pid;
				_tmp34_ = g_strdup_printf ("%u", _tmp33_);
				_tmp35_ = _tmp34_;
				g_string_append (_tmp32_, _tmp35_);
				_g_free0 (_tmp35_);
			} else {
				GString* _tmp36_;
				guint _tmp37_;
				gchar* _tmp38_ = NULL;
				gchar* _tmp39_;
				_tmp36_ = new_pids;
				_tmp37_ = pid;
				_tmp38_ = g_strdup_printf ("%u:", _tmp37_);
				_tmp39_ = _tmp38_;
				g_string_append (_tmp36_, _tmp39_);
				_g_free0 (_tmp39_);
			}
			_tmp40_ = i;
			i = _tmp40_ + 1;
		}
		_g_object_unref0 (_pid_it);
	}
	_tmp41_ = dvb_scanner_log;
	_tmp42_ = pid_set;
	_tmp43_ = gee_collection_get_size ((GeeCollection*) _tmp42_);
	_tmp44_ = _tmp43_;
	_tmp45_ = new_pids;
	_tmp46_ = _tmp45_->str;
	dvb_logging_logger_debug (_tmp41_, "Scanner.vala:556: Setting %d pids: %s", _tmp44_, _tmp46_);
	_tmp47_ = self->pipeline;
	_tmp48_ = gst_bin_get_by_name (GST_BIN (_tmp47_), "dvbsrc");
	dvbsrc = _tmp48_;
	_tmp49_ = new_pids;
	_tmp50_ = _tmp49_->str;
	g_object_set ((GObject*) dvbsrc, "pids", _tmp50_, NULL);
	self->priv->pat_arrived = TRUE;
	_gst_object_unref0 (dvbsrc);
	_g_string_free0 (new_pids);
	_g_object_unref0 (pid_set);
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch161_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch161_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally161;
	__catch161_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally161:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


void dvb_scanner_on_sdt_structure (DVBScanner* self, const GstStructure* structure) {
	guint tsid = 0U;
	const GstStructure* _tmp0_;
	guint _tmp1_ = 0U;
	DVBLoggingLogger* _tmp2_;
	guint _tmp3_;
	const GstStructure* _tmp4_;
	GValue* _tmp5_ = NULL;
	GValue services;
	guint _tmp6_ = 0U;
	guint size;
	GValue val = {0};
	const GstStructure* service = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (structure != NULL);
	_tmp0_ = structure;
	gst_structure_get_uint (_tmp0_, "transport-stream-id", &_tmp1_);
	tsid = _tmp1_;
	_tmp2_ = dvb_scanner_log;
	_tmp3_ = tsid;
	dvb_logging_logger_debug (_tmp2_, "Scanner.vala:568: Received SDT (0x%x)", _tmp3_);
	_tmp4_ = structure;
	_tmp5_ = gst_structure_get_value (_tmp4_, "services");
	services = *_tmp5_;
	_tmp6_ = gst_value_list_get_size (&services);
	size = _tmp6_;
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				gboolean _tmp8_;
				guint _tmp10_;
				guint _tmp11_;
				guint _tmp12_;
				GValue* _tmp13_ = NULL;
				const GstStructure* _tmp14_ = NULL;
				const GstStructure* _tmp15_;
				const gchar* _tmp16_ = NULL;
				gchar* _tmp17_;
				gchar* name;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				gchar* _tmp22_ = NULL;
				gchar* _tmp23_;
				gint _tmp24_ = 0;
				gint _tmp25_;
				gint sid;
				const GstStructure* _tmp26_;
				gboolean _tmp27_ = FALSE;
				DVBChannelList* _tmp31_;
				gint _tmp32_;
				gboolean _tmp33_ = FALSE;
				DVBChannelList* _tmp35_;
				gint _tmp36_;
				DVBChannel* _tmp37_ = NULL;
				DVBChannel* channel;
				const GstStructure* _tmp38_;
				gboolean _tmp39_ = FALSE;
				const gchar* _tmp45_;
				gboolean _tmp46_ = FALSE;
				DVBChannel* _tmp51_;
				guint _tmp52_;
				const GstStructure* _tmp53_;
				const gchar* _tmp54_ = NULL;
				gchar* _tmp55_;
				gchar* provider;
				gboolean _tmp56_ = FALSE;
				const gchar* _tmp57_;
				gboolean _tmp60_;
				DVBLoggingLogger* _tmp64_;
				gint _tmp65_;
				DVBChannel* _tmp66_;
				const gchar* _tmp67_;
				const gchar* _tmp68_;
				DVBChannel* _tmp69_;
				gboolean _tmp70_;
				gboolean _tmp71_;
				gchar* _tmp72_ = NULL;
				gchar* _tmp73_;
				_tmp8_ = _tmp7_;
				if (!_tmp8_) {
					guint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp10_ = i;
				_tmp11_ = size;
				if (!(_tmp10_ < _tmp11_)) {
					break;
				}
				_tmp12_ = i;
				_tmp13_ = gst_value_list_get_value (&services, _tmp12_);
				val = *_tmp13_;
				_tmp14_ = gst_value_get_structure (&val);
				service = _tmp14_;
				_tmp15_ = service;
				_tmp16_ = gst_structure_get_name (_tmp15_);
				_tmp17_ = g_strdup (_tmp16_);
				name = _tmp17_;
				_tmp18_ = name;
				_tmp19_ = name;
				_tmp20_ = strlen (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = string_substring (_tmp18_, (glong) 8, (glong) (_tmp21_ - 8));
				_tmp23_ = _tmp22_;
				_tmp24_ = atoi (_tmp23_);
				_tmp25_ = _tmp24_;
				_g_free0 (_tmp23_);
				sid = _tmp25_;
				_tmp26_ = service;
				_tmp27_ = gst_structure_has_field (_tmp26_, "name");
				if (_tmp27_) {
					const GstStructure* _tmp28_;
					const gchar* _tmp29_ = NULL;
					gchar* _tmp30_;
					_tmp28_ = service;
					_tmp29_ = gst_structure_get_string (_tmp28_, "name");
					_tmp30_ = g_strdup (_tmp29_);
					_g_free0 (name);
					name = _tmp30_;
				}
				_tmp31_ = self->channels;
				_tmp32_ = sid;
				_tmp33_ = dvb_channel_list_contains (_tmp31_, (guint) _tmp32_);
				if (!_tmp33_) {
					gint _tmp34_;
					_tmp34_ = sid;
					dvb_scanner_add_new_channel (self, (guint) _tmp34_);
				}
				_tmp35_ = self->channels;
				_tmp36_ = sid;
				_tmp37_ = dvb_channel_list_get_channel (_tmp35_, (guint) _tmp36_);
				channel = _tmp37_;
				_tmp38_ = service;
				_tmp39_ = gst_structure_has_field (_tmp38_, "scrambled");
				if (_tmp39_) {
					gboolean scrambled = FALSE;
					const GstStructure* _tmp40_;
					gboolean _tmp41_ = FALSE;
					DVBChannel* _tmp42_;
					gboolean _tmp43_;
					_tmp40_ = service;
					gst_structure_get_boolean (_tmp40_, "scrambled", &_tmp41_);
					scrambled = _tmp41_;
					_tmp42_ = channel;
					_tmp43_ = scrambled;
					dvb_channel_set_Scrambled (_tmp42_, _tmp43_);
				} else {
					DVBChannel* _tmp44_;
					_tmp44_ = channel;
					dvb_channel_set_Scrambled (_tmp44_, FALSE);
				}
				_tmp45_ = name;
				_tmp46_ = g_utf8_validate (_tmp45_, (gssize) (-1), NULL);
				if (_tmp46_) {
					DVBChannel* _tmp47_;
					const gchar* _tmp48_;
					gchar* _tmp49_ = NULL;
					gchar* _tmp50_;
					_tmp47_ = channel;
					_tmp48_ = name;
					_tmp49_ = string_replace (_tmp48_, "\\s", " ");
					_tmp50_ = _tmp49_;
					dvb_channel_set_Name (_tmp47_, _tmp50_);
					_g_free0 (_tmp50_);
				}
				_tmp51_ = channel;
				_tmp52_ = tsid;
				dvb_channel_set_TransportStreamId (_tmp51_, _tmp52_);
				_tmp53_ = service;
				_tmp54_ = gst_structure_get_string (_tmp53_, "provider-name");
				_tmp55_ = g_strdup (_tmp54_);
				provider = _tmp55_;
				_tmp57_ = provider;
				if (_tmp57_ != NULL) {
					const gchar* _tmp58_;
					gboolean _tmp59_ = FALSE;
					_tmp58_ = provider;
					_tmp59_ = g_utf8_validate (_tmp58_, (gssize) (-1), NULL);
					_tmp56_ = _tmp59_;
				} else {
					_tmp56_ = FALSE;
				}
				_tmp60_ = _tmp56_;
				if (_tmp60_) {
					DVBChannel* _tmp61_;
					const gchar* _tmp62_;
					_tmp61_ = channel;
					_tmp62_ = provider;
					dvb_channel_set_Network (_tmp61_, _tmp62_);
				} else {
					DVBChannel* _tmp63_;
					_tmp63_ = channel;
					dvb_channel_set_Network (_tmp63_, "");
				}
				_tmp64_ = dvb_scanner_log;
				_tmp65_ = sid;
				_tmp66_ = channel;
				_tmp67_ = dvb_channel_get_Name (_tmp66_);
				_tmp68_ = _tmp67_;
				_tmp69_ = channel;
				_tmp70_ = dvb_channel_get_Scrambled (_tmp69_);
				_tmp71_ = _tmp70_;
				_tmp72_ = bool_to_string (_tmp71_);
				_tmp73_ = _tmp72_;
				dvb_logging_logger_debug (_tmp64_, "Scanner.vala:614: Found service 0x%x, %s, scrambled: %s", (guint) _tmp65_, _tmp68_, _tmp73_);
				_g_free0 (_tmp73_);
				_g_free0 (provider);
				_g_object_unref0 (channel);
				_g_free0 (name);
			}
		}
	}
	self->priv->sdt_arrived = TRUE;
}


void dvb_scanner_on_nit_structure (DVBScanner* self, const GstStructure* structure) {
	gboolean actual = FALSE;
	const GstStructure* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	DVBLoggingLogger* _tmp3_;
	gchar* name = NULL;
	const GstStructure* _tmp4_;
	gboolean _tmp5_ = FALSE;
	DVBLoggingLogger* _tmp13_;
	const gchar* _tmp14_;
	const GstStructure* _tmp15_;
	GValue* _tmp16_ = NULL;
	GValue transports;
	guint _tmp17_ = 0U;
	guint size;
	GValue val = {0};
	const GstStructure* transport = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (structure != NULL);
	_tmp0_ = structure;
	gst_structure_get_boolean (_tmp0_, "actual-network", &_tmp1_);
	actual = _tmp1_;
	_tmp2_ = actual;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = dvb_scanner_log;
	dvb_logging_logger_debug (_tmp3_, "Scanner.vala:627: Received NIT");
	_tmp4_ = structure;
	_tmp5_ = gst_structure_has_field (_tmp4_, "network-name");
	if (_tmp5_) {
		const GstStructure* _tmp6_;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp6_ = structure;
		_tmp7_ = gst_structure_get_string (_tmp6_, "network-name");
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (name);
		name = _tmp8_;
	} else {
		guint nid = 0U;
		const GstStructure* _tmp9_;
		guint _tmp10_ = 0U;
		guint _tmp11_;
		gchar* _tmp12_ = NULL;
		_tmp9_ = structure;
		gst_structure_get_uint (_tmp9_, "network-id", &_tmp10_);
		nid = _tmp10_;
		_tmp11_ = nid;
		_tmp12_ = g_strdup_printf ("%u", _tmp11_);
		_g_free0 (name);
		name = _tmp12_;
	}
	_tmp13_ = dvb_scanner_log;
	_tmp14_ = name;
	dvb_logging_logger_debug (_tmp13_, "Scanner.vala:637: Network name '%s'", _tmp14_);
	_tmp15_ = structure;
	_tmp16_ = gst_structure_get_value (_tmp15_, "transports");
	transports = *_tmp16_;
	_tmp17_ = gst_value_list_get_size (&transports);
	size = _tmp17_;
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp18_;
			_tmp18_ = TRUE;
			while (TRUE) {
				gboolean _tmp19_;
				guint _tmp21_;
				guint _tmp22_;
				guint _tmp23_;
				GValue* _tmp24_ = NULL;
				const GstStructure* _tmp25_ = NULL;
				guint tsid = 0U;
				const GstStructure* _tmp26_;
				guint _tmp27_ = 0U;
				const GstStructure* _tmp28_;
				gboolean _tmp29_ = FALSE;
				const GstStructure* _tmp39_;
				gboolean _tmp40_ = FALSE;
				_tmp19_ = _tmp18_;
				if (!_tmp19_) {
					guint _tmp20_;
					_tmp20_ = i;
					i = _tmp20_ + 1;
				}
				_tmp18_ = FALSE;
				_tmp21_ = i;
				_tmp22_ = size;
				if (!(_tmp21_ < _tmp22_)) {
					break;
				}
				_tmp23_ = i;
				_tmp24_ = gst_value_list_get_value (&transports, _tmp23_);
				val = *_tmp24_;
				_tmp25_ = gst_value_get_structure (&val);
				transport = _tmp25_;
				_tmp26_ = transport;
				gst_structure_get_uint (_tmp26_, "transport-stream-id", &_tmp27_);
				tsid = _tmp27_;
				_tmp28_ = transport;
				_tmp29_ = gst_structure_has_field (_tmp28_, "delivery");
				if (_tmp29_) {
					const GstStructure* _tmp30_;
					GValue* _tmp31_ = NULL;
					GValue delivery_val;
					const GstStructure* _tmp32_ = NULL;
					const GstStructure* delivery;
					DVBLoggingLogger* _tmp33_;
					guint _tmp34_;
					guint freq = 0U;
					const GstStructure* _tmp35_;
					guint _tmp36_ = 0U;
					const GstStructure* _tmp37_;
					GstStructure* _tmp38_;
					_tmp30_ = transport;
					_tmp31_ = gst_structure_get_value (_tmp30_, "delivery");
					delivery_val = *_tmp31_;
					_tmp32_ = gst_value_get_structure (&delivery_val);
					delivery = _tmp32_;
					_tmp33_ = dvb_scanner_log;
					_tmp34_ = tsid;
					dvb_logging_logger_debug (_tmp33_, "Scanner.vala:656: Received TS 0x%x", _tmp34_);
					_tmp35_ = delivery;
					gst_structure_get_uint (_tmp35_, "frequency", &_tmp36_);
					freq = _tmp36_;
					_tmp37_ = delivery;
					_tmp38_ = _gst_structure_copy0 (_tmp37_);
					dvb_scanner_add_structure_to_scan (self, _tmp38_);
				}
				_tmp39_ = transport;
				_tmp40_ = gst_structure_has_field (_tmp39_, "channels");
				if (_tmp40_) {
					const GstStructure* _tmp41_;
					GValue* _tmp42_ = NULL;
					GValue channels;
					guint _tmp43_ = 0U;
					guint channels_size;
					GValue channel_val = {0};
					const GstStructure* channel_struct = NULL;
					_tmp41_ = transport;
					_tmp42_ = gst_structure_get_value (_tmp41_, "channels");
					channels = *_tmp42_;
					_tmp43_ = gst_value_list_get_size (&channels);
					channels_size = _tmp43_;
					{
						gint j;
						j = 0;
						{
							gboolean _tmp44_;
							_tmp44_ = TRUE;
							while (TRUE) {
								gboolean _tmp45_;
								gint _tmp47_;
								guint _tmp48_;
								gint _tmp49_;
								GValue* _tmp50_ = NULL;
								const GstStructure* _tmp51_ = NULL;
								guint sid = 0U;
								const GstStructure* _tmp52_;
								guint _tmp53_ = 0U;
								DVBChannelList* _tmp54_;
								guint _tmp55_;
								gboolean _tmp56_ = FALSE;
								DVBChannelList* _tmp58_;
								guint _tmp59_;
								DVBChannel* _tmp60_ = NULL;
								DVBChannel* dvb_channel;
								const gchar* _tmp61_;
								gboolean _tmp62_ = FALSE;
								guint lcnumber = 0U;
								const GstStructure* _tmp66_;
								guint _tmp67_ = 0U;
								DVBChannel* _tmp68_;
								guint _tmp69_;
								_tmp45_ = _tmp44_;
								if (!_tmp45_) {
									gint _tmp46_;
									_tmp46_ = j;
									j = _tmp46_ + 1;
								}
								_tmp44_ = FALSE;
								_tmp47_ = j;
								_tmp48_ = channels_size;
								if (!(((guint) _tmp47_) < _tmp48_)) {
									break;
								}
								_tmp49_ = j;
								_tmp50_ = gst_value_list_get_value (&channels, (guint) _tmp49_);
								channel_val = *_tmp50_;
								_tmp51_ = gst_value_get_structure (&channel_val);
								channel_struct = _tmp51_;
								_tmp52_ = channel_struct;
								gst_structure_get_uint (_tmp52_, "service-id", &_tmp53_);
								sid = _tmp53_;
								_tmp54_ = self->channels;
								_tmp55_ = sid;
								_tmp56_ = dvb_channel_list_contains (_tmp54_, _tmp55_);
								if (!_tmp56_) {
									guint _tmp57_;
									_tmp57_ = sid;
									dvb_scanner_add_new_channel (self, _tmp57_);
								}
								_tmp58_ = self->channels;
								_tmp59_ = sid;
								_tmp60_ = dvb_channel_list_get_channel (_tmp58_, _tmp59_);
								dvb_channel = _tmp60_;
								_tmp61_ = name;
								_tmp62_ = g_utf8_validate (_tmp61_, (gssize) (-1), NULL);
								if (_tmp62_) {
									DVBChannel* _tmp63_;
									const gchar* _tmp64_;
									_tmp63_ = dvb_channel;
									_tmp64_ = name;
									dvb_channel_set_Network (_tmp63_, _tmp64_);
								} else {
									DVBChannel* _tmp65_;
									_tmp65_ = dvb_channel;
									dvb_channel_set_Network (_tmp65_, "");
								}
								_tmp66_ = channel_struct;
								gst_structure_get_uint (_tmp66_, "logical-channel-number", &_tmp67_);
								lcnumber = _tmp67_;
								_tmp68_ = dvb_channel;
								_tmp69_ = lcnumber;
								dvb_channel_set_LogicalChannelNumber (_tmp68_, &_tmp69_);
								_g_object_unref0 (dvb_channel);
							}
						}
					}
				}
			}
		}
	}
	self->priv->nit_arrived = TRUE;
	_g_free0 (name);
}


void dvb_scanner_on_pmt_structure (DVBScanner* self, const GstStructure* structure) {
	DVBLoggingLogger* _tmp0_;
	guint program_number = 0U;
	const GstStructure* _tmp1_;
	guint _tmp2_ = 0U;
	DVBChannelList* _tmp3_;
	guint _tmp4_;
	gboolean _tmp5_ = FALSE;
	DVBChannelList* _tmp7_;
	guint _tmp8_;
	DVBChannel* _tmp9_ = NULL;
	DVBChannel* dvb_channel;
	const GstStructure* _tmp10_;
	GValue* _tmp11_ = NULL;
	GValue streams;
	guint _tmp12_ = 0U;
	guint size;
	GValue stream_val = {0};
	const GstStructure* stream = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (structure != NULL);
	_tmp0_ = dvb_scanner_log;
	dvb_logging_logger_debug (_tmp0_, "Scanner.vala:701: Received PMT");
	_tmp1_ = structure;
	gst_structure_get_uint (_tmp1_, "program-number", &_tmp2_);
	program_number = _tmp2_;
	_tmp3_ = self->channels;
	_tmp4_ = program_number;
	_tmp5_ = dvb_channel_list_contains (_tmp3_, _tmp4_);
	if (!_tmp5_) {
		guint _tmp6_;
		_tmp6_ = program_number;
		dvb_scanner_add_new_channel (self, _tmp6_);
	}
	_tmp7_ = self->channels;
	_tmp8_ = program_number;
	_tmp9_ = dvb_channel_list_get_channel (_tmp7_, _tmp8_);
	dvb_channel = _tmp9_;
	_tmp10_ = structure;
	_tmp11_ = gst_structure_get_value (_tmp10_, "streams");
	streams = *_tmp11_;
	_tmp12_ = gst_value_list_get_size (&streams);
	size = _tmp12_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp13_;
			_tmp13_ = TRUE;
			while (TRUE) {
				gboolean _tmp14_;
				gint _tmp16_;
				guint _tmp17_;
				gint _tmp18_;
				GValue* _tmp19_ = NULL;
				const GstStructure* _tmp20_ = NULL;
				guint pid = 0U;
				const GstStructure* _tmp21_;
				guint _tmp22_ = 0U;
				guint stream_type = 0U;
				const GstStructure* _tmp23_;
				guint _tmp24_ = 0U;
				guint _tmp25_;
				_tmp14_ = _tmp13_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp16_ = i;
				_tmp17_ = size;
				if (!(((guint) _tmp16_) < _tmp17_)) {
					break;
				}
				_tmp18_ = i;
				_tmp19_ = gst_value_list_get_value (&streams, (guint) _tmp18_);
				stream_val = *_tmp19_;
				_tmp20_ = gst_value_get_structure (&stream_val);
				stream = _tmp20_;
				_tmp21_ = stream;
				gst_structure_get_uint (_tmp21_, "pid", &_tmp22_);
				pid = _tmp22_;
				_tmp23_ = stream;
				gst_structure_get_uint (_tmp23_, "stream-type", &_tmp24_);
				stream_type = _tmp24_;
				_tmp25_ = stream_type;
				switch (_tmp25_) {
					case 0x01:
					case 0x02:
					case 0x1b:
					{
						DVBLoggingLogger* _tmp26_;
						guint _tmp27_;
						guint _tmp28_;
						DVBChannel* _tmp29_;
						guint _tmp30_;
						_tmp26_ = dvb_scanner_log;
						_tmp27_ = pid;
						_tmp28_ = program_number;
						dvb_logging_logger_debug (_tmp26_, "Scanner.vala:733: Found video PID 0x%x for channel 0x%x", _tmp27_, _tmp28_);
						_tmp29_ = dvb_channel;
						_tmp30_ = pid;
						dvb_channel_set_VideoPID (_tmp29_, _tmp30_);
						break;
					}
					case 0x03:
					case 0x04:
					case 0x0f:
					case 0x11:
					{
						DVBLoggingLogger* _tmp31_;
						guint _tmp32_;
						guint _tmp33_;
						DVBChannel* _tmp34_;
						GeeList* _tmp35_;
						GeeList* _tmp36_;
						guint _tmp37_;
						_tmp31_ = dvb_scanner_log;
						_tmp32_ = pid;
						_tmp33_ = program_number;
						dvb_logging_logger_debug (_tmp31_, "Scanner.vala:741: Found audio PID 0x%x for channel 0x%x", _tmp32_, _tmp33_);
						_tmp34_ = dvb_channel;
						_tmp35_ = dvb_channel_get_AudioPIDs (_tmp34_);
						_tmp36_ = _tmp35_;
						_tmp37_ = pid;
						gee_collection_add ((GeeCollection*) _tmp36_, GUINT_TO_POINTER (_tmp37_));
						break;
					}
					default:
					{
						DVBLoggingLogger* _tmp38_;
						guint _tmp39_;
						_tmp38_ = dvb_scanner_log;
						_tmp39_ = stream_type;
						dvb_logging_logger_debug (_tmp38_, "Scanner.vala:746: Other stream type: 0x%02x", _tmp39_);
						break;
					}
				}
			}
		}
	}
	self->priv->pmt_arrived = TRUE;
	_g_object_unref0 (dvb_channel);
}


gboolean dvb_scanner_bus_watch_func (DVBScanner* self, GstBus* bus, GstMessage* message) {
	gboolean result = FALSE;
	GstMessage* _tmp0_;
	GstMessageType _tmp1_;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_;
	gboolean _tmp30_;
	gboolean _tmp32_;
	gboolean _tmp95_ = FALSE;
	gboolean _tmp96_ = FALSE;
	gboolean _tmp97_ = FALSE;
	gboolean _tmp98_;
	gboolean _tmp100_;
	gboolean _tmp102_;
	gboolean _tmp104_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bus != NULL, FALSE);
	g_return_val_if_fail (message != NULL, FALSE);
	_tmp0_ = message;
	_tmp1_ = _tmp0_->type;
	switch (_tmp1_) {
		case GST_MESSAGE_ELEMENT:
		{
			{
				GstMessage* _tmp2_;
				const GstStructure* _tmp3_ = NULL;
				GstStructure* _tmp4_;
				GstStructure* structure;
				const GstStructure* _tmp5_;
				const gchar* _tmp6_ = NULL;
				gchar* _tmp7_;
				gchar* structure_name;
				const gchar* _tmp8_;
				_tmp2_ = message;
				_tmp3_ = gst_message_get_structure (_tmp2_);
				_tmp4_ = _gst_structure_copy0 (_tmp3_);
				structure = _tmp4_;
				_tmp5_ = structure;
				_tmp6_ = gst_structure_get_name (_tmp5_);
				_tmp7_ = g_strdup (_tmp6_);
				structure_name = _tmp7_;
				_tmp8_ = structure_name;
				if (g_strcmp0 (_tmp8_, "dvb-frontend-stats") == 0) {
					const GstStructure* _tmp9_;
					_tmp9_ = structure;
					dvb_scanner_on_dvb_frontend_stats_structure (self, _tmp9_);
				} else {
					const gchar* _tmp10_;
					_tmp10_ = structure_name;
					if (g_strcmp0 (_tmp10_, "dvb-read-failure") == 0) {
						dvb_scanner_on_dvb_read_failure_structure (self);
					} else {
						const gchar* _tmp11_;
						_tmp11_ = structure_name;
						if (g_strcmp0 (_tmp11_, "sdt") == 0) {
							const GstStructure* _tmp12_;
							_tmp12_ = structure;
							dvb_scanner_on_sdt_structure (self, _tmp12_);
						} else {
							const gchar* _tmp13_;
							_tmp13_ = structure_name;
							if (g_strcmp0 (_tmp13_, "nit") == 0) {
								const GstStructure* _tmp14_;
								_tmp14_ = structure;
								dvb_scanner_on_nit_structure (self, _tmp14_);
							} else {
								const gchar* _tmp15_;
								_tmp15_ = structure_name;
								if (g_strcmp0 (_tmp15_, "pat") == 0) {
									const GstStructure* _tmp16_;
									_tmp16_ = structure;
									dvb_scanner_on_pat_structure (self, _tmp16_);
								} else {
									const gchar* _tmp17_;
									_tmp17_ = structure_name;
									if (g_strcmp0 (_tmp17_, "pmt") == 0) {
										const GstStructure* _tmp18_;
										_tmp18_ = structure;
										dvb_scanner_on_pmt_structure (self, _tmp18_);
									} else {
										result = TRUE;
										_g_free0 (structure_name);
										_gst_structure_free0 (structure);
										return result;
									}
								}
							}
						}
					}
				}
				_g_free0 (structure_name);
				_gst_structure_free0 (structure);
				break;
			}
		}
		case GST_MESSAGE_ERROR:
		{
			{
				GError* gerror = NULL;
				gchar* debug = NULL;
				GstMessage* _tmp19_;
				GError* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				DVBLoggingLogger* _tmp22_;
				GError* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				_tmp19_ = message;
				gst_message_parse_error (_tmp19_, &_tmp20_, &_tmp21_);
				_g_error_free0 (gerror);
				gerror = _tmp20_;
				_g_free0 (debug);
				debug = _tmp21_;
				_tmp22_ = dvb_scanner_log;
				_tmp23_ = gerror;
				_tmp24_ = _tmp23_->message;
				_tmp25_ = debug;
				dvb_logging_logger_warning (_tmp22_, "Scanner.vala:779: %s %s", _tmp24_, _tmp25_);
				result = TRUE;
				_g_free0 (debug);
				_g_error_free0 (gerror);
				return result;
			}
		}
		default:
		{
			result = TRUE;
			return result;
		}
	}
	_tmp28_ = self->priv->nit_arrived;
	if (_tmp28_) {
		gboolean _tmp29_;
		_tmp29_ = self->priv->sdt_arrived;
		_tmp27_ = _tmp29_;
	} else {
		_tmp27_ = FALSE;
	}
	_tmp30_ = _tmp27_;
	if (_tmp30_) {
		gboolean _tmp31_;
		_tmp31_ = self->priv->pat_arrived;
		_tmp26_ = _tmp31_;
	} else {
		_tmp26_ = FALSE;
	}
	_tmp32_ = _tmp26_;
	if (_tmp32_) {
		{
			GeeArrayList* _tmp33_;
			_tmp33_ = self->priv->new_channels;
			g_static_rec_mutex_lock (&self->priv->__lock_new_channels);
			{
				GeeArrayList* _tmp34_;
				GeeArrayList* del_channels;
				_tmp34_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL);
				del_channels = _tmp34_;
				{
					GeeArrayList* _tmp35_;
					GeeArrayList* _tmp36_;
					GeeArrayList* _sid_list;
					GeeArrayList* _tmp37_;
					gint _tmp38_;
					gint _tmp39_;
					gint _sid_size;
					gint _sid_index;
					_tmp35_ = self->priv->new_channels;
					_tmp36_ = _g_object_ref0 (_tmp35_);
					_sid_list = _tmp36_;
					_tmp37_ = _sid_list;
					_tmp38_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp37_);
					_tmp39_ = _tmp38_;
					_sid_size = _tmp39_;
					_sid_index = -1;
					while (TRUE) {
						gint _tmp40_;
						gint _tmp41_;
						gint _tmp42_;
						GeeArrayList* _tmp43_;
						gint _tmp44_;
						gpointer _tmp45_ = NULL;
						guint sid;
						DVBChannelList* _tmp46_;
						guint _tmp47_;
						DVBChannel* _tmp48_ = NULL;
						DVBChannel* channel;
						DVBChannel* _tmp49_;
						gboolean _tmp50_ = FALSE;
						_tmp40_ = _sid_index;
						_sid_index = _tmp40_ + 1;
						_tmp41_ = _sid_index;
						_tmp42_ = _sid_size;
						if (!(_tmp41_ < _tmp42_)) {
							break;
						}
						_tmp43_ = _sid_list;
						_tmp44_ = _sid_index;
						_tmp45_ = gee_abstract_list_get ((GeeAbstractList*) _tmp43_, _tmp44_);
						sid = GPOINTER_TO_UINT (_tmp45_);
						_tmp46_ = self->channels;
						_tmp47_ = sid;
						_tmp48_ = dvb_channel_list_get_channel (_tmp46_, _tmp47_);
						channel = _tmp48_;
						_tmp49_ = channel;
						_tmp50_ = dvb_channel_is_valid (_tmp49_);
						if (_tmp50_) {
							const gchar* _tmp51_ = NULL;
							DVBChannel* _tmp52_;
							gboolean _tmp53_ = FALSE;
							const gchar* _tmp54_;
							gchar* _tmp55_;
							gchar* type;
							DVBLoggingLogger* _tmp56_;
							DVBChannel* _tmp57_;
							gchar* _tmp58_ = NULL;
							gchar* _tmp59_;
							DVBChannel* _tmp60_;
							guint _tmp61_;
							guint _tmp62_;
							guint _tmp63_;
							DVBChannel* _tmp64_;
							const gchar* _tmp65_;
							const gchar* _tmp66_;
							DVBChannel* _tmp67_;
							const gchar* _tmp68_;
							const gchar* _tmp69_;
							const gchar* _tmp70_;
							DVBChannel* _tmp71_;
							gboolean _tmp72_;
							gboolean _tmp73_;
							GeeArrayList* _tmp74_;
							guint _tmp75_;
							_tmp52_ = channel;
							_tmp53_ = dvb_channel_is_radio (_tmp52_);
							if (_tmp53_) {
								_tmp51_ = "Radio";
							} else {
								_tmp51_ = "TV";
							}
							_tmp54_ = _tmp51_;
							_tmp55_ = g_strdup (_tmp54_);
							type = _tmp55_;
							_tmp56_ = dvb_scanner_log;
							_tmp57_ = channel;
							_tmp58_ = dvb_channel_to_string (_tmp57_);
							_tmp59_ = _tmp58_;
							dvb_logging_logger_debug (_tmp56_, "Scanner.vala:798: Channel added: %s", _tmp59_);
							_g_free0 (_tmp59_);
							_tmp60_ = channel;
							_tmp61_ = dvb_channel_get_Frequency (_tmp60_);
							_tmp62_ = _tmp61_;
							_tmp63_ = sid;
							_tmp64_ = channel;
							_tmp65_ = dvb_channel_get_Name (_tmp64_);
							_tmp66_ = _tmp65_;
							_tmp67_ = channel;
							_tmp68_ = dvb_channel_get_Network (_tmp67_);
							_tmp69_ = _tmp68_;
							_tmp70_ = type;
							_tmp71_ = channel;
							_tmp72_ = dvb_channel_get_Scrambled (_tmp71_);
							_tmp73_ = _tmp72_;
							g_signal_emit_by_name (self, "channel-added", _tmp62_, _tmp63_, _tmp66_, _tmp69_, _tmp70_, _tmp73_);
							_tmp74_ = del_channels;
							_tmp75_ = sid;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp74_, GUINT_TO_POINTER (_tmp75_));
							_g_free0 (type);
						} else {
							DVBLoggingLogger* _tmp76_;
							guint _tmp77_;
							DVBChannel* _tmp78_;
							gchar* _tmp79_ = NULL;
							gchar* _tmp80_;
							_tmp76_ = dvb_scanner_log;
							_tmp77_ = sid;
							_tmp78_ = channel;
							_tmp79_ = dvb_channel_to_string (_tmp78_);
							_tmp80_ = _tmp79_;
							dvb_logging_logger_debug (_tmp76_, "Scanner.vala:805: Channel 0x%x is not valid: %s", _tmp77_, _tmp80_);
							_g_free0 (_tmp80_);
							self->priv->pmt_arrived = FALSE;
						}
						_g_object_unref0 (channel);
					}
					_g_object_unref0 (_sid_list);
				}
				{
					GeeArrayList* _tmp81_;
					GeeArrayList* _tmp82_;
					GeeArrayList* _sid_list;
					GeeArrayList* _tmp83_;
					gint _tmp84_;
					gint _tmp85_;
					gint _sid_size;
					gint _sid_index;
					_tmp81_ = del_channels;
					_tmp82_ = _g_object_ref0 (_tmp81_);
					_sid_list = _tmp82_;
					_tmp83_ = _sid_list;
					_tmp84_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp83_);
					_tmp85_ = _tmp84_;
					_sid_size = _tmp85_;
					_sid_index = -1;
					while (TRUE) {
						gint _tmp86_;
						gint _tmp87_;
						gint _tmp88_;
						GeeArrayList* _tmp89_;
						gint _tmp90_;
						gpointer _tmp91_ = NULL;
						guint sid;
						GeeArrayList* _tmp92_;
						guint _tmp93_;
						_tmp86_ = _sid_index;
						_sid_index = _tmp86_ + 1;
						_tmp87_ = _sid_index;
						_tmp88_ = _sid_size;
						if (!(_tmp87_ < _tmp88_)) {
							break;
						}
						_tmp89_ = _sid_list;
						_tmp90_ = _sid_index;
						_tmp91_ = gee_abstract_list_get ((GeeAbstractList*) _tmp89_, _tmp90_);
						sid = GPOINTER_TO_UINT (_tmp91_);
						_tmp92_ = self->priv->new_channels;
						_tmp93_ = sid;
						gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp92_, GUINT_TO_POINTER (_tmp93_));
					}
					_g_object_unref0 (_sid_list);
				}
				_g_object_unref0 (del_channels);
			}
			__finally162:
			{
				GeeArrayList* _tmp94_;
				_tmp94_ = self->priv->new_channels;
				g_static_rec_mutex_unlock (&self->priv->__lock_new_channels);
			}
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	_tmp98_ = self->priv->sdt_arrived;
	if (_tmp98_) {
		gboolean _tmp99_;
		_tmp99_ = self->priv->nit_arrived;
		_tmp97_ = _tmp99_;
	} else {
		_tmp97_ = FALSE;
	}
	_tmp100_ = _tmp97_;
	if (_tmp100_) {
		gboolean _tmp101_;
		_tmp101_ = self->priv->pat_arrived;
		_tmp96_ = _tmp101_;
	} else {
		_tmp96_ = FALSE;
	}
	_tmp102_ = _tmp96_;
	if (_tmp102_) {
		gboolean _tmp103_;
		_tmp103_ = self->priv->pmt_arrived;
		_tmp95_ = _tmp103_;
	} else {
		_tmp95_ = FALSE;
	}
	_tmp104_ = _tmp95_;
	if (_tmp104_) {
		dvb_scanner_remove_wait_for_tables_timeout (self);
		dvb_scanner_queue_start_scan (self);
	}
	result = TRUE;
	return result;
}


void dvb_scanner_add_new_channel (DVBScanner* self, guint sid) {
	DVBLoggingLogger* _tmp0_;
	guint _tmp1_;
	DVBChannel* _tmp2_ = NULL;
	DVBChannel* new_channel;
	guint _tmp3_;
	const GstStructure* _tmp4_;
	DVBChannelList* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = dvb_scanner_log;
	_tmp1_ = sid;
	dvb_logging_logger_debug (_tmp0_, "Scanner.vala:831: Adding new channel with SID 0x%x", _tmp1_);
	_tmp2_ = dvb_scanner_get_new_channel (self);
	new_channel = _tmp2_;
	_tmp3_ = sid;
	dvb_channel_set_Sid (new_channel, _tmp3_);
	_tmp4_ = self->current_tuning_params;
	dvb_scanner_add_values_from_structure_to_channel (self, _tmp4_, new_channel);
	_tmp5_ = self->channels;
	dvb_channel_list_add (_tmp5_, new_channel);
	{
		GeeArrayList* _tmp6_;
		_tmp6_ = self->priv->new_channels;
		g_static_rec_mutex_lock (&self->priv->__lock_new_channels);
		{
			GeeArrayList* _tmp7_;
			guint _tmp8_;
			_tmp7_ = self->priv->new_channels;
			_tmp8_ = sid;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, GUINT_TO_POINTER (_tmp8_));
		}
		__finally163:
		{
			GeeArrayList* _tmp9_;
			_tmp9_ = self->priv->new_channels;
			g_static_rec_mutex_unlock (&self->priv->__lock_new_channels);
		}
		if (_inner_error_ != NULL) {
			_g_object_unref0 (new_channel);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (new_channel);
}


DVBScanner* dvb_scanner_construct (GType object_type) {
	DVBScanner * self = NULL;
	self = (DVBScanner*) g_object_new (object_type, NULL);
	return self;
}


DVBDevice* dvb_scanner_get_Device (DVBScanner* self) {
	DVBDevice* result;
	DVBDevice* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_Device;
	result = _tmp0_;
	return result;
}


static void dvb_scanner_set_Device (DVBScanner* self, DVBDevice* value) {
	DVBDevice* _tmp0_;
	DVBDevice* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_Device);
	self->priv->_Device = _tmp1_;
	g_object_notify ((GObject *) self, "Device");
}


DVBChannelList* dvb_scanner_get_Channels (DVBScanner* self) {
	DVBChannelList* result;
	DVBChannelList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->channels;
	result = _tmp0_;
	return result;
}


static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN) (gpointer data1, guint arg_1, guint arg_2, const char* arg_3, const char* arg_4, const char* arg_5, gboolean arg_6, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 7);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_string (param_values + 3), g_value_get_string (param_values + 4), g_value_get_string (param_values + 5), g_value_get_boolean (param_values + 6), data2);
}


static void g_cclosure_user_marshal_VOID__DOUBLE_DOUBLE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__DOUBLE_DOUBLE) (gpointer data1, gdouble arg_1, gdouble arg_2, gpointer data2);
	register GMarshalFunc_VOID__DOUBLE_DOUBLE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__DOUBLE_DOUBLE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_double (param_values + 1), g_value_get_double (param_values + 2), data2);
}


static guint _dvb_scanned_item_hash_ghash_func (gconstpointer key) {
	guint result;
	result = dvb_scanned_item_hash (key);
	return result;
}


static gboolean _dvb_scanned_item_equal_gequal_func (gconstpointer a, gconstpointer b) {
	gboolean result;
	result = dvb_scanned_item_equal (a, b);
	return result;
}


static GObject * dvb_scanner_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBScanner * self;
	GeeHashSet* _tmp0_;
	GeeArrayList* _tmp1_;
	GQueue* _tmp2_;
	GMainContext* _tmp3_;
	parent_class = G_OBJECT_CLASS (dvb_scanner_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_SCANNER (obj);
	_tmp0_ = gee_hash_set_new (DVB_TYPE_SCANNED_ITEM, (GBoxedCopyFunc) g_object_ref, g_object_unref, _dvb_scanned_item_hash_ghash_func, _dvb_scanned_item_equal_gequal_func);
	_g_object_unref0 (self->scanned_frequencies);
	self->scanned_frequencies = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->new_channels);
	self->priv->new_channels = _tmp1_;
	_tmp2_ = g_queue_new ();
	__g_queue_free__gst_structure_free0_0 (self->frequencies);
	self->frequencies = _tmp2_;
	_tmp3_ = g_main_context_new ();
	_g_main_context_unref0 (self->priv->context);
	self->priv->context = _tmp3_;
	self->priv->running = FALSE;
	return obj;
}


static void dvb_scanner_class_init (DVBScannerClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_scanner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBScannerPrivate));
	DVB_SCANNER_CLASS (klass)->prepare = dvb_scanner_real_prepare;
	DVB_SCANNER_CLASS (klass)->get_scanned_item = dvb_scanner_real_get_scanned_item;
	DVB_SCANNER_CLASS (klass)->get_new_channel = dvb_scanner_real_get_new_channel;
	DVB_SCANNER_CLASS (klass)->add_values_from_structure_to_channel = dvb_scanner_real_add_values_from_structure_to_channel;
	DVB_SCANNER_CLASS (klass)->add_scanning_data_from_string = dvb_scanner_real_add_scanning_data_from_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_scanner_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_scanner_set_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_scanner_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_scanner_finalize;
	/**
	         * The DVB device the scanner should use
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_SCANNER_DEVICE, g_param_spec_object ("Device", "Device", "Device", DVB_TYPE_DEVICE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_SCANNER_CHANNELS, g_param_spec_object ("Channels", "Channels", "Channels", DVB_TYPE_CHANNEL_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	         * Emitted when the Destroy () method is called
	         */
	g_signal_new ("destroyed", DVB_TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	         * Emitted when a frequency has been scanned.
	         * Whether a new channel has been found on that frequency or not.
	         */
	g_signal_new ("frequency_scanned", DVB_TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
	/**
	         * @frequency: Frequency of the channel
	         * @sid: SID of the channel
	         * @name: Name of the channel
	         * @network: Name of network the channel is part of
	         * @type: What type of channel this is (Radio or TV)
	         * @scrambled: Whether the channel is scrambled
	         *
	         * Emitted when a new channel has been found
	         */
	g_signal_new ("channel_added", DVB_TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN, G_TYPE_NONE, 6, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN);
	g_signal_new ("frontend_stats", DVB_TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__DOUBLE_DOUBLE, G_TYPE_NONE, 2, G_TYPE_DOUBLE, G_TYPE_DOUBLE);
	/**
	         * Emitted when all frequencies have been scanned
	         */
	g_signal_new ("finished", DVB_TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_scanner_log = _tmp1_;
}


static void dvb_scanner_instance_init (DVBScanner * self) {
	self->priv = DVB_SCANNER_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_new_channels);
}


static void dvb_scanner_finalize (GObject* obj) {
	DVBScanner * self;
	self = DVB_SCANNER (obj);
	_g_object_unref0 (self->priv->_Device);
	_g_object_unref0 (self->channels);
	_gst_object_unref0 (self->pipeline);
	__g_queue_free__gst_structure_free0_0 (self->frequencies);
	_gst_structure_free0 (self->current_tuning_params);
	_g_object_unref0 (self->scanned_frequencies);
	g_static_rec_mutex_free (&self->priv->__lock_new_channels);
	_g_object_unref0 (self->priv->new_channels);
	_g_source_unref0 (self->priv->check_for_lock_source);
	_g_source_unref0 (self->priv->wait_for_tables_source);
	_g_source_unref0 (self->priv->start_scan_source);
	_g_main_context_unref0 (self->priv->context);
	_g_main_loop_unref0 (self->priv->loop);
	_g_thread_unref0 (self->priv->worker_thread);
	G_OBJECT_CLASS (dvb_scanner_parent_class)->finalize (obj);
}


/**
     * An abstract class responsible for scanning for new channels
     */
GType dvb_scanner_get_type (void) {
	static volatile gsize dvb_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_scanner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBScanner), 0, (GInstanceInitFunc) dvb_scanner_instance_init, NULL };
		GType dvb_scanner_type_id;
		dvb_scanner_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBScanner", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&dvb_scanner_type_id__volatile, dvb_scanner_type_id);
	}
	return dvb_scanner_type_id__volatile;
}


static void _vala_dvb_scanner_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBScanner * self;
	self = DVB_SCANNER (object);
	switch (property_id) {
		case DVB_SCANNER_DEVICE:
		g_value_set_object (value, dvb_scanner_get_Device (self));
		break;
		case DVB_SCANNER_CHANNELS:
		g_value_set_object (value, dvb_scanner_get_Channels (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_scanner_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBScanner * self;
	self = DVB_SCANNER (object);
	switch (property_id) {
		case DVB_SCANNER_DEVICE:
		dvb_scanner_set_Device (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



