<p align="center"><img align="center" src="http://imgur.com/V4LtoII.png"/></p>
<p align="center">
  <a href="https://circleci.com/gh/nuxt/nuxt.js"><img src="https://img.shields.io/circleci/project/github/nuxt/nuxt.js.svg" alt="Build Status"></a>
  <a href="https://travis-ci.org/nuxt/nuxt.js"><img src="https://img.shields.io/travis/nuxt/nuxt.js/master.svg" alt="Build Status"></a>
  <a href="https://ci.appveyor.com/project/Atinux/nuxt-js"><img src="https://ci.appveyor.com/api/projects/status/gwab06obc6srx9g4?svg=true" alt="Windows Build Status"></a>
  <a href="https://codecov.io/gh/nuxt/nuxt.js"><img src="https://img.shields.io/codecov/c/github/nuxt/nuxt.js/master.svg" alt="Coverage Status"></a>
  <a href="https://www.npmjs.com/package/nuxt"><img src="https://img.shields.io/npm/dm/nuxt.svg" alt="Downloads"></a>
  <a href="https://www.npmjs.com/package/nuxt"><img src="https://img.shields.io/npm/v/nuxt.svg" alt="Version"></a>
  <a href="https://www.npmjs.com/package/nuxt"><img src="https://img.shields.io/npm/l/nuxt.svg" alt="License"></a>
  <a href="https://gitter.im/nuxt/nuxt.js"><img src="https://img.shields.io/badge/GITTER-join%20chat-green.svg" alt="Gitter"></a>
 </p>
 <p align="center">
  <a href="#backers" alt="sponsors on Open Collective"><img src="https://opencollective.com/nuxtjs/backers/badge.svg" /></a>
  <a href="#sponsors" alt="Sponsors on Open Collective"><img src="https://opencollective.com/nuxtjs/sponsors/badge.svg" /></a>
  <a href="https://opencollective.com/nuxtjs"><img src="https://img.shields.io/badge/Support%20us-Open%20Collective-41B883.svg" alt="Support us"></a>

</p>

> Vue.js Meta Framework to create complex, fast & universal web application *quickly*.

## Links

- 📘 Documentation: [https://nuxtjs.org](https://nuxtjs.org)
- 🎬 Video: [1 minute demo](https://www.youtube.com/watch?v=kmf-p-pTi40)
- 🐦 Twitter: [@nuxt_js](https://twitter.com/nuxt_js)
- 👥 [Nuxt.js Community](https://github.com/nuxt-community)
- 📦 [Nuxt.js Modules](https://github.com/nuxt-community/modules)
- 👉 [Play with Nuxt.js online](https://glitch.com/edit/#!/nuxt-hello-world)

## Features

- Automatic transpilation and bundling (with webpack and babel)
- Hot code reloading
- Server-side rendering OR Single Page App OR Static Generated, you choose :fire:
- Static file serving. `./static/` is mapped to `/`
- Configurable with a `nuxt.config.js` file
- Custom layouts with the `layouts/` directory
- Middleware
- Code splitting for every `pages/`

Learn more at [nuxtjs.org](https://nuxtjs.org).

## Sponsors

Become a sponsor and get your logo on our README on Github with a link to your site. [[Become a sponsor](https://opencollective.com/nuxtjs#sponsor)]

<p>
<a href="https://opencollective.com/nuxtjs/sponsor/0/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/sponsor/0/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/sponsor/1/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/sponsor/1/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/sponsor/2/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/sponsor/2/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/sponsor/3/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/sponsor/3/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/sponsor/4/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/sponsor/4/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/sponsor/5/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/sponsor/5/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/sponsor/6/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/sponsor/6/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/sponsor/7/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/sponsor/7/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/sponsor/8/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/sponsor/8/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/sponsor/9/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/sponsor/9/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/sponsor/10/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/sponsor/10/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/sponsor/11/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/sponsor/11/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/sponsor/12/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/sponsor/12/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/sponsor/13/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/sponsor/13/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/sponsor/14/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/sponsor/14/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/sponsor/15/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/sponsor/15/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/sponsor/16/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/sponsor/16/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/sponsor/17/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/sponsor/17/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/sponsor/18/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/sponsor/18/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/sponsor/19/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/sponsor/19/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/sponsor/20/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/sponsor/20/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/sponsor/21/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/sponsor/21/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/sponsor/22/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/sponsor/22/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/sponsor/23/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/sponsor/23/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/sponsor/24/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/sponsor/24/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/sponsor/25/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/sponsor/25/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/sponsor/26/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/sponsor/26/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/sponsor/27/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/sponsor/27/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/sponsor/28/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/sponsor/28/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/sponsor/29/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/sponsor/29/avatar.svg"></a>
</p>

## Backers

Support us with a monthly donation and help us continue our activities. [[Become a backer](https://opencollective.com/nuxtjs#backer)]

<p>
<a href="https://opencollective.com/nuxtjs/backer/0/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/backer/0/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/backer/1/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/backer/1/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/backer/2/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/backer/2/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/backer/3/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/backer/3/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/backer/4/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/backer/4/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/backer/5/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/backer/5/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/backer/6/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/backer/6/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/backer/7/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/backer/7/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/backer/8/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/backer/8/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/backer/9/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/backer/9/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/backer/10/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/backer/10/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/backer/11/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/backer/11/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/backer/12/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/backer/12/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/backer/13/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/backer/13/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/backer/14/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/backer/14/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/backer/15/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/backer/15/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/backer/16/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/backer/16/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/backer/17/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/backer/17/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/backer/18/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/backer/18/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/backer/19/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/backer/19/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/backer/20/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/backer/20/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/backer/21/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/backer/21/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/backer/22/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/backer/22/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/backer/23/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/backer/23/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/backer/24/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/backer/24/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/backer/25/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/backer/25/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/backer/26/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/backer/26/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/backer/27/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/backer/27/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/backer/28/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/backer/28/avatar.svg"></a>
<a href="https://opencollective.com/nuxtjs/backer/29/website" target="_blank" rel="noopener noreferrer"><img src="https://opencollective.com/nuxtjs/backer/29/avatar.svg"></a>
</p>

## Getting started

```
$ npm install nuxt --save
```

Add a script to your package.json like this:

```json
{
  "scripts": {
    "start": "nuxt"
  }
}
```

After that, the file-system is the main API. Every .vue file becomes a route that gets automatically processed and rendered.

Populate `./pages/index.vue` inside your project:

```html
<template>
  <h1>Hello {{ name }}!</h1>
</template>

<script>
export default {
  data: () => {
    return { name: 'world' }
  }
}
</script>
```

And then run:
```bash
npm start
```

Go to [http://localhost:3000](http://localhost:3000)

## Templates

:point_right: We recommend to start directly with our cli [create-nuxt-app](https://github.com/nuxt-community/create-nuxt-app) for the latest updates.

Or you can start by using one of our starter templates:
- [starter](https://github.com/nuxt-community/starter-template): Basic Nuxt.js project template
- [express](https://github.com/nuxt-community/express-template): Nuxt.js + Express
- [koa](https://github.com/nuxt-community/koa-template): Nuxt.js + Koa
- [adonuxt](https://github.com/nuxt-community/adonuxt-template): Nuxt.js + AdonisJS
- [micro](https://github.com/nuxt-community/micro-template): Nuxt.js + Micro
- [nuxtent](https://github.com/nuxt-community/nuxtent-template): Nuxt.js + Nuxtent module for content heavy sites

## Using nuxt.js programmatically

```js
const { Nuxt, Builder } = require('nuxt')

// Import and set nuxt.js options
let config = require('./nuxt.config.js')
config.dev = (process.env.NODE_ENV !== 'production')

let nuxt = new Nuxt(config)

// Start build process (only in development)
if (config.dev) {
  new Builder(nuxt).build()
}

// You can use nuxt.render(req, res) or nuxt.renderRoute(route, context)
```

Learn more: https://nuxtjs.org/api/nuxt

## Using nuxt.js as a middleware

You might want to use your own server with you configurations, your API and everything awesome your created with. That's why you can use nuxt.js as a middleware. It's recommended to use it at the end of your middleware since it will handle the rendering of your web application and won't call next().

```js
app.use(nuxt.render)
```

Learn more: https://nuxtjs.org/api/nuxt-render

## Render a specific route

This is mostly used for `nuxt generate` and test purposes but you might find another utility!

```js
nuxt.renderRoute('/about', context)
.then(function ({ html, error }) {
  // You can check error to know if your app displayed the error page for this route
  // Useful to set the correct status code if an error appended:
  if (error) {
    return res.status(error.statusCode || 500).send(html)
  }
  res.send(html)
})
.catch(function (error) {
  // And error appended while rendering the route
})
```

Learn more: https://nuxtjs.org/api/nuxt-render-route

## Examples

Please take a look at https://nuxtjs.org/examples or directly in https://github.com/nuxt/nuxt.js/tree/dev/examples.

## Production deployment

To deploy, instead of running nuxt, you probably want to build ahead of time. Therefore, building and starting are separate commands:

```bash
nuxt build
nuxt start
```

For example, to deploy with [`now`](https://zeit.co/now) a `package.json` like follows is recommended:
```json
{
  "name": "my-app",
  "dependencies": {
    "nuxt": "latest"
  },
  "scripts": {
    "dev": "nuxt",
    "build": "nuxt build",
    "start": "nuxt start"
  }
}
```
Then run `now` and enjoy!

Note: we recommend putting `.nuxt` in `.npmignore` or `.gitignore`.

## Core team

| [Sebastien Chopin](https://github.com/Atinux) | [Alexandre Chopin](https://github.com/alexchopin) | [Pooya Parsa](https://github.com/pi0) | [Clark Du](https://github.com/clarkdo) |
| --- | --- | --- | --- |
| [![Atinux](https://avatars1.githubusercontent.com/u/904724?s=150&v=4)](https://github.com/Atinux) | [![alexchopin](https://avatars1.githubusercontent.com/u/4084277?s=150&v=4)](https://github.com/alexchopin) | [![pi0](https://avatars1.githubusercontent.com/u/5158436?s=150&v=4)](https://github.com/pi0) | [![clarkdo](https://avatars3.githubusercontent.com/u/4312154?s=150&v=4)](https://github.com/clarkdo) |

## Contributors

Thank you to all our [contributors](https://github.com/nuxt/nuxt.js/graphs/contributors)!

## Contributing

Please see our [CONTRIBUTING.md](./CONTRIBUTING.md)


## Roadmap

https://trello.com/b/lgy93IOl/nuxtjs-10
