// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/billing/budgets/v1beta1/budget_model.proto

package budgets

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	money "google.golang.org/genproto/googleapis/type/money"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The type of basis used to determine if spend has passed the threshold.
type ThresholdRule_Basis int32

const (
	// Unspecified threshold basis.
	ThresholdRule_BASIS_UNSPECIFIED ThresholdRule_Basis = 0
	// Use current spend as the basis for comparison against the threshold.
	ThresholdRule_CURRENT_SPEND ThresholdRule_Basis = 1
	// Use forecasted spend for the period as the basis for comparison against
	// the threshold.
	ThresholdRule_FORECASTED_SPEND ThresholdRule_Basis = 2
)

var ThresholdRule_Basis_name = map[int32]string{
	0: "BASIS_UNSPECIFIED",
	1: "CURRENT_SPEND",
	2: "FORECASTED_SPEND",
}

var ThresholdRule_Basis_value = map[string]int32{
	"BASIS_UNSPECIFIED": 0,
	"CURRENT_SPEND":     1,
	"FORECASTED_SPEND":  2,
}

func (x ThresholdRule_Basis) String() string {
	return proto.EnumName(ThresholdRule_Basis_name, int32(x))
}

func (ThresholdRule_Basis) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1b88e381b47dbc69, []int{3, 0}
}

// Specifies how credits should be treated when determining spend for
// threshold calculations.
type Filter_CreditTypesTreatment int32

const (
	Filter_CREDIT_TYPES_TREATMENT_UNSPECIFIED Filter_CreditTypesTreatment = 0
	// All types of credit are subtracted from the gross cost to determine the
	// spend for threshold calculations.
	Filter_INCLUDE_ALL_CREDITS Filter_CreditTypesTreatment = 1
	// All types of credit are added to the net cost to determine the spend for
	// threshold calculations.
	Filter_EXCLUDE_ALL_CREDITS Filter_CreditTypesTreatment = 2
)

var Filter_CreditTypesTreatment_name = map[int32]string{
	0: "CREDIT_TYPES_TREATMENT_UNSPECIFIED",
	1: "INCLUDE_ALL_CREDITS",
	2: "EXCLUDE_ALL_CREDITS",
}

var Filter_CreditTypesTreatment_value = map[string]int32{
	"CREDIT_TYPES_TREATMENT_UNSPECIFIED": 0,
	"INCLUDE_ALL_CREDITS":                1,
	"EXCLUDE_ALL_CREDITS":                2,
}

func (x Filter_CreditTypesTreatment) String() string {
	return proto.EnumName(Filter_CreditTypesTreatment_name, int32(x))
}

func (Filter_CreditTypesTreatment) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1b88e381b47dbc69, []int{5, 0}
}

// A budget is a plan that describes what you expect to spend on Cloud
// projects, plus the rules to execute as spend is tracked against that plan,
// (for example, send an alert when 90% of the target spend is met).
// Currently all plans are monthly budgets so the usage period(s) tracked are
// implied (calendar months of usage back-to-back).
type Budget struct {
	// Output only. Resource name of the budget.
	// The resource name implies the scope of a budget. Values are of the form
	// `billingAccounts/{billingAccountId}/budgets/{budgetId}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// User data for display name in UI.
	// Validation: <= 60 chars.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Filters that define which resources are used to compute
	// the actual spend against the budget.
	BudgetFilter *Filter `protobuf:"bytes,3,opt,name=budget_filter,json=budgetFilter,proto3" json:"budget_filter,omitempty"`
	// Required. Budgeted amount.
	Amount *BudgetAmount `protobuf:"bytes,4,opt,name=amount,proto3" json:"amount,omitempty"`
	// Optional. Rules that trigger alerts (notifications of thresholds
	// being crossed) when spend exceeds the specified percentages of the budget.
	ThresholdRules []*ThresholdRule `protobuf:"bytes,5,rep,name=threshold_rules,json=thresholdRules,proto3" json:"threshold_rules,omitempty"`
	// Optional. Rules to apply to all updates to the actual spend, regardless
	// of the thresholds set in `threshold_rules`.
	AllUpdatesRule *AllUpdatesRule `protobuf:"bytes,6,opt,name=all_updates_rule,json=allUpdatesRule,proto3" json:"all_updates_rule,omitempty"`
	// Optional. Etag to validate that the object is unchanged for a
	// read-modify-write operation.
	// An empty etag will cause an update to overwrite other changes.
	Etag                 string   `protobuf:"bytes,7,opt,name=etag,proto3" json:"etag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Budget) Reset()         { *m = Budget{} }
func (m *Budget) String() string { return proto.CompactTextString(m) }
func (*Budget) ProtoMessage()    {}
func (*Budget) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b88e381b47dbc69, []int{0}
}

func (m *Budget) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Budget.Unmarshal(m, b)
}
func (m *Budget) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Budget.Marshal(b, m, deterministic)
}
func (m *Budget) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Budget.Merge(m, src)
}
func (m *Budget) XXX_Size() int {
	return xxx_messageInfo_Budget.Size(m)
}
func (m *Budget) XXX_DiscardUnknown() {
	xxx_messageInfo_Budget.DiscardUnknown(m)
}

var xxx_messageInfo_Budget proto.InternalMessageInfo

func (m *Budget) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Budget) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Budget) GetBudgetFilter() *Filter {
	if m != nil {
		return m.BudgetFilter
	}
	return nil
}

func (m *Budget) GetAmount() *BudgetAmount {
	if m != nil {
		return m.Amount
	}
	return nil
}

func (m *Budget) GetThresholdRules() []*ThresholdRule {
	if m != nil {
		return m.ThresholdRules
	}
	return nil
}

func (m *Budget) GetAllUpdatesRule() *AllUpdatesRule {
	if m != nil {
		return m.AllUpdatesRule
	}
	return nil
}

func (m *Budget) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

// The budgeted amount for each usage period.
type BudgetAmount struct {
	// Specification for what amount to use as the budget.
	//
	// Types that are valid to be assigned to BudgetAmount:
	//	*BudgetAmount_SpecifiedAmount
	//	*BudgetAmount_LastPeriodAmount
	BudgetAmount         isBudgetAmount_BudgetAmount `protobuf_oneof:"budget_amount"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *BudgetAmount) Reset()         { *m = BudgetAmount{} }
func (m *BudgetAmount) String() string { return proto.CompactTextString(m) }
func (*BudgetAmount) ProtoMessage()    {}
func (*BudgetAmount) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b88e381b47dbc69, []int{1}
}

func (m *BudgetAmount) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BudgetAmount.Unmarshal(m, b)
}
func (m *BudgetAmount) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BudgetAmount.Marshal(b, m, deterministic)
}
func (m *BudgetAmount) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BudgetAmount.Merge(m, src)
}
func (m *BudgetAmount) XXX_Size() int {
	return xxx_messageInfo_BudgetAmount.Size(m)
}
func (m *BudgetAmount) XXX_DiscardUnknown() {
	xxx_messageInfo_BudgetAmount.DiscardUnknown(m)
}

var xxx_messageInfo_BudgetAmount proto.InternalMessageInfo

type isBudgetAmount_BudgetAmount interface {
	isBudgetAmount_BudgetAmount()
}

type BudgetAmount_SpecifiedAmount struct {
	SpecifiedAmount *money.Money `protobuf:"bytes,1,opt,name=specified_amount,json=specifiedAmount,proto3,oneof"`
}

type BudgetAmount_LastPeriodAmount struct {
	LastPeriodAmount *LastPeriodAmount `protobuf:"bytes,2,opt,name=last_period_amount,json=lastPeriodAmount,proto3,oneof"`
}

func (*BudgetAmount_SpecifiedAmount) isBudgetAmount_BudgetAmount() {}

func (*BudgetAmount_LastPeriodAmount) isBudgetAmount_BudgetAmount() {}

func (m *BudgetAmount) GetBudgetAmount() isBudgetAmount_BudgetAmount {
	if m != nil {
		return m.BudgetAmount
	}
	return nil
}

func (m *BudgetAmount) GetSpecifiedAmount() *money.Money {
	if x, ok := m.GetBudgetAmount().(*BudgetAmount_SpecifiedAmount); ok {
		return x.SpecifiedAmount
	}
	return nil
}

func (m *BudgetAmount) GetLastPeriodAmount() *LastPeriodAmount {
	if x, ok := m.GetBudgetAmount().(*BudgetAmount_LastPeriodAmount); ok {
		return x.LastPeriodAmount
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*BudgetAmount) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*BudgetAmount_SpecifiedAmount)(nil),
		(*BudgetAmount_LastPeriodAmount)(nil),
	}
}

// Describes a budget amount targeted to last period's spend.
// At this time, the amount is automatically 100% of last period's spend;
// that is, there are no other options yet.
// Future configuration will be described here (for example, configuring a
// percentage of last period's spend).
type LastPeriodAmount struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LastPeriodAmount) Reset()         { *m = LastPeriodAmount{} }
func (m *LastPeriodAmount) String() string { return proto.CompactTextString(m) }
func (*LastPeriodAmount) ProtoMessage()    {}
func (*LastPeriodAmount) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b88e381b47dbc69, []int{2}
}

func (m *LastPeriodAmount) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LastPeriodAmount.Unmarshal(m, b)
}
func (m *LastPeriodAmount) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LastPeriodAmount.Marshal(b, m, deterministic)
}
func (m *LastPeriodAmount) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LastPeriodAmount.Merge(m, src)
}
func (m *LastPeriodAmount) XXX_Size() int {
	return xxx_messageInfo_LastPeriodAmount.Size(m)
}
func (m *LastPeriodAmount) XXX_DiscardUnknown() {
	xxx_messageInfo_LastPeriodAmount.DiscardUnknown(m)
}

var xxx_messageInfo_LastPeriodAmount proto.InternalMessageInfo

// ThresholdRule contains a definition of a threshold which triggers
// an alert (a notification of a threshold being crossed) to be sent when
// spend goes above the specified amount.
// Alerts are automatically e-mailed to users with the Billing Account
// Administrator role or the Billing Account User role.
// The thresholds here have no effect on notifications sent to anything
// configured under `Budget.all_updates_rule`.
type ThresholdRule struct {
	// Required. Send an alert when this threshold is exceeded.
	// This is a 1.0-based percentage, so 0.5 = 50%.
	// Validation: non-negative number.
	ThresholdPercent float64 `protobuf:"fixed64,1,opt,name=threshold_percent,json=thresholdPercent,proto3" json:"threshold_percent,omitempty"`
	// Optional. The type of basis used to determine if spend has passed the
	// threshold. Behavior defaults to CURRENT_SPEND if not set.
	SpendBasis           ThresholdRule_Basis `protobuf:"varint,2,opt,name=spend_basis,json=spendBasis,proto3,enum=google.cloud.billing.budgets.v1beta1.ThresholdRule_Basis" json:"spend_basis,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ThresholdRule) Reset()         { *m = ThresholdRule{} }
func (m *ThresholdRule) String() string { return proto.CompactTextString(m) }
func (*ThresholdRule) ProtoMessage()    {}
func (*ThresholdRule) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b88e381b47dbc69, []int{3}
}

func (m *ThresholdRule) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ThresholdRule.Unmarshal(m, b)
}
func (m *ThresholdRule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ThresholdRule.Marshal(b, m, deterministic)
}
func (m *ThresholdRule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ThresholdRule.Merge(m, src)
}
func (m *ThresholdRule) XXX_Size() int {
	return xxx_messageInfo_ThresholdRule.Size(m)
}
func (m *ThresholdRule) XXX_DiscardUnknown() {
	xxx_messageInfo_ThresholdRule.DiscardUnknown(m)
}

var xxx_messageInfo_ThresholdRule proto.InternalMessageInfo

func (m *ThresholdRule) GetThresholdPercent() float64 {
	if m != nil {
		return m.ThresholdPercent
	}
	return 0
}

func (m *ThresholdRule) GetSpendBasis() ThresholdRule_Basis {
	if m != nil {
		return m.SpendBasis
	}
	return ThresholdRule_BASIS_UNSPECIFIED
}

// AllUpdatesRule defines notifications that are sent on every update to the
// billing account's spend, regardless of the thresholds defined using
// threshold rules.
type AllUpdatesRule struct {
	// Required. The name of the Cloud Pub/Sub topic where budget related messages will be
	// published, in the form `projects/{project_id}/topics/{topic_id}`. Updates
	// are sent at regular intervals to the topic.
	// The topic needs to be created before the budget is created; see
	// https://cloud.google.com/billing/docs/how-to/budgets#manage-notifications
	// for more details.
	// Caller is expected to have
	// `pubsub.topics.setIamPolicy` permission on the topic when it's set for a
	// budget, otherwise, the API call will fail with PERMISSION_DENIED. See
	// https://cloud.google.com/pubsub/docs/access-control for more details on
	// Pub/Sub roles and permissions.
	PubsubTopic string `protobuf:"bytes,1,opt,name=pubsub_topic,json=pubsubTopic,proto3" json:"pubsub_topic,omitempty"`
	// Required. The schema version of the notification.
	// Only "1.0" is accepted. It represents the JSON schema as defined in
	// https://cloud.google.com/billing/docs/how-to/budgets#notification_format
	SchemaVersion        string   `protobuf:"bytes,2,opt,name=schema_version,json=schemaVersion,proto3" json:"schema_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AllUpdatesRule) Reset()         { *m = AllUpdatesRule{} }
func (m *AllUpdatesRule) String() string { return proto.CompactTextString(m) }
func (*AllUpdatesRule) ProtoMessage()    {}
func (*AllUpdatesRule) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b88e381b47dbc69, []int{4}
}

func (m *AllUpdatesRule) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AllUpdatesRule.Unmarshal(m, b)
}
func (m *AllUpdatesRule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AllUpdatesRule.Marshal(b, m, deterministic)
}
func (m *AllUpdatesRule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AllUpdatesRule.Merge(m, src)
}
func (m *AllUpdatesRule) XXX_Size() int {
	return xxx_messageInfo_AllUpdatesRule.Size(m)
}
func (m *AllUpdatesRule) XXX_DiscardUnknown() {
	xxx_messageInfo_AllUpdatesRule.DiscardUnknown(m)
}

var xxx_messageInfo_AllUpdatesRule proto.InternalMessageInfo

func (m *AllUpdatesRule) GetPubsubTopic() string {
	if m != nil {
		return m.PubsubTopic
	}
	return ""
}

func (m *AllUpdatesRule) GetSchemaVersion() string {
	if m != nil {
		return m.SchemaVersion
	}
	return ""
}

// A filter for a budget, limiting the scope of the cost to calculate.
type Filter struct {
	// Optional. A set of projects of the form `projects/{project}`,
	// specifying that usage from only this set of projects should be
	// included in the budget. If omitted, the report will include all usage for
	// the billing account, regardless of which project the usage occurred on.
	// Only zero or one project can be specified currently.
	Projects []string `protobuf:"bytes,1,rep,name=projects,proto3" json:"projects,omitempty"`
	// Optional. If not set, default behavior is `INCLUDE_ALL_CREDITS`.
	CreditTypesTreatment Filter_CreditTypesTreatment `protobuf:"varint,4,opt,name=credit_types_treatment,json=creditTypesTreatment,proto3,enum=google.cloud.billing.budgets.v1beta1.Filter_CreditTypesTreatment" json:"credit_types_treatment,omitempty"`
	// Optional. A set of services of the form `services/{service_id}`,
	// specifying that usage from only this set of services should be
	// included in the budget. If omitted, the report will include usage for
	// all the services.
	// The service names are available through the Catalog API:
	// https://cloud.google.com/billing/v1/how-tos/catalog-api.
	Services             []string `protobuf:"bytes,3,rep,name=services,proto3" json:"services,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Filter) Reset()         { *m = Filter{} }
func (m *Filter) String() string { return proto.CompactTextString(m) }
func (*Filter) ProtoMessage()    {}
func (*Filter) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b88e381b47dbc69, []int{5}
}

func (m *Filter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Filter.Unmarshal(m, b)
}
func (m *Filter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Filter.Marshal(b, m, deterministic)
}
func (m *Filter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Filter.Merge(m, src)
}
func (m *Filter) XXX_Size() int {
	return xxx_messageInfo_Filter.Size(m)
}
func (m *Filter) XXX_DiscardUnknown() {
	xxx_messageInfo_Filter.DiscardUnknown(m)
}

var xxx_messageInfo_Filter proto.InternalMessageInfo

func (m *Filter) GetProjects() []string {
	if m != nil {
		return m.Projects
	}
	return nil
}

func (m *Filter) GetCreditTypesTreatment() Filter_CreditTypesTreatment {
	if m != nil {
		return m.CreditTypesTreatment
	}
	return Filter_CREDIT_TYPES_TREATMENT_UNSPECIFIED
}

func (m *Filter) GetServices() []string {
	if m != nil {
		return m.Services
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.billing.budgets.v1beta1.ThresholdRule_Basis", ThresholdRule_Basis_name, ThresholdRule_Basis_value)
	proto.RegisterEnum("google.cloud.billing.budgets.v1beta1.Filter_CreditTypesTreatment", Filter_CreditTypesTreatment_name, Filter_CreditTypesTreatment_value)
	proto.RegisterType((*Budget)(nil), "google.cloud.billing.budgets.v1beta1.Budget")
	proto.RegisterType((*BudgetAmount)(nil), "google.cloud.billing.budgets.v1beta1.BudgetAmount")
	proto.RegisterType((*LastPeriodAmount)(nil), "google.cloud.billing.budgets.v1beta1.LastPeriodAmount")
	proto.RegisterType((*ThresholdRule)(nil), "google.cloud.billing.budgets.v1beta1.ThresholdRule")
	proto.RegisterType((*AllUpdatesRule)(nil), "google.cloud.billing.budgets.v1beta1.AllUpdatesRule")
	proto.RegisterType((*Filter)(nil), "google.cloud.billing.budgets.v1beta1.Filter")
}

func init() {
	proto.RegisterFile("google/cloud/billing/budgets/v1beta1/budget_model.proto", fileDescriptor_1b88e381b47dbc69)
}

var fileDescriptor_1b88e381b47dbc69 = []byte{
	// 811 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x55, 0xd1, 0x6e, 0xe3, 0x44,
	0x14, 0xad, 0x93, 0x6e, 0x80, 0x49, 0x9b, 0xba, 0x43, 0xa1, 0x61, 0x5f, 0xb6, 0x58, 0xab, 0x55,
	0x85, 0x90, 0xcd, 0x66, 0x11, 0x08, 0x78, 0x40, 0x4e, 0xe2, 0xb2, 0x11, 0xdd, 0x6c, 0xe4, 0xb8,
	0x2b, 0x58, 0x09, 0x8d, 0x26, 0xf6, 0xad, 0x3b, 0x68, 0xe2, 0xb1, 0x3c, 0xe3, 0x4a, 0xd5, 0xb2,
	0x9f, 0xc4, 0x0f, 0xf0, 0x05, 0x7c, 0x06, 0xcf, 0xf0, 0x13, 0xc8, 0x33, 0x93, 0x34, 0x5d, 0x56,
	0x28, 0xf0, 0x66, 0x9f, 0x73, 0xcf, 0xb9, 0x73, 0xe7, 0x5e, 0x5f, 0xa3, 0x2f, 0x73, 0x21, 0x72,
	0x0e, 0x41, 0xca, 0x45, 0x9d, 0x05, 0x0b, 0xc6, 0x39, 0x2b, 0xf2, 0x60, 0x51, 0x67, 0x39, 0x28,
	0x19, 0x5c, 0x3f, 0x5e, 0x80, 0xa2, 0x8f, 0xed, 0x3b, 0x59, 0x8a, 0x0c, 0xb8, 0x5f, 0x56, 0x42,
	0x09, 0xfc, 0xd0, 0x08, 0x7d, 0x2d, 0xf4, 0xad, 0xd0, 0xb7, 0x42, 0xdf, 0x0a, 0xef, 0x3f, 0xb0,
	0xf6, 0xb4, 0x64, 0xc1, 0x25, 0x03, 0x9e, 0x91, 0x05, 0x5c, 0xd1, 0x6b, 0x26, 0x2a, 0x63, 0x73,
	0xff, 0xa3, 0x8d, 0x80, 0x0a, 0xa4, 0xa8, 0xab, 0x14, 0x2c, 0x75, 0x6c, 0x29, 0x75, 0x53, 0x42,
	0xb0, 0x14, 0x05, 0xdc, 0x18, 0xc2, 0xfb, 0x75, 0x17, 0x75, 0x86, 0x3a, 0x11, 0x3e, 0x46, 0xbb,
	0x05, 0x5d, 0x42, 0xdf, 0x39, 0x71, 0x4e, 0xdf, 0x1b, 0xb6, 0xff, 0x08, 0xdb, 0xb1, 0x06, 0xf0,
	0xc7, 0x68, 0x2f, 0x63, 0xb2, 0xe4, 0xf4, 0x86, 0xe8, 0x80, 0x56, 0x13, 0x10, 0x77, 0x2d, 0x36,
	0x6d, 0x42, 0x5e, 0xa0, 0x7d, 0x5b, 0xd7, 0x25, 0xe3, 0x0a, 0xaa, 0x7e, 0xfb, 0xc4, 0x39, 0xed,
	0x0e, 0x3e, 0xf5, 0xb7, 0xa9, 0xcc, 0x3f, 0xd3, 0x9a, 0x26, 0xa5, 0x13, 0xef, 0x19, 0xd2, 0x40,
	0xf8, 0x39, 0xea, 0xd0, 0xa5, 0xa8, 0x0b, 0xd5, 0xdf, 0xd5, 0x86, 0x83, 0xed, 0x0c, 0x4d, 0x45,
	0xa1, 0x56, 0x36, 0xb6, 0xad, 0xd8, 0xda, 0x60, 0x8a, 0x0e, 0xd4, 0x55, 0x05, 0xf2, 0x4a, 0xf0,
	0x8c, 0x54, 0x35, 0x07, 0xd9, 0xbf, 0x77, 0xd2, 0x3e, 0xed, 0x0e, 0x9e, 0x6c, 0xe7, 0x9c, 0xac,
	0xc4, 0x71, 0xcd, 0xc1, 0x9c, 0xb8, 0xa7, 0x36, 0x31, 0x89, 0x53, 0xe4, 0x52, 0xce, 0x49, 0x5d,
	0x66, 0x54, 0x81, 0xd4, 0x49, 0xfa, 0x1d, 0x7d, 0xfa, 0xcf, 0xb7, 0xcb, 0x11, 0x72, 0x7e, 0x61,
	0xc4, 0x1b, 0x49, 0xe8, 0x1d, 0xb0, 0x69, 0x16, 0x28, 0x9a, 0xf7, 0xdf, 0x59, 0x35, 0xcb, 0x89,
	0x35, 0xf0, 0xf5, 0x4f, 0x7f, 0x86, 0x2f, 0xd1, 0x43, 0x6b, 0xbd, 0x72, 0x36, 0x69, 0x69, 0xc9,
	0xa4, 0x9f, 0x8a, 0x65, 0x60, 0x1b, 0x3e, 0xb0, 0x51, 0x61, 0x9a, 0x36, 0x77, 0x23, 0x83, 0x57,
	0x16, 0x20, 0xd4, 0x20, 0xaf, 0xd7, 0xc3, 0xfb, 0xca, 0x3c, 0xbc, 0xf6, 0x7e, 0x77, 0xd0, 0xde,
	0xe6, 0xed, 0xe2, 0x6f, 0x91, 0x2b, 0x4b, 0x48, 0xd9, 0x25, 0x83, 0x8c, 0xd8, 0x5e, 0x39, 0xba,
	0x5a, 0xbc, 0xaa, 0xb6, 0x19, 0x3a, 0xff, 0x59, 0x33, 0x74, 0x4f, 0x77, 0xe2, 0x83, 0x75, 0xb4,
	0x35, 0xb8, 0x44, 0x98, 0x53, 0xa9, 0x48, 0x09, 0x15, 0x13, 0x6b, 0x8b, 0x96, 0xb6, 0xf8, 0x62,
	0xbb, 0x0b, 0x3b, 0xa7, 0x52, 0xcd, 0xb4, 0xdc, 0x78, 0x3e, 0xdd, 0x89, 0x5d, 0xfe, 0x06, 0x36,
	0x3c, 0x58, 0x8f, 0xa8, 0x49, 0xe1, 0x61, 0xe4, 0xbe, 0x29, 0xf4, 0xfe, 0x72, 0xd0, 0xfe, 0x9d,
	0x16, 0xe3, 0xcf, 0xd0, 0xe1, 0xed, 0xc0, 0x94, 0x50, 0xa5, 0x60, 0x0b, 0x74, 0xcc, 0x60, 0xb9,
	0x6b, 0x76, 0x66, 0x48, 0x4c, 0x50, 0x57, 0x96, 0x50, 0x64, 0x64, 0x41, 0x25, 0x93, 0xba, 0x92,
	0xde, 0xe0, 0xab, 0xff, 0x31, 0x5e, 0xfe, 0xb0, 0x31, 0x30, 0xcd, 0x45, 0xda, 0x52, 0x03, 0xde,
	0x77, 0xe8, 0x9e, 0x7e, 0xc0, 0x1f, 0xa0, 0xc3, 0x61, 0x38, 0x9f, 0xcc, 0xc9, 0xc5, 0x74, 0x3e,
	0x8b, 0x46, 0x93, 0xb3, 0x49, 0x34, 0x76, 0x77, 0xf0, 0x21, 0xda, 0x1f, 0x5d, 0xc4, 0x71, 0x34,
	0x4d, 0xc8, 0x7c, 0x16, 0x4d, 0xc7, 0xae, 0x83, 0x8f, 0x90, 0x7b, 0xf6, 0x3c, 0x8e, 0x46, 0xe1,
	0x3c, 0x89, 0xc6, 0x16, 0x6d, 0x79, 0x19, 0xea, 0xdd, 0x9d, 0x35, 0xfc, 0x08, 0xed, 0x95, 0xf5,
	0x42, 0xd6, 0x0b, 0xa2, 0x44, 0xc9, 0xd2, 0xdb, 0x5d, 0xd0, 0x8a, 0xbb, 0x86, 0x48, 0x1a, 0x1c,
	0x7f, 0x82, 0x7a, 0x32, 0xbd, 0x82, 0x25, 0x25, 0xd7, 0x50, 0x49, 0x26, 0x0a, 0xb3, 0x14, 0x4c,
	0xe4, 0xbe, 0xa1, 0x5e, 0x18, 0xc6, 0xfb, 0xad, 0x85, 0x3a, 0xf6, 0x73, 0x7e, 0x80, 0xde, 0x2d,
	0x2b, 0xf1, 0x33, 0xa4, 0x4a, 0xf6, 0x9d, 0x93, 0xf6, 0x6a, 0x72, 0xd7, 0x20, 0xfe, 0x05, 0x7d,
	0x98, 0x56, 0x90, 0x31, 0x45, 0x9a, 0xa1, 0x91, 0x44, 0x55, 0x40, 0xd5, 0x12, 0xec, 0xf7, 0xdf,
	0x1b, 0x84, 0xff, 0x65, 0xa1, 0xf8, 0x23, 0x6d, 0x95, 0x34, 0x4e, 0xc9, 0xca, 0xc8, 0x64, 0x3c,
	0x4a, 0xdf, 0x42, 0x35, 0xc7, 0x93, 0x50, 0x5d, 0xb3, 0x14, 0x64, 0xbf, 0xbd, 0x71, 0xbc, 0x15,
	0xe8, 0x95, 0xe8, 0xe8, 0x6d, 0x9e, 0xf8, 0x11, 0xf2, 0x46, 0x71, 0x34, 0x9e, 0x24, 0x24, 0xf9,
	0x71, 0x16, 0xcd, 0x49, 0x12, 0x47, 0x61, 0xf2, 0xac, 0x69, 0xc0, 0xdd, 0xce, 0x1c, 0xa3, 0xf7,
	0x27, 0xd3, 0xd1, 0xf9, 0xc5, 0x38, 0x22, 0xe1, 0xf9, 0x39, 0x31, 0x9a, 0xb9, 0xeb, 0x34, 0x44,
	0xf4, 0xc3, 0x3f, 0x89, 0xd6, 0xf0, 0x06, 0x9d, 0xa6, 0x62, 0xb9, 0x55, 0xd5, 0x33, 0xe7, 0xe5,
	0xf7, 0x36, 0x2e, 0x17, 0x9c, 0x16, 0xb9, 0x2f, 0xaa, 0x3c, 0xc8, 0xa1, 0xd0, 0x9b, 0x3e, 0xb8,
	0xdd, 0x01, 0xff, 0xfe, 0x83, 0xfa, 0xc6, 0xbe, 0x2f, 0x3a, 0x5a, 0xf7, 0xe4, 0xef, 0x00, 0x00,
	0x00, 0xff, 0xff, 0x43, 0x42, 0x54, 0x09, 0xd7, 0x06, 0x00, 0x00,
}
