#!/bin/sh

nv=$(uscan --report | sed -n 's/grr: Newer version (\(.*\)) available on remote site:/\1/ p')

if [ -n "$nv" ] ; then
    uscan
    zipname="grr"$(echo $nv|tr -d .| sed 's/~dfsg1//')".zip"
    baddirname=$(echo $zipname| sed 's/\.zip//')
    echo $zipname
    wd=$(pwd)
    cd ..
    unzip -q $zipname
    mv $baddirname grr-$nv
    #remove third party software which is already packaged in Debian
    rm -rf grr-$nv/ckeditor grr-$nv/phpmailer
    rm -f grr-$nv/include/prototype-1.6.0.3.js
    #remove unused file and make the source tarball
    rm $zipname
    tar czf grr_$nv.orig.tar.gz grr-$nv
    cd $wd
    echo "created $(ls -d ../grr?$nv*)"
else
    echo "no new version"
fi

