%target GNUmakefile
#
# InspIRCd -- Internet Relay Chat Daemon
#
#   Copyright (C) 2009-2010 Daniel De Graaf <danieldg@inspircd.org>
#
# This file is part of InspIRCd.  InspIRCd is free software: you can
# redistribute it and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation, version 2.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
# details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#


#
#               InspIRCd Main Makefile
#
# This file is automagically generated by configure, from
# make/template/main.mk. Any changes made to the generated
#     files will go away whenever it is regenerated!
#
# Please do not edit unless you know what you're doing.
#


CXX = @CXX@
COMPILER = @COMPILER_NAME@
SYSTEM = @SYSTEM_NAME@
BUILDPATH ?= $(dir $(realpath $(firstword $(MAKEFILE_LIST))))/build/@COMPILER_NAME@-@COMPILER_VERSION@
SOCKETENGINE = @SOCKETENGINE@
CORECXXFLAGS = -fPIC -fvisibility=hidden -fvisibility-inlines-hidden -pipe -Iinclude -Wall -Wextra -Wfatal-errors -Wno-unused-parameter -Wshadow
LDLIBS = -lstdc++
CORELDFLAGS = -rdynamic -L.
PICLDFLAGS = -fPIC -shared -rdynamic

BASE    = "$(DESTDIR)@BASE_DIR@"
BINPATH = "$(DESTDIR)@BINARY_DIR@"
CONPATH = "$(DESTDIR)@CONFIG_DIR@"
DATPATH = "$(DESTDIR)@DATA_DIR@"
EXAPATH = "$(DESTDIR)@EXAMPLE_DIR@"
LOGPATH = "$(DESTDIR)@LOG_DIR@"
MANPATH = "$(DESTDIR)@MANUAL_DIR@"
MODPATH = "$(DESTDIR)@MODULE_DIR@"
SCRPATH = "$(DESTDIR)@SCRIPT_DIR@"

INSTALL ?= install
INSTMODE_DIR ?= 0755
INSTMODE_BIN ?= 0755
INSTMODE_TXT ?= 0644
INSTMODE_PRV ?= 0640

ifneq ($(COMPILER), ICC)
  CORECXXFLAGS += -Woverloaded-virtual -Wshadow
ifneq ($(SYSTEM), openbsd)
    CORECXXFLAGS += -pedantic -Wformat=2 -Wmissing-format-attribute -Wno-format-nonliteral
endif
endif

ifneq ($(SYSTEM), darwin)
  LDLIBS += -pthread
endif

ifeq ($(SYSTEM), linux)
  LDLIBS += -ldl -lrt
endif
ifeq ($(SYSTEM), gnukfreebsd)
  LDLIBS += -ldl -lrt
endif
ifeq ($(SYSTEM), gnu)
  LDLIBS += -ldl -lrt
endif
ifeq ($(SYSTEM), solaris)
  LDLIBS += -lsocket -lnsl -lrt -lresolv
endif
ifeq ($(SYSTEM), darwin)
  LDLIBS += -ldl
  CORELDFLAGS = -dynamic -bind_at_load -L.
  PICLDFLAGS = -fPIC -shared -twolevel_namespace -undefined dynamic_lookup
endif
ifeq ($(SYSTEM), haiku)
  LDLIBS = -lnetwork -lstdc++
  CORELDFLAGS = -L.
  PICLDFLAGS = -fPIC -shared
endif

ifndef INSPIRCD_DEBUG
  INSPIRCD_DEBUG=0
endif

DBGOK=0
ifeq ($(INSPIRCD_DEBUG), 0)
  CORECXXFLAGS += -fno-rtti -O2
ifeq ($(COMPILER), GCC)
    CORECXXFLAGS += -g1
endif
  HEADER = std-header
  DBGOK=1
endif
ifeq ($(INSPIRCD_DEBUG), 1)
  CORECXXFLAGS += -O0 -g3 -Werror -DINSPIRCD_ENABLE_RTTI
  HEADER = debug-header
  DBGOK=1
endif
ifeq ($(INSPIRCD_DEBUG), 2)
  CORECXXFLAGS += -fno-rtti -O2 -g3
  HEADER = debug-header
  DBGOK=1
endif
ifeq ($(INSPIRCD_DEBUG), 3)
  CORECXXFLAGS += -fno-rtti -O0 -g0 -Werror
  HEADER = std-header
  DBGOK=1
endif
FOOTER = finishmessage

MAKEFLAGS += --no-print-directory

SOURCEPATH = $(shell pwd)

ifndef INSPIRCD_VERBOSE
  MAKEFLAGS += --silent
endif

# Append any flags set in the environment after the base flags so
# that they can be overridden if necessary.
CORECXXFLAGS += $(CPPFLAGS) $(CXXFLAGS)
CORELDFLAGS += $(LDFLAGS)
PICLDFLAGS += $(LDFLAGS)

export BUILDPATH
export CORECXXFLAGS
export CORELDFLAGS
export CXX
export INSPIRCD_VERBOSE
export LDLIBS
export PICLDFLAGS
export SOCKETENGINE
export SOURCEPATH

# Default target
TARGET = all

ifdef INSPIRCD_TARGET
    HEADER = mod-header
    FOOTER = mod-footer
    TARGET = $(INSPIRCD_TARGET)
endif

ifeq ($(DBGOK), 0)
  HEADER = unknown-debug-level
endif

all: $(FOOTER)

target: $(HEADER)
	$(MAKEENV) perl make/calcdep.pl
	cd "$(BUILDPATH)"; $(MAKEENV) $(MAKE) -f real.mk $(TARGET)

debug:
	@${MAKE} INSPIRCD_DEBUG=1 all

debug-header:
	@echo "*************************************"
	@echo "*    BUILDING WITH DEBUG SYMBOLS    *"
	@echo "*                                   *"
	@echo "*   This will take a *long* time.   *"
	@echo "*  Please be aware that this build  *"
	@echo "*  will consume a very large amount *"
	@echo "*  of disk space (~350MB), and may  *"
	@echo "*  run slower. Use the debug build  *"
	@echo "*  for module development or if you *"
	@echo "*    are experiencing problems.     *"
	@echo "*                                   *"
	@echo "*************************************"

mod-header:
	@echo 'Building specific targets:'

mod-footer: target
	@echo 'To install, copy $(BUILDPATH)/$(TARGET) to $(MODPATH)'
	@echo 'Or, run "make install"'

std-header:
	@echo "*************************************"
	@echo "*       BUILDING INSPIRCD           *"
	@echo "*                                   *"
	@echo "*   This will take a *long* time.   *"
	@echo "*     Why not read our docs at      *"
	@echo "*     https://docs.inspircd.org     *"
	@echo "*  while you wait for Make to run?  *"
	@echo "*************************************"

finishmessage: target
	@echo ""
	@echo "*************************************"
	@echo "*        BUILD COMPLETE!            *"
	@echo "*                                   *"
	@echo "*   To install InspIRCd, type:      *"
	@echo "*        'make install'             *"
	@echo "*************************************"

install: target
	@-$(INSTALL) -d -g @GID@ -o @UID@ -m $(INSTMODE_DIR) $(BASE)
	@-$(INSTALL) -d -g @GID@ -o @UID@ -m $(INSTMODE_DIR) $(BINPATH)
	@-$(INSTALL) -d -g @GID@ -o @UID@ -m $(INSTMODE_DIR) $(CONPATH)
	@-$(INSTALL) -d -g @GID@ -o @UID@ -m $(INSTMODE_DIR) $(DATPATH)
	@-$(INSTALL) -d -g @GID@ -o @UID@ -m $(INSTMODE_DIR) $(EXAPATH)/providers
	@-$(INSTALL) -d -g @GID@ -o @UID@ -m $(INSTMODE_DIR) $(EXAPATH)/services
	@-$(INSTALL) -d -g @GID@ -o @UID@ -m $(INSTMODE_DIR) $(EXAPATH)/sql
	@-$(INSTALL) -d -g @GID@ -o @UID@ -m $(INSTMODE_DIR) $(LOGPATH)
	@-$(INSTALL) -d -g @GID@ -o @UID@ -m $(INSTMODE_DIR) $(MANPATH)
	@-$(INSTALL) -d -g @GID@ -o @UID@ -m $(INSTMODE_DIR) $(MODPATH)
	@-$(INSTALL) -d -g @GID@ -o @UID@ -m $(INSTMODE_DIR) $(SCRPATH)
	-$(INSTALL) -g @GID@ -o @UID@ -m $(INSTMODE_BIN) "$(BUILDPATH)/bin/inspircd" $(BINPATH)
	-$(INSTALL) -g @GID@ -o @UID@ -m $(INSTMODE_BIN) "$(BUILDPATH)/modules/"*.so $(MODPATH)
	-$(INSTALL) -g @GID@ -o @UID@ -m $(INSTMODE_BIN) @CONFIGURE_DIRECTORY@/inspircd $(SCRPATH) 2>/dev/null
ifeq ($(SYSTEM), darwin)
	-$(INSTALL) -g @GID@ -o @UID@ -m $(INSTMODE_BIN) @CONFIGURE_DIRECTORY@/org.inspircd.plist $(SCRPATH) 2>/dev/null
endif
ifeq ($(SYSTEM), linux)
	-$(INSTALL) -g @GID@ -o @UID@ -m $(INSTMODE_TXT) @CONFIGURE_DIRECTORY@/inspircd.service $(SCRPATH) 2>/dev/null
endif
	-$(INSTALL) -g @GID@ -o @UID@ -m $(INSTMODE_TXT) @CONFIGURE_DIRECTORY@/inspircd.1 $(MANPATH) 2>/dev/null
	-$(INSTALL) -g @GID@ -o @UID@ -m $(INSTMODE_TXT) @CONFIGURE_DIRECTORY@/inspircd-genssl.1 $(MANPATH) 2>/dev/null
	-$(INSTALL) -g @GID@ -o @UID@ -m $(INSTMODE_BIN) tools/genssl $(BINPATH)/inspircd-genssl 2>/dev/null
	-$(INSTALL) -g @GID@ -o @UID@ -m $(INSTMODE_TXT) docs/conf/*.example $(EXAPATH)
	-$(INSTALL) -g @GID@ -o @UID@ -m $(INSTMODE_TXT) docs/conf/providers/*.example $(EXAPATH)/providers
	-$(INSTALL) -g @GID@ -o @UID@ -m $(INSTMODE_TXT) docs/conf/services/*.example $(EXAPATH)/services
	-$(INSTALL) -g @GID@ -o @UID@ -m $(INSTMODE_TXT) docs/sql/*.sql $(EXAPATH)/sql
	-$(INSTALL) -g @GID@ -o @UID@ -m $(INSTMODE_PRV) *.pem $(CONPATH) 2>/dev/null
	@echo ""
	@echo "*************************************"
	@echo "*        INSTALL COMPLETE!          *"
	@echo "*************************************"
	@echo 'Paths:'
	@echo '  Base install:' $(BASE)
	@echo '  Configuration:' $(CONPATH)
	@echo '  Binaries:' $(BINPATH)
	@echo '  Modules:' $(MODPATH)
	@echo '  Data:' $(DATPATH)
	@echo 'To start the ircd, run:' $(SCRPATH)/inspircd start
	@echo 'Remember to create your config file:' $(CONPATH)/inspircd.conf
	@echo 'Examples are available at:' $(EXAPATH)

GNUmakefile: make/template/main.mk src/version.sh configure @CONFIGURE_CACHE_FILE@
	./configure --update

clean:
	@echo Cleaning...
	-rm -f "$(BUILDPATH)/bin/inspircd" "$(BUILDPATH)/include" "$(BUILDPATH)/real.mk"
	-rm -rf "$(BUILDPATH)/obj" "$(BUILDPATH)/modules"
	@-rmdir "$(BUILDPATH)/bin" 2>/dev/null
	@-rmdir "$(BUILDPATH)" 2>/dev/null
	@echo Completed.

deinstall:
	-rm -f $(BINPATH)/inspircd
	-rm -rf $(EXAPATH)
	-rm -f $(MANPATH)/inspircd.1
	-rm -f $(MANPATH)/inspircd-genssl.1
	-rm -f $(MODPATH)/m_*.so
	-rm -f $(MODPATH)/core_*.so
	-rm -f $(SCRPATH)/inspircd.service
	-rm -f $(SCRPATH)/org.inspircd.plist

configureclean:
	-rm -f Makefile
	rm -f GNUmakefile
	rm -f include/config.h
	rm -rf @CONFIGURE_DIRECTORY@

distclean: clean configureclean
	-rm -rf "$(SOURCEPATH)/run"
	find "$(SOURCEPATH)/src/modules" -type l | xargs rm -f

help:
	@echo 'InspIRCd Makefile'
	@echo ''
	@echo 'Use: ${MAKE} [flags] [targets]'
	@echo ''
	@echo 'Flags:'
	@echo ' INSPIRCD_VERBOSE=1  Show the full command being executed instead of "BUILD: dns.cpp"'
	@echo ' INSPIRCD_DEBUG=1    Enable debug build, for module development or crash tracing'
	@echo ' INSPIRCD_DEBUG=2    Enable debug build with optimizations, for detailed backtraces'
	@echo ' INSPIRCD_DEBUG=3    Enable fast build with no optimisations or symbols, for Travis CI'
	@echo ' DESTDIR=            Specify a destination root directory (for tarball creation)'
	@echo ' -j <N>              Run a parallel build using N jobs'
	@echo ''
	@echo 'Targets:'
	@echo ' all       Complete build of InspIRCd, without installing (default)'
	@echo ' install   Build and install InspIRCd to the directory chosen in ./configure'
	@echo '           Currently installs to ${BASE}'
	@echo ' debug     Compile a debug build. Equivalent to "make D=1 all"'
	@echo ''
	@echo ' INSPIRCD_TARGET=target  Builds a user-specified target, such as "inspircd" or "core_dns"'
	@echo '                         Multiple targets may be separated by a space'
	@echo ''
	@echo ' clean     Cleans object files produced by the compile'
	@echo ' distclean Cleans all generated files (build, configure, run, etc)'
	@echo ' deinstall Removes the files created by "make install"'
	@echo

.NOTPARALLEL:

.PHONY: all target debug debug-header mod-header mod-footer std-header finishmessage install clean deinstall configureclean help
