/*
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package org.apache.ivy.plugins.resolver;

import org.apache.ivy.plugins.repository.url.URLRepository;

/**
 * This resolver is able to work with any URLs, it handles latest revisions with file and http urls
 * only, and it does not handle publishing
 */
public class URLResolver extends RepositoryResolver {
    public URLResolver() {
        setRepository(new URLRepository(new LazyTimeoutConstraint(this)));
    }

    @Override
    public String getTypeName() {
        return "url";
    }

}
