/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.jardiff.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.osjava.jardiff.DiffException;
import org.osjava.jardiff.JarDiff;
import org.osjava.jardiff.SimpleDiffCriteria;
import org.osjava.jardiff.StreamDiffHandler;

public class JarDiffTask
extends Task {
    private File fromJar = null;
    private File toJar = null;
    private File out = null;
    private String fromName = null;
    private String toName = null;
    private boolean force = false;

    public void execute() throws BuildException {
        try {
            if (this.fromJar == null) {
                throw new BuildException("no fromjar file specified", this.getLocation());
            }
            if (this.toJar == null) {
                throw new BuildException("no tojar file specified", this.getLocation());
            }
            if (this.out == null) {
                throw new BuildException("no out file specified", this.getLocation());
            }
            if (this.fromName == null) {
                this.fromName = this.fromJar.getName();
            }
            if (this.toName == null) {
                this.toName = this.toJar.getName();
            }
            if (!(this.fromJar.exists() && this.fromJar.isFile() && this.fromJar.canRead())) {
                String msg = "fromjar is not a file, or cannot be read";
                throw new BuildException(msg, this.getLocation());
            }
            if (!(this.toJar.exists() && this.toJar.isFile() && this.toJar.canRead())) {
                String msg = "tojar is not a file, or cannot be read";
                throw new BuildException(msg, this.getLocation());
            }
            long outModified = this.out.lastModified();
            long oldModified = this.fromJar.lastModified();
            long newModified = this.toJar.lastModified();
            if (this.force || oldModified > outModified || newModified > outModified) {
                this.log("Writing xml api diff to " + this.out);
                JarDiff jd = new JarDiff();
                jd.setOldVersion(this.fromName);
                jd.setNewVersion(this.toName);
                jd.loadOldClasses(this.fromJar);
                jd.loadNewClasses(this.toJar);
                jd.diff(new StreamDiffHandler(new FileOutputStream(this.out)), new SimpleDiffCriteria());
            }
        }
        catch (DiffException de) {
            throw new BuildException((Throwable)de);
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe);
        }
    }

    public void setFromjar(File fromJar) {
        this.fromJar = fromJar;
    }

    public void setTojar(File toJar) {
        this.toJar = toJar;
    }

    public void setOut(File out) {
        this.out = out;
    }

    public void setFromname(String fromName) {
        this.fromName = fromName;
    }

    public void setToname(String toName) {
        this.toName = toName;
    }

    public void setForce(boolean force) {
        this.force = force;
    }
}

