#!/usr/bin/env perl

# $Header: /cvs/src/jbofihe/dict2inc.pl,v 1.2 2001/06/19 20:54:06 richard Exp $

# Script to read in a load of dictionary data, sort it, and write it out in the
# form of a C structure initialisation.  This can be used for embedding the
# dictionary within the software binary itself.

#
# Copyright (C) Richard P. Curnow  1998-2001
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of version 2 of the GNU General Public License as
# published by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
# 
#

%def = ();

while (<>) {
chomp;
    if (/^[ \t]*#/) {
        next;
    }

    if (/^([^:]+):([^:]+)/) {
        my $word = $1;
        my $def = $2;
        $def =~ s/\"/\\"/go;
        $def{$word} = $def;
    }
}

$n = 0;
print "static Keyval dict[] = {";
for $x (sort keys %def) {
    print "," if ($n++);
    print "\n  ";
    print "{ \"".$x."\", \"".$def{$x}."\"}";
}
print "};\n\n";
print "static int n_entries = $n;\n\n";
    
