/*
 * Kylin-video
 *
 * Copyright (C) 2021, Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Liu Cong <liucong1@kylinos.cn>
 *
 */

#include "setupsystem.h"
#include "ui_setupsystem.h"

#include "global/global.h"

using namespace Global;

SetupSystem::SetupSystem(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::SetupSystem)
{
    ui->setupUi(this);

    QFont f("Noto Sans CJK SC Regular");
    f.setPixelSize(16);
    ui->label->setFont(f);
    ui->label_2->setFont(f);
    ui->label_2->hide();

    f.setPixelSize(14);
    ui->cb_Mini2Tray->setFont(f);
    ui->cb_PauseWhenMini->setFont(f);
    ui->cb_keepState->setFont(f);
    ui->cb_RunMore->setFont(f);
    ui->cb_RunMore->hide();

    if(isWayland)
        ui->cb_Mini2Tray->hide();

    initConnect();
}

SetupSystem::~SetupSystem()
{
    delete ui;
}


/** **********************************************
 * 主题颜色修改
 *************************************************/
void SetupSystem::setBlackTheme()
{
    ui->label->setStyleSheet(QString("color:rgb(255,255,255);"));
    ui->label_2->setStyleSheet(QString("color:rgb(255,255,255);"));

    ui->cb_Mini2Tray->setStyleSheet(QString("color:rgb(249,249,249);"));
    ui->cb_PauseWhenMini->setStyleSheet(QString("color:rgb(249,249,249);"));
    ui->cb_keepState->setStyleSheet(QString("color:rgb(249,249,249);"));
    ui->cb_RunMore->setStyleSheet(QString("color:rgb(249,249,249);"));
}

void SetupSystem::setLightTheme()
{
    ui->label->setStyleSheet(QString("color:rgb(38,38,38);"));
    ui->label_2->setStyleSheet(QString("color:rgb(38,38,38);"));

    ui->cb_Mini2Tray->setStyleSheet(QString("color:rgb(38,38,38);"));
    ui->cb_PauseWhenMini->setStyleSheet(QString("color:rgb(38,38,38);"));
    ui->cb_keepState->setStyleSheet(QString("color:rgb(38,38,38);"));
    ui->cb_RunMore->setStyleSheet(QString("color:rgb(38,38,38);"));
}

void SetupSystem::setWidgetFont(QString family, int size)
{
    QFont f(family);
    f.setPointSize(size + 2);
    ui->label->setFont(f);

    f.setPointSize(size);
    ui->cb_keepState->setFont(f);
    ui->cb_Mini2Tray->setFont(f);
    ui->cb_PauseWhenMini->setFont(f);
    ui->cb_RunMore->setFont(f);
}

void SetupSystem::initData()
{
    ui->cb_Mini2Tray->setChecked(gsetup->miniToTray.first);
    ui->cb_PauseWhenMini->setChecked(gsetup->pauseWhenMini.first);
    ui->cb_keepState->setChecked(gsetup->keepStateWhenWakeup.first);
    ui->cb_RunMore->setChecked(gsetup->canRunMultiple.first);
}

void SetupSystem::initConnect()
{
    connect(ui->cb_Mini2Tray, &QCheckBox::clicked, [&](bool checked){
        gsetup->miniToTray.second = checked;
    });
    connect(ui->cb_PauseWhenMini, &QCheckBox::clicked, [&](bool checked){
        gsetup->pauseWhenMini.second = checked;
    });
    connect(ui->cb_keepState, &QCheckBox::clicked, [&](bool checked){
        gsetup->keepStateWhenWakeup.second = checked;
    });
    connect(ui->cb_RunMore, &QCheckBox::clicked, [&](bool checked){
        gsetup->canRunMultiple.second = checked;
    });
}
