/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider.dns;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.jndi.provider.dns.DomainProtocolException;
import org.apache.harmony.jndi.provider.dns.ProviderMgr;
import org.apache.harmony.jndi.provider.dns.QuestionRecord;
import org.apache.harmony.jndi.provider.dns.ResourceRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Message {
    private int id = 0;
    private boolean qr = false;
    private int opCode = 0;
    private boolean aa = false;
    private boolean tc = false;
    private boolean rd = false;
    private boolean ra = false;
    private int rCode = 0;
    private int qdCount = 0;
    private int anCount = 0;
    private int nsCount = 0;
    private int arCount = 0;
    private Vector<QuestionRecord> questionRecords = null;
    private Vector<ResourceRecord> answerRRs = null;
    private Vector<ResourceRecord> authorityRRs = null;
    private Vector<ResourceRecord> additionalRRs = null;

    public Message() {
        this.questionRecords = new Vector();
        this.answerRRs = new Vector();
        this.authorityRRs = new Vector();
        this.additionalRRs = new Vector();
    }

    public Message(int id, boolean qr, int opCode, boolean aa, boolean tc, boolean rd, boolean ra, int rCode, int qdCount, int anCount, int nsCount, int arCount) {
        this.id = id;
        this.qr = qr;
        this.opCode = opCode;
        this.aa = aa;
        this.tc = tc;
        this.rd = rd;
        this.ra = ra;
        this.rCode = rCode;
        this.qdCount = qdCount;
        this.anCount = anCount;
        this.nsCount = nsCount;
        this.arCount = arCount;
        this.questionRecords = new Vector();
        this.answerRRs = new Vector();
        this.authorityRRs = new Vector();
        this.additionalRRs = new Vector();
    }

    public int writeBytes(byte[] buffer, int startIdx) throws DomainProtocolException {
        ResourceRecord rr;
        int idx = startIdx;
        int tmp = 0;
        if (buffer == null) {
            throw new DomainProtocolException(Messages.getString("jndi.32"));
        }
        idx = ProviderMgr.write16Int(this.id, buffer, idx);
        tmp = ProviderMgr.setBit(tmp, 32768, this.qr);
        tmp &= 0xFFFF87FF;
        tmp |= (this.opCode & 0xF) << 11;
        tmp = ProviderMgr.setBit(tmp, 1024, this.aa);
        tmp = ProviderMgr.setBit(tmp, 512, this.tc);
        tmp = ProviderMgr.setBit(tmp, 256, this.rd);
        tmp = ProviderMgr.setBit(tmp, 128, this.ra);
        tmp &= 0xFFFFFF8F;
        tmp &= 0xFFFFFFF0;
        idx = ProviderMgr.write16Int(tmp |= (this.rCode & 0xF) << 0, buffer, idx);
        idx = ProviderMgr.write16Int(this.qdCount, buffer, idx);
        idx = ProviderMgr.write16Int(this.anCount, buffer, idx);
        idx = ProviderMgr.write16Int(this.nsCount, buffer, idx);
        idx = ProviderMgr.write16Int(this.arCount, buffer, idx);
        int i = 0;
        while (i < this.questionRecords.size()) {
            QuestionRecord qr = this.questionRecords.elementAt(i);
            idx = qr.writeBytes(buffer, idx);
            ++i;
        }
        i = 0;
        while (i < this.answerRRs.size()) {
            rr = this.answerRRs.elementAt(i);
            idx = rr.writeBytes(buffer, idx);
            ++i;
        }
        i = 0;
        while (i < this.authorityRRs.size()) {
            rr = this.answerRRs.elementAt(i);
            idx = rr.writeBytes(buffer, idx);
            ++i;
        }
        i = 0;
        while (i < this.additionalRRs.size()) {
            rr = this.answerRRs.elementAt(i);
            idx = rr.writeBytes(buffer, idx);
            ++i;
        }
        return idx;
    }

    public static int parseMessage(byte[] mesBytes, int startIdx, Message mesObj) throws DomainProtocolException {
        ResourceRecord rr;
        int idx = startIdx;
        if (mesObj == null) {
            throw new DomainProtocolException(Messages.getString("jndi.58"));
        }
        mesObj.setId(ProviderMgr.parse16Int(mesBytes, idx));
        int tmp = ProviderMgr.parse16Int(mesBytes, idx += 2);
        idx += 2;
        mesObj.setQR(ProviderMgr.checkBit(tmp, 32768));
        int tmp2 = (tmp & 0x7800) >> 11;
        mesObj.setOpCode(tmp2);
        mesObj.setAA(ProviderMgr.checkBit(tmp, 1024));
        mesObj.setTc(ProviderMgr.checkBit(tmp, 512));
        mesObj.setRD(ProviderMgr.checkBit(tmp, 256));
        mesObj.setRA(ProviderMgr.checkBit(tmp, 128));
        tmp2 = (tmp & 0xF) >> 0;
        mesObj.setRCode(tmp2);
        int qdCnt = ProviderMgr.parse16Int(mesBytes, idx);
        mesObj.setQDCount(qdCnt);
        int anCnt = ProviderMgr.parse16Int(mesBytes, idx += 2);
        mesObj.setANCount(anCnt);
        int nsCnt = ProviderMgr.parse16Int(mesBytes, idx += 2);
        mesObj.setNSCount(nsCnt);
        int arCnt = ProviderMgr.parse16Int(mesBytes, idx += 2);
        mesObj.setARCount(arCnt);
        idx += 2;
        int i = 0;
        while (i < qdCnt) {
            QuestionRecord qr = new QuestionRecord();
            idx = QuestionRecord.parseRecord(mesBytes, idx, qr);
            mesObj.addQuestionRecord(qr);
            ++i;
        }
        i = 0;
        while (i < anCnt) {
            rr = new ResourceRecord();
            idx = ResourceRecord.parseRecord(mesBytes, idx, rr);
            mesObj.addAnswerRR(rr);
            ++i;
        }
        i = 0;
        while (i < nsCnt) {
            rr = new ResourceRecord();
            idx = ResourceRecord.parseRecord(mesBytes, idx, rr);
            mesObj.addAuthorityRR(rr);
            ++i;
        }
        i = 0;
        while (i < arCnt) {
            rr = new ResourceRecord();
            idx = ResourceRecord.parseRecord(mesBytes, idx, rr);
            mesObj.addAdditionalRR(rr);
            ++i;
        }
        return idx;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ID=" + this.id + "\n");
        if (this.qr) {
            sb.append(" QR");
        }
        sb.append(" OPCODE=" + this.opCode);
        if (this.aa) {
            sb.append(" AA");
        }
        if (this.tc) {
            sb.append(" TC");
        }
        if (this.rd) {
            sb.append(" RD");
        }
        if (this.ra) {
            sb.append(" RA");
        }
        sb.append(" RCODE=" + this.rCode);
        sb.append("\n");
        sb.append("QDCOUNT=" + this.qdCount);
        int i = 0;
        while (i < this.questionRecords.size()) {
            sb.append("\n");
            sb.append(this.questionRecords.elementAt(i).toString());
            ++i;
        }
        sb.append("\n");
        sb.append(" ANCOUNT=" + this.anCount);
        i = 0;
        while (i < this.answerRRs.size()) {
            sb.append("\n");
            sb.append(this.answerRRs.elementAt(i).toString());
            ++i;
        }
        sb.append("\n");
        sb.append(" NSCOUNT=" + this.nsCount);
        i = 0;
        while (i < this.authorityRRs.size()) {
            sb.append("\n");
            sb.append(this.authorityRRs.elementAt(i).toString());
            ++i;
        }
        sb.append("\n");
        sb.append(" ARCOUNT=" + this.arCount);
        i = 0;
        while (i < this.additionalRRs.size()) {
            sb.append("\n");
            sb.append(this.additionalRRs.elementAt(i).toString());
            ++i;
        }
        return sb.toString();
    }

    public boolean isAA() {
        return this.aa;
    }

    public void setAA(boolean aa) {
        this.aa = aa;
    }

    public int getANCount() {
        return this.anCount;
    }

    public void setANCount(int anCount) {
        this.anCount = anCount;
    }

    public int getARCount() {
        return this.arCount;
    }

    public void setARCount(int arCount) {
        this.arCount = arCount;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getNSCount() {
        return this.nsCount;
    }

    public void setNSCount(int nsCount) {
        this.nsCount = nsCount;
    }

    public int getOpCode() {
        return this.opCode;
    }

    public void setOpCode(int opCode) {
        this.opCode = opCode;
    }

    public int getQDCount() {
        return this.qdCount;
    }

    public void setQDCount(int qdCount) {
        this.qdCount = qdCount;
    }

    public boolean getQR() {
        return this.qr;
    }

    public void setQR(boolean qr) {
        this.qr = qr;
    }

    public boolean isRA() {
        return this.ra;
    }

    public void setRA(boolean ra) {
        this.ra = ra;
    }

    public int getRCode() {
        return this.rCode;
    }

    public void setRCode(int code) {
        this.rCode = code;
    }

    public boolean isRD() {
        return this.rd;
    }

    public void setRD(boolean rd) {
        this.rd = rd;
    }

    public boolean isTc() {
        return this.tc;
    }

    public void setTc(boolean tc) {
        this.tc = tc;
    }

    public Enumeration<QuestionRecord> getQuestionRecords() {
        return this.questionRecords.elements();
    }

    public void addQuestionRecord(QuestionRecord qr) {
        this.questionRecords.addElement(qr);
    }

    public Enumeration<ResourceRecord> getAnswerRRs() {
        return this.answerRRs.elements();
    }

    public void addAnswerRR(ResourceRecord rr) {
        this.answerRRs.addElement(rr);
    }

    public Enumeration<ResourceRecord> getAuthorityRRs() {
        return this.authorityRRs.elements();
    }

    public void addAuthorityRR(ResourceRecord rr) {
        this.authorityRRs.addElement(rr);
    }

    public Enumeration<ResourceRecord> getAdditionalRRs() {
        return this.additionalRRs.elements();
    }

    public void addAdditionalRR(ResourceRecord rr) {
        this.additionalRRs.addElement(rr);
    }
}

