/***************************************************************************
       cstring-upper-lower.cpp  -  test CString ToUpper() / ToLower()
                             -------------------
    begin                : Thu Oct 30 2008
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/**
 * Check ToUpper() and ToLower() work since I'm removing yet
 * another copy. This really needs to be run under valgrind
 * to check for invalid memory access, leaks etc.
 */

#include <dclib/core/cstring.h>

#include <stdio.h>

int main( int, char*[] )
{
	const CString before = "========== a variable before ==========";
	const CString testdata = "0123456789 abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ 0123456789";
	const CString after = "========== a variable before ==========";
	
	CString s1 = testdata.ToLower();
	CString s2 = testdata.ToUpper();
	
	if ( s1.Length() != testdata.Length() )
	{
		printf("cstring-upper-lower: ToLower() changed length: %ld -> %ld\n",testdata.Length(),s1.Length());
		return 100;
	}
	
	if ( s1 != "0123456789 abcdefghijklmnopqrstuvwxyz abcdefghijklmnopqrstuvwxyz 0123456789" )
	{
		printf("cstring-upper-lower: unexpected result from ToLower(): '%s'\n",s1.Data());
		return 100;
	}
	
	if ( s2.Length() != testdata.Length() )
	{
		printf("cstring-upper-lower: ToUpper() changed length: %ld -> %ld\n",testdata.Length(),s2.Length());
	}
	
	if ( s2 != "0123456789 ABCDEFGHIJKLMNOPQRSTUVWXYZ ABCDEFGHIJKLMNOPQRSTUVWXYZ 0123456789" )
	{
		printf("cstring-upper-lower: unexpected result from ToUpper(): '%s'\n",s2.Data());
		return 100;
	}
	
	if ( s1.Data()[s1.Length()] != 0 )
	{
		printf("cstring-upper-lower: ToLower() result not NULL terminated\n");
		return 100;
	}
	
	if ( s2.Data()[s2.Length()] != 0 )
	{
		printf("cstring-upper-lower: ToUpper() result not NULL terminated\n");
		return 100;
	}
	
	s1 += before;
	s1 += after;
	
	if ( (s1.Length() != before.Length() + testdata.Length() + after.Length()) || (s1 != "0123456789 abcdefghijklmnopqrstuvwxyz abcdefghijklmnopqrstuvwxyz 0123456789========== a variable before ==================== a variable before ==========") )
	{
		printf("cstring-upper-lower: result of ToLower() is broken\n");
		return 100;
	}
	
	s2 += before;
	s2 += after;
	
	if ( (s2.Length() != before.Length() + testdata.Length() + after.Length()) || (s2 != "0123456789 ABCDEFGHIJKLMNOPQRSTUVWXYZ ABCDEFGHIJKLMNOPQRSTUVWXYZ 0123456789========== a variable before ==================== a variable before ==========") )
	{
		printf("cstring-upper-lower: result of ToUpper() is broken\n");
		return 100;
	}
	
	return 0;
}
