/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.websvc.wsitconf.projects;

import org.netbeans.api.project.Project;
import org.netbeans.spi.project.LookupProvider;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

/** Lookup Provider for WSIT
 *
 * @author Martin Grebac
 */
@LookupProvider.Registration(projectType="org-netbeans-modules-j2ee-clientproject")
public class AppclientLookupProvider implements LookupProvider {

    /** Creates a new instance of AppclientLookupProvider */
    public AppclientLookupProvider() {
    }

    public Lookup createAdditionalLookup(Lookup baseContext) {
        final Project project = baseContext.lookup(Project.class);
        AppclientWsitProvider wsitProvider = new AppclientWsitProvider(project);

        return Lookups.fixed(new Object[] {
            wsitProvider,
            });
    }
}
