/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * ExportDiffPanel.java
 *
 * Created on Mar 6, 2009, 10:43:25 PM
 */

package org.netbeans.modules.versioning.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.event.DocumentListener;

/**
 *
 * @author tomas
 */
public class ExportDiffPanel extends ExportDiffSupport.AbstractExportDiffPanel implements ActionListener {
    private JComponent attachComponent;

    /** Creates new form ExportDiffPanel */
    public ExportDiffPanel(JComponent attachComponent) {
        initComponents();
        this.attachComponent = attachComponent;
        asFileRadioButton.addActionListener(this);
        attachRadioButton.addActionListener(this);
        attachPanel.add(attachComponent);

        attachComponent.setEnabled(false);
        fileTextField.setEnabled(true);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();

        buttonGroup1.add(asFileRadioButton);
        asFileRadioButton.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(asFileRadioButton, org.openide.util.NbBundle.getMessage(ExportDiffPanel.class, "ExportDiffPanel.asFileRadioButton.text")); // NOI18N
        asFileRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                asFileRadioButtonActionPerformed(evt);
            }
        });

        buttonGroup1.add(attachRadioButton);
        org.openide.awt.Mnemonics.setLocalizedText(attachRadioButton, org.openide.util.NbBundle.getMessage(ExportDiffPanel.class, "ExportDiffPanel.attachRadioButton.text")); // NOI18N

        attachPanel.setLayout(new java.awt.BorderLayout());

        fileTextField.setText(org.openide.util.NbBundle.getMessage(ExportDiffPanel.class, "ExportDiffPanel.fileTextField.text")); // NOI18N
        fileTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fileTextFieldActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(browseButton, org.openide.util.NbBundle.getMessage(ExportDiffPanel.class, "ExportDiffPanel.browseButton.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(attachPanel, javax.swing.GroupLayout.DEFAULT_SIZE, 522, Short.MAX_VALUE)
                        .addContainerGap())
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(asFileRadioButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(fileTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 297, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(browseButton)
                        .addGap(20, 20, 20))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(attachRadioButton)
                        .addContainerGap(398, Short.MAX_VALUE))))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(asFileRadioButton)
                    .addComponent(fileTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(browseButton))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(attachRadioButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(attachPanel, javax.swing.GroupLayout.DEFAULT_SIZE, 133, Short.MAX_VALUE)
                .addContainerGap())
        );

        asFileRadioButton.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ExportDiffPanel.class, "ExportDiffPanel.asFileRadioButton.AccessibleContext.accessibleDescription")); // NOI18N
        attachRadioButton.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ExportDiffPanel.class, "ExportDiffPanel.attachRadioButton.AccessibleContext.accessibleDescription")); // NOI18N
        fileTextField.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(ExportDiffPanel.class, "ExportDiffPanel.fileTextField.AccessibleContext.accessibleName")); // NOI18N
        fileTextField.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ExportDiffPanel.class, "ExportDiffPanel.fileTextField.AccessibleContext.accessibleDescription")); // NOI18N
        browseButton.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ExportDiffPanel.class, "ExportDiffPanel.browseButton.AccessibleContext.accessibleDescription")); // NOI18N

        getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ExportDiffPanel.class, "ExportDiffPanel.AccessibleContext.accessibleDescription")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

    private void asFileRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_asFileRadioButtonActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_asFileRadioButtonActionPerformed

    private void fileTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fileTextFieldActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_fileTextFieldActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    final javax.swing.JRadioButton asFileRadioButton = new javax.swing.JRadioButton();
    final javax.swing.JPanel attachPanel = new javax.swing.JPanel();
    final javax.swing.JRadioButton attachRadioButton = new javax.swing.JRadioButton();
    final javax.swing.JButton browseButton = new javax.swing.JButton();
    private javax.swing.ButtonGroup buttonGroup1;
    final javax.swing.JTextField fileTextField = new javax.swing.JTextField();
    // End of variables declaration//GEN-END:variables

    public void actionPerformed(ActionEvent e) {
        if(asFileRadioButton.isSelected()) {
            attachComponent.setEnabled(false);
            fileTextField.setEnabled(true);
        } else {
            attachComponent.setEnabled(true);
            fileTextField.setEnabled(false);
        }
    }

    @Override
    public String getOutputFileText() {
        return fileTextField.getText();
    }

    @Override
    public void setOutputFileText(String text) {
        fileTextField.setText(text);
    }

    @Override
    public void addOutputFileTextDocumentListener(DocumentListener list) {
        fileTextField.getDocument().addDocumentListener(list);
    }

    @Override
    public void addBrowseActionListener(ActionListener actionListener) {
        browseButton.addActionListener(actionListener);
    }

    @Override
    public boolean isFileOutputSelected() {
        return asFileRadioButton.isSelected();
    }

    @Override
    public void addNotify () {
        super.addNotify();
        fileTextField.requestFocusInWindow();
    }

}
