# CONTRIBUTING

Thank you for considering contributing to this distribution. This file
contains instructions that will help you work with the source code.

Please note that if you have any questions or difficulties, you can reach the
maintainer(s) through the bug queue described later in this document
(preferred), or by emailing the releaser directly. You are not required to
follow any of the steps in this document to submit a patch or bug report;
these are just recommendations, intended to help you (and help us help you
faster).

The distribution is managed with
[Dist::Zilla](https://metacpan.org/release/Dist-Zilla).

However, you can still compile and test the code with the
`MakeFile.PL`
in the repository:

    perl Makefile.PL
    make
    make test


You may need to satisfy some dependencies. The easiest way to satisfy
dependencies is to install the last release. This is available at
https://metacpan.org/release/Specio

You can use [`cpanminus`](https://metacpan.org/pod/App::cpanminus) to do this
without downloading the tarball first:

    $ cpanm --reinstall --installdeps --with-recommends Specio

[`Dist::Zilla`](https://metacpan.org/pod/Dist::Zilla) is a very powerful
authoring tool, but requires a number of author-specific plugins. If you would
like to use it for contributing, install it from CPAN, then the following
command to install the needed distros:

    $ dzil authordeps --missing | cpanm

There may also be additional requirements not needed by the dzil build which
are needed for tests or other development:

    $ dzil listdeps --author --missing | cpanm

Or, you can use the 'dzil stale' command to install all requirements at once:

    $ cpanm Dist::Zilla::App::Command::stale
    $ dzil stale --all | cpanm

You can also do this via cpanm directly:

    $ cpanm --reinstall --installdeps --with-develop --with-recommends Specio

Once installed, here are some dzil commands you might try:

    $ dzil build
    $ dzil test
    $ dzil test --release
    $ dzil xtest
    $ dzil listdeps --json
    $ dzil build --notgz

You can learn more about Dist::Zilla at http://dzil.org/.

The code for this distribution is [hosted on GitHub](https://github.com/houseabsolute/Specio).

You can submit code changes by forking the repository, pushing your code
changes to your clone, and then submitting a pull request. Please update the
Changes file with a user-facing description of your changes as part of your
work. See the GitHub documentation for [detailed instructions on pull
requests](https://help.github.com/articles/creating-a-pull-request)

If you have found a bug, but do not have an accompanying patch to fix it, you
can submit an issue report [via the web](https://github.com/houseabsolute/Specio/issues).




## TidyAll

This distribution uses
[Code::TidyAll](https://metacpan.org/release/Code-TidyAll) to enforce a
uniform coding style. This is tested as part of the author testing suite. You
can install and run tidyall by running the following commands:

    $ cpanm Code::TidyAll
    $ tidyall -a

Please run this before committing your changes and address any issues it
brings up.

## Contributor Names

If you send a patch or pull request, your name and email address will be
included in the documentation as a contributor (using the attribution on the
commit or patch), unless you specifically request for it not to be. If you
wish to be listed under a different name or address, you should submit a pull
request to the `.mailmap` file to contain the correct mapping.

## Generated By

This file was generated via Dist::Zilla::Plugin::GenerateFile::FromShareDir 0.014 from a
template file originating in Dist-Zilla-PluginBundle-DROLSKY-1.02.
