# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.widget_representation import WidgetRepresentation


class MagnifierRepresentation(WidgetRepresentation):
    r"""
    MagnifierRepresentation - represent a BorderWidget
    
    Superclass: WidgetRepresentation
    
    This class is used to represent and render a MagnifierWidget.  To
    use this class, you need to specify a renderer in which to place the
    magnifier, and a magnification factor. Optionally, you can specify
    the size of the magnifier window, whether it has a border, and the
    particular actors to render.
    
    @sa
    MagnifierWidget
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkMagnifierRepresentation, obj, update, **traits)
    
    border = tvtk_base.false_bool_trait(desc=\
        r"""
        Optionally specify whether a border should be drawn on the outer
        edge of the magnifier viewport. By default this is off.
        """
    )

    def _border_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBorder,
                        self.border_)

    interaction_state = traits.Trait(0, traits.Range(0, 1, enter_set=True, auto_set=False), desc=\
        r"""
        Specify the interaction state of the widget. This is generally
        performed by the associated MagnifierWidget. (It is necessary
        for the widget to specify the interaction state in order to
        remove the internal magnification renderer from the render
        window).
        """
    )

    def _interaction_state_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInteractionState,
                        self.interaction_state)

    magnification_factor = traits.Trait(10.0, traits.Range(0.001, 1000.0, enter_set=True, auto_set=False), desc=\
        r"""
        Methods to control the magnification factor. The magnification
        factor is relative to the associated renderer's camera. The bump
        method enables small increments of magnification to be applied.
        If the bump is positive, it increases the magnification; if
        negative it decreases the magnification.
        """
    )

    def _magnification_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMagnificationFactor,
                        self.magnification_factor)

    def _get_renderer(self):
        return wrap_vtk(self._vtk_obj.GetRenderer())
    def _set_renderer(self, arg):
        old_val = self._get_renderer()
        self._wrap_call(self._vtk_obj.SetRenderer,
                        deref_vtk(arg))
        self.trait_property_changed('renderer', old_val, arg)
    renderer = traits.Property(_get_renderer, _set_renderer, desc=\
        r"""
        
        """
    )

    size = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="int", value=(75, 75), cols=2, desc=\
        r"""
        Specify the size of the magnifier viewport in pixels.
        """
    )

    def _size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSize,
                        self.size)

    def _get_border_property(self):
        return wrap_vtk(self._vtk_obj.GetBorderProperty())
    border_property = traits.Property(_get_border_property, desc=\
        r"""
        Specify the properties of the border.
        """
    )

    def _get_magnification_renderer(self):
        return wrap_vtk(self._vtk_obj.GetMagnificationRenderer())
    magnification_renderer = traits.Property(_get_magnification_renderer, desc=\
        r"""
        Provide access to the magnification renderer. This is so
        properties like background color can be set.
        """
    )

    def _get_view_props(self):
        return wrap_vtk(self._vtk_obj.GetViewProps())
    view_props = traits.Property(_get_view_props, desc=\
        r"""
        
        """
    )

    def add_view_prop(self, *args):
        """
        add_view_prop(self, __a:Prop) -> None
        C++: void add_view_prop(Prop *)
        Optionally specify and maintain the list of view props (e.g.,
        actors, volumes, etc).  By default, if nothing is specified, then
        the view props from the associated renderer are used. Note, by
        using view props different than that of the associated renderer,
        it is possible to create special effects and/or remove props from
        what is shown in the magnifier.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddViewProp, *my_args)
        return ret

    def has_view_prop(self, *args):
        """
        has_view_prop(self, __a:Prop) -> int
        C++: int has_view_prop(Prop *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HasViewProp, *my_args)
        return ret

    def remove_all_view_props(self):
        """
        remove_all_view_props(self) -> None
        C++: void remove_all_view_props(void)"""
        ret = self._vtk_obj.RemoveAllViewProps()
        return ret
        

    def remove_view_prop(self, *args):
        """
        remove_view_prop(self, __a:Prop) -> None
        C++: void remove_view_prop(Prop *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RemoveViewProp, *my_args)
        return ret

    _updateable_traits_ = \
    (('border', 'GetBorder'), ('need_to_render', 'GetNeedToRender'),
    ('picking_managed', 'GetPickingManaged'), ('dragable', 'GetDragable'),
    ('pickable', 'GetPickable'), ('use_bounds', 'GetUseBounds'),
    ('visibility', 'GetVisibility'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('interaction_state', 'GetInteractionState'), ('magnification_factor',
    'GetMagnificationFactor'), ('size', 'GetSize'), ('handle_size',
    'GetHandleSize'), ('place_factor', 'GetPlaceFactor'),
    ('estimated_render_time', 'GetEstimatedRenderTime'),
    ('render_time_multiplier', 'GetRenderTimeMultiplier'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['border', 'debug', 'dragable', 'global_warning_display',
    'need_to_render', 'pickable', 'picking_managed', 'use_bounds',
    'visibility', 'estimated_render_time', 'handle_size',
    'interaction_state', 'magnification_factor', 'object_name',
    'place_factor', 'render_time_multiplier', 'size'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(MagnifierRepresentation, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit MagnifierRepresentation properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['border', 'need_to_render', 'picking_managed', 'use_bounds',
            'visibility'], [], ['estimated_render_time', 'handle_size',
            'interaction_state', 'magnification_factor', 'object_name',
            'place_factor', 'render_time_multiplier', 'size']),
            title='Edit MagnifierRepresentation properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit MagnifierRepresentation properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

