/***************************** LICENSE START ***********************************

 Copyright 2013 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef StandardObject_H
#define StandardObject_H

#include <string>

#include "IconObject.h"

class IconClass;

using std::string;

class StandardObject : public IconObject
{
public:
    StandardObject(Folder* parent,
                   const IconClass& kind, const string& name,
                   IconInfo* info);

    virtual ~StandardObject();
    void duplicate();
    IconObject* clone(Folder*, bool update = false);
    IconObject* clone(Folder*, int x, int y, bool update = false);

protected:
    virtual Request request() const;
    virtual const set<DependancyH>& dependancies();
    virtual void dependancies(set<DependancyH>&, const Request&);
    virtual Request fullRequest() const;

private:
    StandardObject(const StandardObject&);
    StandardObject& operator=(const StandardObject&);

    virtual void doubleClick();
    virtual set<string> can();

    virtual void createFiles();
    virtual void request(const Request&);
    virtual bool rename(const string&);
};

inline void destroy(StandardObject**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(StandardObject);
//#endif

#endif
